/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;

public class SliderCircularIndicatorPainter {
    protected Color DIMPLE_COLOR = new Color(160, 160, 160);
    protected Color DIMPLE_TOP = new Color(105, 105, 105);
    protected final double x;
    protected final double y;
    protected final double radius;
    protected final double zeroAngle;
    protected final double p;

    public SliderCircularIndicatorPainter(double x, double y, double radius, double zeroAngle, double p) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.zeroAngle = zeroAngle;
        this.p = p;
    }

    public void paint(@NotNull Graphics2D g) {
        double d = 5.0;
        double angle = this.zeroAngle - this.p * 2.0 * Math.PI;
        double x0 = this.x + Math.cos(angle) * this.radius;
        double y0 = this.y - Math.sin(angle) * this.radius;
        Ellipse2D.Double s = new Ellipse2D.Double(x0 - d / 2.0, y0 - d / 2.0, d, d);
        g.setColor(this.DIMPLE_COLOR);
        g.fill(s);
        s = new Ellipse2D.Double(x0 - d / 4.0, y0 - d / 2.0, d / 2.0, d / 2.0);
        g.setColor(this.DIMPLE_TOP);
        g.fill(s);
    }
}

