/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.impl.PainterExtension;

public class TableColumnHeaderCellPainterExtension
implements PainterExtension {
    @NotNull
    protected final TableColumnHeaderConfiguration tg;
    @NotNull
    protected Color COLOR = new Color(60, 60, 60, 34);

    public TableColumnHeaderCellPainterExtension(@NotNull TableColumnHeaderConfiguration g) {
        this.tg = g;
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        AquaUIPainter.ColumnSortArrowDirection direction;
        if (width == 0.0f || height == 0.0f) {
            return;
        }
        float extraHeight = height - 16.0f;
        float extraGap = Math.min(4.0f, extraHeight / 2.0f);
        float arrowGap = 4.0f + extraGap;
        float dividerGap = 2.5f;
        float dividerHeight = Math.max(0.0f, height - 2.0f * dividerGap);
        if (dividerHeight > 0.0f) {
            float x0 = width - 1.0f;
            float y0 = dividerGap;
            Rectangle2D.Float r = new Rectangle2D.Float(x0, y0, 1.0f, dividerHeight);
            g.setColor(this.COLOR);
            g.fill(r);
        }
        if ((direction = this.tg.getSortArrowDirection()) != AquaUIPainter.ColumnSortArrowDirection.NONE && width >= 12.0f) {
            Image im = null;
            switch (direction) {
                case UP: {
                    im = Toolkit.getDefaultToolkit().getImage("NSImage://NSAscendingSortIndicator");
                    break;
                }
                case DOWN: {
                    im = Toolkit.getDefaultToolkit().getImage("NSImage://NSDescendingSortIndicator");
                }
            }
            if (im != null) {
                int imageWidth = im.getWidth(null);
                int imageHeight = im.getHeight(null);
                float x = this.tg.isLeftToRight() ? width - 1.0f - arrowGap - (float)imageWidth + 1.0f : arrowGap + 1.0f;
                float y = (height - (float)imageHeight) / 2.0f;
                AffineTransform tr = AffineTransform.getTranslateInstance(x, y);
                g.drawImage(im, tr, null);
            }
        }
    }
}

