/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.impl.TitleBarLayoutInfo;
import org.violetlib.jnr.impl.PainterExtension;

public class TitleBarPainterExtension
implements PainterExtension {
    @NotNull
    protected final TitleBarConfiguration tg;
    @NotNull
    protected final TitleBarLayoutInfo layoutInfo;
    @NotNull
    protected final Color RED_COLOR = new Color(255, 96, 88);
    @NotNull
    protected final Color YELLOW_COLOR = new Color(255, 189, 46);
    @NotNull
    protected final Color GREEN_COLOR = new Color(40, 201, 64);

    public TitleBarPainterExtension(@NotNull TitleBarLayoutInfo layoutInfo, @NotNull TitleBarConfiguration tg) {
        this.tg = tg;
        this.layoutInfo = layoutInfo;
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        this.paintIfNeeded(bounds, g, this.tg.getCloseButtonState(), AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX);
        this.paintIfNeeded(bounds, g, this.tg.getMinimizeButtonState(), AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX);
        this.paintIfNeeded(bounds, g, this.tg.getResizeButtonState(), AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX);
    }

    protected void paintIfNeeded(@NotNull Rectangle2D bounds, @NotNull Graphics2D g, @NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.TitleBarButtonWidget bw) {
        boolean paintIcon;
        AquaUIPainter.State titleBarState = this.tg.getTitleBarState();
        boolean isDirty = this.tg.isDirty() && bw == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX;
        boolean paintBackground = titleBarState == AquaUIPainter.State.INACTIVE && state != AquaUIPainter.State.INACTIVE && state != AquaUIPainter.State.PRESSED;
        boolean bl = paintIcon = state == AquaUIPainter.State.ROLLOVER || state == AquaUIPainter.State.PRESSED && bw == AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX || paintBackground && isDirty;
        if (!paintBackground && !paintIcon) {
            return;
        }
        Shape s = this.layoutInfo.getButtonShape(bounds, this.tg, bw);
        if (paintBackground) {
            switch (bw) {
                case CLOSE_BOX: {
                    g.setPaint(this.RED_COLOR);
                    break;
                }
                case MINIMIZE_BOX: {
                    g.setPaint(this.YELLOW_COLOR);
                    break;
                }
                case RESIZE_BOX: {
                    g.setPaint(this.GREEN_COLOR);
                }
            }
            g.fill(s);
            RectangularShape rs = (RectangularShape)s;
            RectangularShape outline = (RectangularShape)rs.clone();
            outline.setFrameFromCenter(rs.getCenterX(), rs.getCenterY(), rs.getMinX() + 0.2, rs.getMinY() + 0.2);
            g.setPaint(new Color(0, 0, 0, 30));
            g.setStroke(new BasicStroke(0.8f));
            g.draw(outline);
        }
        if (paintIcon) {
            if (paintBackground && isDirty) {
                double dd = this.tg.getWidget() == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 4.0 : 3.0;
                double dr = dd / 2.0;
                RectangularShape rs = (RectangularShape)s;
                Ellipse2D.Double dot = new Ellipse2D.Double(rs.getCenterX() - dr, rs.getCenterY() - dr, dd, dd);
                g.setPaint(Color.BLACK);
                g.fill(dot);
            } else {
                Shape icon;
                Rectangle2D buttonBounds = s.getBounds2D();
                g.setPaint(new Color(100, 100, 100));
                g.setStroke(new BasicStroke(0.8f));
                if (bw == AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX) {
                    double rx = buttonBounds.getX() + 2.0;
                    double ry = buttonBounds.getCenterY() - 0.5;
                    double rwidth = buttonBounds.getWidth() - 4.0;
                    double rheight = 1.0;
                    Rectangle2D.Double icon2 = new Rectangle2D.Double(rx, ry, rwidth, rheight);
                    g.fill(icon2);
                }
                if (bw == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX) {
                    g.setStroke(new BasicStroke(2.0f));
                    double a = 3.5;
                    double x1 = buttonBounds.getX() + a;
                    double y1 = buttonBounds.getY() + a;
                    double x2 = buttonBounds.getX() + buttonBounds.getWidth() - a;
                    double y2 = buttonBounds.getY() + buttonBounds.getHeight() - a;
                    icon = new Line2D.Double(x1, y1, x2, y2);
                    g.draw(icon);
                    icon = new Line2D.Double(x1, y2, x2, y1);
                    g.draw(icon);
                }
                if (bw == AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX) {
                    boolean isFullScreen;
                    TitleBarConfiguration.ResizeAction resizeAction = this.tg.getResizeAction();
                    boolean bl2 = isFullScreen = resizeAction == TitleBarConfiguration.ResizeAction.FULL_SCREEN_ENTER || resizeAction == TitleBarConfiguration.ResizeAction.FULL_SCREEN_EXIT;
                    if (isFullScreen) {
                        double top;
                        double left;
                        double a;
                        g.setPaint(new Color(100, 100, 100));
                        if (resizeAction == TitleBarConfiguration.ResizeAction.FULL_SCREEN_ENTER) {
                            a = 3.0;
                            left = buttonBounds.getX() + a;
                            top = buttonBounds.getY() + a;
                            double right = buttonBounds.getX() + buttonBounds.getWidth() - a;
                            double bottom = buttonBounds.getY() + buttonBounds.getHeight() - a;
                            double o = 0.8;
                            Path2D.Double t = new Path2D.Double();
                            t.moveTo(left, top + o);
                            t.lineTo(right - o, bottom);
                            t.lineTo(left, bottom);
                            t.lineTo(left, top + o);
                            g.fill(t);
                            t = new Path2D.Double();
                            t.moveTo(right, bottom - o);
                            t.lineTo(left + o, top);
                            t.lineTo(right, top);
                            t.lineTo(right, bottom - o);
                            g.fill(t);
                        } else {
                            a = 1.5;
                            left = buttonBounds.getX() + a;
                            top = buttonBounds.getY() + a;
                            double right = buttonBounds.getX() + buttonBounds.getWidth() - a;
                            double bottom = buttonBounds.getY() + buttonBounds.getHeight() - a;
                            double xcenter = (left + right) / 2.0;
                            double ycenter = (top + bottom) / 2.0;
                            double o = 0.2;
                            Path2D.Double t = new Path2D.Double();
                            t.moveTo(left, ycenter + o);
                            t.lineTo(xcenter - o, bottom);
                            t.lineTo(xcenter - o, ycenter + o);
                            t.lineTo(left, ycenter + o);
                            g.fill(t);
                            t = new Path2D.Double();
                            t.moveTo(right, ycenter - o);
                            t.lineTo(xcenter + o, top);
                            t.lineTo(xcenter + o, ycenter - o);
                            t.lineTo(right, ycenter - o);
                            g.fill(t);
                        }
                    } else {
                        double rx = buttonBounds.getX() + 2.0;
                        double ry = buttonBounds.getCenterY() - 0.5;
                        double rwidth = buttonBounds.getWidth() - 4.0;
                        double rheight = 1.0;
                        icon = new Rectangle2D.Double(rx, ry, rwidth, rheight);
                        g.fill(icon);
                        rx = buttonBounds.getCenterX() - 0.5;
                        ry = buttonBounds.getY() + 2.0;
                        rwidth = 1.0;
                        rheight = buttonBounds.getHeight() - 4.0;
                        icon = new Rectangle2D.Double(rx, ry, rwidth, rheight);
                        g.setPaint(new Color(100, 100, 100));
                        g.fill(icon);
                    }
                }
            }
        }
    }
}

