/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.impl.RendererDescriptions;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class ViewRendererDescriptions
implements RendererDescriptions {
    @Override
    @NotNull
    public RendererDescription getButtonRendererDescription(@NotNull ButtonConfiguration g) {
        AquaUIPainter.ButtonWidget bw = this.toCanonicalButtonStyle(g.getButtonWidget());
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            ToolBarItemWellConfiguration tg = new ToolBarItemWellConfiguration(g.getState(), true);
            return this.getToolBarItemWellRendererDescription(tg);
        }
        AquaUIPainter.Size sz = g.getSize();
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR && platformVersion < 101100) {
            bw = AquaUIPainter.ButtonWidget.BUTTON_ROUND;
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(-6.0f, 0.0f, 12.0f, 2.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(-5.0f, -1.0f, 10.0f, 3.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            return new BasicRendererDescription(-2.0f, -2.0f, 4.0f, 4.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, platformVersion < 101200 ? 3.0f : 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return platformVersion < 101200 ? new BasicRendererDescription(0.0f, -0.5f, 1.0f, 0.0f) : new BasicRendererDescription(-0.49f, 0.0f, 1.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
            return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -4.0f, 0.0f, 10.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -2.0f, 0.0f, 8.0f);
                }
                case MINI: {
                    BasicRendererDescription rd1 = new BasicRendererDescription(0.0f, -1.0f, 0.0f, 3.0f);
                    BasicRendererDescription rd2 = new BasicRendererDescription(0.0f, -0.5f, 0.0f, 3.0f);
                    return new MultiResolutionRendererDescription(rd1, rd2);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration g) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return this.createVertical(0.0f, 1.0f);
                    }
                    case SMALL: {
                        return this.createVertical(0.0f, 2.0f);
                    }
                    case MINI: {
                        return this.createVertical(-0.51f, 5.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_SEGMENTED_INSET: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return this.createVertical(-1.0f, 4.0f);
                    }
                    case SMALL: {
                        return this.createVertical(-1.0f, 5.0f);
                    }
                    case MINI: {
                        return this.createVertical(-1.0f, 6.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                boolean raise = bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR || bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR;
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return platformVersion >= 101100 ? this.createVertical(-1.49f, 3.0f) : this.createVertical(-1.0f, 2.0f);
                    }
                    case SMALL: {
                        return platformVersion >= 101100 ? this.createVertical(raise ? -1.49f : -0.49f, 4.0f) : this.createVertical(-1.0f, 4.0f);
                    }
                    case MINI: {
                        return new MultiResolutionRendererDescription(this.createVertical(platformVersion >= 101100 ? 0.0f : -1.0f, 5.0f), this.createVertical(0.0f, platformVersion >= 101100 ? 5.0f : 4.5f));
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return this.createVertical(0.0f, 2.0f);
                    }
                    case SMALL: {
                        return this.createVertical(0.0f, 3.0f);
                    }
                    case MINI: {
                        return this.createVertical(0.0f, 4.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected RendererDescription createVertical(float yOffset, float heightAdjustment) {
        return new BasicRendererDescription(0.0f, yOffset, 0.0f, heightAdjustment);
    }

    @NotNull
    protected RendererDescription createVertical(float yOffset1, float yOffset2, float heightAdjustment) {
        BasicRendererDescription rd1 = new BasicRendererDescription(0.0f, yOffset1, 0.0f, heightAdjustment);
        BasicRendererDescription rd2 = new BasicRendererDescription(0.0f, yOffset2, 0.0f, heightAdjustment);
        return new MultiResolutionRendererDescription(rd1, rd2);
    }

    @Override
    @NotNull
    public RendererDescription getComboBoxRendererDescription(@NotNull ComboBoxConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -3.0f, 3.0f, 3.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -1.0f, 3.0f, 1.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 2.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (sz) {
            case LARGE: 
            case REGULAR: {
                return new BasicRendererDescription(-0.5f, 0.0f, 3.0f, 1.0f);
            }
            case SMALL: {
                return new BasicRendererDescription(-0.5f, 0.0f, 3.0f, 2.0f);
            }
            case MINI: {
                return new BasicRendererDescription(-0.5f, 0.0f, 2.0f, 2.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public RendererDescription getBasicPopupButtonRendererDescription(@NotNull PopupButtonConfiguration g) {
        return this.getPopupButtonRendererDescription(g);
    }

    @Override
    @NotNull
    public RendererDescription getPopupButtonRendererDescription(@NotNull PopupButtonConfiguration g) {
        boolean isArrowsOnly;
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        boolean isSquare = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl = isArrowsOnly = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((isSquare || isArrowsOnly) && sz == AquaUIPainter.Size.MINI) {
            sz = AquaUIPainter.Size.SMALL;
        }
        switch (bw) {
            case BUTTON_POP_UP: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(-2.0f, 0.0f, 5.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(-1.0f, 0.0f, 3.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_UP_CELL: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, -3.0f, 0.0f, 3.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 1.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(-1.0f, -1.0f, 3.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_UP_SQUARE: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(-1.0f, -1.0f, 3.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_DOWN: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 1.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 1.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_DOWN_CELL: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_DOWN_SQUARE: {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, -1.0f, 1.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_DOWN_BEVEL: {
                return new BasicRendererDescription(-2.0f, -2.0f, 4.0f, 4.0f);
            }
            case BUTTON_POP_UP_ROUND_RECT: 
            case BUTTON_POP_DOWN_ROUND_RECT: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
            }
            case BUTTON_POP_UP_RECESSED: 
            case BUTTON_POP_DOWN_RECESSED: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
            }
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_DOWN_GRADIENT: {
                return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getToolBarItemWellRendererDescription(@NotNull ToolBarItemWellConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getTitleBarRendererDescription(@NotNull TitleBarConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderRendererDescription(@NotNull SliderConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderTrackRendererDescription(@NotNull SliderConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderThumbRendererDescription(@NotNull SliderConfiguration g) {
        AquaUIPainter.Size sz = g.getSize();
        if (g.isHorizontal() || g.isVertical()) {
            if (!g.hasTickMarks()) {
                float yOffset1 = -1.0f;
                float yOffset2 = g.isHorizontal() ? JNRUtils.size2D(sz, -0.5f, 0.0f, 0.0f) : JNRUtils.size2D(sz, -0.5f, -0.5f, -0.5f);
                BasicRendererDescription rd1 = new BasicRendererDescription(0.0f, yOffset1, 0.0f, 0.0f);
                BasicRendererDescription rd2 = new BasicRendererDescription(0.0f, yOffset2, 0.0f, 0.0f);
                return new MultiResolutionRendererDescription(rd1, rd2);
            }
            if (g.isHorizontal()) {
                float xOffset1 = 0.0f;
                float xOffset2 = JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f);
                if (g.getTickMarkPosition() == AquaUIPainter.TickMarkPosition.ABOVE) {
                    float yOffset1 = 0.0f;
                    float yOffset2 = JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f);
                    float ha = JNRUtils.size2D(sz, 1.0f, 0.0f, 0.0f);
                    BasicRendererDescription rd1 = new BasicRendererDescription(xOffset1, yOffset1, 0.0f, ha);
                    BasicRendererDescription rd2 = new BasicRendererDescription(xOffset2, yOffset2, 0.0f, ha);
                    return new MultiResolutionRendererDescription(rd1, rd2);
                }
                float yOffset1 = JNRUtils.size2D(sz, -1.0f, 0.0f, 0.0f);
                float yOffset2 = JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f);
                float ha = 1.0f;
                BasicRendererDescription rd1 = new BasicRendererDescription(xOffset1, yOffset1, 0.0f, ha);
                BasicRendererDescription rd2 = new BasicRendererDescription(xOffset2, yOffset2, 0.0f, ha);
                return new MultiResolutionRendererDescription(rd1, rd2);
            }
            float yOffset1 = 0.0f;
            float yOffset2 = JNRUtils.size2D(sz, 0.0f, 0.5f, 0.5f);
            if (g.getTickMarkPosition() == AquaUIPainter.TickMarkPosition.LEFT) {
                float wa = JNRUtils.size2D(sz, 1.0f, 2.0f, 2.0f);
                float ha = JNRUtils.size(sz, 1, 0, 0);
                BasicRendererDescription rd1 = new BasicRendererDescription(0.0f, yOffset1, wa, ha);
                BasicRendererDescription rd2 = new BasicRendererDescription(0.0f, yOffset2, wa, ha);
                return new MultiResolutionRendererDescription(rd1, rd2);
            }
            float ha = JNRUtils.size(sz, 1, 0, 0);
            BasicRendererDescription rd1 = new BasicRendererDescription(0.0f, yOffset1, 0.0f, ha);
            BasicRendererDescription rd2 = new BasicRendererDescription(0.0f, yOffset2, 0.0f, ha);
            return new MultiResolutionRendererDescription(rd1, rd2);
        }
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSpinnerArrowsRendererDescription(@NotNull SpinnerArrowsConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSplitPaneDividerRendererDescription(@NotNull SplitPaneDividerConfiguration g) {
        AquaUIPainter.Orientation o = g.getOrientation();
        switch (g.getWidget()) {
            case THIN_DIVIDER: {
                return o == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 9.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
            case THICK_DIVIDER: {
                return o == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f) : new MultiResolutionRendererDescription(new BasicRendererDescription(-4.0f, 0.0f, 6.0f, 0.0f), new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 0.0f));
            }
            case PANE_SPLITTER: {
                return o == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f) : new BasicRendererDescription(-5.0f, 0.0f, 10.0f, 0.0f);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public RendererDescription getGroupBoxRendererDescription(@NotNull GroupBoxConfiguration g) {
        return new BasicRendererDescription(-3.0f, -2.0f, 6.0f, 6.0f);
    }

    @Override
    @NotNull
    public RendererDescription getListBoxRendererDescription(@NotNull ListBoxConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getTextFieldRendererDescription(@NotNull TextFieldConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getScrollBarRendererDescription(@NotNull ScrollBarConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getScrollColumnSizerRendererDescription(@NotNull ScrollColumnSizerConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getProgressIndicatorRendererDescription(@NotNull ProgressIndicatorConfiguration g) {
        AquaUIPainter.ProgressWidget pw = g.getWidget();
        AquaUIPainter.Orientation o = g.getOrientation();
        AquaUIPainter.Size sz = g.getSize();
        if (pw == AquaUIPainter.ProgressWidget.BAR) {
            if (o == AquaUIPainter.Orientation.HORIZONTAL) {
                return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 1.0f);
            }
            return new BasicRendererDescription(0.0f, -1.0f, 1.0f, 2.0f);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getIndeterminateProgressIndicatorRendererDescription(@NotNull IndeterminateProgressIndicatorConfiguration g) {
        AquaUIPainter.ProgressWidget pw = g.getWidget();
        AquaUIPainter.Orientation o = g.getOrientation();
        AquaUIPainter.Size sz = g.getSize();
        if (pw == AquaUIPainter.ProgressWidget.INDETERMINATE_BAR) {
            if (o == AquaUIPainter.Orientation.HORIZONTAL) {
                return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 1.0f);
            }
            return new BasicRendererDescription(0.0f, -1.0f, 1.0f, 2.0f);
        }
        if (pw == AquaUIPainter.ProgressWidget.SPINNER) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getTableColumnHeaderRendererDescription(@NotNull TableColumnHeaderConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getGradientRendererDescription(@NotNull GradientConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    protected AquaUIPainter.ButtonWidget toCanonicalButtonStyle(AquaUIPainter.ButtonWidget bw) {
        return bw;
    }

    protected int pos(@NotNull AquaUIPainter.Position pos, int first, int last, int only) {
        switch (pos) {
            case FIRST: {
                return first;
            }
            case LAST: {
                return last;
            }
            case ONLY: {
                return only;
            }
        }
        return 0;
    }

    protected int pos(@NotNull AquaUIPainter.Position pos, int first, int middle, int last, int only) {
        switch (pos) {
            case FIRST: {
                return first;
            }
            case MIDDLE: {
                return middle;
            }
            case LAST: {
                return last;
            }
            case ONLY: {
                return only;
            }
        }
        return 0;
    }

    protected float pos(@NotNull AquaUIPainter.Position pos, float first, float last, float only) {
        switch (pos) {
            case FIRST: {
                return first;
            }
            case LAST: {
                return last;
            }
            case ONLY: {
                return only;
            }
        }
        return 0.0f;
    }

    protected float pos(@NotNull AquaUIPainter.Position pos, float first, float middle, float last, float only) {
        switch (pos) {
            case FIRST: {
                return first;
            }
            case MIDDLE: {
                return middle;
            }
            case LAST: {
                return last;
            }
            case ONLY: {
                return only;
            }
        }
        return 0.0f;
    }
}

