/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.geom.GeneralRoundRectangle;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.GroupBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.ListBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsLayoutConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerLayoutConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.UIOutliner;
import org.violetlib.jnr.aqua.impl.YosemiteLayoutInfo;

public class YosemiteOutliner
extends UIOutliner {
    @NotNull
    protected final YosemiteLayoutInfo uiLayout;

    public YosemiteOutliner(@NotNull YosemiteLayoutInfo uiLayout) {
        this.uiLayout = uiLayout;
    }

    @Override
    protected Shape getSliderThumbOutline(@NotNull Rectangle2D bounds, @NotNull SliderThumbLayoutConfiguration g) {
        Insetter insets = this.uiLayout.getSliderThumbInsets(g, g.getThumbPosition());
        Rectangle2D tb = insets.applyToBounds2D(bounds);
        AquaUIPainter.SliderWidget sw = g.getWidget();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (!g.hasTickMarks()) {
            return new Ellipse2D.Double(tb.getX(), tb.getY(), tb.getWidth(), tb.getHeight());
        }
        return tb;
    }

    @Override
    @Nullable
    protected Shape getButtonOutline(@NotNull Rectangle2D bounds, @NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO || bw == AquaUIPainter.ButtonWidget.BUTTON_HELP || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR) {
            switch (bw) {
                case BUTTON_HELP: {
                    width -= 1.0;
                    height -= 1.0;
                    x += 0.5;
                    break;
                }
                case BUTTON_ROUND: {
                    width -= 1.0;
                    height -= 1.0;
                    x += 0.5;
                }
            }
            if (height > width && !bw.isTextured()) {
                double excess = height - width;
                y += excess / 2.0;
                height = width;
            }
            return new Ellipse2D.Double(x, y, width, height);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL || bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT || bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return bounds;
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            return bounds;
        }
        double corner = 8.0;
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            corner = 6.0;
            x += (double)YosemiteOutliner.size2D(sz, 0.5f, 0.5f, 0.5f);
            y += (double)YosemiteOutliner.size2D(sz, 0.5f, 1.0f, 0.5f);
            height += (double)YosemiteOutliner.size2D(sz, -2.0f, -2.0f, -2.0f);
            width += (double)YosemiteOutliner.size2D(sz, -1.0f, -1.0f, -1.0f);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            x += (double)YosemiteOutliner.size2D(sz, 0.5f, 0.5f, 0.5f);
            y += (double)YosemiteOutliner.size2D(sz, 0.5f, 0.5f, 0.5f);
            height += (double)YosemiteOutliner.size2D(sz, -2.0f, -2.0f, -2.0f);
            width += (double)YosemiteOutliner.size2D(sz, -1.0f, -1.0f, -1.0f);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            corner = 5.0;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            x += (double)YosemiteOutliner.size2D(sz, 1.0f, 1.0f, 0.5f);
            y += (double)YosemiteOutliner.size2D(sz, 0.5f, 0.5f, 0.5f);
            width += (double)YosemiteOutliner.size2D(sz, -2.0f, -2.0f, -1.0f);
            height += (double)YosemiteOutliner.size2D(sz, -2.0f, -2.0f, -2.0f);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            height -= 0.5;
            corner = 14.0;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            corner = 6.0;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR) {
            corner = 6.0;
            height -= 0.5;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            width -= 0.5;
            corner = 3.0;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            height -= 0.5;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            y += 0.5;
            height -= 1.0;
            corner = YosemiteOutliner.size(sz, 16, 15, 14);
        }
        return new RoundRectangle2D.Double(x, y, width, height, corner, corner);
    }

    @Override
    @Nullable
    protected Shape getSegmentedButtonOutline(@NotNull Rectangle2D bounds, @NotNull SegmentedButtonLayoutConfiguration g) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.Position pos = g.getPosition();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        boolean isLeft = pos == AquaUIPainter.Position.FIRST;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                x += (double)YosemiteOutliner.size2D(sz, isLeft ? 0.5f : 0.0f, 0.0f, 0.0f);
                y += (double)YosemiteOutliner.size2D(sz, 0.5f, 1.0f, 1.0f);
                height += (double)YosemiteOutliner.size2D(sz, -2.0f, -3.0f, -2.0f);
                width += (double)YosemiteOutliner.size2D(sz, -0.5f, 0.0f, 0.0f);
                if (sz != AquaUIPainter.Size.SMALL && sz != AquaUIPainter.Size.MINI) break;
                if (pos == AquaUIPainter.Position.FIRST) {
                    x += 0.5;
                    width -= 0.5;
                    break;
                }
                if (pos == AquaUIPainter.Position.LAST) {
                    width -= 0.5;
                    break;
                }
                if (pos != AquaUIPainter.Position.ONLY) break;
                x += 0.5;
                width -= 1.0;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                width += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, 0.0f);
                height += (double)YosemiteOutliner.size2D(sz, -1.0f, -1.0f, -1.0f);
                break;
            }
        }
        return new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    @Nullable
    protected Shape getComboBoxOutline(@NotNull Rectangle2D bounds, @NotNull ComboBoxLayoutConfiguration g) {
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        AquaUIPainter.ComboBoxWidget widget = g.getWidget();
        if (widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX) {
            AquaUIPainter.Size sz = g.getSize();
            double corner = 6.0;
            return new GeneralRoundRectangle(x += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, 0.0f), y += (double)YosemiteOutliner.size2D(sz, 0.5f, 0.5f, 0.5f), width += (double)YosemiteOutliner.size2D(sz, -1.0f, -1.0f, -1.0f), height += (double)YosemiteOutliner.size2D(sz, -2.0f, -2.0f, -1.0f), 0.0, 0.0, corner, corner, corner, corner, 0.0, 0.0);
        }
        if (widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            Insetter insets = this.uiLayout.getComboBoxEditorInsets(g);
            return insets.applyToBounds2D(bounds);
        }
        if (widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            double corner = 4.0;
            return new GeneralRoundRectangle(x, y, width, height, corner, corner, corner, corner, corner, corner, corner, corner);
        }
        return null;
    }

    @Override
    @Nullable
    protected Shape getPopUpButtonOutline(@NotNull Rectangle2D bounds, @NotNull PopupButtonLayoutConfiguration g) {
        boolean isArrowsOnly;
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        boolean isSquare = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl = isArrowsOnly = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((isSquare || isArrowsOnly) && sz == AquaUIPainter.Size.MINI) {
            sz = AquaUIPainter.Size.SMALL;
        }
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE) {
            return new Rectangle2D.Double(x += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, -2.0f), y, width += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, 1.5f), height += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, -0.5f));
        }
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE) {
            return new Rectangle2D.Double(x += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, -0.5f), y, width += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, 1.0f), height);
        }
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT) {
            return new Rectangle2D.Double(x, y, width, height);
        }
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT) {
            return new Rectangle2D.Double(x, y, width, height);
        }
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL) {
            return new Rectangle2D.Double(x += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, -2.0f), y, width, height);
        }
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL) {
            return new Rectangle2D.Double(x += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, -0.5f), y, width, height);
        }
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR) {
            double corner = 6.0;
            return new RoundRectangle2D.Double(x, y, width, height -= 0.5, corner, corner);
        }
        x += 0.5;
        width -= 1.0;
        double corner = 8.0;
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN) {
            height += (double)YosemiteOutliner.size2D(sz, -2.0f, -2.0f, -2.0f);
            y += (double)YosemiteOutliner.size2D(sz, 0.5f, 0.5f, 0.5f);
        } else if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP) {
            height += (double)YosemiteOutliner.size2D(sz, -2.0f, -2.0f, -2.0f);
            y += (double)YosemiteOutliner.size2D(sz, 0.0f, 0.0f, 0.5f);
        } else if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_BEVEL) {
            height += (double)YosemiteOutliner.size2D(sz, -2.0f, -2.0f, -1.0f);
            y += (double)YosemiteOutliner.size2D(sz, 0.5f, 0.5f, 0.5f);
        }
        return new RoundRectangle2D.Double(x, y, width, height, corner, corner);
    }

    @Override
    @Nullable
    protected Shape getToolBarItemWellOutline(@NotNull Rectangle2D bounds, @NotNull ToolBarItemWellLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getTitleBarOutline(@NotNull Rectangle2D bounds, @NotNull TitleBarLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getSliderOutline(@NotNull Rectangle2D bounds, @NotNull SliderLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getSpinnerArrowsOutline(@NotNull Rectangle2D bounds, @NotNull SpinnerArrowsLayoutConfiguration g) {
        AquaUIPainter.Size sz = g.getSize();
        double x = bounds.getX() + (double)YosemiteOutliner.size2D(sz, 1.0f, 1.0f, 1.0f);
        double y = bounds.getY() + (double)YosemiteOutliner.size2D(sz, 1.0f, 0.5f, 0.5f);
        double w = bounds.getWidth() + (double)YosemiteOutliner.size2D(sz, -2.5f, -2.5f, -2.5f);
        double h = bounds.getHeight() + (double)YosemiteOutliner.size2D(sz, -2.5f, -2.5f, -2.5f);
        double corner = 9.0;
        return new RoundRectangle2D.Double(x, y, w, h, corner, corner);
    }

    @Override
    @Nullable
    protected Shape getSplitPaneDividerOutline(@NotNull Rectangle2D bounds, @NotNull SplitPaneDividerLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getGroupBoxOutline(@NotNull Rectangle2D bounds, @NotNull GroupBoxLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getListBoxOutline(@NotNull Rectangle2D bounds, @NotNull ListBoxLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getTextFieldOutline(@NotNull Rectangle2D bounds, @NotNull TextFieldLayoutConfiguration g) {
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        if (w.isSearch() || w.isRound()) {
            double corner = 6.0;
            if (w.isToolbar()) {
                height -= 0.5;
            } else {
                x += 0.5;
                y += 0.5;
                width -= 1.0;
                height -= 1.0;
            }
            return new RoundRectangle2D.Double(x, y, width, height, corner, corner);
        }
        return new Rectangle2D.Double(x += 0.5, y += 0.5, width -= 1.5, height -= 1.5);
    }

    @Override
    @Nullable
    protected Shape getScrollBarOutline(@NotNull Rectangle2D bounds, @NotNull ScrollBarLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getScrollColumnSizerOutline(@NotNull Rectangle2D bounds, @NotNull ScrollColumnSizerLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getProgressIndicatorOutline(@NotNull Rectangle2D bounds, @NotNull ProgressIndicatorLayoutConfiguration g) {
        return null;
    }

    @Override
    @Nullable
    protected Shape getTableColumnHeaderOutline(@NotNull Rectangle2D bounds, @NotNull TableColumnHeaderLayoutConfiguration g) {
        return null;
    }
}

