/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.impl.CircularSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.ComboBoxButtonCellPainterExtension;
import org.violetlib.jnr.aqua.impl.LinearSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.OverlayScrollBarPainterExtension;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainter;
import org.violetlib.jnr.aqua.impl.PullDownArrowPainter;
import org.violetlib.jnr.aqua.impl.TableColumnHeaderCellPainterExtension;
import org.violetlib.jnr.aqua.impl.ThickSplitPaneDividerPainterExtension;
import org.violetlib.jnr.aqua.impl.ThinSplitPaneDividerPainterExtension;
import org.violetlib.jnr.aqua.jrs.JRSPainter;
import org.violetlib.jnr.impl.Renderer;

public class AugmentedJRSPainter
extends JRSPainter {
    @Override
    @NotNull
    public AugmentedJRSPainter copy() {
        return new AugmentedJRSPainter();
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration g) {
        TableColumnHeaderCellPainterExtension px = new TableColumnHeaderCellPainterExtension(g);
        return Renderer.create(px);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration g) {
        if (g.getWidget() == AquaUIPainter.DividerWidget.THICK_DIVIDER) {
            ThickSplitPaneDividerPainterExtension px = new ThickSplitPaneDividerPainterExtension(g);
            return Renderer.create(px);
        }
        if (g.getWidget() == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            ThinSplitPaneDividerPainterExtension px = new ThinSplitPaneDividerPainterExtension(g);
            return Renderer.create(px);
        }
        return super.getSplitPaneDividerRenderer(g);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            ComboBoxButtonCellPainterExtension px = new ComboBoxButtonCellPainterExtension(g);
            return Renderer.create(px);
        }
        return super.getComboBoxButtonRenderer(g);
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration g) {
        Renderer r = super.getPopupArrowRenderer(g);
        if (this.isArrowNeeded(g)) {
            if (g.isPopUp()) {
                return Renderer.create(new PopUpArrowPainter(g));
            }
            return Renderer.create(new PullDownArrowPainter(g));
        }
        return r;
    }

    private boolean isArrowNeeded(@NotNull PopupButtonConfiguration g) {
        AquaUIPainter.PopupButtonWidget w = g.getPopupButtonWidget();
        if (g.isPopUp()) {
            return w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED;
        }
        switch (w) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration g) {
        AquaUIPainter.ScrollBarWidget sw = g.getWidget();
        if (sw == AquaUIPainter.ScrollBarWidget.LEGACY) {
            return super.getScrollBarRenderer(g);
        }
        return Renderer.create(new OverlayScrollBarPainterExtension(uiLayout, g));
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration g) {
        Renderer r = super.getSliderRenderer(g);
        if (g.getWidget() == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            Renderer pr = Renderer.create(new CircularSliderPainterExtension(g));
            return Renderer.createCompositeRenderer(r, pr);
        }
        return r;
    }

    @Override
    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration g) {
        if (g.getWidget() != AquaUIPainter.SliderWidget.SLIDER_CIRCULAR && g.hasTickMarks()) {
            return Renderer.create(new LinearSliderPainterExtension(uiLayout, g));
        }
        return null;
    }
}

