/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.coreui.CoreUIRendererDescriptions;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.RendererDescription;

public class JRSRendererDescriptions
extends CoreUIRendererDescriptions {
    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration g) {
        boolean compress = false;
        AquaUIPainter.SegmentedButtonWidget w = g.getWidget();
        if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR) {
            g = g.withWidget(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED);
        } else if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
            g = g.withWidget(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED);
            compress = true;
        }
        RendererDescription rd = super.getSegmentedButtonRendererDescription(g);
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.Position position = g.getPosition();
        try {
            switch (bw) {
                case BUTTON_SEGMENTED: {
                    if (sz == AquaUIPainter.Size.MINI) {
                        rd = new BasicRendererDescription(0.0f, 0.0f, position == AquaUIPainter.Position.MIDDLE ? 1.0f : 0.0f, 4.0f);
                    }
                    float yOffset = JNRUtils.size(sz, -1, -1, 0);
                    float xOffset = compress ? JNRUtils.size2D(sz, -2.49f, -2.49f, -1.49f) : -123456.0f;
                    float widthAdjust = compress ? JNRUtils.size2D(sz, 5.0f, 5.0f, 3.0f) : -123456.0f;
                    return JNRUtils.changeRendererDescription(rd, xOffset, yOffset, widthAdjust, -123456.0f);
                }
                case BUTTON_SEGMENTED_INSET: {
                    return JNRUtils.changeRendererDescription(rd, -123456.0f, -1.0f, -123456.0f, -123456.0f);
                }
                case BUTTON_SEGMENTED_SCURVE: 
                case BUTTON_SEGMENTED_TEXTURED: 
                case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
                case BUTTON_SEGMENTED_TOOLBAR: {
                    if (sz == AquaUIPainter.Size.MINI) {
                        rd = new BasicRendererDescription(0.0f, 0.0f, position == AquaUIPainter.Position.MIDDLE ? 1.0f : 0.0f, 4.0f);
                    }
                    return JNRUtils.changeRendererDescription(rd, -123456.0f, 0.0f, -123456.0f, -123456.0f);
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + g);
        }
        return rd;
    }
}

