/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIControl;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.jrs.JRSRenderer;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.EmptyRenderer;

public class JRSRendererMaker {
    @Nullable
    protected JRSUIConstants.Widget currentWidget;
    @Nullable
    protected JRSUIControl control;
    @Nullable
    protected JRSUIState state;
    private static final Method stateSetMethod = JRSRendererMaker.getStateSetMethod();

    private static Method getStateSetMethod() {
        Method[] methods;
        Class<JRSUIState> c = JRSUIState.class;
        for (Method m : methods = c.getMethods()) {
            if (!m.getName().equals("set")) continue;
            return m;
        }
        throw new UnsupportedOperationException("Set method on JRSUIState not found");
    }

    public void reset() {
        if (this.state != null) {
            this.state.reset();
        }
    }

    protected void setProperty(@NotNull Object p) {
        try {
            stateSetMethod.invoke((Object)this.state, p);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Unable to set JRSUIState property: " + ex);
        }
    }

    public void set(@NotNull JRSUIConstants.Size p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.State p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.Direction p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.Orientation p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.AlignmentVertical p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.AlignmentHorizontal p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.SegmentPosition p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.ScrollBarPart p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.Variant p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.WindowType p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.Focused p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.IndicatorOnly p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.NoIndicator p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.ArrowsOnly p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.FrameOnly p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.SegmentTrailingSeparator p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.SegmentLeadingSeparator p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.NothingToScroll p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.WindowTitleBarSeparator p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.WindowClipCorners p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.ShowArrows p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.BooleanValue p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.Animating p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.Widget p) {
        if (p == this.currentWidget) {
            return;
        }
        if (p == JRSUIConstants.Widget.SCROLL_BAR) {
            this.state = JRSUIStateFactory.getScrollBar();
        } else if (p == JRSUIConstants.Widget.PROGRESS_BAR || p == JRSUIConstants.Widget.PROGRESS_INDETERMINATE_BAR || p == JRSUIConstants.Widget.PROGRESS_RELEVANCE || p == JRSUIConstants.Widget.PROGRESS_SPINNER) {
            this.state = JRSUIStateFactory.getProgressBar();
            this.setProperty(p);
        } else if (p == JRSUIConstants.Widget.DISCLOSURE_TRIANGLE) {
            this.state = JRSUIStateFactory.getDisclosureTriangle();
        } else if (p == JRSUIConstants.Widget.BUTTON_CHECK_BOX || p == JRSUIConstants.Widget.BUTTON_RADIO) {
            this.state = JRSUIStateFactory.getLabeledButton();
            this.setProperty(p);
        } else if (p == JRSUIConstants.Widget.WINDOW_FRAME) {
            this.state = JRSUIStateFactory.getTitleBar();
        } else if (p == JRSUIConstants.Widget.TAB) {
            this.state = JRSUIStateFactory.getTab();
        } else if (p == JRSUIConstants.Widget.DIVIDER_SPLITTER) {
            this.state = JRSUIStateFactory.getSplitPaneDivider();
        } else if (p == JRSUIConstants.Widget.BUTTON_LITTLE_ARROWS) {
            this.state = JRSUIStateFactory.getSpinnerArrows();
        } else if (p == JRSUIConstants.Widget.SLIDER_THUMB) {
            this.state = JRSUIStateFactory.getProgressBar();
            this.setProperty(p);
        } else if (p == JRSUIConstants.Widget.SLIDER || p == JRSUIConstants.Widget.DIAL || p == JRSUIConstants.Widget.BUTTON_BEVEL || p == JRSUIConstants.Widget.BUTTON_BEVEL_ROUND || p == JRSUIConstants.Widget.BUTTON_BEVEL_INSET || p == JRSUIConstants.Widget.BUTTON_PUSH_TEXTURED || p == JRSUIConstants.Widget.BUTTON_ROUND) {
            this.state = JRSUIStateFactory.getProgressBar();
            this.setProperty(p);
        } else {
            this.state = JRSUIState.getInstance();
            this.setProperty(p);
        }
        this.control = new JRSUIControl(false);
    }

    public void set(@NotNull JRSUIConstants.Hit p) {
        this.setProperty(p);
    }

    public void set(@NotNull JRSUIConstants.ScrollBarHit p) {
        this.setProperty(p);
    }

    public void setValue(double value) {
        if (!(this.state instanceof JRSUIState.ValueState)) {
            throw new IllegalStateException("Renderer not configured for value attribute");
        }
        JRSUIState.ValueState vstate = (JRSUIState.ValueState)this.state;
        vstate.setValue(value);
    }

    public void setThumbStart(double value) {
        if (!(this.state instanceof JRSUIState.ScrollBarState)) {
            throw new IllegalStateException("Renderer not configured for thumb start attribute");
        }
        JRSUIState.ScrollBarState sbstate = (JRSUIState.ScrollBarState)this.state;
        sbstate.setThumbStart(value);
    }

    public void setThumbPercent(double value) {
        if (!(this.state instanceof JRSUIState.ScrollBarState)) {
            throw new IllegalStateException("Renderer not configured for thumb percent attribute");
        }
        JRSUIState.ScrollBarState sbstate = (JRSUIState.ScrollBarState)this.state;
        sbstate.setThumbPercent(value);
    }

    public void setAnimationFrame(int frame) {
        if (!(this.state instanceof JRSUIState.AnimationFrameState)) {
            throw new IllegalStateException("Renderer not configured for animation frame attribute");
        }
        JRSUIState.AnimationFrameState astate = (JRSUIState.AnimationFrameState)this.state;
        astate.setAnimationFrame(frame);
    }

    @NotNull
    public BasicRenderer getRenderer() {
        if (this.state != null) {
            assert (this.control != null);
            this.state = this.state.derive();
            return new JRSRenderer(this.control, this.state);
        }
        return new EmptyRenderer();
    }
}

