/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.JNR18MultiResolutionImage;

public class JNRPlatformUtils {
    @Nullable
    private static String platformVersionString;
    private static int platformVersion;
    @NotNull
    private static final WeakHashMap<Graphics, Integer> scaleMap;

    public static synchronized int getPlatformVersion() {
        if (platformVersionString == null) {
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            boolean isOSX = osName.equals("Mac OS X");
            if (isOSX) {
                platformVersionString = osVersion;
                int n1 = 0;
                int n2 = 0;
                int n3 = 0;
                StringTokenizer st = new StringTokenizer(osVersion, ".");
                if (st.hasMoreTokens()) {
                    n1 = JNRPlatformUtils.parseComponent(st.nextToken());
                    if (st.hasMoreTokens()) {
                        n2 = JNRPlatformUtils.parseComponent(st.nextToken());
                        if (st.hasMoreTokens()) {
                            n3 = JNRPlatformUtils.parseComponent(st.nextToken());
                        }
                    }
                }
                platformVersion = n1 * 10000 + n2 * 100 + n3;
                return platformVersion;
            }
        }
        return platformVersion;
    }

    private static int parseComponent(@NotNull String s) {
        try {
            int n = Integer.parseInt(s);
            if (n > 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    @Nullable
    public static Graphics2D toGraphics2D(@NotNull Graphics g) {
        try {
            return (Graphics2D)g;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static int getScaleFactor(@NotNull Graphics g) {
        int scaleFactor;
        Integer n = scaleMap.get(g);
        if (n != null) {
            return n;
        }
        if (g instanceof Graphics2D) {
            Graphics2D gg = (Graphics2D)g;
            GraphicsConfiguration gc = gg.getDeviceConfiguration();
            scaleFactor = JNRPlatformUtils.getScaleFactor(gc);
        } else {
            scaleFactor = 1;
        }
        scaleMap.put(g, scaleFactor);
        return scaleFactor;
    }

    public static int getScaleFactor(@NotNull GraphicsConfiguration gc) {
        GraphicsDevice device = gc.getDevice();
        Object scale = null;
        try {
            Field field = device.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                scale = field.get(device);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (scale instanceof Integer) {
            return (Integer)scale;
        }
        return 1;
    }

    @NotNull
    public static Image createMultiResolutionImage(int baseImageWidth, int baseImageHeight, @NotNull BufferedImage im) {
        return new JNR18MultiResolutionImage(baseImageWidth, baseImageHeight, im);
    }

    static {
        platformVersion = 0;
        scaleMap = new WeakHashMap();
    }
}

