/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class JNRUtils {
    @NotNull
    static final DecimalFormat df2 = new DecimalFormat("0.00");
    public static final float NO_CHANGE = -123456.0f;

    public static int size(@NotNull AquaUIPainter.Size sz, int regular, int small, int mini) {
        switch (sz) {
            case SMALL: {
                return small;
            }
            case MINI: {
                return mini;
            }
        }
        return regular;
    }

    public static float size2D(@NotNull AquaUIPainter.Size sz, float regular, float small, float mini) {
        switch (sz) {
            case SMALL: {
                return small;
            }
            case MINI: {
                return mini;
            }
        }
        return regular;
    }

    @NotNull
    public static String format2(double v) {
        return df2.format(v);
    }

    @Nullable
    public static BasicRendererDescription toBasicRendererDescription(@NotNull RendererDescription rd) {
        if (rd instanceof BasicRendererDescription) {
            return (BasicRendererDescription)rd;
        }
        return null;
    }

    @Nullable
    public static BasicRendererDescription toBasicRendererDescription(@NotNull RendererDescription rd, int scaleFactor) {
        if (rd instanceof BasicRendererDescription) {
            return (BasicRendererDescription)rd;
        }
        if (rd instanceof MultiResolutionRendererDescription) {
            RendererDescription ard;
            MultiResolutionRendererDescription mrd = (MultiResolutionRendererDescription)rd;
            RendererDescription rendererDescription = ard = scaleFactor == 1 ? mrd.getDescription1() : mrd.getDescription2();
            if (ard instanceof BasicRendererDescription) {
                return (BasicRendererDescription)ard;
            }
        }
        return null;
    }

    @NotNull
    public static RendererDescription adjustRendererDescription(@NotNull RendererDescription rd, float deltaX, float deltaY, float deltaWA, float deltaHA) throws UnsupportedOperationException {
        if (deltaX == 0.0f && deltaY == 0.0f && deltaWA == 0.0f && deltaHA == 0.0f) {
            return rd;
        }
        BasicRendererDescription brd = JNRUtils.toBasicRendererDescription(rd);
        if (brd != null) {
            return brd.withAdjustments(deltaX, deltaY, deltaWA, deltaHA);
        }
        if (rd instanceof MultiResolutionRendererDescription) {
            MultiResolutionRendererDescription mrd = (MultiResolutionRendererDescription)rd;
            BasicRendererDescription rd1 = JNRUtils.toBasicRendererDescription(mrd.getDescription1());
            BasicRendererDescription rd2 = JNRUtils.toBasicRendererDescription(mrd.getDescription2());
            if (rd1 != null && rd2 != null) {
                rd1 = rd1.withAdjustments(deltaX, deltaY, deltaWA, deltaHA);
                rd2 = rd2.withAdjustments(deltaX, deltaY, deltaWA, deltaHA);
                return new MultiResolutionRendererDescription(rd1, rd2);
            }
        }
        throw new UnsupportedOperationException("Renderer description cannot be adjusted");
    }

    @NotNull
    public static RendererDescription changeRendererDescription(@NotNull RendererDescription rd, float x, float y, float wa, float ha) throws UnsupportedOperationException {
        if (x == -123456.0f && y == -123456.0f && wa == -123456.0f && ha == -123456.0f) {
            return rd;
        }
        BasicRendererDescription brd = JNRUtils.toBasicRendererDescription(rd);
        if (brd != null) {
            return JNRUtils.change(brd, x, y, wa, ha);
        }
        if (rd instanceof MultiResolutionRendererDescription) {
            MultiResolutionRendererDescription mrd = (MultiResolutionRendererDescription)rd;
            BasicRendererDescription rd1 = JNRUtils.toBasicRendererDescription(mrd.getDescription1());
            BasicRendererDescription rd2 = JNRUtils.toBasicRendererDescription(mrd.getDescription2());
            if (rd1 != null && rd2 != null) {
                rd1 = JNRUtils.change(rd1, x, y, wa, ha);
                rd2 = JNRUtils.change(rd2, x, y, wa, ha);
                return new MultiResolutionRendererDescription(rd1, rd2);
            }
        }
        throw new UnsupportedOperationException("Renderer description cannot be changed");
    }

    @NotNull
    private static BasicRendererDescription change(@NotNull BasicRendererDescription brd, float x, float y, float wa, float ha) {
        float nx = x == -123456.0f ? brd.getXOffset() : x;
        float ny = y == -123456.0f ? brd.getYOffset() : y;
        float nwa = wa == -123456.0f ? brd.getWidthAdjustment() : wa;
        float nha = ha == -123456.0f ? brd.getHeightAdjustment() : ha;
        return new BasicRendererDescription(nx, ny, nwa, nha);
    }

    static {
        df2.setDecimalSeparatorAlwaysShown(true);
    }
}

