/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererRenderer;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.PainterExtensionRenderer;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

class OffsetRasterRendererX
extends Renderer {
    @NotNull
    private final Renderer source;
    private final int x;
    private final int y;
    private final int w;
    private final int h;

    public OffsetRasterRendererX(@NotNull Renderer source, int x, int y, int w, int h) {
        this.source = source;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        if (this.source instanceof BasicRendererRenderer) {
            BasicRendererRenderer brr = (BasicRendererRenderer)this.source;
            BasicRenderer r = brr.getBasicRenderer();
            RendererDescription rd = brr.getRendererDescription();
            if (rd.isTrivial()) {
                compositor.composeRenderer(r, this.x, this.y, this.w, this.h);
            } else {
                int scaleFactor = compositor.getScaleFactor();
                float sf = scaleFactor;
                Rectangle2D.Float bounds = new Rectangle2D.Float((float)this.x / sf, (float)this.y / sf, (float)this.w / sf, (float)this.h / sf);
                RasterDescription sd = rd.getRasterBounds(bounds, scaleFactor);
                int rx = Math.round((float)scaleFactor * sd.getX());
                int ry = Math.round((float)scaleFactor * sd.getY());
                int rw = (int)Math.ceil((float)scaleFactor * sd.getWidth());
                int rh = (int)Math.ceil((float)scaleFactor * sd.getHeight());
                compositor.composeRenderer(r, rx, ry, rw, rh);
            }
        } else if (this.source instanceof PainterExtensionRenderer) {
            PainterExtensionRenderer pxr = (PainterExtensionRenderer)this.source;
            PainterExtension px = pxr.getPainterExtension();
            compositor.composePainter(px, this.x, this.y, this.w, this.h);
        }
    }
}

