/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererRenderer;
import org.violetlib.jnr.impl.CompositeRenderer;
import org.violetlib.jnr.impl.NullRenderer;
import org.violetlib.jnr.impl.OffsetRasterRendererX;
import org.violetlib.jnr.impl.OffsetRendererX;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.PainterExtensionRenderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;
import org.violetlib.jnr.impl.TrivialRendererDescription;

public abstract class Renderer
implements ReusableCompositor.PixelSource {
    private static final Renderer NULL_RENDERER = new NullRenderer();

    @NotNull
    public static Renderer create(@NotNull BasicRenderer r, @Nullable RendererDescription rd) {
        if (rd == null) {
            rd = TrivialRendererDescription.getInstance();
        }
        return new BasicRendererRenderer(r, rd);
    }

    @NotNull
    public static Renderer create(@NotNull PainterExtension px) {
        return new PainterExtensionRenderer(px);
    }

    @NotNull
    public static Renderer createCompositeRenderer(Renderer ... rs) {
        if (rs == null || rs.length == 0) {
            return NULL_RENDERER;
        }
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        for (Renderer r : rs) {
            if (r == null) continue;
            renderers.add(r);
        }
        switch (renderers.size()) {
            case 0: {
                return NULL_RENDERER;
            }
            case 1: {
                return (Renderer)renderers.get(0);
            }
        }
        return new CompositeRenderer(renderers);
    }

    @NotNull
    public static Renderer createOffsetRenderer(@NotNull Renderer source, float x, float y, float w, float h) {
        return new OffsetRendererX(source, x, y, w, h);
    }

    @NotNull
    public static Renderer createOffsetRenderer(@NotNull Renderer source, double x, double y, double w, double h) {
        return new OffsetRendererX(source, (float)x, (float)y, (float)w, (float)h);
    }

    @NotNull
    public static Renderer createOffsetRenderer(@NotNull Renderer source, @NotNull Rectangle2D bounds) {
        return new OffsetRendererX(source, (float)bounds.getX(), (float)bounds.getY(), (float)bounds.getWidth(), (float)bounds.getHeight());
    }

    @NotNull
    public static Renderer createRasterOffsetRenderer(@NotNull Renderer source, int x, int y, int w, int h) {
        return new OffsetRasterRendererX(source, x, y, w, h);
    }

    @Nullable
    public BasicRenderer getBasicRenderer() {
        return null;
    }

    @Nullable
    public RendererDescription getRendererDescription() {
        return null;
    }
}

