/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public abstract class RendererPainter
implements Painter {
    @NotNull
    protected final Renderer r;
    protected final float width;
    protected final float height;

    public RendererPainter(@NotNull Renderer r, float width, float height) {
        this.r = r;
        this.width = width;
        this.height = height;
    }

    @Override
    public void paint(@NotNull Graphics gg, float x, float y) {
        Graphics2D g2;
        int h;
        int w;
        int scaleFactor = JNRPlatformUtils.getScaleFactor(gg);
        Image im = this.getImage(scaleFactor, w = (int)Math.ceil(this.width), h = (int)Math.ceil(this.height));
        if (im != null && (g2 = JNRPlatformUtils.toGraphics2D(gg)) != null) {
            Graphics2D g = (Graphics2D)g2.create();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform tr = AffineTransform.getTranslateInstance(x, y);
            g.drawImage(im, tr, null);
            g.dispose();
        }
    }

    @Nullable
    protected Image getImage(int scaleFactor, int width, int height) {
        return this.createImage(scaleFactor, width, height);
    }

    @Nullable
    protected Image createImage(int scaleFactor, int width, int height) {
        ReusableCompositor rc = new ReusableCompositor();
        int rasterWidth = width * scaleFactor;
        int rasterHeight = height * scaleFactor;
        rc.reset(rasterWidth, rasterHeight, scaleFactor);
        this.r.composeTo(rc);
        BufferedImage theImage = rc.getImage();
        return theImage != null ? JNRPlatformUtils.createMultiResolutionImage(width, height, theImage) : null;
    }
}

