/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.BasicImageSupport;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.PainterExtension;

public class ReusableCompositor {
    @Nullable
    private int[] data;
    @Nullable
    private BufferedImage b;
    private boolean isConfigured;
    private boolean isEmpty;
    private int rasterWidth;
    private int rasterHeight;
    private int scaleFactor;

    @NotNull
    public static ColorModel getColorModel() {
        return BasicImageSupport.getColorModel();
    }

    public int getRasterWidth() {
        return this.rasterWidth;
    }

    public int getRasterHeight() {
        return this.rasterHeight;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public float getWidth() {
        return (float)this.rasterWidth / (float)this.scaleFactor;
    }

    public float getHeight() {
        return (float)this.rasterHeight / (float)this.scaleFactor;
    }

    public void reset(int rasterWidth, int rasterHeight, int scaleFactor) {
        if (rasterWidth < 0 || rasterHeight < 0) {
            throw new IllegalArgumentException("Invalid negative raster width and/or height");
        }
        if (scaleFactor < 1 || scaleFactor > 8) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        this.rasterWidth = rasterWidth;
        this.rasterHeight = rasterHeight;
        this.scaleFactor = scaleFactor;
        this.isEmpty = true;
    }

    protected void ensureConfigured() {
        if (!this.isConfigured) {
            this.isConfigured = true;
            int requiredSize = this.rasterWidth * this.rasterHeight;
            if (requiredSize > 0) {
                if (this.data == null || this.data.length < requiredSize) {
                    this.data = new int[requiredSize];
                    this.b = null;
                } else {
                    Arrays.fill(this.data, 0);
                }
            }
        }
    }

    public void render(@NotNull BasicRenderer r, int rasterWidth, int rasterHeight, int scaleFactor) {
        this.reset(rasterWidth, rasterHeight, scaleFactor);
        this.ensureConfigured();
        if (this.data != null) {
            float rw = (float)rasterWidth / (float)scaleFactor;
            float rh = (float)rasterHeight / (float)scaleFactor;
            r.render(this.data, rasterWidth, rasterHeight, rw, rh);
            this.isEmpty = false;
        }
    }

    public void compose(@NotNull Object o) {
        if (o instanceof BasicRenderer) {
            BasicRenderer br = (BasicRenderer)o;
            this.composeRenderer(br);
        } else if (o instanceof PainterExtension) {
            PainterExtension px = (PainterExtension)o;
            this.composePainter(px, 0.0f, 0.0f);
        } else if (o instanceof ReusableCompositor) {
            ReusableCompositor rc = (ReusableCompositor)o;
            this.composeFrom(rc, 0, 0, this.rasterWidth, this.rasterHeight);
        } else if (o instanceof PixelSource) {
            PixelSource sr = (PixelSource)o;
            sr.composeTo(this);
        } else {
            throw new UnsupportedOperationException("Unsupported pixel source");
        }
    }

    public void composeRenderer(@NotNull BasicRenderer r) {
        this.ensureConfigured();
        if (this.data != null) {
            if (this.isEmpty) {
                float rw = (float)this.rasterWidth / (float)this.scaleFactor;
                float rh = (float)this.rasterHeight / (float)this.scaleFactor;
                r.render(this.data, this.rasterWidth, this.rasterHeight, rw, rh);
                this.isEmpty = false;
            } else {
                this.composeRenderer(r, 0, 0, this.rasterWidth, this.rasterHeight);
            }
        }
    }

    public void composeRenderer(@NotNull BasicRenderer r, int dx, int dy, int dw, int dh) {
        if (dw > 0 && dh > 0) {
            ReusableCompositor temp = new ReusableCompositor();
            temp.render(r, dw, dh, this.scaleFactor);
            this.composeFrom(temp, dx, dy, dw, dh);
        }
    }

    public void composePainter(@NotNull PainterExtension px, int dx, int dy, int dw, int dh) {
        if (dw > 0 && dh > 0) {
            ReusableCompositor temp = new ReusableCompositor();
            temp.reset(dw, dh, this.scaleFactor);
            temp.composePainter(px, 0.0f, 0.0f);
            this.composeFrom(temp, dx, dy, dw, dh);
        }
    }

    public void composeFrom(@NotNull ReusableCompositor source, int dx, int dy, int dw, int dh) {
        int[] sourceData;
        this.ensureConfigured();
        if (this.data != null && (sourceData = source.data) != null) {
            this.isEmpty = false;
            int sourceSpan = source.getRasterWidth();
            for (int rowOffset = 0; rowOffset < dh; ++rowOffset) {
                int row = dy + rowOffset;
                if (row < 0 || row >= this.rasterHeight) continue;
                for (int colOffset = 0; colOffset < dw; ++colOffset) {
                    int pixel;
                    int alpha;
                    int col = dx + colOffset;
                    if (col < 0 || col >= this.rasterWidth || (alpha = (pixel = sourceData[rowOffset * sourceSpan + colOffset]) >> 24 & 0xFF) == 0) continue;
                    if (alpha != 255) {
                        pixel = ReusableCompositor.combine(this.data[row * this.rasterWidth + col], pixel);
                    }
                    this.data[row * this.rasterWidth + col] = pixel;
                }
            }
        }
    }

    public void composeFrom(@NotNull ReusableCompositor source, int sx, int sy, int dx, int dy, int dw, int dh) {
        int[] sourceData;
        this.ensureConfigured();
        if (this.data != null && (sourceData = source.data) != null) {
            this.isEmpty = false;
            int sourceWidth = source.getRasterWidth();
            int sourceHeight = source.getRasterHeight();
            for (int rowOffset = 0; rowOffset < dh; ++rowOffset) {
                int sourceRow = sy + rowOffset;
                int row = dy + rowOffset;
                if (row < 0 || row >= this.rasterHeight || sourceRow < 0 || sourceRow >= sourceHeight) continue;
                for (int colOffset = 0; colOffset < dw; ++colOffset) {
                    int pixel;
                    int alpha;
                    int sourceColumn = sx + colOffset;
                    int col = dx + colOffset;
                    if (col < 0 || col >= this.rasterWidth || sourceColumn < 0 || sourceColumn >= sourceWidth || (alpha = (pixel = sourceData[sourceRow * sourceWidth + sourceColumn]) >> 24 & 0xFF) == 0) continue;
                    if (alpha != 255) {
                        pixel = ReusableCompositor.combine(this.data[row * this.rasterWidth + col], pixel);
                    }
                    this.data[row * this.rasterWidth + col] = pixel;
                }
            }
        }
    }

    public void composePainter(@NotNull PainterExtension px, float x, float y) {
        BufferedImage im = this.getImage();
        if (im != null) {
            this.isEmpty = false;
            Graphics2D g = im.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.scale(this.scaleFactor, this.scaleFactor);
            g.translate(x, y);
            float rw = (float)this.rasterWidth / (float)this.scaleFactor;
            float rh = (float)this.rasterHeight / (float)this.scaleFactor;
            px.paint(g, rw, rh);
        }
    }

    public void renderFrom(@NotNull BasicRenderer r) {
        this.ensureConfigured();
        if (this.data != null) {
            this.isEmpty = false;
            float w = (float)this.rasterWidth / (float)this.scaleFactor;
            float h = (float)this.rasterHeight / (float)this.scaleFactor;
            r.render(this.data, this.rasterWidth, this.rasterHeight, w, h);
        }
    }

    public void erase(int dx, int dy, int dw, int dh) {
        if (dw > 0 && dh > 0) {
            this.ensureConfigured();
            if (this.data != null) {
                for (int rowOffset = 0; rowOffset < dh; ++rowOffset) {
                    int row = dy + rowOffset;
                    if (row < 0 || row >= this.rasterHeight) continue;
                    for (int colOffset = 0; colOffset < dw; ++colOffset) {
                        int col = dx + colOffset;
                        if (col < 0 || col >= this.rasterWidth) continue;
                        this.data[row * this.rasterWidth + col] = 0;
                    }
                }
            }
        }
    }

    @Nullable
    public BufferedImage getImage() {
        this.ensureConfigured();
        if (this.b == null && this.data != null) {
            this.b = BasicImageSupport.createImage(this.data, this.rasterWidth, this.rasterHeight);
        }
        return this.b;
    }

    public void paint(@NotNull Graphics2D g) {
        BufferedImage im = this.getImage();
        if (im != null) {
            g.drawImage(im, null, null);
        }
    }

    public static void compose(int[] data, int rw, int rh, int x, int y, int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        if (alpha != 0 && x >= 0 && x < rw && y >= 0 && y < rh) {
            int newPixel;
            int index = y * rw + x;
            int oldPixel = data[index];
            data[index] = newPixel = alpha != 255 ? ReusableCompositor.combine(oldPixel, pixel) : pixel;
        }
    }

    private static int combine(int oldPixel, int newPixel) {
        int oldAlpha = oldPixel >> 24 & 0xFF;
        int oldRed = oldPixel >> 16 & 0xFF;
        int oldGreen = oldPixel >> 8 & 0xFF;
        int oldBlue = oldPixel >> 0 & 0xFF;
        int newAlpha = newPixel >> 24 & 0xFF;
        int newRed = newPixel >> 16 & 0xFF;
        int newGreen = newPixel >> 8 & 0xFF;
        int newBlue = newPixel >> 0 & 0xFF;
        int f = 255 - newAlpha;
        int red = newRed + (oldRed * f >> 8) & 0xFF;
        int green = newGreen + (oldGreen * f >> 8) & 0xFF;
        int blue = newBlue + (oldBlue * f >> 8) & 0xFF;
        int alpha = (255 * newAlpha + oldAlpha * f) / 255 & 0xFF;
        int result = (alpha << 24) + (red << 16) + (green << 8) + blue;
        return result;
    }

    public static interface PixelSource {
        public void composeTo(@NotNull ReusableCompositor var1);
    }
}

