/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.GenericList;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.plaf.ListUI;

public class JListModel
implements GenericList {
    protected final JList list;

    public JListModel(JList list) {
        this.list = list;
    }

    @Override
    public JComponent getComponent() {
        return this.list;
    }

    @Override
    public void requestFocus() {
        if (this.list.isEnabled() && this.list.isRequestFocusEnabled()) {
            this.list.requestFocusInWindow();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.list.isEnabled();
    }

    @Override
    public int getRowCount() {
        return this.list.getModel().getSize();
    }

    @Override
    public Object getRow(int index) {
        return this.list.getModel().getElementAt(index);
    }

    @Override
    public boolean isMultipleSelection() {
        return this.list.getSelectionMode() != 0;
    }

    @Override
    public boolean isRowSelected(int index) {
        return this.list.isSelectedIndex(index);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.list.isSelectionEmpty();
    }

    @Override
    public void clearSelection() {
        this.list.clearSelection();
    }

    @Override
    public void setSelectionInterval(int index1, int index2) {
        this.list.setSelectionInterval(index1, index2);
    }

    @Override
    public void addSelectionInterval(int index1, int index2) {
        this.list.addSelectionInterval(index1, index2);
    }

    @Override
    public void removeSelectionInterval(int index1, int index2) {
        this.list.removeSelectionInterval(index1, index2);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.list.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.list.getSelectionModel().setAnchorSelectionIndex(index);
    }

    @Override
    public int getMinSelectionIndex() {
        return this.list.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.list.getMaxSelectionIndex();
    }

    @Override
    public boolean isValueAdjusting() {
        return this.list.getValueIsAdjusting();
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.list.getSelectionModel().setValueIsAdjusting(b);
    }

    @Override
    public int identifyRowAtLocation(Point loc) {
        Rectangle cellBounds;
        ListUI ui = this.list.getUI();
        int index = ui.locationToIndex(this.list, loc);
        if (index != -1 && ((double)loc.x > (cellBounds = this.list.getCellBounds(index, index)).getX() + cellBounds.getWidth() || (double)loc.y > cellBounds.getY() + cellBounds.getHeight())) {
            index = -1;
        }
        return index;
    }

    @Override
    public void scrollToViewRows(int index1, int index2) {
        ListUI ui = this.list.getUI();
        Rectangle cellBounds = ui.getCellBounds(this.list, index1, index2);
        this.list.scrollRectToVisible(cellBounds);
    }

    @Override
    public boolean isDragEnabled() {
        return this.list.getDragEnabled();
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.list.getTransferHandler();
    }
}

