/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.GenericList;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class JTableModel
implements GenericList {
    protected final JTable table;
    protected final int designatedColumnIndex;

    public JTableModel(JTable table, int designatedColumnIndex) {
        this.table = table;
        this.designatedColumnIndex = designatedColumnIndex;
    }

    @Override
    public JComponent getComponent() {
        return this.table;
    }

    @Override
    public void requestFocus() {
        if (this.table.isEnabled() && this.table.isRequestFocusEnabled()) {
            this.table.requestFocusInWindow();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.table.isEnabled();
    }

    @Override
    public int getRowCount() {
        return this.table.getRowCount();
    }

    @Override
    public Object getRow(int index) {
        return this.table.getModel().getValueAt(index, this.designatedColumnIndex);
    }

    @Override
    public boolean isMultipleSelection() {
        return this.table.getSelectionModel().getSelectionMode() != 0;
    }

    @Override
    public boolean isRowSelected(int index) {
        return this.table.getSelectionModel().isSelectedIndex(index);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.table.getSelectionModel().isSelectionEmpty();
    }

    @Override
    public void clearSelection() {
        this.table.clearSelection();
    }

    @Override
    public void setSelectionInterval(int index1, int index2) {
        this.table.getSelectionModel().setSelectionInterval(index1, index2);
    }

    @Override
    public void addSelectionInterval(int index1, int index2) {
        this.table.getSelectionModel().addSelectionInterval(index1, index2);
    }

    @Override
    public void removeSelectionInterval(int index1, int index2) {
        this.table.getSelectionModel().removeSelectionInterval(index1, index2);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.table.getSelectionModel().getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.table.getSelectionModel().setAnchorSelectionIndex(index);
    }

    @Override
    public int getMinSelectionIndex() {
        return this.table.getSelectionModel().getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.table.getSelectionModel().getMaxSelectionIndex();
    }

    @Override
    public boolean isValueAdjusting() {
        return this.table.getSelectionModel().getValueIsAdjusting();
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.table.getSelectionModel().setValueIsAdjusting(b);
    }

    @Override
    public int identifyRowAtLocation(Point loc) {
        return this.table.rowAtPoint(loc);
    }

    @Override
    public void scrollToViewRows(int index1, int index2) {
        int columnCount = this.table.getColumnCount();
        Rectangle r1 = this.table.getCellRect(index1, 0, false);
        Rectangle r2 = this.table.getCellRect(index2, columnCount - 1, false);
        this.table.scrollRectToVisible(r1.union(r2));
    }

    @Override
    public boolean isDragEnabled() {
        return this.table.getDragEnabled();
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.table.getTransferHandler();
    }
}

