/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaButtonUI;
import ch.randelshofer.quaqua.QuaquaLazyActionMap;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonListener;

public class QuaquaButtonListener
extends BasicButtonListener {
    transient long lastPressedTimestamp = -1L;
    transient boolean shouldDiscardRelease = false;

    public QuaquaButtonListener(AbstractButton button) {
        super(button);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)e.getSource();
            if (prop == null || prop.equals("Frame.active") || prop.equals("Quaqua.Button.type") || prop.equals("JButton.buttonType") || prop.equals("JButton.segmentPosition") || prop.equals("JComponent.sizeVariant")) {
                btn.repaint();
            }
        }
        super.propertyChange(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        AbstractButton b;
        if (SwingUtilities.isLeftMouseButton(e) && (b = (AbstractButton)e.getSource()).contains(e.getX(), e.getY())) {
            long multiClickThreshhold = Methods.invokeGetter((Object)b, "getMultiClickThreshhold", 0L);
            long lastTime = this.lastPressedTimestamp;
            long currentTime = this.lastPressedTimestamp = e.getWhen();
            if (lastTime != -1L && currentTime - lastTime < multiClickThreshhold) {
                this.shouldDiscardRelease = true;
                return;
            }
            ButtonModel model = b.getModel();
            if (!model.isEnabled()) {
                return;
            }
            if (!model.isArmed()) {
                model.setArmed(true);
            }
            if (!b.hasFocus()) {
                ButtonGroup grp;
                if (b.isRequestFocusEnabled()) {
                    b.requestFocus();
                } else if (model instanceof DefaultButtonModel && (grp = ((DefaultButtonModel)model).getGroup()) != null) {
                    Enumeration<AbstractButton> i = grp.getElements();
                    while (i.hasMoreElements()) {
                        AbstractButton grpButton = i.nextElement();
                        if (!grpButton.hasFocus()) continue;
                        b.setFocusable(true);
                        b.requestFocus();
                        break;
                    }
                }
            }
            model.setPressed(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            ButtonGroup grp;
            if (this.shouldDiscardRelease) {
                this.shouldDiscardRelease = false;
                return;
            }
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            model.setPressed(false);
            model.setArmed(false);
            if (!model.isSelected() && b.hasFocus() && model instanceof DefaultButtonModel && (grp = ((DefaultButtonModel)model).getGroup()) != null) {
                boolean groupHasFocus = false;
                Enumeration<AbstractButton> i = grp.getElements();
                while (i.hasMoreElements()) {
                    AbstractButton grpButton = i.nextElement();
                    if (!grpButton.isSelected()) continue;
                    grpButton.requestFocus();
                    break;
                }
                b.setFocusable(false);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled()) {
            model.setRollover(true);
        }
        if (model.isPressed()) {
            model.setArmed(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled()) {
            model.setRollover(false);
        }
        model.setArmed(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        QuaquaButtonUI ui;
        JRootPane root;
        AbstractButton b = (AbstractButton)e.getSource();
        if (b instanceof JButton && ((JButton)b).isDefaultCapable() && (root = b.getRootPane()) != null && (ui = (QuaquaButtonUI)QuaquaUtilities.getUIOfType(b.getUI(), QuaquaButtonUI.class)) != null && UIManager.get(ui.getPropertyPrefix() + "defaultButtonFollowsFocus") != Boolean.FALSE) {
            root.putClientProperty("temporaryDefaultButton", b);
            root.setDefaultButton((JButton)b);
            root.putClientProperty("temporaryDefaultButton", null);
        }
        b.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        QuaquaButtonUI ui;
        JButton initialDefault;
        AbstractButton b = (AbstractButton)e.getSource();
        JRootPane root = b.getRootPane();
        if (root != null && b != (initialDefault = (JButton)root.getClientProperty("initialDefaultButton")) && (ui = (QuaquaButtonUI)QuaquaUtilities.getUIOfType(b.getUI(), QuaquaButtonUI.class)) != null && UIManager.get(ui.getPropertyPrefix() + "defaultButtonFollowsFocus") != Boolean.FALSE) {
            root.setDefaultButton(initialDefault);
        }
        b.getModel().setArmed(false);
        b.repaint();
    }

    static void loadActionMap(QuaquaLazyActionMap map) {
        map.put(new Actions("pressed"));
        map.put(new Actions("released"));
        map.put(new Actions("selectNextButton"));
        map.put(new Actions("selectPreviousButton"));
    }

    private static class Actions
    extends AbstractAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String SELECT_NEXT_BUTTON = "selectNextButton";
        private static final String SELECT_PREVIOUS_BUTTON = "selectPreviousButton";

        public Actions(String name) {
            super(name);
        }

        public String getName() {
            return (String)this.getValue("Name");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton btn;
            DefaultButtonModel defaultButtonModel;
            ButtonGroup group;
            ButtonModel model;
            AbstractButton b = (AbstractButton)e.getSource();
            String key = this.getName();
            if (key == PRESS) {
                ButtonModel model2 = b.getModel();
                model2.setArmed(true);
                model2.setPressed(true);
                if (!b.hasFocus()) {
                    b.requestFocus();
                }
            } else if (key == RELEASE) {
                ButtonModel model3 = b.getModel();
                model3.setPressed(false);
                model3.setArmed(false);
            } else if (key == SELECT_NEXT_BUTTON) {
                AbstractButton btn2;
                DefaultButtonModel defaultButtonModel2;
                ButtonGroup group2;
                ButtonModel model4 = b.getModel();
                if (model4 instanceof DefaultButtonModel && (group2 = (defaultButtonModel2 = (DefaultButtonModel)model4).getGroup()) != null && (btn2 = this.getSiblingButton(group2, true)) != null) {
                    btn2.doClick();
                    btn2.requestFocusInWindow();
                }
            } else if (key == SELECT_PREVIOUS_BUTTON && (model = b.getModel()) instanceof DefaultButtonModel && (group = (defaultButtonModel = (DefaultButtonModel)model).getGroup()) != null && (btn = this.getSiblingButton(group, false)) != null) {
                btn.doClick();
                btn.requestFocusInWindow();
            }
        }

        public boolean isEnabled(Object sender) {
            return sender == null || !(sender instanceof AbstractButton) || ((AbstractButton)sender).getModel().isEnabled();
        }

        private AbstractButton getSiblingButton(ButtonGroup group, boolean isSelectNext) {
            AbstractButton adjacentToSelected = null;
            AbstractButton adjacentToFocused = null;
            if (isSelectNext) {
                boolean takeNextSelected = false;
                boolean takeNextFocused = false;
                Enumeration<AbstractButton> i = group.getElements();
                while (i.hasMoreElements()) {
                    AbstractButton buttonInGroup = i.nextElement();
                    if (takeNextSelected && buttonInGroup.isEnabled()) {
                        adjacentToSelected = buttonInGroup;
                        takeNextSelected = false;
                    }
                    if (takeNextFocused && buttonInGroup.isEnabled()) {
                        adjacentToFocused = buttonInGroup;
                        takeNextFocused = false;
                    }
                    if (buttonInGroup.isSelected()) {
                        takeNextSelected = true;
                    }
                    if (!buttonInGroup.isFocusOwner()) continue;
                    takeNextFocused = true;
                }
            } else {
                AbstractButton previousButton = null;
                Enumeration<AbstractButton> i = group.getElements();
                while (i.hasMoreElements()) {
                    AbstractButton buttonInGroup = i.nextElement();
                    if (buttonInGroup.isSelected()) {
                        adjacentToSelected = previousButton;
                    }
                    if (buttonInGroup.isFocusOwner()) {
                        adjacentToFocused = previousButton;
                    }
                    if (!buttonInGroup.isEnabled()) continue;
                    previousButton = buttonInGroup;
                }
            }
            return adjacentToFocused == null ? adjacentToSelected : adjacentToFocused;
        }
    }
}

