/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaComboBoxButton;
import ch.randelshofer.quaqua.QuaquaComboBoxEditor;
import ch.randelshofer.quaqua.QuaquaComboPopup;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class QuaquaComboBoxUI
extends BasicComboBoxUI
implements VisuallyLayoutable {
    private boolean isTableCellEditor = false;
    public static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    private static final Border tableCellEditorBorder = new EmptyBorder(0, 2, 0, 0);
    static final StringBuffer HIDE_POPUP_KEY = new StringBuffer("HidePopupKey");
    private Insets padding;
    private boolean isDisplaySizeDirty = true;
    private Dimension cachedDisplaySize = new Dimension(0, 0);
    private boolean sameBaseline;
    private QuaquaComboBoxUIHandler handler;
    private long lastTime = 0L;
    private long time = 0L;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Boolean value = (Boolean)c.getClientProperty(IS_TABLE_CELL_EDITOR);
        if (value == null) {
            value = (Boolean)c.getClientProperty("JComboBox.lightweightKeyboardNavigation");
        }
        this.setTableCellEditor(value != null && value.equals(Boolean.TRUE));
        c.setOpaque(UIManager.getBoolean("ComboBox.opaque"));
        this.comboBox.setRequestFocusEnabled(UIManager.getBoolean("ComboBox.requestFocusEnabled"));
        this.comboBox.setFocusable(this.comboBox.isEditable() || UIManager.getBoolean("ComboBox.focusable"));
        QuaquaUtilities.applySizeVariant(this.comboBox);
        if (this.arrowButton != null) {
            this.arrowButton.putClientProperty("JComponent.sizeVariant", this.comboBox.getClientProperty("JComponent.sizeVariant"));
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setMaximumRowCount(UIManager.getInt("ComboBox.maximumRowCount"));
        this.padding = UIManager.getInsets("ComboBox.padding");
    }

    @Override
    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    boolean isTableCellEditor() {
        return this.isTableCellEditor;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new QuaquaComboBoxEditor.UIResource();
    }

    @Override
    protected ComboPopup createPopup() {
        QuaquaComboPopup p = new QuaquaComboPopup(this.comboBox, this);
        p.getAccessibleContext().setAccessibleParent(this.comboBox);
        return p;
    }

    @Override
    protected JButton createArrowButton() {
        QuaquaComboBoxButton button = new QuaquaComboBoxButton(this, this.comboBox, this.getArrowIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.putClientProperty("Quaqua.Component.cellRendererFor", this.comboBox);
        button.setMargin(new Insets(0, 1, 1, 3));
        return button;
    }

    @Override
    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    @Override
    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    @Override
    protected ListDataListener createListDataListener() {
        return this.getHandler();
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private void updateToolTipTextForChildren() {
        Component[] children = this.comboBox.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof JComponent)) continue;
            ((JComponent)children[i]).setToolTipText(this.comboBox.getToolTipText());
        }
    }

    private void setTableCellEditor(boolean b) {
        this.isTableCellEditor = b;
        this.updateTableCellEditor();
    }

    private void updateTableCellEditor() {
        boolean b = this.isTableCellEditor();
        if (this.editor instanceof JComponent) {
            JComponent jeditor = (JComponent)this.editor;
            jeditor.setBorder(b ? tableCellEditorBorder : UIManager.getBorder("ComboBox.editorBorder"));
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.editor != null && UIManager.getBoolean("ComboBox.changeEditorForeground")) {
            this.editor.setForeground(c.getForeground());
        }
        Debug.paint(g, c, this);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    @Override
    protected boolean isNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == 224 || keyCode == 225;
    }

    private boolean isNavigationKey(int keyCode, int modifiers) {
        InputMap inputMap = this.comboBox.getInputMap(1);
        KeyStroke key = KeyStroke.getKeyStroke(keyCode, modifiers);
        return inputMap != null && inputMap.get(key) != null;
    }

    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    public void layoutComboBox(Container parent, QuaquaComboBoxUIHandler manager) {
        if (this.comboBox.isEditable()) {
            manager.superLayout(parent);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            Insets buttonInsets = UIManager.getInsets("ComboBox.buttonInsets");
            if (buttonInsets != null) {
                insets = new Insets(insets.top + buttonInsets.top, insets.left + buttonInsets.left, insets.bottom + buttonInsets.bottom, insets.right + buttonInsets.right);
            }
            int width = this.comboBox.getWidth();
            int height = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
        }
    }

    protected Icon getArrowIcon() {
        if (this.isTableCellEditor()) {
            return UIManager.getIcon("ComboBox.cellEditorPopupIcon");
        }
        if (this.comboBox.isEditable()) {
            switch (QuaquaUtilities.getSizeVariant(this.comboBox)) {
                default: {
                    return UIManager.getIcon("ComboBox.dropDownIcon");
                }
                case SMALL: {
                    return UIManager.getIcon("ComboBox.smallDropDownIcon");
                }
                case MINI: 
            }
            return UIManager.getIcon("ComboBox.miniDropDownIcon");
        }
        switch (QuaquaUtilities.getSizeVariant(this.comboBox)) {
            default: {
                return UIManager.getIcon("ComboBox.popupIcon");
            }
            case SMALL: {
                return UIManager.getIcon("ComboBox.smallPopupIcon");
            }
            case MINI: 
        }
        return UIManager.getIcon("ComboBox.miniPopupIcon");
    }

    protected int getArrowWidth() {
        if (this.isTableCellEditor()) {
            return 7;
        }
        if (this.comboBox.isEditable()) {
            switch (QuaquaUtilities.getSizeVariant(this.comboBox)) {
                default: {
                    return UIManager.getInt("ComboBox.dropDownWidth");
                }
                case SMALL: {
                    return UIManager.getInt("ComboBox.smallDropDownWidth");
                }
                case MINI: 
            }
            return UIManager.getInt("ComboBox.miniDropDownWidth");
        }
        switch (QuaquaUtilities.getSizeVariant(this.comboBox)) {
            default: {
                return UIManager.getInt("ComboBox.popupWidth");
            }
            case SMALL: {
                return UIManager.getInt("ComboBox.smallPopupWidth");
            }
            case MINI: 
        }
        return UIManager.getInt("ComboBox.miniPopupWidth");
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected boolean isSmall() {
        boolean isSmall = QuaquaUtilities.getSizeVariant(this.comboBox) == QuaquaUtilities.SizeVariant.SMALL;
        return isSmall;
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        return this.rectangleForCurrentValue(this.comboBox.getWidth(), this.comboBox.getHeight());
    }

    protected Rectangle rectangleForCurrentValue(int width, int height) {
        Insets insets = this.getInsets();
        Insets margin = this.getMargin();
        if (this.comboBox.isEditable()) {
            if (!this.isTableCellEditor()) {
                insets.right -= margin.right;
                insets.left -= margin.left - 2;
                insets.top -= margin.top - 2;
                insets.bottom -= margin.bottom - 2;
            }
        } else if (this.isTableCellEditor()) {
            --insets.top;
        } else {
            switch (QuaquaUtilities.getSizeVariant(this.comboBox)) {
                default: {
                    insets.left += 6;
                    insets.top += margin.top;
                    insets.left += margin.left;
                    insets.bottom += margin.bottom;
                    break;
                }
                case SMALL: {
                    insets.left += 4;
                    insets.top += margin.top;
                    insets.left += margin.left;
                    insets.bottom += margin.bottom;
                    break;
                }
                case MINI: {
                    insets.left += 3;
                    insets.top += margin.top;
                    insets.left += margin.left;
                    insets.bottom += margin.bottom;
                }
            }
        }
        return new Rectangle(insets.left, insets.top, width - this.getArrowWidth() - insets.right - insets.left, height - insets.top - insets.bottom);
    }

    protected Insets getMargin() {
        Insets margin = (Insets)this.comboBox.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return margin == null ? new Insets(0, 0, 0, 0) : (Insets)margin.clone();
    }

    @Override
    protected Dimension getDisplaySize() {
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension result = new Dimension();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        this.sameBaseline = true;
        Object prototypeValue = this.comboBox.getPrototypeDisplayValue();
        if (prototypeValue != null) {
            result = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, prototypeValue, -1, false, false));
        } else {
            ComboBoxModel model = this.comboBox.getModel();
            int modelSize = model.getSize();
            int baseline = -1;
            if (modelSize > 0) {
                for (int i = 0; i < modelSize; ++i) {
                    Object value = model.getElementAt(i);
                    Component c = renderer.getListCellRendererComponent(this.listBox, value, -1, false, false);
                    Dimension d = this.getSizeForComponent(c);
                    if (!(!this.sameBaseline || value == null || value instanceof String && "".equals(value))) {
                        int newBaseline;
                        try {
                            newBaseline = (Integer)Methods.invoke((Object)c, "getBaseline", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{d.width, d.height});
                        }
                        catch (NoSuchMethodException ex) {
                            newBaseline = -1;
                        }
                        if (newBaseline == -1) {
                            this.sameBaseline = false;
                        } else if (baseline == -1) {
                            baseline = newBaseline;
                        } else if (baseline != newBaseline) {
                            this.sameBaseline = false;
                        }
                    }
                    result.width = Math.max(result.width, d.width);
                    result.height = Math.max(result.height, d.height);
                }
            } else {
                result = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    result.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            Dimension d = this.editor.getPreferredSize();
            result.width = Math.max(result.width, d.width);
            result.height = Math.max(result.height, d.height);
        }
        if (this.padding != null) {
            result.width += this.padding.left + this.padding.right;
            result.height += this.padding.top + this.padding.bottom;
        }
        this.cachedDisplaySize.setSize(result.width, result.height);
        this.isDisplaySizeDirty = false;
        return result;
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof QuaquaComboBoxButton) {
            Insets buttonInsets;
            switch (QuaquaUtilities.getSizeVariant(this.comboBox)) {
                default: {
                    buttonInsets = UIManager.getInsets("ComboBox.arrowButtonInsets");
                    break;
                }
                case SMALL: {
                    buttonInsets = UIManager.getInsets("ComboBox.smallArrowButtonInsets");
                    break;
                }
                case MINI: {
                    buttonInsets = UIManager.getInsets("ComboBox.miniArrowButtonInsets");
                }
            }
            buttonInsets = (Insets)buttonInsets.clone();
            buttonInsets.right += this.getArrowWidth();
            Insets insets = this.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right + buttonInsets.left + buttonInsets.right;
            size.height += insets.top + insets.bottom + buttonInsets.top + buttonInsets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            Insets insets = this.comboBox.getInsets();
            Insets margin = this.getMargin();
            Insets buttonInsets = new Insets(2 - margin.top, 4 - margin.left, 2 - margin.bottom, this.getArrowWidth());
            size = this.getDisplaySize();
            size.width += insets.left + insets.right + buttonInsets.left + buttonInsets.right;
            size.height += insets.top + insets.bottom + buttonInsets.top + buttonInsets.bottom;
            size.width += this.getArrowWidth();
        } else {
            size = super.getMinimumSize(c);
            if (size == null) {
                size = new Dimension(0, 0);
            }
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension size = this.getPreferredSize(c);
        if (size != null && !(c.getParent() instanceof JToolBar)) {
            size.width = Short.MAX_VALUE;
        }
        return size;
    }

    private QuaquaComboBoxUIHandler getHandler() {
        if (this.handler == null) {
            this.handler = new QuaquaComboBoxUIHandler();
        }
        return this.handler;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        Rectangle vb = this.getVisualBounds(c, 2, width, height);
        return vb == null ? -1 : vb.y + vb.height;
    }

    @Override
    public Rectangle getVisualBounds(JComponent c, int layoutType, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (layoutType == 0) {
            return bounds;
        }
        if (c != this.comboBox) {
            return null;
        }
        Rectangle buttonRect = new Rectangle();
        Rectangle editorRect = null;
        Insets insets = this.getInsets();
        Insets margin = this.getMargin();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            if (QuaquaUtilities.isLeftToRight(this.comboBox)) {
                int plusHeight = this.isSmall() ? 5 : 4;
                buttonRect.setBounds(width - this.getArrowWidth() - insets.right, insets.top + margin.top - 2, this.getArrowWidth(), buttonSize - margin.top - margin.bottom + plusHeight);
            } else {
                buttonRect.setBounds(insets.left, insets.top, this.getArrowWidth(), buttonSize);
            }
        }
        editorRect = this.rectangleForCurrentValue(width, height);
        ++editorRect.x;
        editorRect.width -= 2;
        switch (layoutType) {
            case 1: {
                if (this.isTableCellEditor()) break;
                if (this.editor != null) {
                    bounds.x += margin.left;
                    bounds.y += margin.top;
                    bounds.width -= margin.left + margin.right;
                    bounds.height -= margin.top + margin.bottom + 1;
                    break;
                }
                bounds.x += margin.left;
                bounds.y += margin.top;
                bounds.width -= margin.left + margin.right;
                bounds.height -= margin.top + margin.bottom;
                break;
            }
            case 2: {
                Component renderer;
                Component component = renderer = this.editor == null ? this.comboBox.getRenderer().getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), this.comboBox.getSelectedIndex(), false, this.comboBox.hasFocus()) : this.editor;
                if (renderer instanceof JComponent && Methods.invokeGetter((Object)renderer, "getUI", null) instanceof VisuallyLayoutable) {
                    bounds = ((VisuallyLayoutable)Methods.invokeGetter((Object)renderer, "getUI", null)).getVisualBounds((JComponent)renderer, layoutType, editorRect.width, editorRect.height);
                    bounds.x += editorRect.x;
                    bounds.y += editorRect.y;
                    break;
                }
                bounds.setBounds(editorRect);
            }
        }
        return bounds;
    }

    public class GlowFocusHandler
    extends BasicComboBoxUI.FocusHandler {
        public GlowFocusHandler() {
            super(QuaquaComboBoxUI.this);
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            this.glowyRepaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            this.glowyRepaint();
        }

        private void glowyRepaint() {
            if (QuaquaComboBoxUI.this.comboBox.getParent() != null) {
                Rectangle r = QuaquaComboBoxUI.this.comboBox.getBounds();
                r.grow(2, 2);
                QuaquaComboBoxUI.this.comboBox.getParent().repaint(r.x, r.y, r.width, r.height);
            }
        }
    }

    private class QuaquaComboBoxUIHandler
    implements ActionListener,
    FocusListener,
    KeyListener,
    LayoutManager,
    ListDataListener,
    PropertyChangeListener {
        private QuaquaComboBoxUIHandler() {
        }

        private void superPropertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getSource() == QuaquaComboBoxUI.this.editor) {
                if ("border".equals(propertyName)) {
                    QuaquaComboBoxUI.this.isMinimumSizeDirty = true;
                    QuaquaComboBoxUI.this.isDisplaySizeDirty = true;
                    QuaquaComboBoxUI.this.comboBox.revalidate();
                }
            } else {
                JComboBox comboBox = (JComboBox)e.getSource();
                if (propertyName == "model") {
                    ComboBoxModel newModel = (ComboBoxModel)e.getNewValue();
                    ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                    if (oldModel != null && QuaquaComboBoxUI.this.listDataListener != null) {
                        oldModel.removeListDataListener(QuaquaComboBoxUI.this.listDataListener);
                    }
                    if (newModel != null && QuaquaComboBoxUI.this.listDataListener != null) {
                        newModel.addListDataListener(QuaquaComboBoxUI.this.listDataListener);
                    }
                    if (QuaquaComboBoxUI.this.editor != null) {
                        comboBox.configureEditor(comboBox.getEditor(), comboBox.getSelectedItem());
                    }
                    QuaquaComboBoxUI.this.isMinimumSizeDirty = true;
                    QuaquaComboBoxUI.this.isDisplaySizeDirty = true;
                    comboBox.revalidate();
                    comboBox.repaint();
                } else if (propertyName == "editor" && comboBox.isEditable()) {
                    QuaquaComboBoxUI.this.addEditor();
                    comboBox.revalidate();
                } else if (propertyName == "editable") {
                    if (comboBox.isEditable()) {
                        comboBox.setRequestFocusEnabled(false);
                        QuaquaComboBoxUI.this.addEditor();
                    } else {
                        comboBox.setRequestFocusEnabled(true);
                        QuaquaComboBoxUI.this.removeEditor();
                    }
                    QuaquaComboBoxUI.this.updateToolTipTextForChildren();
                    comboBox.revalidate();
                } else if (propertyName == "enabled") {
                    boolean enabled = comboBox.isEnabled();
                    if (QuaquaComboBoxUI.this.editor != null) {
                        QuaquaComboBoxUI.this.editor.setEnabled(enabled);
                    }
                    if (QuaquaComboBoxUI.this.arrowButton != null) {
                        QuaquaComboBoxUI.this.arrowButton.setEnabled(enabled);
                    }
                    comboBox.repaint();
                } else if (propertyName == "focusable") {
                    boolean focusable = comboBox.isFocusable();
                    if (QuaquaComboBoxUI.this.editor != null) {
                        QuaquaComboBoxUI.this.editor.setFocusable(focusable);
                    }
                    if (QuaquaComboBoxUI.this.arrowButton != null) {
                        QuaquaComboBoxUI.this.arrowButton.setFocusable(focusable);
                    }
                    comboBox.repaint();
                } else if (propertyName == "maximumRowCount") {
                    if (QuaquaComboBoxUI.this.isPopupVisible(comboBox)) {
                        QuaquaComboBoxUI.this.setPopupVisible(comboBox, false);
                        QuaquaComboBoxUI.this.setPopupVisible(comboBox, true);
                    }
                } else if (propertyName == "font") {
                    QuaquaComboBoxUI.this.listBox.setFont(comboBox.getFont());
                    if (QuaquaComboBoxUI.this.editor != null) {
                        QuaquaComboBoxUI.this.editor.setFont(comboBox.getFont());
                    }
                    QuaquaComboBoxUI.this.isMinimumSizeDirty = true;
                    comboBox.validate();
                } else if (propertyName == "ToolTipText") {
                    QuaquaComboBoxUI.this.updateToolTipTextForChildren();
                } else if (propertyName == QuaquaComboBoxUI.IS_TABLE_CELL_EDITOR) {
                    Boolean inTable = (Boolean)e.getNewValue();
                    QuaquaComboBoxUI.this.isTableCellEditor = inTable.equals(Boolean.TRUE);
                } else if (propertyName == "prototypeDisplayValue") {
                    QuaquaComboBoxUI.this.isMinimumSizeDirty = true;
                    QuaquaComboBoxUI.this.isDisplaySizeDirty = true;
                    comboBox.revalidate();
                } else if (propertyName == "renderer") {
                    QuaquaComboBoxUI.this.isMinimumSizeDirty = true;
                    QuaquaComboBoxUI.this.isDisplaySizeDirty = true;
                    comboBox.revalidate();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.superPropertyChange(e);
            String name = e.getPropertyName();
            if (e.getSource() == QuaquaComboBoxUI.this.editor && (name == null || "border".equals(name))) {
                QuaquaComboBoxUI.this.isMinimumSizeDirty = true;
            }
            if (name != null) {
                if (name.equals("model") || name.equals("prototypeDisplayValue") || name.equals("renderer")) {
                    QuaquaComboBoxUI.this.isMinimumSizeDirty = true;
                } else if (name.equals("editable")) {
                    QuaquaComboBoxButton button = (QuaquaComboBoxButton)QuaquaComboBoxUI.this.arrowButton;
                    button.setIconOnly(QuaquaComboBoxUI.this.comboBox.isEditable());
                    QuaquaComboBoxUI.this.updateTableCellEditor();
                    QuaquaComboBoxUI.this.comboBox.setFocusable(QuaquaComboBoxUI.this.comboBox.isEditable() || UIManager.getBoolean("ComboBox.focusable"));
                    QuaquaComboBoxUI.this.comboBox.repaint();
                } else if (name.equals("background")) {
                    Color color = (Color)e.getNewValue();
                    QuaquaComboBoxUI.this.arrowButton.setBackground(color);
                } else if (name.equals("foreground")) {
                    Color color = (Color)e.getNewValue();
                    QuaquaComboBoxUI.this.arrowButton.setForeground(color);
                    QuaquaComboBoxUI.this.listBox.setForeground(color);
                } else if (name.equals(QuaquaComboBoxUI.IS_TABLE_CELL_EDITOR)) {
                    Boolean inTable = (Boolean)e.getNewValue();
                    QuaquaComboBoxUI.this.setTableCellEditor(inTable.equals(Boolean.TRUE));
                } else if (name.equals("JComboBox.lightweightKeyboardNavigation")) {
                    QuaquaComboBoxUI.this.setTableCellEditor(e.getNewValue() != null && e.getNewValue().equals("Lightweight"));
                } else if (name.equals("JComponent.sizeVariant")) {
                    QuaquaUtilities.applySizeVariant(QuaquaComboBoxUI.this.comboBox);
                    QuaquaComboBoxUI.this.arrowButton.putClientProperty("JComponent.sizeVariant", e.getNewValue());
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (QuaquaComboBoxUI.this.isNavigationKey(e.getKeyCode(), e.getModifiers())) {
                QuaquaComboBoxUI.this.lastTime = 0L;
            } else if (QuaquaComboBoxUI.this.comboBox.isEnabled() && QuaquaComboBoxUI.this.comboBox.getModel().getSize() != 0 && this.isTypeAheadKey(e) && e.getKeyChar() != '\uffff') {
                QuaquaComboBoxUI.this.time = e.getWhen();
                if (QuaquaComboBoxUI.this.comboBox.selectWithKeyChar(e.getKeyChar())) {
                    e.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private boolean isTypeAheadKey(KeyEvent e) {
            return !e.isAltDown() && !e.isControlDown() && !e.isMetaDown();
        }

        @Override
        public void focusGained(FocusEvent e) {
            ComboBoxEditor comboBoxEditor = QuaquaComboBoxUI.this.comboBox.getEditor();
            if (comboBoxEditor != null && e.getSource() == comboBoxEditor.getEditorComponent()) {
                return;
            }
            QuaquaComboBoxUI.this.hasFocus = true;
            QuaquaComboBoxUI.this.comboBox.repaint();
            if (QuaquaComboBoxUI.this.comboBox.isEditable() && QuaquaComboBoxUI.this.editor != null) {
                QuaquaComboBoxUI.this.editor.requestFocus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            ComboBoxEditor editor = QuaquaComboBoxUI.this.comboBox.getEditor();
            if (editor != null && e.getSource() == editor.getEditorComponent()) {
                Object item = editor.getItem();
                Object selectedItem = QuaquaComboBoxUI.this.comboBox.getSelectedItem();
                if (!e.isTemporary() && item != null && !item.equals(selectedItem == null ? "" : selectedItem)) {
                    QuaquaComboBoxUI.this.comboBox.actionPerformed(new ActionEvent(editor, 0, "", EventQueue.getMostRecentEventTime(), 0));
                }
            }
            QuaquaComboBoxUI.this.hasFocus = false;
            if (!e.isTemporary()) {
                QuaquaComboBoxUI.this.setPopupVisible(QuaquaComboBoxUI.this.comboBox, false);
            }
            QuaquaComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() != -1 || e.getIndex1() != -1) {
                QuaquaComboBoxUI.this.isMinimumSizeDirty = true;
                QuaquaComboBoxUI.this.comboBox.revalidate();
            }
            if (QuaquaComboBoxUI.this.comboBox.isEditable() && QuaquaComboBoxUI.this.editor != null) {
                QuaquaComboBoxUI.this.comboBox.configureEditor(QuaquaComboBoxUI.this.comboBox.getEditor(), QuaquaComboBoxUI.this.comboBox.getSelectedItem());
            }
            QuaquaComboBoxUI.this.isDisplaySizeDirty = true;
            QuaquaComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object item = QuaquaComboBoxUI.this.comboBox.getEditor().getItem();
            if (item != null) {
                Action action;
                ActionMap am;
                if (!QuaquaComboBoxUI.this.comboBox.isPopupVisible() && !item.equals(QuaquaComboBoxUI.this.comboBox.getSelectedItem())) {
                    QuaquaComboBoxUI.this.comboBox.setSelectedItem(QuaquaComboBoxUI.this.comboBox.getEditor().getItem());
                }
                if ((am = QuaquaComboBoxUI.this.comboBox.getActionMap()) != null && (action = am.get("enterPressed")) != null) {
                    action.actionPerformed(new ActionEvent(QuaquaComboBoxUI.this.comboBox, evt.getID(), evt.getActionCommand(), evt.getModifiers()));
                }
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            QuaquaComboBoxUI.this.layoutComboBox(parent, this);
        }

        public void superLayout(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = QuaquaComboBoxUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (QuaquaComboBoxUI.this.arrowButton != null) {
                if (QuaquaUtilities.isLeftToRight(cb)) {
                    Insets buttonInsets = UIManager.getInsets("ComboBox.button.insets." + (Object)((Object)QuaquaUtilities.getSizeVariant(QuaquaComboBoxUI.this.comboBox)));
                    if (buttonInsets == null && (buttonInsets = UIManager.getInsets("ComboBox.button.insets")) == null) {
                        buttonInsets = new Insets(0, 0, 2, 0);
                    }
                    QuaquaComboBoxUI.this.arrowButton.setBounds(width - QuaquaComboBoxUI.this.getArrowWidth() - insets.right, insets.top + buttonInsets.top, QuaquaComboBoxUI.this.getArrowWidth(), buttonSize - (buttonInsets.top + buttonInsets.bottom));
                } else {
                    QuaquaComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, QuaquaComboBoxUI.this.getArrowWidth(), buttonSize);
                }
            }
            if (QuaquaComboBoxUI.this.editor != null) {
                Rectangle cvb = QuaquaComboBoxUI.this.rectangleForCurrentValue();
                QuaquaComboBoxUI.this.editor.setBounds(cvb);
            }
        }
    }
}

