/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaListMouseBehavior;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import ch.randelshofer.quaqua.color.PaintableColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class QuaquaListUI
extends BasicListUI {
    private boolean isStriped = false;
    private boolean isComboPopup = false;
    private static final int VERTICAL;
    private static final Method getLayoutOrientation;
    private int layoutOrientation;

    private Color getAlternateColor(int modulo) {
        if (modulo == 0) {
            return UIManager.getColor("List.alternateBackground.0");
        }
        return UIManager.getColor("List.alternateBackground.1");
    }

    private void updateStriped() {
        Object value = this.list.getClientProperty("Quaqua.List.style");
        this.isStriped = value != null && value.equals("striped") && this.getLayoutOrientation() == VERTICAL;
    }

    private int getLayoutOrientation() {
        if (getLayoutOrientation != null) {
            try {
                return (Integer)getLayoutOrientation.invoke((Object)this.list, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return VERTICAL;
    }

    public void paintStripes(Graphics g, JComponent c) {
        if (this.isStriped && this.list.getModel() != null) {
            int y;
            Dimension vs = c.getSize();
            Dimension ts = this.list.getSize();
            Point p = this.list.getLocation();
            int rh = this.list.getFixedCellHeight();
            int n = this.list.getModel().getSize();
            if (rh <= 0) {
                rh = n == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int row = Math.abs(p.y / rh);
            int th = n * rh - row * rh;
            g.setColor(this.getAlternateColor(1));
            g.fillRect(0, 0, ts.width, ts.height);
            g.setColor(this.getAlternateColor(0));
            if (ts.width < vs.width) {
                y = p.y + row * rh;
                while (y < th) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
            if (th < vs.height) {
                row = n;
                y = th;
                while (y < vs.height) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
        }
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean isEnabled = this.list.isEnabled();
        boolean isFocused = isEnabled && QuaquaUtilities.isFocused(this.list);
        boolean cellHasFocus = isFocused && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (this.list.isSelectedIndex(row)) {
            ((Graphics2D)g).setPaint(PaintableColor.getPaint(UIManager.getColor(this.isComboPopup ? "ComboBox.selectionBackground" : "List.selectionBackground"), rendererComponent, cx, cy, cw, ch));
            g.fillRect(cx, cy, cw, ch);
        } else if (this.isStriped) {
            g.setColor(this.getAlternateColor(row % 2));
            g.fillRect(cx, cy, cw, ch);
        }
        if (this.isComboPopup) {
            cx += 7;
            cw -= 14;
        }
        this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintStripes(g, c);
        boolean isFocused = this.isComboPopup || QuaquaUtilities.isFocused(c);
        Object value = c.getClientProperty("Quaqua.List.style");
        this.isComboPopup = value != null && value.equals("comboPopup");
        Color selectionBackground = UIManager.getColor(this.isComboPopup ? "ComboBox.selectionBackground" : "List.selectionBackground");
        Color selectionForeground = UIManager.getColor(this.isComboPopup ? "ComboBox.selectionForeground" : "List.selectionForeground");
        if (selectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionBackground).setActive(isFocused);
        }
        if (selectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionForeground).setActive(isFocused);
        }
        Color treeSelectionBackground = UIManager.getColor("Tree.selectionBackground");
        Color treeSelectionForeground = UIManager.getColor("Tree.selectionForeground");
        if (treeSelectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)treeSelectionBackground).setActive(isFocused);
        }
        if (treeSelectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)treeSelectionForeground).setActive(isFocused);
        }
        super.paint(g, c);
        if (selectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionBackground).setActive(true);
        }
        if (selectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionForeground).setActive(true);
        }
        if (treeSelectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)treeSelectionBackground).setActive(true);
        }
        if (treeSelectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)treeSelectionForeground).setActive(true);
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateStriped();
    }

    public static ComponentUI createUI(JComponent list) {
        return new QuaquaListUI();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new QuaquaListMouseBehavior(this.list);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    static {
        int value = 0;
        try {
            value = JList.class.getField("VERTICAL").getInt(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        VERTICAL = value;
        Method value2 = null;
        try {
            value2 = JList.class.getMethod("getLayoutOrientation", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        getLayoutOrientation = value2;
    }

    protected class ListDataHandler
    implements ListDataListener {
        protected ListDataHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            QuaquaListUI.this.updateLayoutStateNeeded = 1;
            int minIndex = Math.min(e.getIndex0(), e.getIndex1());
            int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
            ListSelectionModel sm = QuaquaListUI.this.list.getSelectionModel();
            if (sm != null && sm.getMinSelectionIndex() != -1) {
                sm.insertIndexInterval(minIndex, maxIndex - minIndex + 1, true);
            }
            QuaquaListUI.this.redrawList();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            QuaquaListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel sm = QuaquaListUI.this.list.getSelectionModel();
            if (sm != null) {
                sm.removeIndexInterval(e.getIndex0(), e.getIndex1());
            }
            QuaquaListUI.this.redrawList();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            QuaquaListUI.this.updateLayoutStateNeeded = 1;
            if (QuaquaListUI.this.list.getFixedCellHeight() == -1) {
                QuaquaListUI.this.redrawList();
            } else {
                Rectangle bounds = QuaquaListUI.this.list.getCellBounds(e.getIndex0(), e.getIndex1());
                if (bounds == null) {
                    QuaquaListUI.this.redrawList();
                } else {
                    QuaquaListUI.this.list.repaint(bounds);
                }
            }
        }
    }

    public class PropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public PropertyChangeHandler() {
            super(QuaquaListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("Quaqua.List.style")) {
                QuaquaListUI.this.updateStriped();
            } else if ("layoutOrientation".equals(name)) {
                QuaquaListUI.this.layoutOrientation = (Integer)e.getNewValue();
                QuaquaListUI.this.updateStriped();
            } else if (name.equals("JComponent.sizeVariant")) {
                QuaquaUtilities.applySizeVariant(QuaquaListUI.this.list);
            }
            super.propertyChange(e);
        }
    }

    public class FocusHandler
    implements FocusListener {
        protected void repaintCellFocus() {
            Rectangle r;
            Object[] cells = QuaquaListUI.this.list.getSelectedValues();
            if (cells.length > 1) {
                QuaquaListUI.this.list.repaint();
                return;
            }
            int leadIndex = QuaquaListUI.this.list.getLeadSelectionIndex();
            if (leadIndex != -1 && (r = QuaquaListUI.this.getCellBounds(QuaquaListUI.this.list, leadIndex, leadIndex)) != null) {
                QuaquaListUI.this.list.repaint(r.x, r.y, r.width, r.height);
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            this.repaintCellFocus();
        }

        @Override
        public void focusLost(FocusEvent event) {
            this.repaintCellFocus();
        }
    }
}

