/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.osx.OSXFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class QuaquaManager {
    private static Properties properties;
    private static Set includedUIs;
    private static Set excludedUIs;
    private static final String version;
    public static final int CHEETAH = 0;
    public static final int PUMA = 1;
    public static final int JAGUAR = 2;
    public static final int PANTHER = 3;
    public static final int TIGER = 4;
    public static final int LEOPARD = 5;
    public static final int SNOW_LEOPARD = 6;
    public static final int LION = 7;
    public static final int MOUNTAIN_LION = 8;
    public static final int MAVERICKS = 9;
    public static final int YOSEMITE = 10;
    public static final int EL_CAPITAN = 11;
    public static final int SIERRA = 12;
    public static final int X = 100;
    public static final int LINUX = -4;
    public static final int DARWIN = -3;
    public static final int WINDOWS = -2;
    public static final int UNKNOWN = -1;
    private static int OS;
    private static boolean isOSX;
    private static int design;
    private static HashMap lafs;

    private static void updateDesignAndOS() {
        String osName = QuaquaManager.getProperty("os.name");
        String osVersion = QuaquaManager.getProperty("os.version");
        isOSX = osName.equals("Mac OS X");
        if (isOSX) {
            int p = osVersion.indexOf(46);
            if ((p = osVersion.indexOf(46, p + 1)) != -1) {
                osVersion = osVersion.substring(0, p);
            }
            OS = osVersion.equals("10.0") ? 0 : (osVersion.equals("10.1") ? 1 : (osVersion.equals("10.2") ? 2 : (osVersion.equals("10.3") ? 3 : (osVersion.equals("10.4") ? 4 : (osVersion.equals("10.5") ? 5 : (osVersion.equals("10.6") ? 6 : (osVersion.equals("10.7") ? 7 : (osVersion.equals("10.8") ? 8 : (osVersion.equals("10.9") ? 9 : (osVersion.equals("10.10") ? 10 : (osVersion.equals("10.11") ? 11 : (osVersion.equals("10.12") ? 12 : (osVersion.startsWith("10.") ? 100 : 6)))))))))))));
        } else {
            OS = osName.startsWith("Darwin") ? -3 : (osName.startsWith("Linux") ? -4 : (osName.startsWith("Windows") ? -2 : -1));
        }
        String osDesign = QuaquaManager.getProperty("Quaqua.design", "auto").toLowerCase();
        if (osDesign.equals("cheetah")) {
            design = 2;
        } else if (osDesign.equals("puma")) {
            design = 2;
        } else if (osDesign.equals("jaguar")) {
            design = 2;
        } else if (osDesign.equals("panther")) {
            design = 3;
        } else if (osDesign.equals("tiger")) {
            design = 4;
        } else if (osDesign.equals("leopard")) {
            design = 5;
        } else if (osDesign.equals("snowleopard")) {
            design = 6;
        } else if (osDesign.equals("lion")) {
            design = 7;
        } else if (osDesign.equals("mountainlion")) {
            design = 8;
        } else if (osDesign.equals("mavericks")) {
            design = 9;
        } else if (osDesign.equals("yosemite")) {
            design = 10;
        } else if (osDesign.equals("elcapitan")) {
            design = 11;
        } else if (osDesign.equals("sierra")) {
            design = 12;
        } else {
            switch (OS) {
                case 0: {
                    design = 2;
                    break;
                }
                case 1: {
                    design = 2;
                    break;
                }
                case 2: {
                    design = 2;
                    break;
                }
                case 3: {
                    design = 3;
                    break;
                }
                case 4: {
                    design = 4;
                    break;
                }
                case 5: {
                    design = 5;
                    break;
                }
                case 6: {
                    design = 6;
                    break;
                }
                case 7: {
                    design = 7;
                    break;
                }
                case 8: {
                    design = 8;
                    break;
                }
                case 9: {
                    design = 9;
                    break;
                }
                case 10: {
                    design = 10;
                    break;
                }
                case 11: {
                    design = 11;
                    break;
                }
                case 12: {
                    design = 12;
                    break;
                }
                default: {
                    design = 6;
                }
            }
        }
    }

    private static void updateAvailableLAFs() {
        lafs = new HashMap();
        try {
            BufferedReader r;
            InputStream s = QuaquaManager.class.getResourceAsStream("laf.txt");
            if (s != null) {
                r = new BufferedReader(new InputStreamReader(s, "UTF8"));
                StreamTokenizer tt = new StreamTokenizer(r);
                tt.wordChars(95, 95);
                tt.ordinaryChar(61);
                tt.ordinaryChar(59);
                while (tt.nextToken() != -1) {
                    if (tt.ttype != -3) {
                        throw new IOException("Illegal token for 'design.version' in line " + tt.lineno() + " of laf.txt File");
                    }
                    String lafKey = tt.sval;
                    if (tt.nextToken() != 61) {
                        throw new IOException("Illegal token for '=' in line " + tt.lineno() + " of laf.txt File");
                    }
                    if (tt.nextToken() != -3) {
                        throw new IOException("Illegal token for 'class' in line " + tt.lineno() + " of laf.txt File at key '" + lafKey + "'");
                    }
                    String className = tt.sval;
                    if (tt.nextToken() != 59) {
                        throw new IOException("Illegal token " + (tt.ttype > 32 ? "'" + (char)tt.ttype + "'" : "" + tt.ttype) + " for ';' in line " + tt.lineno() + " of laf.txt File");
                    }
                    lafs.put(lafKey, className);
                }
            } else {
                throw new IOException("File laf.txt not found");
            }
            r.close();
        }
        catch (IOException e) {
            System.err.println("Warning: " + QuaquaManager.class + ".updateAvailableLAFs() couldn't access resource file \"laf.txt\".");
            lafs.put("Jaguar.15", "ch.randelshofer.quaqua.jaguar.Quaqua15JaguarLookAndFeel");
            lafs.put("Jaguar.16", "ch.randelshofer.quaqua.jaguar.Quaqua15JaguarLookAndFeel");
            lafs.put("Panther.15", "ch.randelshofer.quaqua.panther.Quaqua15PantherLookAndFeel");
            lafs.put("Panther.16", "ch.randelshofer.quaqua.panther.Quaqua15PantherLookAndFeel");
            lafs.put("Tiger.15", "ch.randelshofer.quaqua.tiger.Quaqua15TigerLookAndFeel");
            lafs.put("Tiger.16", "ch.randelshofer.quaqua.tiger.Quaqua15TigerLookAndFeel");
            lafs.put("Leopard.15", "ch.randelshofer.quaqua.leopard.Quaqua15LeopardLookAndFeel");
            lafs.put("Leopard.16", "ch.randelshofer.quaqua.leopard.Quaqua16LeopardLookAndFeel");
            lafs.put("SnowLeopard.15", "ch.randelshofer.quaqua.leopard.Quaqua15LeopardLookAndFeel");
            lafs.put("SnowLeopard.16", "ch.randelshofer.quaqua.snowleopard.Quaqua16SnowLeopardLookAndFeel");
            lafs.put("Lion.16", "ch.randelshofer.quaqua.lion.Quaqua16LionLookAndFeel");
            lafs.put("MountainLion.16", "ch.randelshofer.quaqua.mountainlion.Quaqua16MountainLionLookAndFeel");
            lafs.put("Mavericks.16", "ch.randelshofer.quaqua.mavericks.Quaqua16MavericksLookAndFeel");
            lafs.put("CrossTiger.15", "ch.randelshofer.quaqua.tiger.Quaqua15TigerCrossPlatformLookAndFeel");
            lafs.put("CrossTiger.16", "ch.randelshofer.quaqua.tiger.Quaqua15TigerCrossPlatformLookAndFeel");
            lafs.put("CrossLeopard.15", "ch.randelshofer.quaqua.leopard.Quaqua15LeopardCrossPlatformLookAndFeel");
            lafs.put("CrossLeopard.16", "ch.randelshofer.quaqua.leopard.Quaqua15LeopardCrossPlatformLookAndFeel");
            lafs.put("Yosemite.16", "ch.randelshofer.quaqua.yosemite.Quaqua16YosemiteLookAndFeel");
            lafs.put("ElCapitan.16", "ch.randelshofer.quaqua.elcapitan.Quaqua16ElCapitanLookAndFeel");
            lafs.put("Sierra.16", "ch.randelshofer.quaqua.sierra.Quaqua16SierraLookAndFeel");
        }
    }

    private QuaquaManager() {
    }

    public static int getOS() {
        return OS;
    }

    public static boolean isOSX() {
        return OS >= 0;
    }

    public static int getDesign() {
        return design;
    }

    public static String getLookAndFeelClassName() {
        QuaquaManager.updateDesignAndOS();
        if (QuaquaManager.getProperty("Quaqua.noQuaqua", "false").equals("true")) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        String lafKey = null;
        String className = "apple.laf.AquaLookAndFeel";
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            className = "com.apple.mrj.swing.MacLookAndFeel";
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                className = UIManager.getCrossPlatformLookAndFeelClassName();
            }
        }
        String javaVersion = QuaquaManager.getProperty("java.version", "");
        if (className.equals("apple.laf.AquaLookAndFeel")) {
            if (javaVersion.startsWith("1.5")) {
                switch (design) {
                    case 2: {
                        lafKey = "Jaguar.15";
                        break;
                    }
                    case 3: {
                        lafKey = "Panther.15";
                        break;
                    }
                    case 4: {
                        lafKey = "Tiger.15";
                        break;
                    }
                    case 5: {
                        lafKey = "Leopard.15";
                        break;
                    }
                    case 6: {
                        lafKey = "SnowLeopard.16";
                        break;
                    }
                    case 7: {
                        lafKey = "Lion.16";
                        break;
                    }
                    case 8: {
                        lafKey = "MountainLion.16";
                        break;
                    }
                    case 9: {
                        lafKey = "Mavericks.16";
                        break;
                    }
                    case 10: {
                        lafKey = "Yosemite.16";
                        break;
                    }
                    case 11: {
                        lafKey = "ElCapitan.16";
                        break;
                    }
                    case 12: 
                    case 100: {
                        lafKey = "Sierra.16";
                        break;
                    }
                    default: {
                        lafKey = "SnowLeopard.16";
                        break;
                    }
                }
            } else {
                switch (design) {
                    case 2: {
                        lafKey = "Jaguar.16";
                        break;
                    }
                    case 3: {
                        lafKey = "Panther.16";
                        break;
                    }
                    case 4: {
                        lafKey = "Tiger.16";
                        break;
                    }
                    case 5: {
                        lafKey = "Leopard.16";
                        break;
                    }
                    case 6: {
                        lafKey = "SnowLeopard.16";
                        break;
                    }
                    case 7: {
                        lafKey = "Lion.16";
                        break;
                    }
                    case 8: {
                        lafKey = "MountainLion.16";
                        break;
                    }
                    case 9: {
                        lafKey = "Mavericks.16";
                        break;
                    }
                    case 10: {
                        lafKey = "Yosemite.16";
                        break;
                    }
                    case 11: {
                        lafKey = "ElCapitan.16";
                        break;
                    }
                    case 12: 
                    case 100: {
                        lafKey = "Sierra.16";
                        break;
                    }
                    default: {
                        lafKey = "SnowLeopard.16";
                        break;
                    }
                }
            }
        } else {
            lafKey = "CrossPlatform.15";
            switch (design) {
                case 2: {
                    lafKey = "CrossTiger.15";
                    break;
                }
                case 3: {
                    lafKey = "CrossTiger.15";
                    break;
                }
                case 4: {
                    lafKey = "CrossTiger.15";
                    break;
                }
                case 5: {
                    lafKey = "CrossLeopard.15";
                    break;
                }
                case 6: {
                    lafKey = "CrossSnowLeopard.15";
                    break;
                }
                default: {
                    lafKey = "CrossSnowLeopard.15";
                }
            }
        }
        if (lafs.containsKey(lafKey)) {
            className = (String)lafs.get(lafKey);
        }
        return className;
    }

    public static LookAndFeel getLookAndFeel() {
        try {
            return (LookAndFeel)Class.forName(QuaquaManager.getLookAndFeelClassName()).newInstance();
        }
        catch (Exception e) {
            InternalError ie = new InternalError(e.toString());
            throw ie;
        }
    }

    public static String getProperty(String key) {
        try {
            if (properties == null || !properties.containsKey(key)) {
                return System.getProperty(key);
            }
            return properties.getProperty(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static String getProperty(String key, String def) {
        try {
            if (properties == null || !properties.containsKey(key)) {
                return System.getProperty(key, def);
            }
            return properties.getProperty(key, def);
        }
        catch (SecurityException e) {
            return def;
        }
    }

    public static int[] getProperty(String key, int[] def) {
        StringTokenizer tt;
        String value;
        try {
            value = properties == null || !properties.containsKey(key) ? System.getProperty(key, null) : properties.getProperty(key, null);
        }
        catch (SecurityException e) {
            value = null;
        }
        if (value != null && (tt = new StringTokenizer(value, ",")).countTokens() == def.length) {
            int[] result = new int[def.length];
            try {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = Integer.decode(tt.nextToken());
                }
                return result;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public static String setProperty(String key, String value) {
        if (properties == null) {
            properties = new Properties();
        }
        return (String)properties.setProperty(key, value);
    }

    public static void removeProperty(String key) {
        if (properties != null) {
            properties.remove(key);
        }
    }

    public static String getVersion() {
        return version;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JFrame f = new JFrame("Quaqua Look and Feel");
                    f.setDefaultCloseOperation(3);
                    JLabel label = new JLabel("<html><p align=center><b>Quaqua Look and Feel " + version + "</b><br><br>Copyright 2003-2013 Werner Randelshofer<br>All Rights Reserved.<br><br>This is a software library.<br>Please read the accompanying documentation<br>for additional information.");
                    label.setBorder(new EmptyBorder(12, 20, 20, 20));
                    f.getContentPane().add(label);
                    f.pack();
                    f.setVisible(true);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public static boolean isNativeCodeAvailable() {
        return OSXFile.canWorkWithAliases();
    }

    public static void setIncludedUIs(Set includes) {
        includedUIs = includes;
    }

    public static void setExcludedUIs(Set excludes) {
        excludedUIs = excludes;
    }

    public static Set getIncludedUIs() {
        return includedUIs;
    }

    public static Set getExcludedUIs() {
        return excludedUIs;
    }

    static {
        excludedUIs = Collections.EMPTY_SET;
        String v = null;
        try {
            InputStream s = QuaquaManager.class.getResourceAsStream("version.txt");
            if (s != null) {
                BufferedReader r = new BufferedReader(new InputStreamReader(s, "UTF8"));
                v = r.readLine();
                r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        version = v == null ? "unknown" : v;
        QuaquaManager.updateAvailableLAFs();
        QuaquaManager.updateDesignAndOS();
    }
}

