/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaButtonBorder;
import ch.randelshofer.quaqua.QuaquaColorWellBorder;
import ch.randelshofer.quaqua.QuaquaPlacardButtonBorder;
import ch.randelshofer.quaqua.QuaquaToolBarTabButtonBorder;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.border.ButtonStateBorder;
import ch.randelshofer.quaqua.border.CompositeVisualMarginBorder;
import ch.randelshofer.quaqua.border.FocusedBorder;
import ch.randelshofer.quaqua.border.PressedCueBorder;
import ch.randelshofer.quaqua.border.VisualMarginBorder;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.CachedPainter;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class QuaquaNativeButtonBorder
extends VisualMarginBorder
implements Border,
PressedCueBorder,
BackgroundBorder {
    private static final HashMap<String, WidgetConfig> wcs;
    private OSXAquaPainter painter = new OSXAquaPainter();
    private Insets imageInsets = new Insets(0, 0, 0, 0);
    private Border backgroundBorder;

    public QuaquaNativeButtonBorder() {
        super(new Insets(0, 0, 0, 0));
    }

    @Override
    public Border getBackgroundBorder() {
        if (this.backgroundBorder == null) {
            this.backgroundBorder = new BGBorder();
        }
        return this.backgroundBorder;
    }

    @Override
    public boolean hasPressedCue(JComponent c) {
        Border b = this.getBackgroundBorder();
        if (b instanceof PressedCueBorder) {
            return ((PressedCueBorder)b).hasPressedCue(c);
        }
        return true;
    }

    private String getStyle(Component c) {
        JComponent jc;
        String s = null;
        if (c instanceof JComponent && (s = (String)(jc = (JComponent)c).getClientProperty("Quaqua.Button.style")) == null) {
            s = (String)jc.getClientProperty("JButton.buttonType");
        }
        if (s == null && c.getParent() instanceof JToolBar) {
            String tbs = (String)((JToolBar)c.getParent()).getClientProperty("Quaqua.ToolBar.style");
            s = "gradient".equals(tbs) || "placard".equals(tbs) ? "gradient" : "toolBar";
        }
        if (s == null || "push".equals(s)) {
            Insets vm = super.getVisualMargin(c, new Insets(0, 0, 0, 0));
            if (c.getHeight() - vm.top - vm.bottom > 26 || QuaquaUtilities.getSizeVariant(c) == QuaquaUtilities.SizeVariant.LARGE) {
                s = "bevel";
            }
        }
        if ("placard".equals(s) || "segmentedGradient".equals("")) {
            s = "gradient";
        }
        return s == null ? "push" : s;
    }

    private OSXAquaPainter.SegmentPosition getSegmentPosition(Component c) {
        String s = null;
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            s = (String)jc.getClientProperty("Quaqua.Button.style");
            if (s != null) {
                if ("toggleWest".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.first;
                }
                if ("toggleCenter".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.middle;
                }
                if ("toggleEast".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.last;
                }
            }
            if ((s = (String)jc.getClientProperty("JButton.segmentPosition")) != null) {
                if ("first".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.first;
                }
                if ("middle".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.middle;
                }
                if ("last".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.last;
                }
            }
        }
        return OSXAquaPainter.SegmentPosition.only;
    }

    @Override
    protected Insets getVisualMargin(Component c, Insets insets) {
        String ts;
        String s = this.getStyle(c);
        if ((insets = super.getVisualMargin(c, insets)) instanceof javax.swing.plaf.UIResource && "gradient".equals(s) && c.getParent() instanceof JToolBar && ("placard".equals(ts = (String)((JToolBar)c.getParent()).getClientProperty("Quaqua.ToolBar.style")) || "gradient".equals(ts))) {
            InsetsUtil.clear(insets);
        }
        WidgetConfig wc = wcs.get(s);
        if (insets instanceof javax.swing.plaf.UIResource) {
            switch (this.getSegmentPosition(c)) {
                case first: {
                    insets.right = 0;
                    break;
                }
                case middle: {
                    insets.right = 0;
                    insets.left = 0;
                    break;
                }
                case last: {
                    insets.left = 0;
                }
            }
        }
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        int sizeIndex;
        Insets i;
        if (c instanceof JComponent && (i = (Insets)((JComponent)c).getClientProperty("Quaqua.Border.insets")) != null) {
            InsetsUtil.setTo(i, insets);
            return insets;
        }
        String s = this.getStyle(c);
        QuaquaUtilities.SizeVariant size = QuaquaUtilities.getSizeVariant(c);
        WidgetConfig wc = wcs.get(s);
        Insets i2 = this.getVisualMargin(c, insets);
        switch (size) {
            default: {
                sizeIndex = 0;
                break;
            }
            case SMALL: {
                sizeIndex = 1;
                break;
            }
            case MINI: {
                sizeIndex = 2;
            }
        }
        if (wc != null) {
            Insets borderInsets = wc.borderInsets[sizeIndex];
            InsetsUtil.addTo(borderInsets, i2);
        }
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Insets margin = b.getMargin();
            if ((margin == null || margin instanceof javax.swing.plaf.UIResource) && b.isBorderPainted()) {
                Insets insets2 = margin = wc == null || wc.margin.length <= sizeIndex ? null : wc.margin[sizeIndex];
            }
            if (margin != null) {
                InsetsUtil.addTo(margin, i2);
            }
        }
        return i2;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    static {
        Object[][] a = new Object[][]{{"push", false, OSXAquaPainter.Widget.buttonPush, new Insets[]{new Insets(1, 3, 2, 3), new Insets(1, 3, 1, 3), new Insets(1, 2, 1, 2)}, new Insets[]{new Insets(1, 14, 1, 14), new Insets(1, 5, 1, 5), new Insets(1, 4, 1, 4)}, new Insets[]{new Insets(2, -3, 0, -3), new Insets(2, -2, 0, -2), new Insets(1, 2, 0, 2)}}, {"square", false, OSXAquaPainter.Widget.buttonBevel, new Insets[]{new Insets(1, 1, 1, 1), new Insets(1, 1, 1, 1), new Insets(1, 1, 1, 1)}, new Insets[]{new Insets(2, 8, 2, 8), new Insets(1, 5, 1, 5), new Insets(1, 4, 1, 4)}, new Insets[]{new Insets(3, 3, 3, 3), new Insets(3, 3, 3, 3), new Insets(3, 3, 3, 3), new Insets(3, 3, 3, 2), new Insets(3, 3, 3, 2), new Insets(3, 3, 3, 2), new Insets(3, 3, 3, 2), new Insets(3, 3, 3, 2), new Insets(3, 3, 3, 2), new Insets(3, 3, 3, 3), new Insets(3, 3, 3, 3), new Insets(3, 3, 3, 3)}}, {"bevel", false, OSXAquaPainter.Widget.buttonBevelRound, new Insets[]{new Insets(1, 1, 2, 1), new Insets(1, 1, 2, 1), new Insets(1, 1, 2, 1)}, new Insets[]{new Insets(3, 13, 4, 13), new Insets(3, 9, 1, 9), new Insets(3, 7, 3, 7)}, new Insets[]{new Insets(1, 1, 1, 1), new Insets(1, 1, 1, 1), new Insets(1, 1, 1, 1)}}, {"gradient", "placard", false, OSXAquaPainter.Widget.buttonBevelInset, new Insets[]{new Insets(1, 1, 1, 1), new Insets(1, 1, 1, 1), new Insets(1, 1, 1, 1)}, new Insets[]{new Insets(2, 8, 2, 8), new Insets(1, 5, 1, 5), new Insets(1, 4, 1, 4)}, new Insets[]{new Insets(2, 3, 2, 3), new Insets(2, 3, 2, 3), new Insets(2, 3, 2, 3), new Insets(2, 3, 2, 2), new Insets(2, 3, 2, 2), new Insets(2, 3, 2, 2), new Insets(2, 3, 2, 2), new Insets(2, 3, 2, 2), new Insets(2, 3, 2, 2), new Insets(2, 3, 2, 3), new Insets(2, 3, 2, 3), new Insets(2, 3, 2, 3)}}, {"tableHeader", false, OSXAquaPainter.Widget.buttonListHeader, new Insets[]{new Insets(2, 4, 2, 4), new Insets(2, 4, 2, 4), new Insets(2, 4, 2, 4)}, new Insets[]{new Insets(1, 4, 1, 4), new Insets(1, 2, 1, 2), new Insets(1, 2, 1, 2)}, new Insets[]{new Insets(0, 2, 0, 3), new Insets(0, 2, 0, 3), new Insets(0, 2, 0, 3)}}, {"textured", false, OSXAquaPainter.Widget.buttonPushTextured, new Insets[]{new Insets(1, 3, 2, 3), new Insets(1, 3, 1, 3), new Insets(1, 2, 1, 2)}, new Insets[]{new Insets(1, 14, 1, 14), new Insets(1, 5, 1, 5), new Insets(1, 4, 1, 4)}, new Insets[]{new Insets(3, 3, 2, 3), new Insets(3, 3, 2, 3), new Insets(1, 3, 0, 3)}}, {"roundRect", false, OSXAquaPainter.Widget.buttonPushInset, new Insets[]{new Insets(1, 5, 1, 5), new Insets(1, 3, 1, 3), new Insets(1, 3, 1, 3)}, new Insets[]{new Insets(0, 6, 0, 6), new Insets(0, 5, 0, 5), new Insets(0, 4, 0, 4)}, new Insets[]{new Insets(0, 2, 0, 2), new Insets(0, 2, 0, 2), new Insets(1, 2, 0, 2)}}, {"recessed", false, OSXAquaPainter.Widget.buttonPushScope, new Insets[]{new Insets(1, 7, 1, 7), new Insets(1, 5, 1, 5), new Insets(1, 5, 1, 5)}, new Insets[]{new Insets(0, 6, 0, 6), new Insets(0, 5, 0, 5), new Insets(0, 4, 0, 4)}, new Insets[]{new Insets(0, 2, 0, 2), new Insets(0, 2, 0, 2), new Insets(1, 2, 0, 2)}}, {"colorWell", false, null, new Insets[]{new Insets(7, 6, 7, 6), new Insets(7, 6, 7, 6), new Insets(7, 6, 7, 6)}, new Insets[]{new Insets(1, 10, 1, 10), new Insets(1, 8, 1, 8), new Insets(1, 8, 1, 8)}, null}, {"help", false, OSXAquaPainter.Widget.buttonRoundHelp, new Insets[]{new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, new Insets[]{new Insets(1, 4, 1, 4), new Insets(1, 2, 1, 2), new Insets(1, 2, 1, 2)}, new Insets[]{new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}}, {"toolBar", false, null, new Insets[]{new Insets(3, 3, 3, 3), new Insets(3, 3, 3, 3), new Insets(3, 3, 3, 3)}, new Insets[]{new Insets(1, 4, 1, 4), new Insets(1, 2, 1, 2), new Insets(1, 2, 1, 2)}, new Insets[]{new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}}, {"segmented", "toggle", "toggleEast", "toggleCenter", "toggleWest", true, OSXAquaPainter.Widget.buttonSegmented, new Insets[]{new Insets(2, 13, 3, 13), new Insets(2, 8, 2, 8), new Insets(2, 7, 2, 7)}, new Insets[]{new Insets(1, 4, 1, 4), new Insets(1, 2, 1, 2), new Insets(1, 2, 1, 2)}, new Insets[]{new Insets(0, 1, 0, 1), new Insets(1, 1, 0, 1), new Insets(0, 2, 0, 2), new Insets(0, 1, 0, 0), new Insets(1, 1, 0, 0), new Insets(0, 2, 0, 0), new Insets(0, 0, 0, 0), new Insets(1, 0, 0, 1), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 1), new Insets(1, 1, 0, 1), new Insets(0, 0, 0, 2)}}, {"segmentedRoundRect", "segmentedCapsule", "segmentedTextured", true, OSXAquaPainter.Widget.buttonSegmentedInset, new Insets[]{new Insets(2, 13, 3, 13), new Insets(2, 8, 2, 8), new Insets(2, 7, 2, 7)}, new Insets[]{new Insets(1, 4, 1, 4), new Insets(1, 2, 1, 2), new Insets(1, 2, 1, 2)}, new Insets[]{new Insets(0, 1, 0, 1), new Insets(0, 1, 0, 1), new Insets(0, 2, 0, 2), new Insets(0, 1, 0, 0), new Insets(1, 1, 0, 0), new Insets(0, 2, 0, 0), new Insets(0, 0, 0, 0), new Insets(1, 0, 0, 1), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 1), new Insets(1, 1, 0, 1), new Insets(0, 0, 0, 2)}}};
        wcs = new HashMap();
        for (int i = 0; i < a.length; ++i) {
            int j = 0;
            int numNames = 0;
            WidgetConfig wp = new WidgetConfig();
            while (j < a[i].length) {
                Insets[] ii;
                while (a[i][j++] instanceof String) {
                }
                numNames = --j;
                wp.needsTrailingSeparatorHack = (Boolean)a[i][j++];
                wp.widget = (OSXAquaPainter.Widget)((Object)a[i][j++]);
                Insets[] bi = (Insets[])a[i][j++];
                wp.borderInsets[0] = bi[0];
                wp.borderInsets[1] = bi[1];
                wp.borderInsets[2] = bi[2];
                Insets[] mi = (Insets[])a[i][j++];
                wp.margin[0] = mi[0];
                wp.margin[1] = mi[1];
                wp.margin[2] = mi[2];
                if ((ii = (Insets[])a[i][j++]) == null) continue;
                boolean k = false;
                wp.imageInsets[0][0] = ii[0];
                wp.imageInsets[0][1] = ii[1];
                wp.imageInsets[0][2] = ii[2];
                wp.imageInsets[1][0] = ii.length == 3 ? ii[0] : ii[3];
                wp.imageInsets[1][1] = ii.length == 3 ? ii[1] : ii[4];
                wp.imageInsets[1][2] = ii.length == 3 ? ii[2] : ii[5];
                wp.imageInsets[2][0] = ii.length == 3 ? ii[0] : ii[6];
                wp.imageInsets[2][1] = ii.length == 3 ? ii[1] : ii[7];
                wp.imageInsets[2][2] = ii.length == 3 ? ii[2] : ii[8];
                wp.imageInsets[3][0] = ii.length == 3 ? ii[0] : ii[9];
                wp.imageInsets[3][1] = ii.length == 3 ? ii[1] : ii[10];
                wp.imageInsets[3][2] = ii.length == 3 ? ii[2] : ii[11];
            }
            for (j = 0; j < numNames; ++j) {
                wcs.put((String)a[i][j], wp);
            }
        }
    }

    public static class UIResource
    extends QuaquaNativeButtonBorder
    implements javax.swing.plaf.UIResource {
    }

    private class NativeBGBorder
    extends CachedPainter
    implements PressedCueBorder,
    VisualMargin {
        private static final int ARG_ACTIVE = 0;
        private static final int ARG_PRESSED = 1;
        private static final int ARG_DISABLED = 2;
        private static final int ARG_ROLLOVER = 3;
        private static final int ARG_SELECTED = 4;
        private static final int ARG_FOCUSED = 5;
        private static final int ARG_PULSED = 6;
        private static final int ARG_SIZE_VARIANT = 7;
        private static final int ARG_SEGPOS = 9;
        private static final int ARG_WIDGET = 12;
        private static final int ARG_TRAILING_SEPARATOR = 19;
        private static final int ARG_TRAILING_SEPARATOR_HACK = 20;
        private static final int ARG_ANIM_FRAME = 21;

        public NativeBGBorder() {
            super(12);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int segIndex;
            int sizeIndex;
            OSXAquaPainter.Size size;
            OSXAquaPainter.State state;
            AbstractButton b = null;
            JComponent jc = null;
            ButtonModel bm = null;
            if (c instanceof AbstractButton) {
                jc = b = (AbstractButton)c;
                bm = b.getModel();
            } else if (c instanceof JComponent) {
                jc = (JComponent)c;
            }
            String s = QuaquaNativeButtonBorder.this.getStyle(c);
            WidgetConfig wc = (WidgetConfig)wcs.get(s);
            OSXAquaPainter.Widget widget = wc.widget;
            int args = 0;
            if (QuaquaUtilities.isOnActiveWindow(c)) {
                state = OSXAquaPainter.State.active;
                args |= 1;
                if (b instanceof JButton && ((JButton)b).isDefaultButton()) {
                    state = OSXAquaPainter.State.pulsed;
                    args |= 0x40;
                    long animationTime = System.currentTimeMillis();
                    args = (int)((long)args | animationTime << 21);
                    QuaquaNativeButtonBorder.this.painter.setValueByKey(OSXAquaPainter.Key.animationTime, (double)animationTime / 1000.0);
                }
            } else {
                state = OSXAquaPainter.State.inactive;
            }
            if (bm != null) {
                if (bm.isRollover()) {
                    state = OSXAquaPainter.State.rollover;
                    args |= 8;
                }
                if (bm.isArmed() && bm.isPressed()) {
                    state = OSXAquaPainter.State.pressed;
                    args |= 2;
                }
                if (!bm.isEnabled()) {
                    state = OSXAquaPainter.State.disabled;
                    args |= 4;
                }
            }
            QuaquaNativeButtonBorder.this.painter.setState(state);
            int value = b == null ? 0 : (b.isSelected() ? 1 : 0);
            QuaquaNativeButtonBorder.this.painter.setValueByKey(OSXAquaPainter.Key.value, value);
            args |= value << 4;
            boolean isFocused = QuaquaUtilities.isFocused(c);
            QuaquaNativeButtonBorder.this.painter.setValueByKey(OSXAquaPainter.Key.focused, isFocused ? 1.0 : 0.0);
            args |= isFocused ? 32 : 0;
            switch (QuaquaUtilities.getSizeVariant(c)) {
                default: {
                    size = OSXAquaPainter.Size.regular;
                    args |= 0;
                    break;
                }
                case SMALL: {
                    size = OSXAquaPainter.Size.small;
                    args |= 0x80;
                    break;
                }
                case LARGE: {
                    size = OSXAquaPainter.Size.large;
                    args |= 0x100;
                    break;
                }
                case MINI: {
                    size = OSXAquaPainter.Size.mini;
                    args |= 0x180;
                }
            }
            QuaquaNativeButtonBorder.this.painter.setSize(size);
            OSXAquaPainter.SegmentPosition segpos = QuaquaNativeButtonBorder.this.getSegmentPosition(c);
            QuaquaNativeButtonBorder.this.painter.setSegmentPosition(segpos);
            args |= segpos.getId() << 9;
            switch (segpos) {
                case first: 
                case middle: {
                    QuaquaNativeButtonBorder.this.painter.setValueByKey(OSXAquaPainter.Key.segmentTrailingSeparator, 1.0);
                    args |= 0x80000;
                    if (!wc.needsTrailingSeparatorHack) break;
                    args |= 0x100000;
                    break;
                }
                default: {
                    QuaquaNativeButtonBorder.this.painter.setValueByKey(OSXAquaPainter.Key.segmentTrailingSeparator, 0.0);
                }
            }
            args |= widget.getId() << 12;
            QuaquaNativeButtonBorder.this.painter.setWidget(widget);
            switch (size) {
                default: {
                    sizeIndex = 0;
                    break;
                }
                case small: {
                    sizeIndex = 1;
                    break;
                }
                case mini: {
                    sizeIndex = 2;
                }
            }
            switch (segpos) {
                case first: {
                    segIndex = 1;
                    break;
                }
                case middle: {
                    segIndex = 2;
                    break;
                }
                case last: {
                    segIndex = 3;
                    break;
                }
                default: {
                    segIndex = 0;
                }
            }
            QuaquaNativeButtonBorder.this.imageInsets = wc.imageInsets[segIndex][sizeIndex];
            this.paint(c, g, x, y, width, height, args);
        }

        @Override
        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
            return new BufferedImage(w, h, 3);
        }

        @Override
        protected void paintToImage(Component c, Image img, int w, int h, Object argso) {
            Graphics2D ig = (Graphics2D)img.getGraphics();
            ig.setColor(new Color(0, true));
            ig.setComposite(AlphaComposite.getInstance(2));
            ig.fillRect(0, 0, img.getWidth(null), img.getHeight(null));
            ig.dispose();
            Insets vm = this.getVisualMargin(c);
            QuaquaNativeButtonBorder.this.painter.paint((BufferedImage)img, ((QuaquaNativeButtonBorder)QuaquaNativeButtonBorder.this).imageInsets.left - 3 + vm.left, ((QuaquaNativeButtonBorder)QuaquaNativeButtonBorder.this).imageInsets.top - 3 + vm.top, w - ((QuaquaNativeButtonBorder)QuaquaNativeButtonBorder.this).imageInsets.left - ((QuaquaNativeButtonBorder)QuaquaNativeButtonBorder.this).imageInsets.right + 6 - vm.left - vm.right, h - ((QuaquaNativeButtonBorder)QuaquaNativeButtonBorder.this).imageInsets.top - ((QuaquaNativeButtonBorder)QuaquaNativeButtonBorder.this).imageInsets.bottom + 6 - vm.top - vm.bottom);
            int args = (Integer)argso;
            if ((args & 0x100000) != 0) {
                Graphics2D g = ((BufferedImage)img).createGraphics();
                g.setColor(new Color(-356795461, true));
                g.drawLine(w - 1, 6, w - 1, h - 8);
                g.dispose();
            }
        }

        @Override
        protected void paintToImage(Component c, Graphics g, int w, int h, Object args) {
            BufferedImage img = (BufferedImage)this.createImage(c, (w / 32 + 1) * 32, (h / 32 + 1) * 32, null);
            this.paintToImage(c, img, w, h, args);
            g.drawImage(img, 0, 0, null);
            img.flush();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public Insets getVisualMargin(Component c) {
            Insets i = QuaquaNativeButtonBorder.this.getVisualMargin(c);
            return i;
        }

        @Override
        public boolean hasPressedCue(JComponent c) {
            return true;
        }
    }

    private class BGBorder
    implements Border,
    PressedCueBorder,
    VisualMargin {
        private PressedCueBorder nativeBorder;
        private PressedCueBorder bevelBorder;
        private PressedCueBorder placardBorder;
        private PressedCueBorder toolBarBorder;
        private PressedCueBorder toolBarTabBorder;
        private PressedCueBorder colorWellBorder;

        private BGBorder() {
        }

        private PressedCueBorder getActualBorder(Component c) {
            String s = QuaquaNativeButtonBorder.this.getStyle(c);
            WidgetConfig wp = (WidgetConfig)wcs.get(s);
            PressedCueBorder b = wp == null || wp.widget == null ? ("colorWell".equals(s) ? this.getColorWellBorder() : ("toolBar".equals(s) ? this.getToolBarBorder() : ("toolBarTab".equals(s) ? this.getToolBarTabBorder() : this.getBevelBorder()))) : this.getNativeBorder();
            return b;
        }

        private PressedCueBorder getBevelBorder() {
            if (this.bevelBorder == null) {
                this.bevelBorder = new FocusedBorder(new CompositeVisualMarginBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/RoundedBevel.borders.png")), 10, true, new Insets(10, 9, 10, 8), new Insets(0, 0, 0, 0), true), 3, 2, 2, 2));
            }
            return this.bevelBorder;
        }

        private PressedCueBorder getNativeBorder() {
            if (this.nativeBorder == null) {
                this.nativeBorder = new FocusedBorder(new NativeBGBorder());
            }
            return this.nativeBorder;
        }

        private PressedCueBorder getPlacardBorder() {
            if (this.placardBorder == null) {
                this.placardBorder = new FocusedBorder(new CompositeVisualMarginBorder(new QuaquaPlacardButtonBorder(), 1, 0, 1, 0));
            }
            return this.placardBorder;
        }

        private PressedCueBorder getToolBarBorder() {
            if (this.toolBarBorder == null) {
                this.toolBarBorder = new VisualMarginBorder(0, 4, 0, 4){

                    @Override
                    public boolean hasPressedCue(JComponent c) {
                        return false;
                    }
                };
            }
            return this.toolBarBorder;
        }

        private PressedCueBorder getColorWellBorder() {
            if (this.colorWellBorder == null) {
                this.colorWellBorder = new FocusedBorder(new CompositeVisualMarginBorder(new QuaquaColorWellBorder(), 0, 0, 0, 0));
            }
            return this.colorWellBorder;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.getActualBorder(c).paintBorder(c, g, x, y, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getActualBorder(c).getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public Insets getVisualMargin(Component c) {
            return ((VisualMargin)((Object)this.getActualBorder(c))).getVisualMargin(c);
        }

        @Override
        public boolean hasPressedCue(JComponent c) {
            return this.getActualBorder(c).hasPressedCue(c);
        }

        private PressedCueBorder getToolBarTabBorder() {
            if (this.toolBarTabBorder == null) {
                this.toolBarTabBorder = new QuaquaToolBarTabButtonBorder();
            }
            return this.toolBarTabBorder;
        }
    }

    private static class WidgetConfig {
        String[] type;
        OSXAquaPainter.Widget widget;
        boolean needsTrailingSeparatorHack;
        Insets[] margin = new Insets[3];
        Insets[] borderInsets = new Insets[3];
        Insets[][] imageInsets = new Insets[4][3];

        private WidgetConfig() {
        }
    }
}

