/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.color.PaintableColor;
import ch.randelshofer.quaqua.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class QuaquaPanelUI
extends BasicPanelUI {
    private static PanelUI panelUI;

    public static ComponentUI createUI(JComponent c) {
        if (panelUI == null) {
            panelUI = new QuaquaPanelUI();
        }
        return panelUI;
    }

    @Override
    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        QuaquaUtilities.installProperty(p, "opaque", UIManager.get("Panel.opaque"));
    }

    @Override
    protected void uninstallDefaults(JPanel p) {
        super.uninstallDefaults(p);
    }

    public static boolean isInTabbedPane(Component comp) {
        if (comp == null) {
            return false;
        }
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JTabbedPane) {
                return true;
            }
            if (parent instanceof JRootPane) {
                return false;
            }
            if (parent instanceof RootPaneContainer) {
                return false;
            }
            if (!(parent instanceof Window)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void paint(Graphics gr, JComponent c) {
        TitledBorder tb;
        Border titledBorderBorder;
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        if (c.isOpaque()) {
            g.setPaint(PaintableColor.getPaint(c.getBackground(), c));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Border backgroundBorder = null;
        Graphics2D bg = (Graphics2D)g.create();
        Insets insets = new Insets(0, 0, 0, 0);
        if (c.getBorder() instanceof BackgroundBorder) {
            backgroundBorder = ((BackgroundBorder)c.getBorder()).getBackgroundBorder();
        } else if (c.getBorder() instanceof TitledBorder && (titledBorderBorder = (tb = (TitledBorder)c.getBorder()).getBorder()) instanceof BackgroundBorder) {
            backgroundBorder = ((BackgroundBorder)titledBorderBorder).getBackgroundBorder();
            insets = this.getTitledBorderBorderPaintingInsets(c, tb);
            this.setTitledBorderClip(bg, c, tb);
        }
        if (backgroundBorder != null) {
            backgroundBorder.paintBorder(c, bg, insets.left, insets.top, c.getWidth() - insets.left - insets.right, c.getHeight() - insets.top - insets.bottom);
        }
        Debug.paint(gr, c, this);
        QuaquaUtilities.endGraphics(g, oldHints);
    }

    private void setTitledBorderClip(Graphics2D g, JComponent c, TitledBorder tb) {
        int position = this.getTitlePosition(tb);
        if (position != 2 && position != 5) {
            return;
        }
        Rectangle bounds = this.getTitledBorderBorderTitleBounds(c, tb);
        if (bounds == null) {
            return;
        }
        Path2D.Float path = new Path2D.Float();
        path.append(new Rectangle(0, 0, c.getWidth(), bounds.y), false);
        path.append(new Rectangle(0, bounds.y, bounds.x - 2, bounds.height), false);
        path.append(new Rectangle(bounds.x + bounds.width + 2, bounds.y, c.getWidth() - bounds.width - bounds.x - 2, bounds.height), false);
        path.append(new Rectangle(0, bounds.y + bounds.height, c.getWidth(), c.getHeight() - bounds.height - bounds.y), false);
        g.clip(path);
    }

    private Rectangle getTitledBorderBorderTitleBounds(Component c, TitledBorder tb) {
        String title = tb.getTitle();
        if (title == null || title.isEmpty()) {
            return null;
        }
        JLabel label = new JLabel(title);
        Font f = tb.getTitleFont();
        if (f == null) {
            f = UIManager.getFont("TitledBorder.font");
        }
        label.setFont(f);
        label.setComponentOrientation(c.getComponentOrientation());
        Border b = tb.getBorder();
        int edge = b instanceof TitledBorder ? 0 : 2;
        Dimension size = label.getPreferredSize();
        Insets insets = this.getTitledBorderBorderPaintingInsets(c, tb);
        int labelY = 0;
        int labelH = size.height;
        int position = this.getTitlePosition(tb);
        switch (position) {
            case 1: {
                insets.left = 0;
                insets.right = 0;
                break;
            }
            case 2: {
                insets.top = edge + insets.top / 2 - labelH / 2;
                if (insets.top < edge) break;
                labelY += insets.top;
                break;
            }
            case 3: {
                labelY += insets.top + edge;
                break;
            }
            case 4: {
                labelY += c.getHeight() - labelH - insets.bottom - edge;
                break;
            }
            case 5: {
                labelY += c.getHeight() - labelH;
                insets.bottom = edge + (insets.bottom - labelH) / 2;
                if (insets.bottom < edge) break;
                labelY -= insets.bottom;
                break;
            }
            case 6: {
                insets.left = 0;
                insets.right = 0;
                labelY += c.getHeight() - labelH;
            }
        }
        insets.left += edge + 5;
        insets.right += edge + 5;
        int labelX = 0;
        int labelW = c.getWidth() - insets.left - insets.right;
        if (labelW > size.width) {
            labelW = size.width;
        }
        switch (this.getJustification(c, tb)) {
            case 1: {
                labelX += insets.left;
                break;
            }
            case 3: {
                labelX += c.getWidth() - insets.right - labelW;
                break;
            }
            case 2: {
                labelX += (c.getWidth() - labelW) / 2;
            }
        }
        return new Rectangle(labelX, labelY, labelW, labelH);
    }

    private int getJustification(Component c, TitledBorder tb) {
        int justification = tb.getTitleJustification();
        if (justification == 4 || justification == 0) {
            return c.getComponentOrientation().isLeftToRight() ? 1 : 3;
        }
        if (justification == 5) {
            return c.getComponentOrientation().isLeftToRight() ? 3 : 1;
        }
        return justification;
    }

    private Insets getTitledBorderBorderPaintingInsets(Component c, TitledBorder tb) {
        String title = tb.getTitle();
        if (title == null || title.isEmpty()) {
            return new Insets(0, 0, 0, 0);
        }
        Insets borderInsets = tb.getBorder().getBorderInsets(c);
        Insets titledBorderInsets = tb.getBorderInsets(c);
        int margin = titledBorderInsets.left - borderInsets.left;
        int top = margin / 2;
        int left = margin / 2;
        int bottom = margin / 2;
        int right = margin / 2;
        switch (this.getTitlePosition(tb)) {
            case 1: {
                top = titledBorderInsets.top - borderInsets.top - top;
                break;
            }
            case 2: {
                top = (titledBorderInsets.top - top) / 2;
                break;
            }
            case 5: {
                bottom = (titledBorderInsets.bottom - bottom) / 2;
                break;
            }
            case 6: {
                bottom = titledBorderInsets.bottom - borderInsets.bottom;
            }
        }
        return new Insets(top, left, bottom, right);
    }

    private int getTitlePosition(TitledBorder tb) {
        int position = tb.getTitlePosition();
        if (position != 0) {
            return position;
        }
        Object value = UIManager.get("TitledBorder.position");
        if (value instanceof Integer) {
            int i = (Integer)value;
            if (0 < i && i <= 6) {
                return i;
            }
        } else if (value instanceof String) {
            String s = (String)value;
            if (s.equalsIgnoreCase("ABOVE_TOP")) {
                return 1;
            }
            if (s.equalsIgnoreCase("TOP")) {
                return 2;
            }
            if (s.equalsIgnoreCase("BELOW_TOP")) {
                return 3;
            }
            if (s.equalsIgnoreCase("ABOVE_BOTTOM")) {
                return 4;
            }
            if (s.equalsIgnoreCase("BOTTOM")) {
                return 5;
            }
            if (s.equalsIgnoreCase("BELOW_BOTTOM")) {
                return 6;
            }
        }
        return 2;
    }
}

