/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaTableUI;
import ch.randelshofer.quaqua.QuaquaTreeUI;
import ch.randelshofer.quaqua.QuaquaUtilities;
import de.sciss.treetable.j.TreeTable;
import de.sciss.treetable.j.TreeTableCellRenderer;
import de.sciss.treetable.j.ui.BasicTreeTableUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class QuaquaTreeTableUI
extends BasicTreeTableUI {
    protected MyHandler handler = new MyHandler();
    protected MyTableUI tableUI = new MyTableUI();
    protected MyTreeUI treeUI = new MyTreeUI();

    @Override
    protected BasicTreeTableUI.Handler createHandler() {
        return this.handler;
    }

    @Override
    protected JTree createAndConfigureTree() {
        JTree tree = super.createAndConfigureTree();
        tree.setFocusable(false);
        tree.setUI(this.treeUI);
        return tree;
    }

    @Override
    protected JTable createAndConfigureTable() {
        JTable table = super.createAndConfigureTable();
        table.setFocusable(false);
        table.setUI(this.tableUI);
        return table;
    }

    @Override
    protected TreeTableCellRenderer createFocusRenderer() {
        return null;
    }

    @Override
    protected boolean hasTreeHandle(TreeTable treeTable, TreePath path) {
        return !treeTable.isLeaf(path);
    }

    @Override
    protected List<String> getProperties() {
        ArrayList<String> props = new ArrayList<String>(super.getProperties());
        props.add("Frame.active");
        return props;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MyPropertyChangeListener();
    }

    protected void handleDoubleClick(TreePath path) {
    }

    protected class MyTableUI
    extends QuaquaTableUI {
        protected MyHandler handler;

        protected MyTableUI() {
        }

        @Override
        protected QuaquaTableUI.Handler createHandler() {
            this.handler = new MyHandler();
            return this.handler;
        }

        public void repaintSelection() {
            this.handler.repaintSelection();
        }

        @Override
        protected boolean isFocused() {
            return this.table.isEditing() || QuaquaUtilities.isFocused(QuaquaTreeTableUI.this.treeTable);
        }

        protected class MyHandler
        extends QuaquaTableUI.Handler {
            protected MyHandler() {
            }
        }
    }

    protected class MyTreeUI
    extends QuaquaTreeUI {
        protected MyHandler handler;

        protected MyTreeUI() {
        }

        @Override
        protected QuaquaTreeUI.Handler createHandler() {
            this.handler = new MyHandler();
            return this.handler;
        }

        @Override
        protected boolean shouldDisplayAsFocused(Component c) {
            return QuaquaUtilities.isFocused(QuaquaTreeTableUI.this.treeTable);
        }

        @Override
        protected boolean shouldPaintSelectionBackground(Component c) {
            return false;
        }

        @Override
        public void repaintSelection() {
            QuaquaTreeTableUI.this.tableUI.repaintSelection();
        }

        protected class MyHandler
        extends QuaquaTreeUI.Handler {
            protected MyHandler() {
                super(MyTreeUI.this);
            }
        }
    }

    protected class MyHandler
    extends BasicTreeTableUI.Handler {
        protected MyHandler() {
            super(QuaquaTreeTableUI.this);
        }

        @Override
        protected void focusChanged() {
            QuaquaTreeTableUI.this.treeUI.repaintSelection();
            QuaquaTreeTableUI.this.tableUI.repaintSelection();
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            QuaquaTreeTableUI.this.handler.propertyChange(event);
        }
    }
}

