/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaDragRecognitionSupport;
import ch.randelshofer.quaqua.QuaquaDropTargetListener;
import ch.randelshofer.quaqua.QuaquaLazyActionMap;
import ch.randelshofer.quaqua.QuaquaUIAction;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import ch.randelshofer.quaqua.color.PaintableColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class QuaquaTreeUI
extends BasicTreeUI {
    private static final Actions SHARED_ACTION = new Actions();
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private int lastWidth;
    private long timeFactor = 1000L;
    private Handler handler;
    private MouseEvent releaseEvent;
    private boolean ignoreLAChange;
    private int leadRow;
    private static DropTargetListener defaultDropTargetListener = null;
    private boolean isMouseReleaseStartsEditing;
    private boolean isDragRecognitionOngoing;
    private static final Color TRANSPARENT_COLOR = new Color(0, true);
    private boolean isCellFilled;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaTreeUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tree.setInvokesStopCellEditing(true);
    }

    @Override
    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tree, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tree, 0, km);
        QuaquaLazyActionMap.installLazyActionMap(this.tree, QuaquaTreeUI.class, "Tree.actionMap");
    }

    static void loadActionMap(QuaquaLazyActionMap map) {
        map.put(new Actions("selectPrevious"));
        map.put(new Actions("selectPreviousChangeLead"));
        map.put(new Actions("selectPreviousExtendSelection"));
        map.put(new Actions("selectNext"));
        map.put(new Actions("selectNextChangeLead"));
        map.put(new Actions("selectNextExtendSelection"));
        map.put(new Actions("selectChild"));
        map.put(new Actions("selectChildChangeLead"));
        map.put(new Actions("selectParent"));
        map.put(new Actions("selectParentChangeLead"));
        map.put(new Actions("scrollUpChangeSelection"));
        map.put(new Actions("scrollUpChangeLead"));
        map.put(new Actions("scrollUpExtendSelection"));
        map.put(new Actions("scrollDownChangeSelection"));
        map.put(new Actions("scrollDownExtendSelection"));
        map.put(new Actions("scrollDownChangeLead"));
        map.put(new Actions("selectFirst"));
        map.put(new Actions("selectFirstChangeLead"));
        map.put(new Actions("selectFirstExtendSelection"));
        map.put(new Actions("selectLast"));
        map.put(new Actions("selectLastChangeLead"));
        map.put(new Actions("selectLastExtendSelection"));
        map.put(new Actions("toggle"));
        map.put(new Actions("cancel"));
        map.put(new Actions("startEditing"));
        map.put(new Actions("selectAll"));
        map.put(new Actions("clearSelection"));
        map.put(new Actions("scrollLeft"));
        map.put(new Actions("scrollRight"));
        map.put(new Actions("scrollLeftExtendSelection"));
        map.put(new Actions("scrollRightExtendSelection"));
        map.put(new Actions("scrollRightChangeLead"));
        map.put(new Actions("scrollLeftChangeLead"));
        map.put(new Actions("expand"));
        map.put(new Actions("collapse"));
        map.put(new Actions("moveSelectionToParent"));
        map.put(new Actions("addToSelection"));
        map.put(new Actions("toggleAndAnchor"));
        map.put(new Actions("extendTo"));
        map.put(new Actions("moveSelectionTo"));
        map.put(TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction());
    }

    @Override
    protected void prepareForUIInstall() {
        super.prepareForUIInstall();
        this.leadRow = -1;
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.handler = null;
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            QuaquaTreeCellEditor editor = new QuaquaTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
            return editor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new QuaquaTreeCellRenderer();
    }

    @Override
    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    @Override
    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return this.getHandler();
    }

    @Override
    protected TreeSelectionListener createTreeSelectionListener() {
        return this.getHandler();
    }

    @Override
    protected CellEditorListener createCellEditorListener() {
        return this.getHandler();
    }

    @Override
    protected TreeExpansionListener createTreeExpansionListener() {
        return this.getHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = this.createHandler();
        }
        return this.handler;
    }

    protected Handler createHandler() {
        return new Handler();
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return this.getHandler();
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent event) {
        return event.getID() == 501 && SwingUtilities.isLeftMouseButton(event) && event.isMetaDown();
    }

    @Override
    protected boolean isToggleEvent(MouseEvent event) {
        if (event.getID() != 501 || !SwingUtilities.isLeftMouseButton(event)) {
            return false;
        }
        int clickCount = this.tree.getToggleClickCount();
        if (clickCount <= 0) {
            return false;
        }
        return event.getClickCount() % clickCount == 0;
    }

    @Override
    protected boolean isMultiSelectEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isShiftDown();
    }

    private TreePath getMouseClickedClosestPathForLocation(JTree tree, int x, int y) {
        TreePath path = this.getClosestPathForLocation(tree, x, y);
        if (path == null) {
            return null;
        }
        Rectangle pathBounds = this.getPathBounds(tree, path);
        if (y > pathBounds.y + pathBounds.height) {
            return null;
        }
        return path;
    }

    private void setAnchorSelectionPath(TreePath newPath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(newPath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    private TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLeadSelectionPath(TreePath newPath, boolean repaint) {
        Rectangle bounds = repaint ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(newPath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        this.leadRow = this.getRowForPath(this.tree, newPath);
        if (repaint) {
            if (bounds != null) {
                this.tree.repaint(bounds);
            }
            if ((bounds = this.getPathBounds(this.tree, newPath)) != null) {
                this.tree.repaint(bounds);
            }
        }
    }

    private TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    private void setLeadSelectionPath(TreePath newPath) {
        this.setLeadSelectionPath(newPath, false);
    }

    private void updateLeadRow() {
        this.leadRow = this.getRowForPath(this.tree, this.getLeadSelectionPath());
    }

    private void updateSize0() {
        this.validCachedPreferredSize = false;
        this.tree.revalidate();
    }

    @Override
    protected int getLeadSelectionRow() {
        return this.tree.getLeadSelectionRow();
    }

    @Override
    protected void setShowsRootHandles(boolean newValue) {
        super.setShowsRootHandles(true);
    }

    @Override
    protected boolean getShowsRootHandles() {
        return true;
    }

    private void repaintPath(TreePath path) {
        Rectangle bounds;
        if (path != null && (bounds = this.getPathBounds(this.tree, path)) != null) {
            this.tree.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Object value = path.getLastPathComponent();
        if (!isLeaf) {
            int middleXOfKnob = QuaquaUtilities.isLeftToRight(this.tree) ? bounds.x - (this.getRightChildIndent() - 1) : bounds.x + bounds.width + this.getRightChildIndent();
            int middleYOfKnob = bounds.y + bounds.height / 2;
            Icon treeIcon = this.getTreeIcon(isExpanded, this.tree.isRowSelected(row));
            if (treeIcon != null) {
                this.drawCentered(this.tree, g, treeIcon, middleXOfKnob, middleYOfKnob);
            }
        }
    }

    private Icon getTreeIcon(boolean isExpanded, boolean isSelected) {
        int index;
        boolean isSideBar = this.isSideBar();
        Icon[] icons = (Icon[])UIManager.get(isSideBar ? "Tree.sideBar.icons" : "Tree.icons");
        if (icons == null) {
            return UIManager.getIcon(isExpanded ? "Tree.expandedIcon" : "Tree.collapsedIcon");
        }
        int n = index = isExpanded ? 6 : 0;
        if (isSelected) {
            index = QuaquaUtilities.isFocused(this.tree) ? (index += 2) : (QuaquaUtilities.isOnActiveWindow(this.tree) ? ++index : (index += 4));
        } else if (!this.tree.isEnabled()) {
            index += 5;
        } else if (!QuaquaUtilities.isOnActiveWindow(this.tree)) {
            index += 3;
        }
        return icons[index];
    }

    @Override
    protected int getRowX(int row, int depth) {
        boolean isSideBar = this.isSideBar();
        if (isSideBar) {
            return this.totalChildIndent * (Math.max(1, depth - (this.tree.isRootVisible() ? 2 : 1)) + this.depthOffset);
        }
        return this.totalChildIndent * (depth + this.depthOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startEditingOnRelease(TreePath path, MouseEvent event, MouseEvent releaseEvent) {
        this.releaseEvent = releaseEvent;
        try {
            if (this.isMouseReleaseStartsEditing) {
                boolean bl = this.startEditing(path, event);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseEvent = null;
        }
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (condition == 0) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)UIManager.get("Tree.focusInputMap");
            if (this.tree.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)UIManager.get("Tree.focusInputMap.RightToLeft")) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    @Override
    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    @Override
    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    @Override
    public void paint(Graphics gr, JComponent c) {
        Border selectionBorder;
        Color background;
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        Graphics2D g = (Graphics2D)gr;
        Object property = this.tree.getClientProperty("Quaqua.Tree.style");
        boolean isStriped = property != null && property.equals("striped");
        boolean isSideBar = this.isSideBar();
        Color[] stripes = new Color[]{UIManager.getColor("Tree.alternateBackground.0"), UIManager.getColor("Tree.alternateBackground.1")};
        boolean isEnabled = c.isEnabled();
        boolean isFocused = this.shouldDisplayAsFocused(c);
        boolean isActive = QuaquaUtilities.isOnActiveWindow(c);
        boolean shouldPaintSelection = this.shouldPaintSelectionBackground(c);
        Color selectionBackground = UIManager.getColor("Tree.selectionBackground");
        Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
        if (selectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionBackground).setActive(isFocused && isEnabled);
        }
        if (selectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionForeground).setActive(isFocused && isEnabled);
        }
        if (this.treeState == null) {
            return;
        }
        this.isCellFilled = Boolean.TRUE.equals(this.tree.getClientProperty("Quaqua.Tree.isCellFilled"));
        boolean leftToRight = QuaquaUtilities.isLeftToRight(this.tree);
        int width = this.tree.getWidth();
        int height = this.tree.getHeight();
        if (width != this.lastWidth) {
            this.lastWidth = width;
            if (!leftToRight) {
                this.redoTheLayout();
                this.updateSize();
            }
        }
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        this.drawingCache.clear();
        if (isSideBar) {
            background = UIManager.getColor("Tree.sideBar.background");
            selectionBorder = UIManager.getBorder("Tree.sideBar.selectionBorder");
            if (selectionBackground instanceof InactivatableColorUIResource) {
                ((InactivatableColorUIResource)selectionBackground).setTransparent(true);
            }
        } else {
            background = this.tree.getBackground();
            selectionBorder = null;
        }
        if (this.tree.isOpaque()) {
            if (background instanceof InactivatableColorUIResource) {
                if (isSideBar) {
                    ((InactivatableColorUIResource)background).setActive(QuaquaUtilities.isOnActiveWindow(c, true));
                } else {
                    ((InactivatableColorUIResource)background).setActive(isActive);
                }
            }
            g.setPaint(PaintableColor.getPaint(background, this.tree, 0, 0, width, height));
            g.fillRect(0, 0, width, height);
        }
        if (initialPath != null && paintingEnumerator != null) {
            boolean isExpanded;
            boolean hasBeenExpanded;
            boolean isLeaf;
            TreePath path;
            TreePath parentPath = initialPath;
            boolean done = false;
            Rectangle bounds = null;
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            int rwidth = width - insets.right - insets.left;
            if (isStriped) {
                int startY;
                while (!done && paintingEnumerator.hasMoreElements()) {
                    path = paintingEnumerator.nextElement();
                    if (path != null) {
                        isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                        if (isLeaf) {
                            hasBeenExpanded = false;
                            isExpanded = false;
                        } else {
                            isExpanded = this.treeState.getExpandedState(path);
                            hasBeenExpanded = this.tree.hasBeenExpanded(path);
                        }
                        bounds = this.getCellBoundsForPainting(path, boundsBuffer);
                        if (bounds == null) {
                            return;
                        }
                        bounds.x += insets.left;
                        bounds.y += insets.top;
                        if (this.tree.isRowSelected(row) && shouldPaintSelection) {
                            if (selectionBorder == null) {
                                g.setColor(selectionBackground);
                                g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
                            } else {
                                selectionBorder.paintBorder(this.tree, g, insets.left, bounds.y, rwidth, bounds.height);
                            }
                        } else {
                            g.setColor(stripes[row % 2]);
                            g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
                        }
                        if (bounds.y + bounds.height >= endY) {
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                    ++row;
                }
                int rheight = this.tree.getRowHeight();
                if (rheight <= 0) {
                    rheight = this.tree.getFont().getSize() + 4;
                }
                for (int y = startY = bounds != null ? bounds.y + bounds.height : 0; y < height; y += rheight) {
                    g.setColor(stripes[row % 2]);
                    g.fillRect(insets.left, y, rwidth, rheight);
                    ++row;
                }
            } else {
                g.setColor(selectionBackground);
                while (!done && paintingEnumerator.hasMoreElements()) {
                    path = paintingEnumerator.nextElement();
                    if (path != null) {
                        isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                        if (isLeaf) {
                            hasBeenExpanded = false;
                            isExpanded = false;
                        } else {
                            isExpanded = this.treeState.getExpandedState(path);
                            hasBeenExpanded = this.tree.hasBeenExpanded(path);
                        }
                        bounds = this.getCellBoundsForPainting(path, boundsBuffer);
                        if (bounds == null) {
                            return;
                        }
                        bounds.x += insets.left;
                        bounds.y += insets.top;
                        if (this.tree.isRowSelected(row) && shouldPaintSelection) {
                            if (selectionBorder == null) {
                                g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
                            } else {
                                selectionBorder.paintBorder(this.tree, g, insets.left, bounds.y, rwidth, bounds.height);
                            }
                        }
                        if (bounds.y + bounds.height >= endY) {
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                    ++row;
                }
            }
            paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
            row = this.treeState.getRowForPath(initialPath);
            for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
            }
            done = false;
            while (!done && paintingEnumerator.hasMoreElements()) {
                path = paintingEnumerator.nextElement();
                if (path != null) {
                    isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    bounds = this.getCellBoundsForPainting(path, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (!leftToRight) {
                        bounds.x += 4;
                    }
                    this.paintRow(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf, isEnabled, isFocused, isActive);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        } else if (isStriped) {
            int rwidth = width - insets.left - insets.left;
            int rheight = this.tree.getRowHeight();
            if (rheight <= 0) {
                rheight = this.tree.getFont().getSize() + 4;
            }
            row = 0;
            for (int y = 0; y < height; y += rheight) {
                g.setColor(stripes[row % 2]);
                g.fillRect(insets.left, y, rwidth, rheight);
                ++row;
            }
        }
        this.rendererPane.removeAll();
        if (selectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionBackground).setActive(true);
            ((InactivatableColorUIResource)selectionBackground).setTransparent(false);
        }
        if (selectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionForeground).setActive(true);
        }
    }

    protected boolean shouldDisplayAsFocused(Component c) {
        return QuaquaUtilities.isFocused(c);
    }

    protected boolean shouldPaintSelectionBackground(Component c) {
        return true;
    }

    protected Rectangle getCellBoundsForPainting(TreePath path, Rectangle output) {
        this.treeState.getBounds(path, output);
        if (this.isCellFilled) {
            int width;
            Insets s = this.tree.getInsets();
            output.width = width = this.tree.getWidth() - s.left - s.right;
        }
        return output;
    }

    private void redoTheLayout() {
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf, boolean isEnabled, boolean isFocused, boolean isActive) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        int leadIndex = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        boolean isRowSelected = this.tree.isRowSelected(row);
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), isRowSelected, isExpanded, isLeaf, row, leadIndex == row);
        boolean isSideBar = this.isSideBar();
        if (isSideBar && component instanceof JLabel) {
            boolean isTopLevel;
            JLabel label = (JLabel)component;
            boolean bl = isTopLevel = path.getPathCount() == (this.isRootVisible() ? 1 : 2);
            label.putClientProperty("Quaqua.Label.style", isTopLevel ? (isRowSelected ? (isActive ? "categorySelected" : "categoryInactiveSelected") : (isActive ? "category" : "categoryInactive")) : (isRowSelected ? (isActive ? "rowSelected" : "rowInactiveSelected") : (isActive ? "row" : "rowInactive")));
            if (label instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer treeCellRenderer = (DefaultTreeCellRenderer)label;
                treeCellRenderer.setBackgroundNonSelectionColor(TRANSPARENT_COLOR);
                treeCellRenderer.setBackgroundSelectionColor(TRANSPARENT_COLOR);
                treeCellRenderer.setBorderSelectionColor(TRANSPARENT_COLOR);
                treeCellRenderer.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            if (isTopLevel) {
                label.setIcon(null);
                label.setDisabledIcon(null);
            }
        }
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    private boolean isSideBar() {
        Object property = this.tree.getClientProperty("Quaqua.Tree.style");
        return property != null && (property.equals("sideBar") || property.equals("sourceList"));
    }

    private void extendSelection(TreePath newLead) {
        TreePath aPath = this.getAnchorSelectionPath();
        int aRow = aPath == null ? -1 : this.getRowForPath(this.tree, aPath);
        int newIndex = this.getRowForPath(this.tree, newLead);
        if (aRow == -1) {
            this.tree.setSelectionRow(newIndex);
        } else {
            if (aRow < newIndex) {
                this.tree.setSelectionInterval(aRow, newIndex);
            } else {
                this.tree.setSelectionInterval(newIndex, aRow);
            }
            this.setAnchorSelectionPath(aPath);
            this.setLeadSelectionPath(newLead);
        }
    }

    protected void repaintSelection() {
        if (this.tree != null) {
            Rectangle pBounds = null;
            TreePath[] selectionPaths = this.tree.getSelectionPaths();
            if (selectionPaths != null) {
                for (int i = 0; i < selectionPaths.length; ++i) {
                    if (i == 0) {
                        pBounds = this.getPathBounds(this.tree, selectionPaths[i]);
                        continue;
                    }
                    pBounds.add(this.getPathBounds(this.tree, selectionPaths[i]));
                }
                if (pBounds != null) {
                    this.tree.repaint(0, pBounds.y, this.tree.getWidth(), pBounds.height);
                }
            }
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String name) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.cancelEditing(QuaquaTreeUI.this.tree, QuaquaTreeUI.this);
            }
        }

        @Override
        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled() && QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree);
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String name) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.toggle(QuaquaTreeUI.this.tree, QuaquaTreeUI.this);
            }
        }

        @Override
        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeHomeAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreeHomeAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.changeSelection = changeSelection;
            this.addToSelection = addToSelection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.home(QuaquaTreeUI.this.tree, QuaquaTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeIncrementAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreeIncrementAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.changeSelection = changeSelection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.increment(QuaquaTreeUI.this.tree, QuaquaTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreePageAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreePageAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.changeSelection = changeSelection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.page(QuaquaTreeUI.this.tree, QuaquaTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;
        private boolean changeSelection;

        public TreeTraverseAction(int direction, String name) {
            this(direction, name, true);
        }

        private TreeTraverseAction(int direction, String name, boolean changeSelection) {
            this.direction = direction;
            this.changeSelection = changeSelection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QuaquaTreeUI.this.tree != null) {
                SHARED_ACTION.traverse(QuaquaTreeUI.this.tree, QuaquaTreeUI.this, this.direction, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled();
        }
    }

    private static class Actions
    extends QuaquaUIAction {
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PREVIOUS_CHANGE_LEAD = "selectPreviousChangeLead";
        private static final String SELECT_PREVIOUS_EXTEND_SELECTION = "selectPreviousExtendSelection";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_NEXT_CHANGE_LEAD = "selectNextChangeLead";
        private static final String SELECT_NEXT_EXTEND_SELECTION = "selectNextExtendSelection";
        private static final String SELECT_CHILD = "selectChild";
        private static final String SELECT_CHILD_CHANGE_LEAD = "selectChildChangeLead";
        private static final String SELECT_PARENT = "selectParent";
        private static final String SELECT_PARENT_CHANGE_LEAD = "selectParentChangeLead";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_FIRST = "selectFirst";
        private static final String SELECT_FIRST_CHANGE_LEAD = "selectFirstChangeLead";
        private static final String SELECT_FIRST_EXTEND_SELECTION = "selectFirstExtendSelection";
        private static final String SELECT_LAST = "selectLast";
        private static final String SELECT_LAST_CHANGE_LEAD = "selectLastChangeLead";
        private static final String SELECT_LAST_EXTEND_SELECTION = "selectLastExtendSelection";
        private static final String TOGGLE = "toggle";
        private static final String CANCEL_EDITING = "cancel";
        private static final String START_EDITING = "startEditing";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_LEAD = "scrollRightChangeLead";
        private static final String SCROLL_LEFT_CHANGE_LEAD = "scrollLeftChangeLead";
        private static final String EXPAND = "expand";
        private static final String COLLAPSE = "collapse";
        private static final String MOVE_SELECTION_TO_PARENT = "moveSelectionToParent";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions() {
            super(null);
        }

        Actions(String key) {
            super(key);
        }

        @Override
        public boolean isEnabled(Object o) {
            if (o instanceof JTree && this.getName() != null && this.getName().equals(CANCEL_EDITING)) {
                return ((JTree)o).isEditing();
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTree tree = (JTree)e.getSource();
            QuaquaTreeUI ui = (QuaquaTreeUI)QuaquaUtilities.getUIOfType(tree.getUI(), QuaquaTreeUI.class);
            if (ui == null) {
                return;
            }
            String key = this.getName();
            if (key != null && key.equals(SELECT_PREVIOUS)) {
                this.increment(tree, ui, -1, false, true);
            } else if (key != null && key.equals(SELECT_PREVIOUS_CHANGE_LEAD)) {
                this.increment(tree, ui, -1, false, false);
            } else if (key != null && key.equals(SELECT_PREVIOUS_EXTEND_SELECTION)) {
                this.increment(tree, ui, -1, true, true);
            } else if (key != null && key.equals(SELECT_NEXT)) {
                this.increment(tree, ui, 1, false, true);
            } else if (key != null && key.equals(SELECT_NEXT_CHANGE_LEAD)) {
                this.increment(tree, ui, 1, false, false);
            } else if (key != null && key.equals(SELECT_NEXT_EXTEND_SELECTION)) {
                this.increment(tree, ui, 1, true, true);
            } else if (key != null && key.equals(SELECT_CHILD)) {
                this.traverse(tree, ui, 1, true);
            } else if (key != null && key.equals(SELECT_CHILD_CHANGE_LEAD)) {
                this.traverse(tree, ui, 1, false);
            } else if (key != null && key.equals(SELECT_PARENT)) {
                this.traverse(tree, ui, -1, true);
            } else if (key != null && key.equals(SELECT_PARENT_CHANGE_LEAD)) {
                this.traverse(tree, ui, -1, false);
            } else if (key != null && key.equals(SCROLL_UP_CHANGE_SELECTION)) {
                this.page(tree, ui, -1, false, true);
            } else if (key != null && key.equals(SCROLL_UP_CHANGE_LEAD)) {
                this.page(tree, ui, -1, false, false);
            } else if (key != null && key.equals(SCROLL_UP_EXTEND_SELECTION)) {
                this.page(tree, ui, -1, true, true);
            } else if (key != null && key.equals(SCROLL_DOWN_CHANGE_SELECTION)) {
                this.page(tree, ui, 1, false, true);
            } else if (key != null && key.equals(SCROLL_DOWN_EXTEND_SELECTION)) {
                this.page(tree, ui, 1, true, true);
            } else if (key != null && key.equals(SCROLL_DOWN_CHANGE_LEAD)) {
                this.page(tree, ui, 1, false, false);
            } else if (key != null && key.equals(SELECT_FIRST)) {
                this.home(tree, ui, -1, false, true);
            } else if (key != null && key.equals(SELECT_FIRST_CHANGE_LEAD)) {
                this.home(tree, ui, -1, false, false);
            } else if (key != null && key.equals(SELECT_FIRST_EXTEND_SELECTION)) {
                this.home(tree, ui, -1, true, true);
            } else if (key != null && key.equals(SELECT_LAST)) {
                this.home(tree, ui, 1, false, true);
            } else if (key != null && key.equals(SELECT_LAST_CHANGE_LEAD)) {
                this.home(tree, ui, 1, false, false);
            } else if (key != null && key.equals(SELECT_LAST_EXTEND_SELECTION)) {
                this.home(tree, ui, 1, true, true);
            } else if (key != null && key.equals(TOGGLE)) {
                this.toggle(tree, ui);
            } else if (key != null && key.equals(CANCEL_EDITING)) {
                this.cancelEditing(tree, ui);
            } else if (key != null && key.equals(START_EDITING)) {
                this.startEditing(tree, ui);
            } else if (key != null && key.equals(SELECT_ALL)) {
                this.selectAll(tree, ui, true);
            } else if (key != null && key.equals(CLEAR_SELECTION)) {
                this.selectAll(tree, ui, false);
            } else if (key != null && key.equals(ADD_TO_SELECTION)) {
                int lead;
                if (ui.getRowCount(tree) > 0 && !tree.isRowSelected(lead = ui.getLeadSelectionRow())) {
                    TreePath aPath = ui.getAnchorSelectionPath();
                    tree.addSelectionRow(lead);
                    ui.setAnchorSelectionPath(aPath);
                }
            } else if (key != null && key.equals(TOGGLE_AND_ANCHOR)) {
                if (ui.getRowCount(tree) > 0) {
                    int lead = ui.getLeadSelectionRow();
                    TreePath lPath = ui.getLeadSelectionPath();
                    if (!tree.isRowSelected(lead)) {
                        tree.addSelectionRow(lead);
                    } else {
                        tree.removeSelectionRow(lead);
                        ui.setLeadSelectionPath(lPath);
                    }
                    ui.setAnchorSelectionPath(lPath);
                }
            } else if (key != null && key.equals(EXTEND_TO)) {
                this.extendSelection(tree, ui);
            } else if (key != null && key.equals(MOVE_SELECTION_TO)) {
                if (ui.getRowCount(tree) > 0) {
                    int lead = ui.getLeadSelectionRow();
                    tree.setSelectionInterval(lead, lead);
                }
            } else if (key != null && key.equals(SCROLL_LEFT)) {
                this.scroll(tree, ui, 0, -10);
            } else if (key != null && key.equals(SCROLL_RIGHT)) {
                this.scroll(tree, ui, 0, 10);
            } else if (key != null && key.equals(SCROLL_LEFT_EXTEND_SELECTION)) {
                this.scrollChangeSelection(tree, ui, -1, true, true);
            } else if (key != null && key.equals(SCROLL_RIGHT_EXTEND_SELECTION)) {
                this.scrollChangeSelection(tree, ui, 1, true, true);
            } else if (key != null && key.equals(SCROLL_RIGHT_CHANGE_LEAD)) {
                this.scrollChangeSelection(tree, ui, 1, false, false);
            } else if (key != null && key.equals(SCROLL_LEFT_CHANGE_LEAD)) {
                this.scrollChangeSelection(tree, ui, -1, false, false);
            } else if (key != null && key.equals(EXPAND)) {
                this.expand(tree, ui);
            } else if (key != null && key.equals(COLLAPSE)) {
                this.collapse(tree, ui);
            } else if (key != null && key.equals(MOVE_SELECTION_TO_PARENT)) {
                this.moveSelectionToParent(tree, ui);
            }
        }

        private void scrollChangeSelection(JTree tree, QuaquaTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            if (ui.getRowCount(tree) > 0 && ui.treeSelectionModel != null) {
                TreePath newPath;
                Rectangle visRect = tree.getVisibleRect();
                if (direction == -1) {
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y);
                    visRect.x = Math.max(0, visRect.x - visRect.width);
                } else {
                    visRect.x = Math.min(Math.max(0, tree.getWidth() - visRect.width), visRect.x + visRect.width);
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y + visRect.height);
                }
                tree.scrollRectToVisible(visRect);
                if (addToSelection) {
                    ui.extendSelection(newPath);
                } else if (changeSelection) {
                    tree.setSelectionPath(newPath);
                } else {
                    ui.setLeadSelectionPath(newPath, true);
                }
            }
        }

        private void scroll(JTree component, QuaquaTreeUI ui, int direction, int amount) {
            Rectangle visRect = component.getVisibleRect();
            Dimension size = component.getSize();
            if (direction == 0) {
                visRect.x += amount;
                visRect.x = Math.max(0, visRect.x);
                visRect.x = Math.min(Math.max(0, size.width - visRect.width), visRect.x);
            } else {
                visRect.y += amount;
                visRect.y = Math.max(0, visRect.y);
                visRect.y = Math.min(Math.max(0, size.width - visRect.height), visRect.y);
            }
            component.scrollRectToVisible(visRect);
        }

        private void extendSelection(JTree tree, QuaquaTreeUI ui) {
            int lead;
            if (ui.getRowCount(tree) > 0 && (lead = ui.getLeadSelectionRow()) != -1) {
                TreePath leadP = ui.getLeadSelectionPath();
                TreePath aPath = ui.getAnchorSelectionPath();
                int aRow = ui.getRowForPath(tree, aPath);
                if (aRow == -1) {
                    aRow = 0;
                }
                tree.setSelectionInterval(aRow, lead);
                ui.setLeadSelectionPath(leadP);
                ui.setAnchorSelectionPath(aPath);
            }
        }

        private void selectAll(JTree tree, QuaquaTreeUI ui, boolean selectAll) {
            int rowCount = ui.getRowCount(tree);
            if (rowCount > 0) {
                if (selectAll) {
                    if (tree.getSelectionModel().getSelectionMode() == 1) {
                        int lead = ui.getLeadSelectionRow();
                        if (lead != -1) {
                            tree.setSelectionRow(lead);
                        } else if (tree.getMinSelectionRow() == -1) {
                            tree.setSelectionRow(0);
                            ui.ensureRowsAreVisible(0, 0);
                        }
                        return;
                    }
                    TreePath lastPath = ui.getLeadSelectionPath();
                    TreePath aPath = ui.getAnchorSelectionPath();
                    if (lastPath != null && !tree.isVisible(lastPath)) {
                        lastPath = null;
                    }
                    tree.setSelectionInterval(0, rowCount - 1);
                    if (lastPath != null) {
                        ui.setLeadSelectionPath(lastPath);
                    }
                    if (aPath != null && tree.isVisible(aPath)) {
                        ui.setAnchorSelectionPath(aPath);
                    }
                } else {
                    TreePath lastPath = ui.getLeadSelectionPath();
                    TreePath aPath = ui.getAnchorSelectionPath();
                    tree.clearSelection();
                    ui.setAnchorSelectionPath(aPath);
                    ui.setLeadSelectionPath(lastPath);
                }
            }
        }

        private void startEditing(JTree tree, QuaquaTreeUI ui) {
            int editRow;
            new Throwable().printStackTrace();
            TreePath lead = ui.getLeadSelectionPath();
            int n = editRow = lead != null ? ui.getRowForPath(tree, lead) : -1;
            if (editRow != -1) {
                tree.startEditingAtPath(lead);
            }
        }

        private void cancelEditing(JTree tree, QuaquaTreeUI ui) {
            tree.cancelEditing();
        }

        private void toggle(JTree tree, QuaquaTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            if (selRow != -1 && !ui.isLeaf(selRow)) {
                TreePath aPath = ui.getAnchorSelectionPath();
                TreePath lPath = ui.getLeadSelectionPath();
                ui.toggleExpandState(ui.getPathForRow(tree, selRow));
                ui.setAnchorSelectionPath(aPath);
                ui.setLeadSelectionPath(lPath);
            }
        }

        private void expand(JTree tree, QuaquaTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            tree.expandRow(selRow);
        }

        private void collapse(JTree tree, QuaquaTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            tree.collapseRow(selRow);
        }

        private void increment(JTree tree, QuaquaTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if (ui.treeSelectionModel != null && (rowCount = tree.getRowCount()) > 0) {
                int selIndex = ui.getLeadSelectionRow();
                int newIndex = selIndex == -1 ? (direction == 1 ? 0 : rowCount - 1) : Math.min(rowCount - 1, Math.max(0, selIndex + direction));
                if (addToSelection && ui.treeSelectionModel.getSelectionMode() != 1) {
                    ui.extendSelection(tree.getPathForRow(newIndex));
                } else if (changeSelection) {
                    tree.setSelectionInterval(newIndex, newIndex);
                } else {
                    ui.setLeadSelectionPath(tree.getPathForRow(newIndex), true);
                }
                ui.ensureRowsAreVisible(newIndex, newIndex);
                ui.lastSelectedRow = newIndex;
            }
        }

        private void traverse(JTree tree, QuaquaTreeUI ui, int direction, boolean changeSelection) {
            int rowCount;
            if (!changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = tree.getRowCount()) > 0) {
                int newIndex;
                int minSelIndex = ui.getLeadSelectionRow();
                if (minSelIndex == -1) {
                    newIndex = 0;
                } else if (direction == 1) {
                    if (!ui.isLeaf(minSelIndex) && !tree.isExpanded(minSelIndex)) {
                        ui.toggleExpandState(ui.getPathForRow(tree, minSelIndex));
                        newIndex = -1;
                    } else {
                        newIndex = Math.min(minSelIndex + 1, rowCount - 1);
                    }
                } else if (!ui.isLeaf(minSelIndex) && tree.isExpanded(minSelIndex)) {
                    ui.toggleExpandState(ui.getPathForRow(tree, minSelIndex));
                    newIndex = -1;
                } else {
                    TreePath path = ui.getPathForRow(tree, minSelIndex);
                    newIndex = path != null && path.getPathCount() > 1 ? ui.getRowForPath(tree, path.getParentPath()) : -1;
                }
                if (newIndex != -1) {
                    if (changeSelection) {
                        tree.setSelectionInterval(newIndex, newIndex);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, newIndex), true);
                    }
                    ui.ensureRowsAreVisible(newIndex, newIndex);
                }
            }
        }

        private void moveSelectionToParent(JTree tree, QuaquaTreeUI ui) {
            int newIndex;
            int selRow = ui.getLeadSelectionRow();
            TreePath path = ui.getPathForRow(tree, selRow);
            if (path != null && path.getPathCount() > 1 && (newIndex = ui.getRowForPath(tree, path.getParentPath())) != -1) {
                tree.setSelectionInterval(newIndex, newIndex);
                ui.ensureRowsAreVisible(newIndex, newIndex);
            }
        }

        private void page(JTree tree, QuaquaTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if (ui.getRowCount(tree) > 0 && ui.treeSelectionModel != null) {
                TreePath newPath;
                Dimension maxSize = tree.getSize();
                TreePath lead = ui.getLeadSelectionPath();
                Rectangle visRect = tree.getVisibleRect();
                if (direction == -1) {
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.max(0, visRect.y - visRect.height);
                        newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                } else {
                    visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                    newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                        newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                }
                Rectangle newRect = ui.getPathBounds(tree, newPath);
                newRect.x = visRect.x;
                newRect.width = visRect.width;
                if (direction == -1) {
                    newRect.height = visRect.height;
                } else {
                    newRect.y -= visRect.height - newRect.height;
                    newRect.height = visRect.height;
                }
                if (addToSelection) {
                    ui.extendSelection(newPath);
                } else if (changeSelection) {
                    tree.setSelectionPath(newPath);
                } else {
                    ui.setLeadSelectionPath(newPath, true);
                }
                tree.scrollRectToVisible(newRect);
            }
        }

        private void home(JTree tree, QuaquaTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = ui.getRowCount(tree)) > 0) {
                if (direction == -1) {
                    ui.ensureRowsAreVisible(0, 0);
                    if (addToSelection) {
                        int aRow;
                        TreePath aPath = ui.getAnchorSelectionPath();
                        int n = aRow = aPath == null ? -1 : ui.getRowForPath(tree, aPath);
                        if (aRow == -1) {
                            tree.setSelectionInterval(0, 0);
                        } else {
                            tree.setSelectionInterval(0, aRow);
                            ui.setAnchorSelectionPath(aPath);
                            ui.setLeadSelectionPath(ui.getPathForRow(tree, 0));
                        }
                    } else if (changeSelection) {
                        tree.setSelectionInterval(0, 0);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, 0), true);
                    }
                } else {
                    ui.ensureRowsAreVisible(rowCount - 1, rowCount - 1);
                    if (addToSelection) {
                        int aRow;
                        TreePath aPath = ui.getAnchorSelectionPath();
                        int n = aRow = aPath == null ? -1 : ui.getRowForPath(tree, aPath);
                        if (aRow == -1) {
                            tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                        } else {
                            tree.setSelectionInterval(aRow, rowCount - 1);
                            ui.setAnchorSelectionPath(aPath);
                            ui.setLeadSelectionPath(ui.getPathForRow(tree, rowCount - 1));
                        }
                    } else if (changeSelection) {
                        tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, rowCount - 1), true);
                    }
                }
            }
        }
    }

    static class TreeDropTargetListener
    extends QuaquaDropTargetListener {
        private int[] selectedIndices;

        TreeDropTargetListener() {
        }

        @Override
        protected void saveComponentState(JComponent comp) {
            JTree tree = (JTree)comp;
            this.selectedIndices = tree.getSelectionRows();
        }

        @Override
        protected void restoreComponentState(JComponent comp) {
            JTree tree = (JTree)comp;
            tree.setSelectionRows(this.selectedIndices);
        }

        @Override
        protected void updateInsertionLocation(JComponent comp, Point p) {
            JTree tree = (JTree)comp;
            BasicTreeUI ui = (BasicTreeUI)tree.getUI();
            TreePath path = ui.getClosestPathForLocation(tree, p.x, p.y);
            if (path != null) {
                tree.setSelectionPath(path);
            }
        }
    }

    protected class Handler
    implements CellEditorListener,
    FocusListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeModelListener,
    TreeSelectionListener,
    QuaquaDragRecognitionSupport.BeforeDrag {
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private boolean mouseReleaseDeselects;
        private boolean mouseDragSelects;

        protected Handler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.getRowCount() > 0 && QuaquaTreeUI.this.tree.hasFocus() && QuaquaTreeUI.this.tree.isEnabled()) {
                TreePath path;
                if (e.isAltDown() || e.isControlDown() || e.isMetaDown() || this.isNavigationKey(e)) {
                    return;
                }
                boolean startingFromSelection = true;
                char c = e.getKeyChar();
                long time = e.getWhen();
                int startingRow = QuaquaTreeUI.this.getLeadSelectionRow();
                if (time - this.lastTime < QuaquaTreeUI.this.timeFactor) {
                    this.typedString = this.typedString + c;
                    if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                        ++startingRow;
                    } else {
                        this.prefix = this.typedString;
                    }
                } else {
                    ++startingRow;
                    this.prefix = this.typedString = "" + c;
                }
                this.lastTime = time;
                if (startingRow < 0 || startingRow >= QuaquaTreeUI.this.tree.getRowCount()) {
                    startingFromSelection = false;
                    startingRow = 0;
                }
                if ((path = QuaquaTreeUI.this.tree.getNextMatch(this.prefix, startingRow, Position.Bias.Forward)) != null) {
                    QuaquaTreeUI.this.tree.setSelectionPath(path);
                    int row = QuaquaTreeUI.this.getRowForPath(QuaquaTreeUI.this.tree, path);
                    QuaquaTreeUI.this.ensureRowsAreVisible(row, row);
                } else if (startingFromSelection && (path = QuaquaTreeUI.this.tree.getNextMatch(this.prefix, 0, Position.Bias.Forward)) != null) {
                    QuaquaTreeUI.this.tree.setSelectionPath(path);
                    int row = QuaquaTreeUI.this.getRowForPath(QuaquaTreeUI.this.tree, path);
                    QuaquaTreeUI.this.ensureRowsAreVisible(row, row);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.isNavigationKey(e)) {
                this.prefix = "";
                this.typedString = "";
                this.lastTime = 0L;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        protected boolean isNavigationKey(KeyEvent event) {
            InputMap inputMap = QuaquaTreeUI.this.tree.getInputMap(1);
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(event);
            return inputMap != null && inputMap.get(key) != null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if (event.getSource() == QuaquaTreeUI.this.treeSelectionModel) {
                QuaquaTreeUI.this.treeSelectionModel.resetRowSelection();
            } else if (event.getSource() == QuaquaTreeUI.this.tree) {
                if (name != null && name.equals("Frame.active")) {
                    if (QuaquaTreeUI.this.tree.getClientProperty("Quaqua.Tree.style") != null && (QuaquaTreeUI.this.tree.getClientProperty("Quaqua.Tree.style").equals("sideBar") || QuaquaTreeUI.this.tree.getClientProperty("Quaqua.Tree.style").equals("sourceList"))) {
                        QuaquaTreeUI.this.tree.repaint();
                    }
                } else if (name != null && name.equals("leadSelectionPath")) {
                    if (!QuaquaTreeUI.this.ignoreLAChange) {
                        QuaquaTreeUI.this.updateLeadRow();
                        QuaquaTreeUI.this.repaintPath((TreePath)event.getOldValue());
                        QuaquaTreeUI.this.repaintPath((TreePath)event.getNewValue());
                    }
                } else if (name != null && name.equals("anchorSelectionPath") && !QuaquaTreeUI.this.ignoreLAChange) {
                    QuaquaTreeUI.this.repaintPath((TreePath)event.getOldValue());
                    QuaquaTreeUI.this.repaintPath((TreePath)event.getNewValue());
                }
                if (name != null && name.equals("cellRenderer")) {
                    QuaquaTreeUI.this.setCellRenderer((TreeCellRenderer)event.getNewValue());
                    QuaquaTreeUI.this.redoTheLayout();
                } else if (name != null && name.equals("model")) {
                    QuaquaTreeUI.this.setModel((TreeModel)event.getNewValue());
                } else if (name != null && name.equals("rootVisible")) {
                    QuaquaTreeUI.this.setRootVisible((Boolean)event.getNewValue());
                } else if (name != null && name.equals("showsRootHandles")) {
                    QuaquaTreeUI.this.setShowsRootHandles((Boolean)event.getNewValue());
                } else if (name != null && name.equals("rowHeight")) {
                    QuaquaTreeUI.this.setRowHeight((Integer)event.getNewValue());
                } else if (name != null && name.equals("cellEditor")) {
                    QuaquaTreeUI.this.setCellEditor((TreeCellEditor)event.getNewValue());
                } else if (name != null && name.equals("editable")) {
                    QuaquaTreeUI.this.setEditable((Boolean)event.getNewValue());
                } else if (name != null && name.equals("largeModel")) {
                    QuaquaTreeUI.this.setLargeModel(QuaquaTreeUI.this.tree.isLargeModel());
                } else if (name != null && name.equals("selectionModel")) {
                    QuaquaTreeUI.this.setSelectionModel(QuaquaTreeUI.this.tree.getSelectionModel());
                } else if (name != null && name.equals("font")) {
                    QuaquaTreeUI.this.completeEditing();
                    if (QuaquaTreeUI.this.treeState != null) {
                        QuaquaTreeUI.this.treeState.invalidateSizes();
                    }
                    QuaquaTreeUI.this.updateSize();
                } else if (name != null && name.equals("componentOrientation")) {
                    if (QuaquaTreeUI.this.tree != null) {
                        QuaquaTreeUI.this.redoTheLayout();
                        QuaquaTreeUI.this.tree.treeDidChange();
                        InputMap km = QuaquaTreeUI.this.getInputMap(0);
                        SwingUtilities.replaceUIInputMap(QuaquaTreeUI.this.tree, 0, km);
                    }
                } else if (name != null && name.equals("transferHandler")) {
                    DropTarget dropTarget = QuaquaTreeUI.this.tree.getDropTarget();
                    if (dropTarget instanceof UIResource) {
                        if (defaultDropTargetListener == null) {
                            defaultDropTargetListener = new TreeDropTargetListener();
                        }
                        try {
                            dropTarget.addDropTargetListener(defaultDropTargetListener);
                        }
                        catch (TooManyListenersException tooManyListenersException) {}
                    }
                } else if (name != null && name.equals("JComponent.sizeVariant")) {
                    QuaquaUtilities.applySizeVariant(QuaquaTreeUI.this.tree);
                } else if (name != null && name.equals("Quaqua.Tree.style")) {
                    QuaquaUtilities.applySizeVariant(QuaquaTreeUI.this.tree);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            QuaquaTreeUI.this.isMouseReleaseStartsEditing = false;
        }

        @Override
        public void dragStarting(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (QuaquaTreeUI.this.tree.isEnabled()) {
                boolean isRowAtIndexSelected;
                TreePath path;
                if (QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree) && QuaquaTreeUI.this.tree.getInvokesStopCellEditing() && !QuaquaTreeUI.this.stopEditing(QuaquaTreeUI.this.tree)) {
                    return;
                }
                QuaquaTreeUI.this.completeEditing();
                if (QuaquaTreeUI.this.tree.isRequestFocusEnabled()) {
                    QuaquaTreeUI.this.tree.requestFocusInWindow();
                }
                if (QuaquaTreeUI.this.isLocationInExpandControl(path = QuaquaTreeUI.this.getMouseClickedClosestPathForLocation(QuaquaTreeUI.this.tree, e.getX(), e.getY()), e.getX(), e.getY())) {
                    QuaquaTreeUI.this.checkForClickInExpandControl(path, e.getX(), e.getY());
                    return;
                }
                int index = QuaquaTreeUI.this.tree.getRowForPath(path);
                this.mouseDragSelects = false;
                this.mouseReleaseDeselects = false;
                QuaquaTreeUI.this.isMouseReleaseStartsEditing = true;
                QuaquaTreeUI.this.isDragRecognitionOngoing = false;
                if (!(index == -1 || (isRowAtIndexSelected = QuaquaTreeUI.this.tree.isRowSelected(index)) && e.isPopupTrigger())) {
                    int anchorIndex = QuaquaTreeUI.this.tree.getRowForPath(QuaquaTreeUI.this.tree.getAnchorSelectionPath());
                    if ((e.getModifiersEx() & 0x1900) == 256) {
                        if (isRowAtIndexSelected) {
                            QuaquaTreeUI.this.tree.removeSelectionInterval(index, index);
                        } else {
                            QuaquaTreeUI.this.tree.addSelectionInterval(index, index);
                            this.mouseDragSelects = true;
                            QuaquaTreeUI.this.isMouseReleaseStartsEditing = false;
                        }
                    } else if ((e.getModifiersEx() & 0x1840) == 64 && anchorIndex != -1) {
                        QuaquaTreeUI.this.tree.setSelectionInterval(anchorIndex, index);
                        QuaquaTreeUI.this.setLeadSelectionPath(path);
                        this.mouseDragSelects = true;
                        QuaquaTreeUI.this.isMouseReleaseStartsEditing = false;
                    } else if ((e.getModifiersEx() & 0x140) == 0) {
                        if (isRowAtIndexSelected) {
                            if (QuaquaTreeUI.this.tree.getDragEnabled()) {
                                QuaquaTreeUI.this.isDragRecognitionOngoing = QuaquaDragRecognitionSupport.mousePressed(e);
                                this.mouseReleaseDeselects = false;
                                this.mouseDragSelects = false;
                            } else {
                                this.mouseReleaseDeselects = QuaquaTreeUI.this.tree.isFocusOwner();
                            }
                        } else {
                            QuaquaTreeUI.this.tree.setSelectionInterval(index, index);
                            if (QuaquaTreeUI.this.tree.getDragEnabled() && QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, path).contains(e.getPoint())) {
                                QuaquaTreeUI.this.isDragRecognitionOngoing = QuaquaDragRecognitionSupport.mousePressed(e);
                                this.mouseReleaseDeselects = false;
                                this.mouseDragSelects = false;
                                QuaquaTreeUI.this.isMouseReleaseStartsEditing = false;
                            } else {
                                this.mouseDragSelects = true;
                                QuaquaTreeUI.this.isMouseReleaseStartsEditing = false;
                            }
                        }
                        QuaquaTreeUI.this.setAnchorSelectionPath(path);
                        QuaquaTreeUI.this.setLeadSelectionPath(path);
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (QuaquaTreeUI.this.tree.isEnabled()) {
                int index;
                if (QuaquaTreeUI.this.tree.getDragEnabled() && QuaquaTreeUI.this.isDragRecognitionOngoing) {
                    QuaquaDragRecognitionSupport.mouseDragged(e, this);
                }
                if (QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree) && QuaquaTreeUI.this.tree.getInvokesStopCellEditing() && !QuaquaTreeUI.this.stopEditing(QuaquaTreeUI.this.tree)) {
                    return;
                }
                TreePath leadPath = QuaquaTreeUI.this.getClosestPathForLocation(QuaquaTreeUI.this.tree, e.getX(), e.getY());
                if (QuaquaTreeUI.this.tree.getCellEditor() != null) {
                    QuaquaTreeUI.this.tree.getCellEditor().isCellEditable(new EventObject(this));
                }
                this.mouseReleaseDeselects = false;
                QuaquaTreeUI.this.isMouseReleaseStartsEditing = false;
                if (this.mouseDragSelects && (index = QuaquaTreeUI.this.tree.getRowForPath(leadPath)) != -1) {
                    Rectangle cellBounds = QuaquaTreeUI.this.tree.getRowBounds(index);
                    QuaquaTreeUI.this.tree.scrollRectToVisible(cellBounds);
                    TreePath anchorPath = QuaquaTreeUI.this.tree.getAnchorSelectionPath();
                    int anchorIndex = QuaquaTreeUI.this.tree.getRowForPath(anchorPath);
                    if (QuaquaTreeUI.this.tree.getSelectionModel().getSelectionMode() == 1) {
                        QuaquaTreeUI.this.tree.setSelectionInterval(index, index);
                    } else {
                        if (anchorIndex < index) {
                            QuaquaTreeUI.this.tree.setSelectionInterval(anchorIndex, index);
                        } else {
                            QuaquaTreeUI.this.tree.setSelectionInterval(index, anchorIndex);
                        }
                        QuaquaTreeUI.this.setAnchorSelectionPath(anchorPath);
                        QuaquaTreeUI.this.setLeadSelectionPath(leadPath);
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            QuaquaTreeUI.this.isMouseReleaseStartsEditing = false;
            if (QuaquaTreeUI.this.tree.getCellEditor() != null) {
                QuaquaTreeUI.this.tree.getCellEditor().isCellEditable(new EventObject(this));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (QuaquaTreeUI.this.tree.isEnabled()) {
                if (QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree) && QuaquaTreeUI.this.tree.getInvokesStopCellEditing() && !QuaquaTreeUI.this.stopEditing(QuaquaTreeUI.this.tree)) {
                    return;
                }
                TreePath path = QuaquaTreeUI.this.getMouseClickedClosestPathForLocation(QuaquaTreeUI.this.tree, e.getX(), e.getY());
                if (QuaquaTreeUI.this.startEditingOnRelease(path, e, e)) {
                    return;
                }
                this.mouseDragSelects = false;
                if (this.mouseReleaseDeselects) {
                    int index = QuaquaTreeUI.this.tree.getRowForPath(path);
                    QuaquaTreeUI.this.tree.setSelectionInterval(index, index);
                }
            }
            if (QuaquaTreeUI.this.tree.isRequestFocusEnabled()) {
                QuaquaTreeUI.this.tree.requestFocus();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusChanged();
        }

        protected void focusChanged() {
            QuaquaTreeUI.this.repaintSelection();
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            QuaquaTreeUI.this.completeEditing(false, false, true);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            QuaquaTreeUI.this.completeEditing(false, false, false);
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath[] paths;
            QuaquaTreeUI.this.completeEditing();
            if (QuaquaTreeUI.this.tree.getExpandsSelectedPaths() && QuaquaTreeUI.this.treeSelectionModel != null && (paths = QuaquaTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                for (int counter = paths.length - 1; counter >= 0; --counter) {
                    TreePath path = paths[counter].getParentPath();
                    boolean expand = true;
                    while (path != null) {
                        if (QuaquaTreeUI.this.treeModel.isLeaf(path.getLastPathComponent())) {
                            expand = false;
                            path = null;
                            continue;
                        }
                        path = path.getParentPath();
                    }
                    if (!expand) continue;
                    QuaquaTreeUI.this.tree.makeVisible(paths[counter]);
                }
            }
            TreePath oldLead = QuaquaTreeUI.this.getLeadSelectionPath();
            QuaquaTreeUI.this.lastSelectedRow = QuaquaTreeUI.this.tree.getMinSelectionRow();
            TreePath lead = QuaquaTreeUI.this.tree.getSelectionModel().getLeadSelectionPath();
            QuaquaTreeUI.this.setAnchorSelectionPath(lead);
            QuaquaTreeUI.this.setLeadSelectionPath(lead);
            TreePath[] changedPaths = event.getPaths();
            Rectangle visRect = QuaquaTreeUI.this.tree.getVisibleRect();
            boolean paintPaths = true;
            int nWidth = QuaquaTreeUI.this.tree.getWidth();
            if (changedPaths != null) {
                int maxCounter = changedPaths.length;
                if (maxCounter > 4) {
                    QuaquaTreeUI.this.tree.repaint();
                    paintPaths = false;
                } else {
                    for (int counter = 0; counter < maxCounter; ++counter) {
                        Rectangle nodeBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, changedPaths[counter]);
                        if (nodeBounds == null || !visRect.intersects(nodeBounds)) continue;
                        QuaquaTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                    }
                }
            }
            if (paintPaths) {
                oldLead = event.getOldLeadSelectionPath();
                Rectangle nodeBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, oldLead);
                if (nodeBounds != null && visRect.intersects(nodeBounds)) {
                    QuaquaTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
                if ((nodeBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, lead)) != null && visRect.intersects(nodeBounds)) {
                    QuaquaTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (event != null && QuaquaTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                QuaquaTreeUI.this.updateExpandedDescendants(path);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (event != null && QuaquaTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                QuaquaTreeUI.this.completeEditing();
                if (path != null && QuaquaTreeUI.this.tree.isVisible(path)) {
                    QuaquaTreeUI.this.treeState.setExpandedState(path, false);
                    QuaquaTreeUI.this.updateLeadRow();
                    QuaquaTreeUI.this.updateSize();
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (QuaquaTreeUI.this.treeState != null && e != null) {
                TreePath parentPath = e.getTreePath();
                int[] indices = e.getChildIndices();
                if (indices == null || indices.length == 0) {
                    QuaquaTreeUI.this.treeState.treeNodesChanged(e);
                    QuaquaTreeUI.this.updateSize();
                } else if (QuaquaTreeUI.this.treeState.isExpanded(parentPath)) {
                    int minIndex = indices[0];
                    for (int i = indices.length - 1; i > 0; --i) {
                        minIndex = Math.min(indices[i], minIndex);
                    }
                    Object minChild = QuaquaTreeUI.this.treeModel.getChild(parentPath.getLastPathComponent(), minIndex);
                    TreePath minPath = parentPath.pathByAddingChild(minChild);
                    Rectangle minBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, minPath);
                    QuaquaTreeUI.this.treeState.treeNodesChanged(e);
                    QuaquaTreeUI.this.updateSize0();
                    Rectangle newMinBounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, minPath);
                    if (newMinBounds != null) {
                        if (indices.length == 1 && newMinBounds.height == minBounds.height) {
                            QuaquaTreeUI.this.tree.repaint(0, minBounds.y, QuaquaTreeUI.this.tree.getWidth(), minBounds.height);
                        } else {
                            QuaquaTreeUI.this.tree.repaint(0, minBounds.y, QuaquaTreeUI.this.tree.getWidth(), QuaquaTreeUI.this.tree.getHeight() - minBounds.y);
                        }
                    }
                } else {
                    QuaquaTreeUI.this.treeState.treeNodesChanged(e);
                }
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (QuaquaTreeUI.this.treeState != null && e != null) {
                QuaquaTreeUI.this.treeState.treeNodesInserted(e);
                QuaquaTreeUI.this.updateLeadRow();
                TreePath path = e.getTreePath();
                if (QuaquaTreeUI.this.treeState.isExpanded(path)) {
                    QuaquaTreeUI.this.updateSize();
                } else {
                    int[] indices = e.getChildIndices();
                    int childCount = QuaquaTreeUI.this.treeModel.getChildCount(path.getLastPathComponent());
                    if (indices != null && childCount - indices.length == 0) {
                        QuaquaTreeUI.this.updateSize();
                    }
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (QuaquaTreeUI.this.treeState != null && e != null) {
                QuaquaTreeUI.this.treeState.treeNodesRemoved(e);
                QuaquaTreeUI.this.updateLeadRow();
                TreePath path = e.getTreePath();
                if (QuaquaTreeUI.this.treeState.isExpanded(path) || QuaquaTreeUI.this.treeModel.getChildCount(path.getLastPathComponent()) == 0) {
                    QuaquaTreeUI.this.updateSize();
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (QuaquaTreeUI.this.treeState != null && e != null) {
                QuaquaTreeUI.this.treeState.treeStructureChanged(e);
                QuaquaTreeUI.this.updateLeadRow();
                TreePath pPath = e.getTreePath();
                if (pPath != null) {
                    pPath = pPath.getParentPath();
                }
                if (pPath == null || QuaquaTreeUI.this.treeState.isExpanded(pPath)) {
                    QuaquaTreeUI.this.updateSize();
                }
            }
        }
    }

    private static class QuaquaTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements UIResource {
        public QuaquaTreeCellRenderer() {
            this.setBorder(null);
        }
    }

    private static class QuaquaTreeCellEditor
    extends DefaultTreeCellEditor
    implements UIResource {
        public QuaquaTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        @Override
        protected Container createContainer() {
            return new DefaultTreeCellEditor.EditorContainer(){

                @Override
                public void paint(Graphics gr) {
                    Graphics2D g = (Graphics2D)gr;
                    g.setColor(UIManager.getColor("TextField.background"));
                    Component[] c = this.getComponents();
                    for (int i = 0; i < c.length; ++i) {
                        g.fill(c[i].getBounds());
                    }
                    super.paint(g);
                }
            };
        }
    }
}

