/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaFocusHandler;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Methods;
import ch.randelshofer.quaqua.util.ViewportPainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicViewportUI;

public class QuaquaViewportUI
extends BasicViewportUI {
    private ChangeListener changeListener;
    private ContainerListener containerListener;
    private FocusListener focusListener;
    private PropertyChangeListener propertyChangeListener;
    private JViewport viewport;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaViewportUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            Object ui;
            Component view = this.viewport.getView();
            Object object = ui = view == null ? null : Methods.invokeGetter((Object)view, "getUI", null);
            if (ui instanceof ViewportPainter) {
                ((ViewportPainter)ui).paintViewport(g, this.viewport);
            } else if (this.viewport.getView() != null) {
                g.setColor(this.viewport.getView().getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
        Debug.paint(g, c, this);
    }

    @Override
    public void installUI(JComponent c) {
        this.viewport = (JViewport)c;
        super.installUI(c);
        QuaquaUtilities.installProperty(c, "opaque", UIManager.get("Viewport.opaque"));
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.viewport = (JViewport)c;
        super.uninstallUI(c);
        this.uninstallListeners();
    }

    protected void installListeners() {
        this.changeListener = this.createChangeListener();
        this.viewport.addChangeListener(this.changeListener);
        this.containerListener = this.createContainerListener();
        this.viewport.addContainerListener(this.containerListener);
        this.focusListener = this.createFocusListener();
        this.viewport.addFocusListener(this.focusListener);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.viewport.addPropertyChangeListener(this.propertyChangeListener);
        if (this.viewport.getView() != null) {
            this.viewport.getView().addFocusListener(this.focusListener);
        }
    }

    protected void uninstallListeners() {
        this.viewport.removeChangeListener(this.changeListener);
        this.viewport.removeContainerListener(this.containerListener);
        this.viewport.removeFocusListener(this.focusListener);
        this.viewport.removePropertyChangeListener(this.propertyChangeListener);
        this.changeListener = null;
        this.containerListener = null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new QuaquaPropertyChangeHandler();
    }

    private ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    private ContainerListener createContainerListener() {
        return new ContainerHandler();
    }

    private FocusListener createFocusListener() {
        return QuaquaFocusHandler.getInstance();
    }

    public class QuaquaPropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (!"Frame.active".equals(name) && "JComponent.sizeVariant".equals(name)) {
                QuaquaUtilities.applySizeVariant(QuaquaViewportUI.this.viewport);
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            e.getChild().removeFocusListener(QuaquaViewportUI.this.focusListener);
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            e.getChild().addFocusListener(QuaquaViewportUI.this.focusListener);
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private Point previousLocation = new Point();

        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component view;
            Point newLocation;
            if (QuaquaViewportUI.this.viewport.getView() != null && !this.previousLocation.equals(newLocation = (view = QuaquaViewportUI.this.viewport.getView()).getLocation())) {
                if (view.getHeight() < QuaquaViewportUI.this.viewport.getHeight()) {
                    if (newLocation.x > this.previousLocation.x) {
                        QuaquaViewportUI.this.viewport.repaint(0, view.getHeight(), newLocation.x - this.previousLocation.x, QuaquaViewportUI.this.viewport.getHeight() - view.getHeight());
                    }
                    if (newLocation.x < this.previousLocation.x) {
                        QuaquaViewportUI.this.viewport.repaint(QuaquaViewportUI.this.viewport.getWidth() + newLocation.x - this.previousLocation.x, view.getHeight(), this.previousLocation.x - newLocation.x, QuaquaViewportUI.this.viewport.getHeight() - view.getHeight());
                    }
                }
                if (view.getWidth() < QuaquaViewportUI.this.viewport.getWidth()) {
                    if (newLocation.y > this.previousLocation.y) {
                        QuaquaViewportUI.this.viewport.repaint(view.getWidth(), 0, QuaquaViewportUI.this.viewport.getWidth() - view.getWidth(), Math.min(view.getHeight(), newLocation.y - this.previousLocation.y));
                    }
                    if (newLocation.y < this.previousLocation.y) {
                        QuaquaViewportUI.this.viewport.repaint(view.getWidth(), Math.min(view.getHeight(), QuaquaViewportUI.this.viewport.getHeight()) - this.previousLocation.y + newLocation.y, QuaquaViewportUI.this.viewport.getWidth() - view.getWidth(), this.previousLocation.y - newLocation.y);
                    }
                }
                this.previousLocation = newLocation;
            }
        }
    }
}

