/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.Border;

public class RoundRectangleBorder
implements Border {
    private Insets borderInsets;
    private double arcw;
    private double arch;
    private Color strokeColor;
    private Color fillColor;

    public RoundRectangleBorder(double arcw, double arch, Color fillColor, Color strokeColor, Insets borderInsets) {
        this.arcw = arcw;
        this.arch = arch;
        this.fillColor = fillColor;
        this.strokeColor = strokeColor;
        this.borderInsets = borderInsets;
    }

    @Override
    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)gr;
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(x, y, width, height, this.arcw, this.arch);
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            g.fill(rr);
        }
        if (this.strokeColor != null) {
            g.setColor(this.strokeColor);
            g.draw(rr);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.borderInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

