/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.color;

import ch.randelshofer.quaqua.color.PaintableColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import javax.swing.plaf.UIResource;

public class InactivatableColorUIResource
extends PaintableColor
implements UIResource {
    private boolean isActive;
    private Color active;
    private Color inactive;
    private boolean isTransparent;

    public InactivatableColorUIResource(int activeRGB, int inactiveRGB) {
        super(activeRGB);
        this.active = new Color(activeRGB);
        this.inactive = new Color(inactiveRGB);
    }

    public InactivatableColorUIResource(int activeRGB, int inactiveRGB, boolean hasAlpha) {
        super(activeRGB, hasAlpha);
        this.active = new Color(activeRGB, hasAlpha);
        this.inactive = new Color(inactiveRGB, hasAlpha);
    }

    public InactivatableColorUIResource(Color active, Color inactive) {
        super(active.getRGB(), true);
        this.active = active;
        this.inactive = inactive;
    }

    public void setActive(boolean newValue) {
        this.isActive = newValue;
    }

    public void setTransparent(boolean newValue) {
        this.isTransparent = newValue;
    }

    @Override
    public int getTransparency() {
        return this.isTransparent ? 3 : super.getTransparency();
    }

    @Override
    public int getAlpha() {
        return this.isTransparent ? 0 : super.getAlpha();
    }

    @Override
    public int getRGB() {
        return this.isTransparent ? 0 : (this.isActive ? this.active.getRGB() : this.inactive.getRGB());
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        return this.isActive ? this.active.createContext(cm, r, r2d, xform, hints) : this.inactive.createContext(cm, r, r2d, xform, hints);
    }

    @Override
    public Paint getPaint(Component c, int x, int y, int width, int height) {
        Color clr;
        Color color = clr = this.isActive ? this.active : this.inactive;
        if (clr instanceof PaintableColor) {
            return ((PaintableColor)clr).getPaint(c, x, y, width, height);
        }
        return clr;
    }
}

