/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.colorchooser;

import ch.randelshofer.quaqua.colorchooser.ColorSliderModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ColorSliderTextFieldHandler
implements DocumentListener,
ChangeListener {
    protected JTextField textField;
    protected ColorSliderModel ccModel;
    protected int component;

    public ColorSliderTextFieldHandler(JTextField textField, ColorSliderModel ccModel, int component) {
        this.textField = textField;
        this.ccModel = ccModel;
        this.component = component;
        textField.getDocument().addDocumentListener(this);
        ccModel.getBoundedRangeModel(component).addChangeListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.docChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.docChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.docChanged();
    }

    protected void docChanged() {
        if (this.textField.hasFocus()) {
            DefaultBoundedRangeModel brm = this.ccModel.getBoundedRangeModel(this.component);
            try {
                int value = Integer.decode(this.textField.getText());
                if (brm.getMinimum() <= value && value <= brm.getMaximum()) {
                    brm.setValue(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.textField.hasFocus()) {
            this.textField.setText(Integer.toString(this.ccModel.getBoundedRangeModel(this.component).getValue()));
        }
    }
}

