/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.filechooser.FileChooserView;
import ch.randelshofer.quaqua.filechooser.SubtreeTreeModel;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public abstract class ListView
extends JPanel
implements FileChooserView {
    protected SubtreeTreeModel model;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private FileChooserView.SelectListener selectListener;

    public static ListView create(int design, JFileChooser fc) {
        switch (design) {
            case 7: 
            case 8: {
                return new ch.randelshofer.quaqua.lion.filechooser.ListView(fc);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return new ch.randelshofer.quaqua.mavericks.filechooser.ListView(fc);
            }
        }
        return null;
    }

    @Override
    public void setModel(SubtreeTreeModel m) {
        if (m != this.model) {
            this.model = m;
            this.updateForNewModel();
        }
    }

    @Override
    public void addSelectionChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    @Override
    public void addSelectListener(FileChooserView.SelectListener l) {
        this.selectListener = l;
    }

    protected void selectionChanged() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    protected abstract void updateForNewModel();

    protected final void select(TreePath path) {
        if (this.selectListener != null) {
            this.selectListener.select(path);
        }
    }

    @Override
    public void ensureSelectionIsVisible() {
        List<TreePath> paths = this.getSelection();
        if (!paths.isEmpty()) {
            this.ensurePathIsVisible(paths.get(0));
        }
    }
}

