/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaListUI;
import ch.randelshofer.quaqua.filechooser.QuaquaFileChooserListMouseBehavior;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class QuaquaFileChooserBrowserListUI
extends QuaquaListUI {
    private JFileChooser fc;
    private QuaquaFileChooserListMouseBehavior.FileSelectionHandler fileSelectionHandler;
    private QuaquaFileChooserListMouseBehavior mouseBehavior;

    public QuaquaFileChooserBrowserListUI(JFileChooser fc) {
        this.fc = fc;
    }

    public void setFileSelectionHandler(QuaquaFileChooserListMouseBehavior.FileSelectionHandler h) {
        this.fileSelectionHandler = h;
        if (this.mouseBehavior != null) {
            this.mouseBehavior.setFileSelectionHandler(h);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        InputMap map = this.list.getInputMap(0).getParent();
        KeyStroke ks = KeyStroke.getKeyStroke("shift meta A");
        Object v = map.get(ks);
        if (v != null && v.equals("clearSelection")) {
            InputMap newMap = new InputMap();
            newMap.setParent(map);
            newMap.put(ks, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(this.list, 0, newMap);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        if (this.mouseBehavior == null) {
            this.mouseBehavior = new QuaquaFileChooserListMouseBehavior(this.fc, this.list);
            this.mouseBehavior.setFileSelectionHandler(this.fileSelectionHandler);
        }
        return this.mouseBehavior;
    }
}

