/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaTreeTableUI;
import ch.randelshofer.quaqua.TreeTableModel;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.FileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.QuaquaFileChooserListMouseBehavior;
import ch.randelshofer.quaqua.filechooser.SubtreeTreeModel;
import ch.randelshofer.quaqua.util.ViewportPainter;
import de.sciss.treetable.j.TreeTable;
import de.sciss.treetable.j.ui.BasicTreeTableUI;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public abstract class QuaquaFileChooserTreeTableUI
extends QuaquaTreeTableUI
implements ViewportPainter {
    protected QuaquaFileChooserListMouseBehavior mouseBehavior;

    public QuaquaFileChooserTreeTableUI(JFileChooser fc, final TreeTable tt) {
        this.mouseBehavior = new QuaquaFileChooserListMouseBehavior(fc, new TreeTableModel(tt));
        this.mouseBehavior.setFileSelectionHandler(new QuaquaFileChooserListMouseBehavior.FileSelectionHandler(){

            @Override
            public void fileSelected(File f) {
                SubtreeTreeModel model = (SubtreeTreeModel)tt.getTreeModel();
                FileSystemTreeModel fullModel = (FileSystemTreeModel)model.getTargetModel();
                TreePath path = fullModel.toPath(f, null);
                QuaquaFileChooserTreeTableUI.this.select(path);
            }
        });
    }

    @Override
    protected JTree createAndConfigureTree() {
        JTree tree = super.createAndConfigureTree();
        tree.putClientProperty("Quaqua.Tree.isCellFilled", true);
        return tree;
    }

    @Override
    protected JTable createAndConfigureTable() {
        JTable table = super.createAndConfigureTable();
        table.putClientProperty("Quaqua.Table.style", "striped");
        return table;
    }

    @Override
    public void paintViewport(Graphics g, JViewport c) {
        this.tableUI.paintViewport(g, c);
    }

    @Override
    protected BasicTreeTableUI.Handler createHandler() {
        return new MyHandler();
    }

    @Override
    protected void installListeners() {
        JTree tree;
        InputMap newMap;
        super.installListeners();
        JTable table = this.getTable();
        InputMap map = table.getInputMap(1).getParent();
        KeyStroke ks = KeyStroke.getKeyStroke("shift meta A");
        Object v = map.get(ks);
        if (v != null && v.equals("clearSelection")) {
            newMap = new InputMap();
            newMap.setParent(map);
            newMap.put(ks, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(table, 0, newMap);
        }
        if ((v = (map = (tree = this.getTree()).getInputMap(0).getParent()).get(ks = KeyStroke.getKeyStroke("shift meta A"))) != null && v.equals("clearSelection")) {
            newMap = new InputMap();
            newMap.setParent(map);
            newMap.put(ks, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(tree, 0, newMap);
        }
    }

    @Override
    protected void handleDoubleClick(TreePath path) {
        FileInfo info;
        Object node = path.getLastPathComponent();
        if (node instanceof FileInfo && ((info = (FileInfo)node).isAcceptable() || info.isTraversable())) {
            this.select(path);
        }
    }

    protected abstract void select(TreePath var1);

    protected class MyHandler
    extends QuaquaTreeTableUI.MyHandler {
        protected MyHandler() {
        }

        @Override
        protected void dispatchMouseEvent(MouseEvent e, JComponent c) {
            TreePath path;
            int id = e.getID();
            if (id == 500 && e.getClickCount() == 2 && (path = QuaquaFileChooserTreeTableUI.this.treeTable.getPathForLocation(e.getX(), e.getY())) != null) {
                QuaquaFileChooserTreeTableUI.this.handleDoubleClick(path);
                e.consume();
                return;
            }
            JTable table = QuaquaFileChooserTreeTableUI.this.getTable();
            if (c == table) {
                QuaquaFileChooserTreeTableUI.this.mouseBehavior.processMouseEvent(e);
                e.consume();
                return;
            }
            super.dispatchMouseEvent(e, c);
        }
    }
}

