/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.filechooser.FileSystemViewFilter;
import ch.randelshofer.quaqua.filechooser.QuaquaFileView;
import ch.randelshofer.quaqua.osx.OSXFile;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;

public abstract class QuaquaFileSystemView
extends FileSystemViewFilter {
    private static QuaquaFileSystemView fileSystemView;

    public File canonicalize(File f) {
        return f;
    }

    public abstract File getComputer();

    public abstract File getSystemVolume();

    public FileView createFileView(JFileChooser chooser) {
        return new QuaquaFileView(this);
    }

    public static QuaquaFileSystemView getQuaquaFileSystemView() {
        if (fileSystemView == null) {
            String className;
            int os = QuaquaManager.getOS();
            switch (os) {
                case 2: {
                    className = "ch.randelshofer.quaqua.jaguar.filechooser.OSXJaguarFileSystemView";
                    break;
                }
                case 3: {
                    className = "ch.randelshofer.quaqua.panther.filechooser.OSXPantherFileSystemView";
                    break;
                }
                case -3: {
                    className = "ch.randelshofer.quaqua.leopard.filechooser.DarwinLeopardFileSystemView";
                    break;
                }
                case 5: {
                    className = "ch.randelshofer.quaqua.leopard.filechooser.OSXLeopardFileSystemView";
                    break;
                }
                case 6: {
                    className = "ch.randelshofer.quaqua.snowleopard.filechooser.OSX16SnowLeopardFileSystemView";
                    break;
                }
                default: {
                    className = "ch.randelshofer.quaqua.lion.filechooser.OSXLionFileSystemView";
                    break;
                }
                case 4: {
                    className = "ch.randelshofer.quaqua.tiger.filechooser.OSXTigerFileSystemView";
                    break;
                }
                case -2: {
                    className = "ch.randelshofer.quaqua.filechooser.WindowsFileSystemView";
                    break;
                }
                case -4: {
                    className = "ch.randelshofer.quaqua.filechooser.LinuxFileSystemView";
                }
            }
            try {
                fileSystemView = (QuaquaFileSystemView)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalError(e.getMessage());
            }
        }
        return fileSystemView;
    }

    public static void setQuaquaFileSystemView(QuaquaFileSystemView newValue) {
        fileSystemView = newValue;
    }

    @Override
    public Icon getSystemIcon(File f) {
        if (f.equals(this.getComputer())) {
            return UIManager.getIcon("FileView.computerIcon");
        }
        if (OSXFile.canWorkWithAliases()) {
            return OSXFile.getIcon(f, 16);
        }
        return this.target.getSystemIcon(f);
    }

    @Override
    public String getSystemTypeDescription(File f) {
        if (OSXFile.canWorkWithAliases()) {
            return OSXFile.getKindString(f);
        }
        return this.target.getSystemTypeDescription(f);
    }

    @Override
    public Boolean isTraversable(File f) {
        if (OSXFile.canWorkWithAliases()) {
            return OSXFile.isTraversable(f);
        }
        return this.target.isTraversable(f);
    }

    @Override
    public String getSystemDisplayName(File f) {
        if (f.equals(this.getComputer())) {
            String name = OSXFile.getComputerName();
            return name != null ? name : this.getSystemVolume().getName();
        }
        if (OSXFile.canWorkWithAliases()) {
            return OSXFile.getDisplayName(f);
        }
        return this.target.getSystemDisplayName(f);
    }
}

