/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.jaguar;

import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.color.PaintableColor;
import ch.randelshofer.quaqua.color.TextureColor;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.InsetsUtil;
import ch.randelshofer.quaqua.util.NavigatableTabbedPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class QuaquaJaguarTabbedPaneUI
extends BasicTabbedPaneUI
implements VisuallyLayoutable,
NavigatableTabbedPaneUI {
    protected int minTabWidth = 40;
    protected Color tabAreaBackground;
    protected Color selectColor;
    protected Color selectHighlight;
    protected Color disabledForeground;
    private Insets currentContentBorderInsets = new Insets(0, 0, 0, 0);
    private int tabCount;
    private boolean isFrameActive;
    private static Border[] tabTopBorder;
    private static Border[] tabBottomBorder;
    private static Border[] tabRightBorder;
    private static Border[] tabLeftBorder;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private String propertyPrefix = "TabbedPane.";

    private Border getContentBorder() {
        return UIManager.getBorder("TabbedPane.wrap.contentBorder");
    }

    private static Border createImageBorder(String name, Insets insets) {
        return QuaquaBorderFactory.create(Images.createImage(QuaquaJaguarTabbedPaneUI.class.getResource(name)), insets);
    }

    private static Border createNonCachedImageBorder(String name, Insets insets) {
        return QuaquaBorderFactory.create(Images.createImage(QuaquaJaguarTabbedPaneUI.class.getResource(name)), insets, insets, true, null, false);
    }

    private Border getBarTopBorder(int i) {
        Border[] borders = (Border[])UIManager.get("TabbedPane.wrapBarTopBorders");
        return borders[i];
    }

    private Border getBarBottomBorder(int i) {
        Border[] borders = (Border[])UIManager.get("TabbedPane.wrapBarBottomBorders");
        return borders[i];
    }

    private Border getBarRightBorder(int i) {
        Border[] borders = (Border[])UIManager.get("TabbedPane.wrapBarRightBorders");
        return borders[i];
    }

    private Border getBarLeftBorder(int i) {
        Border[] borders = (Border[])UIManager.get("TabbedPane.wrapBarLeftBorders");
        return borders[i];
    }

    private Border getTabTopBorder(int i) {
        if (tabTopBorder == null) {
            Insets insets = new Insets(12, 8, 11, 8);
            tabTopBorder = new Border[]{QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabTop.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabTop.S.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabTop.I.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabTop.D.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabTop.DS.png", insets)};
        }
        return tabTopBorder[i];
    }

    private Border getTabBottomBorder(int i) {
        if (tabBottomBorder == null) {
            Insets insets = new Insets(11, 8, 12, 8);
            tabBottomBorder = new Border[]{QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabBottom.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabBottom.S.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabBottom.I.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabBottom.D.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabBottom.DS.png", insets)};
        }
        return tabBottomBorder[i];
    }

    private Border getTabRightBorder(int i) {
        if (tabRightBorder == null) {
            Insets insets = new Insets(11, 1, 11, 7);
            Insets insetsS = new Insets(11, 2, 11, 7);
            tabRightBorder = new Border[]{QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabRight.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabRight.S.png", insetsS), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabRight.I.png", insetsS), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabRight.D.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabRight.DS.png", insetsS)};
        }
        return tabRightBorder[i];
    }

    private Border getTabLeftBorder(int i) {
        if (tabLeftBorder == null) {
            Insets insets = new Insets(11, 7, 11, 1);
            Insets insetsS = new Insets(11, 7, 11, 2);
            tabLeftBorder = new Border[]{QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabLeft.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabLeft.S.png", insetsS), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabLeft.I.png", insetsS), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabLeft.D.png", insets), QuaquaJaguarTabbedPaneUI.createImageBorder("images/TabbedPane.tabLeft.DS.png", insetsS)};
        }
        return tabLeftBorder[i];
    }

    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String newValue) {
        this.propertyPrefix = newValue;
    }

    public static ComponentUI createUI(JComponent x) {
        return new QuaquaJaguarTabbedPaneUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new QuaquaPropertyChangeHandler();
    }

    @Override
    protected MouseListener createMouseListener() {
        return new QuaquaMouseHandler();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.tabPane, prefix + "background", prefix + "foreground", prefix + "font");
        this.tabPane.setBackground(UIManager.getColor(prefix + "background"));
        this.highlight = UIManager.getColor(prefix + "light");
        this.lightHighlight = UIManager.getColor(prefix + "highlight");
        this.shadow = UIManager.getColor(prefix + "shadow");
        this.darkShadow = UIManager.getColor(prefix + "darkShadow");
        this.focus = UIManager.getColor(prefix + "focus");
        this.textIconGap = UIManager.getInt(prefix + "textIconGap");
        this.tabInsets = UIManager.getInsets(prefix + "tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets(prefix + "selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets(prefix + "tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets(prefix + "contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt(prefix + "tabRunOverlay");
        this.tabAreaBackground = UIManager.getColor(prefix + "tabAreaBackground");
        this.selectColor = UIManager.getColor(prefix + "selected");
        this.selectHighlight = UIManager.getColor(prefix + "selectHighlight");
        this.disabledForeground = UIManager.getColor(prefix + "disabledForeground");
        LookAndFeel.installBorder(this.tabPane, prefix + "border");
        this.tabPane.setOpaque(UIManager.getBoolean(prefix + "opaque"));
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int bottom = y + (h - 1);
        int right = x + (w - 1);
        switch (tabPlacement) {
            case 2: {
                this.paintTabBorderLeft(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            case 3: {
                this.paintTabBorderBottom(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            case 4: {
                this.paintTabBorderRight(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            default: {
                this.paintTabBorderTop(tabIndex, g, x, y, w, h, bottom, right, isSelected);
            }
        }
    }

    protected void paintTabBorderTop(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 1 : 2) : 4;
            this.getTabTopBorder(border).paintBorder(this.tabPane, g, x - 1, y - 1, w + 3, h + 2);
        } else {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 0) : 3;
            this.getTabTopBorder(border).paintBorder(this.tabPane, g, x - 1, y - 1, w + 3, h + 1);
        }
    }

    protected boolean shouldFillGap(int currentRun, int tabIndex, int x, int y) {
        boolean result = false;
        if (currentRun == this.runCount - 2) {
            int currentTabRight;
            int lastTabLeft;
            int lastTabRight;
            Rectangle lastTabBounds = this.getTabBounds(this.tabPane, this.tabPane.getTabCount() - 1);
            Rectangle tabBounds = this.getTabBounds(this.tabPane, tabIndex);
            if (QuaquaUtilities.isLeftToRight(this.tabPane) ? (lastTabRight = lastTabBounds.x + lastTabBounds.width - 1) > tabBounds.x + 2 : (lastTabLeft = lastTabBounds.x) < (currentTabRight = tabBounds.x + tabBounds.width - 1) - 2) {
                return true;
            }
        } else {
            result = currentRun != this.runCount - 1;
        }
        return result;
    }

    protected Color getColorForGap(int currentRun, int x, int y) {
        int shadowWidth = 4;
        int selectedIndex = this.tabPane.getSelectedIndex();
        int startIndex = this.tabRuns[currentRun + 1];
        int endIndex = this.lastTabInRun(this.tabPane.getTabCount(), currentRun + 1);
        int tabOverGap = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            Rectangle tabBounds = this.getTabBounds(this.tabPane, i);
            int tabLeft = tabBounds.x;
            int tabRight = tabBounds.x + tabBounds.width - 1;
            if (!(QuaquaUtilities.isLeftToRight(this.tabPane) ? tabLeft <= x && tabRight - 4 > x : tabLeft + 4 < x && tabRight >= x)) continue;
            return selectedIndex == i ? this.selectColor : this.tabPane.getBackgroundAt(i);
        }
        return this.tabPane.getBackground();
    }

    protected void paintTabBorderLeft(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 1 : 2) : 4;
            this.getTabLeftBorder(border).paintBorder(this.tabPane, g, x - 2, y, w + 4, h + 1);
        } else {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 0) : 3;
            this.getTabLeftBorder(border).paintBorder(this.tabPane, g, x - 2, y, w + 2, h + 1);
        }
    }

    protected void paintTabBorderBottom(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 1 : 2) : 4;
            this.getTabBottomBorder(border).paintBorder(this.tabPane, g, x - 1, y - 1, w + 3, h + 2);
        } else {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 0) : 3;
            this.getTabBottomBorder(border).paintBorder(this.tabPane, g, x - 1, y, w + 3, h + 1);
        }
    }

    protected void paintTabBorderRight(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 1 : 2) : 4;
            this.getTabRightBorder(border).paintBorder(this.tabPane, g, x - 2, y, w + 4, h + 1);
        } else {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 0) : 3;
            this.getTabRightBorder(border).paintBorder(this.tabPane, g, x, y, w + 2, h + 1);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(this.tabAreaBackground);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected Insets getVisualMargin() {
        Insets margin = (Insets)this.tabPane.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        switch (this.tabPane.getTabPlacement()) {
            case 2: {
                return InsetsUtil.add(-1, -2, -4, -3, margin);
            }
            case 3: {
                return InsetsUtil.add(-1, -3, -5, -3, margin);
            }
            case 4: {
                return InsetsUtil.add(-1, -3, -4, -2, margin);
            }
        }
        return InsetsUtil.add(-3, -3, -4, -3, margin);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                return 0;
            }
            case 3: {
                return -1;
            }
            case 4: {
                return 0;
            }
        }
        return 1;
    }

    protected void repaintTabArea() {
        int tabPlacement = this.tabPane.getTabPlacement();
        Rectangle clipRect = new Rectangle();
        Insets insets = InsetsUtil.add(this.tabPane.getInsets(), this.getVisualMargin());
        Dimension size = this.tabPane.getSize();
        switch (tabPlacement) {
            case 2: {
                clipRect.setBounds(insets.left, insets.top, this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) + 6, size.height - insets.bottom - insets.top);
                break;
            }
            case 3: {
                int totalTabHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                clipRect.setBounds(insets.left, size.height - insets.bottom - totalTabHeight - 6, size.width - insets.left - insets.right, totalTabHeight + 6);
                break;
            }
            case 4: {
                int totalTabWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                clipRect.setBounds(size.width - insets.right - totalTabWidth - 6, insets.top, totalTabWidth + 6, size.height - insets.top - insets.bottom);
                break;
            }
            default: {
                clipRect.setBounds(insets.left, insets.top, size.width - insets.right - insets.left, this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) + 6);
            }
        }
        this.tabPane.repaint(clipRect);
    }

    @Override
    public void paint(Graphics gr, JComponent c) {
        int tc;
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        int tabPlacement = this.tabPane.getTabPlacement();
        this.isFrameActive = QuaquaUtilities.isOnActiveWindow(c);
        Dimension size = c.getSize();
        if (this.tabPane.isOpaque()) {
            g.setPaint(TextureColor.getPaint(c.getBackground(), c));
            g.fillRect(0, 0, size.width, size.height);
        }
        if (this.tabCount != (tc = this.tabPane.getTabCount())) {
            this.tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        this.ensureCurrentLayout();
        this.paintContentBorder(g, tabPlacement, selectedIndex);
        this.paintTabArea(g, tabPlacement, selectedIndex);
        QuaquaUtilities.endGraphics(g, oldHints);
        Debug.paint(g, c, this);
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        Rectangle tabClipRect = new Rectangle();
        for (int i = this.runCount - 1; i >= 0; --i) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : this.tabCount - 1;
            for (int j = start; j <= end; ++j) {
                tabClipRect.setBounds(this.rects[j]);
                tabClipRect.grow(2, 2);
                if (!tabClipRect.intersects(clipRect)) continue;
                this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && this.getRunForTab(this.tabCount, selectedIndex) == 0) {
            tabClipRect.setBounds(this.rects[selectedIndex]);
            tabClipRect.grow(2, 2);
            if (tabClipRect.intersects(clipRect)) {
                this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout layout = (TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    protected void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    protected void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(mnemonic, index);
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    protected void paintHighlightBelowTab() {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        if (tabPlacement == 4 || tabPlacement == 2) {
            return new Insets(this.tabInsets.top, 6, this.tabInsets.bottom, 5);
        }
        return this.tabInsets;
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets i = (Insets)super.getTabAreaInsets(tabPlacement).clone();
        switch (tabPlacement) {
            case 1: {
                --i.top;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ++i.bottom;
                break;
            }
        }
        return i;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = this.contentBorderInsets;
        Component selectedComponent = this.tabPane.getSelectedComponent();
        if (selectedComponent instanceof JComponent) {
            insets = (Insets)((JComponent)selectedComponent).getClientProperty("Quaqua.TabbedPaneChild.contentInsets");
        }
        if (insets == null) {
            insets = this.contentBorderInsets;
        }
        this.currentContentBorderInsets.top = insets.top + 3;
        this.currentContentBorderInsets.left = insets.left + 3;
        this.currentContentBorderInsets.bottom = insets.bottom + 3;
        this.currentContentBorderInsets.right = insets.right + 3;
        switch (tabPlacement) {
            case 2: {
                this.currentContentBorderInsets.left += 5;
                ++this.currentContentBorderInsets.bottom;
                break;
            }
            case 4: {
                this.currentContentBorderInsets.right += 4;
                ++this.currentContentBorderInsets.bottom;
                break;
            }
            case 3: {
                ++this.currentContentBorderInsets.bottom;
                break;
            }
            default: {
                this.currentContentBorderInsets.top += 4;
            }
        }
        return this.currentContentBorderInsets;
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = InsetsUtil.add(this.tabPane.getInsets(), this.getVisualMargin());
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                this.paintContentArea(g, x + 6, y + 1, (w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left) - 8, h - 6);
                this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                break;
            }
            case 4: {
                this.paintContentArea(g, x + 2, y + 1, (w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - 7, h - 6);
                this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                break;
            }
            case 3: {
                this.paintContentArea(g, x + 2, y + 1, w - 4, (h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - 6);
                this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                break;
            }
            default: {
                this.paintContentArea(g, x + 2, y + 7, w - 4, (h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top) - 12);
                this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            }
        }
    }

    private int getDepth(JTabbedPane tp) {
        int depth = 1;
        for (Container parent = tp.getParent(); parent != null && !(parent instanceof RootPaneContainer); parent = parent.getParent()) {
            if (!(parent instanceof JTabbedPane)) continue;
            ++depth;
        }
        return depth;
    }

    protected void paintContentArea(Graphics gr, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)gr;
        Color contentBackground = null;
        Component selectedComponent = this.tabPane.getSelectedComponent();
        if (selectedComponent instanceof JComponent) {
            contentBackground = (Color)((JComponent)selectedComponent).getClientProperty("Quaqua.TabbedPaneChild.contentBackground");
        }
        if (contentBackground == null) {
            contentBackground = this.tabPane.getBackground();
        }
        g.setPaint(PaintableColor.getPaint(contentBackground, this.tabPane, 0, -this.getDepth(this.tabPane) % 4));
        g.fillRect(x, y, width, height);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Insets contentBorderInsets = this.getContentBorder().getBorderInsets(this.tabPane);
        this.getContentBorder().paintBorder(this.tabPane, g, x, y - contentBorderInsets.top + 1, w, h + contentBorderInsets.top - 1);
        int bar = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 1) : 2;
        this.getBarTopBorder(bar).paintBorder(this.tabPane, g, x + contentBorderInsets.left, y, w - contentBorderInsets.left - contentBorderInsets.right, 7);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Insets contentBorderInsets = this.getContentBorder().getBorderInsets(this.tabPane);
        this.getContentBorder().paintBorder(this.tabPane, g, x, y, w, h + contentBorderInsets.bottom);
        int bar = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 1) : 2;
        this.getBarBottomBorder(bar).paintBorder(this.tabPane, g, x + contentBorderInsets.left, y + h - 6, w - contentBorderInsets.left - contentBorderInsets.right, 6);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        this.getContentBorder().paintBorder(this.tabPane, g, x, y, w, h);
        int bar = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 1) : 2;
        this.getBarLeftBorder(bar).paintBorder(this.tabPane, g, x, y + 1, 7, h - 6);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        this.getContentBorder().paintBorder(this.tabPane, g, x, y, w + 3, h);
        int bar = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 1) : 2;
        this.getBarRightBorder(bar).paintBorder(this.tabPane, g, x + w - 6, y + 1, 6, h - 6);
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int height = metrics.getHeight();
        boolean tallerIcons = false;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Icon icon = this.tabPane.getIconAt(i);
            if (icon == null || icon.getIconHeight() <= height) continue;
            tallerIcons = true;
            break;
        }
        return super.calculateMaxTabHeight(tabPlacement) - (tallerIcons ? this.tabInsets.top + this.tabInsets.bottom : 0);
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return 2;
        }
        return 1;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement, int selectedRun) {
        return false;
    }

    @Override
    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1;
    }

    private boolean isLastInRun(int tabIndex) {
        int run = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), run);
        return tabIndex == lastIndex;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                QuaquaUtilities.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.disabledForeground);
                QuaquaUtilities.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            }
        }
    }

    @Override
    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Rectangle rect = new Rectangle(0, 0, width, height);
        InsetsUtil.subtractInto(c.getInsets(), rect);
        if (type != 0) {
            Insets margin = this.getVisualMargin();
            switch (((JTabbedPane)c).getTabPlacement()) {
                case 2: {
                    InsetsUtil.addTo(1, 2, 5, 3, margin);
                    break;
                }
                case 3: {
                    InsetsUtil.addTo(1, 3, 5, 3, margin);
                    break;
                }
                case 4: {
                    InsetsUtil.addTo(1, 3, 5, 2, margin);
                    break;
                }
                default: {
                    InsetsUtil.addTo(3, 3, 5, 3, margin);
                }
            }
            rect.x += margin.left;
            rect.y += margin.top;
            rect.width -= margin.left + margin.right;
            rect.height -= margin.top + margin.bottom;
        }
        return rect;
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tCount = this.tabPane.getTabCount();
        for (int i = 0; i < tCount; ++i) {
            if (!this.rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getBaseline(JComponent component, int width, int height) {
        return -1;
    }

    @Override
    public void navigateSelectedTab(int direction) {
        super.navigateSelectedTab(direction);
    }

    @Override
    public Integer getIndexForMnemonic(int mnemonic) {
        return (Integer)this.mnemonicToIndexMap.get(mnemonic);
    }

    @Override
    public boolean requestFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent != null && visibleComponent.isFocusable()) {
            QuaquaUtilities.compositeRequestFocus(visibleComponent);
            return true;
        }
        return visibleComponent instanceof JComponent && ((JComponent)visibleComponent).requestDefaultFocus();
    }

    @Override
    protected void installComponents() {
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    private static class TabSelectionHandler
    implements ChangeListener {
        private TabSelectionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
        }
    }

    public class QuaquaMouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (!QuaquaJaguarTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = QuaquaJaguarTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && QuaquaJaguarTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == QuaquaJaguarTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (QuaquaJaguarTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        QuaquaJaguarTabbedPaneUI.this.tabPane.requestFocus();
                        QuaquaJaguarTabbedPaneUI.this.tabPane.repaint(QuaquaJaguarTabbedPaneUI.this.getTabBounds(QuaquaJaguarTabbedPaneUI.this.tabPane, tabIndex));
                    }
                } else {
                    QuaquaJaguarTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                }
            }
        }
    }

    public class QuaquaPropertyChangeHandler
    extends BasicTabbedPaneUI.PropertyChangeHandler {
        public QuaquaPropertyChangeHandler() {
            super(QuaquaJaguarTabbedPaneUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("Frame.active")) {
                QuaquaJaguarTabbedPaneUI.this.repaintTabArea();
            } else if (name.equals("JComponent.sizeVariant")) {
                QuaquaUtilities.applySizeVariant(QuaquaJaguarTabbedPaneUI.this.tabPane);
            }
            if (!name.equals("tabLayoutPolicy")) {
                super.propertyChange(evt);
            }
        }
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(QuaquaJaguarTabbedPaneUI.this);
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Integer propertyValue;
            int tabAlignment;
            Rectangle rect;
            int i;
            int returnAt;
            int y;
            int x;
            Dimension size = QuaquaJaguarTabbedPaneUI.this.tabPane.getSize();
            Insets insets = InsetsUtil.add(QuaquaJaguarTabbedPaneUI.this.tabPane.getInsets(), QuaquaJaguarTabbedPaneUI.this.getVisualMargin());
            Insets tabAreaInsets = QuaquaJaguarTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            FontMetrics metrics = QuaquaJaguarTabbedPaneUI.this.getFontMetrics();
            int fontHeight = metrics.getHeight();
            int selectedIndex = QuaquaJaguarTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = QuaquaUtilities.isLeftToRight(QuaquaJaguarTabbedPaneUI.this.tabPane);
            switch (tabPlacement) {
                case 2: {
                    QuaquaJaguarTabbedPaneUI.this.maxTabWidth = QuaquaJaguarTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    QuaquaJaguarTabbedPaneUI.this.maxTabWidth = QuaquaJaguarTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - QuaquaJaguarTabbedPaneUI.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    QuaquaJaguarTabbedPaneUI.this.maxTabHeight = QuaquaJaguarTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - QuaquaJaguarTabbedPaneUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    QuaquaJaguarTabbedPaneUI.this.maxTabHeight = QuaquaJaguarTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = QuaquaJaguarTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            QuaquaJaguarTabbedPaneUI.this.runCount = 0;
            QuaquaJaguarTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            for (i = 0; i < tabCount; ++i) {
                rect = QuaquaJaguarTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i - 1].x + ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i - 1].width;
                    } else {
                        ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).tabRuns[0] = 0;
                        QuaquaJaguarTabbedPaneUI.this.runCount = 1;
                        QuaquaJaguarTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = QuaquaJaguarTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    QuaquaJaguarTabbedPaneUI.this.maxTabWidth = Math.max(QuaquaJaguarTabbedPaneUI.this.maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (QuaquaJaguarTabbedPaneUI.this.runCount > QuaquaJaguarTabbedPaneUI.this.tabRuns.length - 1) {
                            QuaquaJaguarTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).tabRuns[((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).runCount] = i;
                        QuaquaJaguarTabbedPaneUI.this.runCount++;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = QuaquaJaguarTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i - 1].y + ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i - 1].height;
                    } else {
                        ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).tabRuns[0] = 0;
                        QuaquaJaguarTabbedPaneUI.this.runCount = 1;
                        QuaquaJaguarTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = QuaquaJaguarTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    QuaquaJaguarTabbedPaneUI.this.maxTabHeight = Math.max(QuaquaJaguarTabbedPaneUI.this.maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (QuaquaJaguarTabbedPaneUI.this.runCount > QuaquaJaguarTabbedPaneUI.this.tabRuns.length - 1) {
                            QuaquaJaguarTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).tabRuns[((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).runCount] = i;
                        QuaquaJaguarTabbedPaneUI.this.runCount++;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = QuaquaJaguarTabbedPaneUI.this.maxTabWidth;
                }
                if (i != selectedIndex) continue;
                QuaquaJaguarTabbedPaneUI.this.selectedRun = QuaquaJaguarTabbedPaneUI.this.runCount - 1;
            }
            if (QuaquaJaguarTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                QuaquaJaguarTabbedPaneUI.this.selectedRun = QuaquaJaguarTabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (QuaquaJaguarTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, QuaquaJaguarTabbedPaneUI.this.selectedRun);
                }
            }
            int maxPad = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    maxPad = size.height - tabAreaInsets.top - tabAreaInsets.bottom;
                    break;
                }
                default: {
                    maxPad = size.width - tabAreaInsets.left - tabAreaInsets.right;
                }
            }
            for (i = QuaquaJaguarTabbedPaneUI.this.runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = QuaquaJaguarTabbedPaneUI.this.tabRuns[i];
                int next = QuaquaJaguarTabbedPaneUI.this.tabRuns[i == QuaquaJaguarTabbedPaneUI.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = QuaquaJaguarTabbedPaneUI.this.rects[j];
                        rect.y = y;
                        rect.x += QuaquaJaguarTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (QuaquaJaguarTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, maxPad);
                    }
                    if (tabPlacement == 3) {
                        y -= QuaquaJaguarTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += QuaquaJaguarTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = QuaquaJaguarTabbedPaneUI.this.rects[j];
                    rect.x = x;
                    rect.y += QuaquaJaguarTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                }
                if (QuaquaJaguarTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, maxPad);
                }
                if (tabPlacement == 4) {
                    x -= QuaquaJaguarTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += QuaquaJaguarTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].x = rightMargin - ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].x - ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].width;
                }
            }
            int n = tabAlignment = (propertyValue = (Integer)QuaquaJaguarTabbedPaneUI.this.tabPane.getClientProperty("Quaqua.TabbedPane.tabAlignment")) != null && propertyValue == 10 ? 10 : 0;
            if (tabAlignment == 0) {
                switch (tabPlacement) {
                    case 2: 
                    case 4: {
                        int availableTabAreaHeight = size.height - insets.top - insets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                        int usedTabAreaHeight = 0;
                        int pad = 0;
                        for (int run = 0; run < QuaquaJaguarTabbedPaneUI.this.runCount; ++run) {
                            int firstIndex = QuaquaJaguarTabbedPaneUI.this.tabRuns[run];
                            int lastIndex = QuaquaJaguarTabbedPaneUI.this.lastTabInRun(tabCount, run);
                            if (run == 0) {
                                usedTabAreaHeight = 0;
                                for (i = firstIndex; i <= lastIndex; ++i) {
                                    usedTabAreaHeight += ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].height;
                                }
                                pad = (availableTabAreaHeight - usedTabAreaHeight) / 2;
                            }
                            for (i = firstIndex; i <= lastIndex; ++i) {
                                ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].y += pad;
                            }
                        }
                        break;
                    }
                    default: {
                        int availableTabAreaWidth = size.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                        for (int run = 0; run < QuaquaJaguarTabbedPaneUI.this.runCount; ++run) {
                            int firstIndex = QuaquaJaguarTabbedPaneUI.this.tabRuns[run];
                            int lastIndex = QuaquaJaguarTabbedPaneUI.this.lastTabInRun(tabCount, run);
                            int usedTabAreaWidth = 0;
                            for (i = firstIndex; i <= lastIndex; ++i) {
                                usedTabAreaWidth += ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].width;
                            }
                            int pad = (availableTabAreaWidth - usedTabAreaWidth) / 2;
                            for (i = firstIndex; i <= lastIndex; ++i) {
                                ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].x += pad;
                            }
                        }
                    }
                }
            }
        }

        @Override
        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
                int run = QuaquaJaguarTabbedPaneUI.this.runCount - 1;
                boolean keepAdjusting = true;
                double weight = 1.33;
                while (keepAdjusting) {
                    int prevLastLen;
                    int end;
                    int last = QuaquaJaguarTabbedPaneUI.this.lastTabInRun(tabCount, run);
                    int prevLast = QuaquaJaguarTabbedPaneUI.this.lastTabInRun(tabCount, run - 1);
                    if (!verticalTabRuns) {
                        end = ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[last].x + ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[last].width;
                        prevLastLen = (int)((double)QuaquaJaguarTabbedPaneUI.this.maxTabWidth * weight);
                    } else {
                        end = ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[last].y + ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[last].height;
                        prevLastLen = (int)((double)QuaquaJaguarTabbedPaneUI.this.maxTabHeight * weight * 2.0);
                    }
                    if (max - end > prevLastLen) {
                        ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).tabRuns[run] = prevLast;
                        if (!verticalTabRuns) {
                            ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[prevLast].x = start;
                        } else {
                            ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[prevLast].y = start;
                        }
                        for (int i = prevLast + 1; i <= last; ++i) {
                            if (!verticalTabRuns) {
                                ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].x = ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i - 1].x + ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i - 1].width;
                                continue;
                            }
                            ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i].y = ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i - 1].y + ((QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.this).rects[i - 1].height;
                        }
                    } else if (run == QuaquaJaguarTabbedPaneUI.this.runCount - 1) {
                        keepAdjusting = false;
                    }
                    if (run - 1 > 0) {
                        --run;
                        continue;
                    }
                    run = QuaquaJaguarTabbedPaneUI.this.runCount - 1;
                    weight += 0.33;
                }
            }
        }

        @Override
        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        @Override
        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }

        @Override
        public void calculateLayoutInfo() {
            int tabCount = QuaquaJaguarTabbedPaneUI.this.tabPane.getTabCount();
            QuaquaJaguarTabbedPaneUI.this.assureRectsCreated(tabCount);
            this.calculateTabRects(QuaquaJaguarTabbedPaneUI.this.tabPane.getTabPlacement(), tabCount);
        }

        @Override
        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.padTabRun(tabPlacement, start, end, max);
            }
        }
    }
}

