/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.lion;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.ext.batik.ext.awt.LinearGradientPaint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class QuaquaLionScrollBarTrackBorder
implements Border,
UIResource {
    private static final Color rrectColor = new Color(-606348325, true);
    private static final Color[] rrectGradientColors = new Color[]{new Color(-605821981, true), new Color(-605558809, true), new Color(-605361430, true)};
    private static final float[] rrectGradientFractions = new float[]{0.0f, 0.5f, 1.0f};
    private static final Color topColor = new Color(0xE4E4E4);
    private static final Color bottomColor = new Color(0xEFEFEF);
    private static final Color[] gradientColors = new Color[]{new Color(0xF2F2F2), new Color(0xFCFCFC), new Color(0xF8F8F8)};
    private static final float[] gradientFractions = new float[]{0.0f, 0.5f, 1.0f};

    @Override
    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        JScrollBar sb = (JScrollBar)c;
        Container parent = sb.getParent();
        JScrollPane sp = parent instanceof JScrollPane ? (JScrollPane)parent : null;
        Dimension ps = sb.getUI().getPreferredSize(sb);
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        if (sb.getOrientation() == 0) {
            height = Math.min(ps.height, height);
            g.setColor(topColor);
            g.drawLine(x, y, x + width - 1, y);
            g.setColor(bottomColor);
            g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
            int tx = x + 1;
            int ty = y + 1;
            int tw = width - 2;
            int th = height - 2;
            g.setPaint(new LinearGradientPaint((float)tx, (float)ty, tx, (float)(ty + th - 1), gradientFractions, gradientColors));
            g.fillRect(tx, ty, tw, th);
        } else {
            width = Math.min(ps.width, width);
            g.setColor(topColor);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(bottomColor);
            g.drawLine(x + width - 2, y, x + width - 2, y + height - 1);
            int tx = x + 1;
            int ty = y + 1;
            int tw = width - 2;
            int th = height - 2;
            g.setPaint(new LinearGradientPaint((float)tx, (float)ty, tx + width - 1, (float)ty, gradientFractions, gradientColors));
            g.fillRect(tx, ty, tw, th);
        }
        QuaquaUtilities.endGraphics(g, oldHints);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

