/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.lion.filechooser;

import ch.randelshofer.quaqua.BrowserPreviewRenderer;
import ch.randelshofer.quaqua.JBrowser;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import ch.randelshofer.quaqua.osx.OSXFile;
import ch.randelshofer.quaqua.util.Worker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class LionFilePreview
extends JPanel
implements BrowserPreviewRenderer {
    private JFileChooser fileChooser;
    private boolean isFileIconAvailable = true;
    private JPanel emptyPreview;
    private FileInfo info;
    private JTable attributeView;
    private Font labelFont;
    private Font valueFont;
    private String labelDelimiter;
    private ScaledImageView previewImageView;

    public LionFilePreview(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
        this.previewImageView = new ScaledImageView();
        this.previewImageView.setMinimumSize(new Dimension(128, 128));
        this.previewImageView.setPreferredSize(new Dimension(128, 128));
        this.setBorder(BorderFactory.createEmptyBorder(3, 4, 4, 4));
        this.setLayout(new BoxLayout(this, 1));
        Color bg = UIManager.getColor("List.background");
        Color fgl = UIManager.getColor("FileChooser.previewLabelForeground");
        Color fgv = UIManager.getColor("FileChooser.previewValueForeground");
        this.labelFont = UIManager.getFont("FileChooser.previewLabelFont");
        this.valueFont = UIManager.getFont("FileChooser.previewValueFont");
        this.emptyPreview = new JPanel();
        this.emptyPreview.setBackground(bg);
        this.emptyPreview.setOpaque(true);
        Insets labelInsets = UIManager.getInsets("FileChooser.previewLabelInsets");
        this.labelDelimiter = UIManager.getString("FileChooser.previewLabelDelimiter");
        if (this.labelDelimiter == null) {
            this.labelDelimiter = "";
        }
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        TableColumn names = new TableColumn();
        SimpleTableCellRenderer r = new SimpleTableCellRenderer(this.labelFont, fgl);
        r.setHorizontalAlignment(4);
        Insets borderMargin = new Insets(0, 0, 0, 0);
        r.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        names.setCellRenderer(r);
        names.setModelIndex(0);
        cm.addColumn(names);
        TableColumn values = new TableColumn();
        r = new SimpleTableCellRenderer(this.valueFont, fgv);
        r.setHorizontalAlignment(2);
        values.setCellRenderer(r);
        values.setModelIndex(1);
        cm.addColumn(values);
        this.attributeView = new JTable(null, cm);
        this.attributeView.setIntercellSpacing(new Dimension(5, 0));
        this.attributeView.setAutoResizeMode(0);
        this.attributeView.setFocusable(false);
        this.setBackground(bg);
        this.attributeView.setBackground(bg);
        this.setOpaque(true);
        this.add(Box.createVerticalGlue());
        Box p = new Box(0);
        p.add(Box.createHorizontalGlue());
        p.add(this.previewImageView);
        p.add(Box.createHorizontalGlue());
        this.add(p);
        this.add(Box.createVerticalGlue());
        GrayLine b = new GrayLine();
        b.setBorder(new EmptyBorder(5, 25, 5, 25));
        this.add(b);
        p = new Box(0);
        p.add(Box.createHorizontalGlue());
        p.add(this.attributeView);
        p.add(Box.createHorizontalGlue());
        p.setBorder(new EmptyBorder(0, 0, 40, 0));
        this.add(p);
        MouseAdapter mouseHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    LionFilePreview.this.fileChooser.approveSelection();
                }
            }
        };
        this.addMouseListener(mouseHandler);
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            c[i].addMouseListener(mouseHandler);
        }
    }

    private String toOSXPath(File file) {
        StringBuffer buf = new StringBuffer();
        QuaquaFileSystemView fsv = QuaquaFileSystemView.getQuaquaFileSystemView();
        if (file != null && file.isDirectory()) {
            buf.append(':');
        }
        while (file != null) {
            buf.insert(0, this.fileChooser.getName(file));
            if ((file = ((FileSystemView)fsv).getParentDirectory(file)) == null) continue;
            buf.insert(0, ':');
        }
        return buf.toString();
    }

    @Override
    public Component getPreviewRendererComponent(JBrowser browser, TreePath[] paths) {
        File resolvedFile;
        String kind;
        if (paths.length > 1) {
            return this.emptyPreview;
        }
        Locale locale = Locale.getDefault();
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMaximumFractionDigits(1);
        this.info = (FileInfo)paths[0].getLastPathComponent();
        if (!this.info.isAcceptable()) {
            return this.emptyPreview;
        }
        File file = this.info.getFile();
        AttributeTableModel m = new AttributeTableModel();
        m.add("name", this.info.getUserName());
        m.add("kind", OSXFile.getKindString(file));
        m.add("size", this.getLengthString(this.info.getFileLength()));
        m.add("modified", this.getModifiedString(file));
        Date d = OSXFile.getLastUsedDate(file);
        if (d != null) {
            m.add("lastUsed", this.getLastUsedString(d));
        }
        if ((kind = this.info.getFileKind()) == "alias" && (resolvedFile = this.info.lazyGetResolvedFile()) != null) {
            m.add("original", this.toOSXPath(resolvedFile));
        }
        this.attributeView.setModel(m);
        m.updatePreferredWidths();
        this.attributeView.revalidate();
        this.attributeView.repaint();
        this.updatePreviewImage();
        return this;
    }

    protected String getLengthString(long fileLength) {
        float scaledLength;
        String label;
        if (fileLength < 0L) {
            return null;
        }
        if (fileLength >= 1000000000L) {
            label = "FileChooser.sizeGBytesOnly";
            scaledLength = (float)fileLength / 1.0E9f;
        } else if (fileLength >= 1000000L) {
            label = "FileChooser.sizeMBytesOnly";
            scaledLength = (float)fileLength / 1000000.0f;
        } else if (fileLength >= 1024L) {
            label = "FileChooser.sizeKBytesOnly";
            scaledLength = (float)fileLength / 1000.0f;
        } else {
            label = "FileChooser.sizeBytesOnly";
            scaledLength = fileLength;
        }
        return MessageFormat.format(UIManager.getString(label), Float.valueOf(scaledLength), fileLength);
    }

    protected String getModifiedString(File f) {
        if (f != null) {
            return DateFormat.getInstance().format(new Date(f.lastModified()));
        }
        return null;
    }

    protected String getLastUsedString(Date d) {
        return DateFormat.getInstance().format(d);
    }

    private void updatePreviewImage() {
        File file;
        this.previewImageView.setVisible(this.isFileIconAvailable);
        this.previewImageView.setImage(null);
        if (this.info != null && (file = this.info.lazyGetResolvedFile()) != null) {
            new Worker<BufferedImage>(){

                @Override
                public BufferedImage construct() {
                    BufferedImage o = null;
                    if (UIManager.getBoolean("FileChooser.quickLookEnabled") && System.getProperty("os.version").compareTo("10.6") >= 0) {
                        o = OSXFile.getQuickLookThumbnailImage(file, 800);
                    }
                    if (o == null) {
                        return OSXFile.getIconImage(file, 512);
                    }
                    return o;
                }

                @Override
                public void done(BufferedImage value) {
                    BufferedImage fileIconImage = value;
                    LionFilePreview.this.isFileIconAvailable = fileIconImage != null;
                    if (LionFilePreview.this.isFileIconAvailable) {
                        LionFilePreview.this.previewImageView.setImage(fileIconImage);
                    } else {
                        LionFilePreview.this.previewImageView.setVisible(false);
                    }
                    LionFilePreview.this.previewImageView.getParent().validate();
                }
            }.start();
        }
    }

    public static int getTextWidth(String s, Font f, JComponent c) {
        Dimension size = LionFilePreview.getTextSize(s, f, c);
        return size != null ? size.width : 0;
    }

    public static Dimension getTextSize(String s, Font f, JComponent c) {
        if (f == null && (f = c.getFont()) == null) {
            return null;
        }
        FontMetrics fm = null;
        try {
            fm = c.getFontMetrics(f);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (fm == null) {
            return null;
        }
        int w = fm.stringWidth(s);
        int h = fm.getHeight();
        return new Dimension(w, h);
    }

    private static class ScaledImageView
    extends JComponent {
        private BufferedImage im;

        private ScaledImageView() {
        }

        public void setImage(BufferedImage im) {
            this.im = im;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.im != null) {
                Insets s = this.getInsets();
                int left = s.left;
                int top = s.top;
                int cwidth = this.getWidth() - s.left - s.right;
                int cheight = this.getHeight() - s.top - s.bottom;
                float imwidth = this.im.getWidth();
                float imheight = this.im.getHeight();
                if (imwidth > 0.0f && imheight > 0.0f) {
                    int size = Math.min(cwidth, cheight);
                    float scale = Math.min((float)cwidth / imwidth, (float)cheight / imheight);
                    int extraLeft = (int)Math.max(0.0f, ((float)cwidth - imwidth * scale) / 2.0f);
                    int extraTop = (int)Math.max(0.0f, ((float)cheight - imheight * scale) / 2.0f);
                    g.drawImage(this.im, left + extraLeft, top + extraTop, size, size, null);
                }
            }
        }
    }

    private static class GrayLine
    extends JComponent {
        private GrayLine() {
        }

        @Override
        public Dimension getMinimumSize() {
            Insets s = this.getInsets();
            return new Dimension(0, s.top + s.bottom + 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            Insets s = this.getInsets();
            return new Dimension(100000, s.top + s.bottom + 1);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Insets s = this.getInsets();
            g.setColor(new Color(0xD9D9D9));
            g.drawLine(s.left, s.top, this.getWidth() - s.right, s.top);
        }
    }

    private static class SimpleTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private Font f;
        private Color fg;

        public SimpleTableCellRenderer(Font f, Color fg) {
            this.f = f;
            this.fg = fg;
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            this.setFont(this.f);
            this.setForeground(this.fg);
            return this;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text" || propertyName == "labelFor" || propertyName == "displayedMnemonic" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private List<String> names = new ArrayList<String>();
        private List<String> values = new ArrayList<String>();
        private int nameWidth;
        private int valueWidth;

        private AttributeTableModel() {
        }

        public void add(String name, String value) {
            if (value != null && !value.isEmpty()) {
                String s = UIManager.getString("FileChooser." + name);
                String actualName = (s != null ? s : name) + LionFilePreview.this.labelDelimiter;
                this.names.add(actualName);
                this.values.add(value);
                this.nameWidth = Math.max(this.nameWidth, LionFilePreview.getTextWidth(actualName, LionFilePreview.this.labelFont, LionFilePreview.this.attributeView));
                this.valueWidth = Math.max(this.valueWidth, LionFilePreview.getTextWidth(value, LionFilePreview.this.valueFont, LionFilePreview.this.attributeView));
            }
        }

        public void updatePreferredWidths() {
            int fudge = 15;
            LionFilePreview.this.attributeView.getColumnModel().getColumn(0).setPreferredWidth(this.nameWidth + fudge);
            LionFilePreview.this.attributeView.getColumnModel().getColumn(1).setPreferredWidth(this.valueWidth + fudge);
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Attribute";
            }
            if (columnIndex == 1) {
                return "Value";
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.names.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.values.get(rowIndex);
            }
            return null;
        }
    }
}

