/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.lion.filechooser;

import ch.randelshofer.quaqua.QuaquaLabelUI;
import ch.randelshofer.quaqua.QuaquaScrollPaneUI;
import ch.randelshofer.quaqua.QuaquaTableHeaderUI;
import ch.randelshofer.quaqua.QuaquaViewportUI;
import ch.randelshofer.quaqua.filechooser.CellRenderer;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.FileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.QuaquaFileChooserTreeTableUI;
import ch.randelshofer.quaqua.osx.OSXFile;
import de.sciss.treetable.j.AbstractTreeColumnModel;
import de.sciss.treetable.j.DefaultTreeTableCellRenderer;
import de.sciss.treetable.j.TreeColumnModel;
import de.sciss.treetable.j.TreeTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ListView
extends ch.randelshofer.quaqua.filechooser.ListView {
    protected final TreeTable tree;
    protected final JScrollPane listViewScrollPane;
    protected final MyTableColumnModel tableColumnModel;
    private Color labelColor;
    private Font labelFont;
    private Font headerFont;
    private Color headerColor;
    private int COLUMN_MARGIN = 10;
    private CellRenderer fileRenderer;
    protected final JFileChooser fc;
    private final TreeSelectionListener treeSelectionListener;

    public ListView(JFileChooser fc) {
        this.fc = fc;
        this.labelColor = UIManager.getColor("FileChooser.listView.extraColumnTextColor");
        this.headerColor = UIManager.getColor("FileChooser.listView.headerColor");
        this.labelFont = UIManager.getFont("ViewFont");
        this.headerFont = UIManager.getFont("EmphasizedSmallSystemFont");
        this.treeSelectionListener = new MyTreeSelectionListener();
        Color selectionForeground = Color.WHITE;
        this.setFocusable(false);
        FileSystemTreeModel fakeTreeModel = new FileSystemTreeModel(fc);
        this.tableColumnModel = this.createColumnModel();
        this.tree = new MyTreeTable(fakeTreeModel, new MyTreeColumnModel(), this.tableColumnModel);
        this.tree.setUI(new MyTreeTableUI(fc, this.tree));
        this.tree.putClientProperty("Quaqua.Tree.style", "striped");
        this.tree.setRootVisible(false);
        this.tree.setAlternateRowColor(this.tree.getBackground());
        this.tree.setBackground(UIManager.getColor("List.alternateBackground.0"));
        this.tree.setNodeSortingEnabled(false);
        this.tree.setRowMargin(0);
        this.tree.setRowHeight(18);
        this.tree.getTableHeader().setUI(new QuaquaTableHeaderUI());
        this.tree.setSelectionForeground(selectionForeground);
        this.tree.setOpaque(false);
        this.listViewScrollPane = new JScrollPane();
        this.listViewScrollPane.setUI(new QuaquaScrollPaneUI());
        JViewport vp = this.listViewScrollPane.getViewport();
        vp.setUI(new QuaquaViewportUI());
        this.listViewScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.listViewScrollPane.setViewportView(this.tree);
        this.listViewScrollPane.setColumnHeaderView(this.tree.getTableHeader());
        this.setLayout(new BorderLayout());
        this.add(this.listViewScrollPane);
    }

    @Override
    public void setActive(boolean b) {
        TreeSelectionModel sm = this.tree.getSelectionModel();
        if (b) {
            sm.addTreeSelectionListener(this.treeSelectionListener);
        } else {
            sm.removeTreeSelectionListener(this.treeSelectionListener);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.tree.addKeyListener(l);
    }

    @Override
    protected void updateForNewModel() {
        this.tree.setTreeModel(this.model);
        this.tree.revalidate();
        this.tree.repaint();
    }

    @Override
    public void reconfigure() {
        this.setMultipleSelection(this.fc.isMultiSelectionEnabled());
        this.tree.repaint();
    }

    @Override
    public void setFileRenderer(CellRenderer r) {
        this.fileRenderer = r;
        this.tree.repaint();
    }

    @Override
    public void setMultipleSelection(boolean b) {
        this.tree.getSelectionModel().setSelectionMode(b ? 4 : 1);
    }

    @Override
    public void setSelection(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    @Override
    public void setSelection(List<TreePath> paths) {
        TreePath[] ps = paths.toArray(new TreePath[paths.size()]);
        this.tree.setSelectionPaths(ps);
    }

    @Override
    public List<TreePath> getSelection() {
        TreePath[] ps = this.tree.getSelectionPaths();
        return ps != null ? new ArrayList<TreePath>(Arrays.asList(ps)) : new ArrayList();
    }

    @Override
    public void ensurePathIsVisible(TreePath path) {
        this.tree.scrollPathToVisible(path);
    }

    protected MyTableColumnModel createColumnModel() {
        return new MyTableColumnModel();
    }

    protected String getLengthString(long fileLength) {
        float scaledLength;
        String label;
        if (fileLength < 0L) {
            return "--";
        }
        if (fileLength >= 1000000000L) {
            label = "FileChooser.sizeGBytesOnly";
            scaledLength = (float)fileLength / 1.0E9f;
        } else if (fileLength >= 1000000L) {
            label = "FileChooser.sizeMBytesOnly";
            scaledLength = (float)fileLength / 1000000.0f;
        } else if (fileLength >= 1024L) {
            label = "FileChooser.sizeKBytesOnly";
            scaledLength = (float)fileLength / 1000.0f;
        } else {
            label = "FileChooser.sizeBytesOnly";
            scaledLength = fileLength;
        }
        return MessageFormat.format(UIManager.getString(label), Float.valueOf(scaledLength), fileLength);
    }

    protected String getModifiedString(File f, int width) {
        if (f != null) {
            Date d = new Date(f.lastModified());
            if (width < 150) {
                DateFormat df = DateFormat.getDateInstance(3);
                return df.format(d);
            }
            DateFormat df = DateFormat.getDateInstance();
            return df.format(d);
        }
        return "";
    }

    protected String getKindString(File f) {
        return f != null ? OSXFile.getKindString(f) : "";
    }

    protected class MyTreeColumnModel
    extends AbstractTreeColumnModel {
        private List<String> columnNames = new ArrayList<String>();

        public MyTreeColumnModel() {
            this.columnNames.add("Name");
            this.columnNames.add("Date Modified");
            this.columnNames.add("Size");
            this.columnNames.add("Kind");
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames.get(column);
        }

        @Override
        public Object getValueAt(Object node, int column) {
            FileSystemTreeModel.Node pn = (FileSystemTreeModel.Node)node;
            File f = pn.lazyGetResolvedFile();
            switch (column) {
                case 0: {
                    return pn;
                }
                case 1: {
                    return f != null ? ListView.this.getModifiedString(f, ListView.this.tableColumnModel.dateModifiedColumn.getWidth()) : "";
                }
                case 2: {
                    return ListView.this.getLengthString(pn.getFileLength());
                }
                case 3: {
                    return ListView.this.getKindString(f);
                }
            }
            throw new IllegalArgumentException();
        }
    }

    protected class MyHeaderRenderer
    extends DefaultTableCellRenderer {
        public MyHeaderRenderer(int alignment) {
            this.setHorizontalAlignment(alignment);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (ListView.this.headerFont != null) {
                c.setFont(ListView.this.headerFont);
            }
            if (ListView.this.headerColor != null) {
                c.setForeground(ListView.this.headerColor);
            }
            int columnMargin = ListView.this.tableColumnModel.getColumnMargin();
            c.setBorder(new EmptyBorder(0, columnMargin / 2, 0, columnMargin / 2));
            return c;
        }
    }

    private class MyNameCellRenderer
    extends MyCellRenderer {
        private MyNameCellRenderer(int alignment) {
            super(null, alignment);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column, boolean expanded, boolean leaf) {
            Component c = ListView.this.fileRenderer.getCellRendererComponent(treeTable, value, selected, hasFocus);
            if (c == null) {
                c = super.getTreeTableCellRendererComponent(treeTable, value, selected, hasFocus, row, column, expanded, leaf);
            }
            return c;
        }
    }

    protected class MyCellRenderer
    extends DefaultTreeTableCellRenderer {
        protected Color fg;

        public MyCellRenderer(Color fg, int alignment) {
            this.fg = fg;
            this.setHorizontalAlignment(alignment);
            this.setFont(ListView.this.labelFont);
            this.setUI(new QuaquaLabelUI());
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column) {
            hasFocus = false;
            Component c = super.getTreeTableCellRendererComponent(treeTable, value, selected, hasFocus, row, column);
            return this.fix(c, selected);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column, boolean expanded, boolean leaf) {
            Component c = super.getTreeTableCellRendererComponent(treeTable, value, selected, hasFocus, row, column, expanded, leaf);
            return this.fix(c, selected);
        }

        protected Component fix(Component c, boolean selected) {
            if (this.fg != null && !selected) {
                c.setForeground(this.fg);
            }
            return c;
        }
    }

    protected class MyTableColumn
    extends TableColumn {
        public MyTableColumn(int modelIndex, int width, boolean canWiden, String name) {
            super(modelIndex, width + ListView.this.COLUMN_MARGIN);
            if (!canWiden) {
                this.setMaxWidth(this.getWidth());
            }
            this.setHeaderValue(name);
        }
    }

    protected class MyTableColumnModel
    extends DefaultTableColumnModel {
        public TableColumn nameColumn;
        public TableColumn dateModifiedColumn;
        public TableColumn sizeColumn;
        public TableColumn kindColumn;

        public MyTableColumnModel() {
            this.nameColumn = new MyTableColumn(0, 200, true, "Name");
            this.dateModifiedColumn = new MyTableColumn(1, 80, false, "Date Modified");
            this.sizeColumn = new MyTableColumn(2, 65, false, "Size");
            this.kindColumn = new MyTableColumn(3, 150, false, "Kind");
            MyNameCellRenderer nameRenderer = new MyNameCellRenderer(2);
            MyCellRenderer leftRenderer = new MyCellRenderer(ListView.this.labelColor, 2);
            MyCellRenderer rightRenderer = new MyCellRenderer(ListView.this.labelColor, 4);
            this.nameColumn.setCellRenderer(nameRenderer);
            this.dateModifiedColumn.setCellRenderer(leftRenderer);
            this.sizeColumn.setCellRenderer(rightRenderer);
            this.kindColumn.setCellRenderer(leftRenderer);
            this.addColumn(this.nameColumn);
            this.addColumn(this.dateModifiedColumn);
            this.addColumn(this.sizeColumn);
            this.addColumn(this.kindColumn);
            this.setColumnMargin(ListView.this.COLUMN_MARGIN);
        }

        protected DefaultTableCellRenderer createHeaderCellRenderer(int align) {
            return new MyHeaderRenderer(align);
        }
    }

    protected class MyTreeTableUI
    extends QuaquaFileChooserTreeTableUI {
        public MyTreeTableUI(JFileChooser fc, TreeTable tt) {
            super(fc, tt);
        }

        @Override
        protected void select(TreePath path) {
            ListView.this.select(path);
        }
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ListView.this.selectionChanged();
        }
    }

    protected class MyTreeTable
    extends TreeTable {
        public MyTreeTable(TreeModel tm, TreeColumnModel tcm, TableColumnModel cm) {
            super(tm, tcm, cm);
        }

        @Override
        public Icon getIcon(Object node, boolean expanded, boolean leaf) {
            if (node instanceof FileInfo) {
                FileInfo info = (FileInfo)node;
                return info.getIcon();
            }
            return super.getIcon(node, expanded, leaf);
        }
    }
}

