/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.lion.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.base64.Base64;
import ch.randelshofer.quaqua.ext.nanoxml.XMLElement;
import ch.randelshofer.quaqua.ext.nanoxml.XMLParseException;
import ch.randelshofer.quaqua.filechooser.FileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.SidebarTreeFileNode;
import ch.randelshofer.quaqua.osx.OSXFile;
import ch.randelshofer.quaqua.util.BinaryPListParser;
import ch.randelshofer.quaqua.util.SequentialDispatcher;
import ch.randelshofer.quaqua.util.Worker;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SidebarTreeModel
extends DefaultTreeModel
implements TreeModelListener {
    private static final File sidebarFile = new File(QuaquaManager.getProperty("user.home"), "Library/Preferences/com.apple.sidebarlists.plist");
    private TreePath volumesPath;
    private TreeModel model;
    private DefaultMutableTreeNode devicesNode;
    private DefaultMutableTreeNode favoritesNode;
    private FileSystemTreeModel.Node computerNode;
    private static final long VALIDATION_TTL = 60000L;
    private long bestBefore;
    private JFileChooser fileChooser;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private HashMap systemItemsMap = new HashMap();
    private static final File[] defaultUserItems;
    private static String favoriteItemsDictionaryName;
    public static final int INVALID = 0;
    public static final int VALIDATING = 1;
    public static final int VALID = 2;
    private int infoState = 0;

    public SidebarTreeModel(JFileChooser fileChooser, TreePath path, TreeModel model) {
        super(new DefaultMutableTreeNode(), true);
        this.fileChooser = fileChooser;
        this.volumesPath = path;
        this.model = model;
        this.computerNode = (FileSystemTreeModel.Node)model.getRoot();
        this.devicesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.devices"));
        this.devicesNode.setAllowsChildren(true);
        this.favoritesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.favorites"));
        this.favoritesNode.setAllowsChildren(true);
        DefaultMutableTreeNode r = (DefaultMutableTreeNode)this.getRoot();
        r.add(this.favoritesNode);
        r.add(this.devicesNode);
        this.validate();
        this.updateDevicesNode();
        model.addTreeModelListener(this);
    }

    public void lazyValidate() {
    }

    public void invokeWhenValid(final Runnable r) {
        if (this.infoState == 2) {
            r.run();
        } else {
            if (this.infoState == 0) {
                this.validate();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SidebarTreeModel.this.invokeWhenValid(r);
                }
            });
        }
    }

    private void validate() {
        if (this.infoState == 0) {
            this.infoState = 1;
            this.bestBefore = Long.MAX_VALUE;
            this.dispatcher.dispatch(new Worker<Object[]>(){

                @Override
                public Object[] construct() throws IOException {
                    return SidebarTreeModel.this.read();
                }

                @Override
                public void done(Object[] value) {
                    SidebarTreeModel.this.systemItemsMap = (HashMap)value[0];
                    ArrayList freshUserItems = (ArrayList)value[1];
                    this.update(freshUserItems);
                }

                @Override
                public void failed(Throwable value) {
                    System.err.println("Warning: SidebarTreeModel uses default user items.");
                    ArrayList<FileNode> freshUserItems = new ArrayList<FileNode>(defaultUserItems.length);
                    for (int i = 0; i < defaultUserItems.length; ++i) {
                        if (defaultUserItems[i] == null) {
                            freshUserItems.add(null);
                            continue;
                        }
                        if (!defaultUserItems[i].exists()) continue;
                        freshUserItems.add(new FileNode(defaultUserItems[i]));
                    }
                    this.update(freshUserItems);
                }

                private void update(ArrayList freshUserItems) {
                    int i;
                    int oldUserItemsSize = SidebarTreeModel.this.favoritesNode.getChildCount();
                    if (oldUserItemsSize > 0) {
                        int[] removedIndices = new int[oldUserItemsSize];
                        Object[] removedChildren = new Object[oldUserItemsSize];
                        for (i = 0; i < oldUserItemsSize; ++i) {
                            removedIndices[i] = i;
                            removedChildren[i] = SidebarTreeModel.this.favoritesNode.getChildAt(i);
                        }
                        SidebarTreeModel.this.favoritesNode.removeAllChildren();
                        SidebarTreeModel.this.fireTreeNodesRemoved(SidebarTreeModel.this, SidebarTreeModel.this.favoritesNode.getPath(), removedIndices, removedChildren);
                    }
                    if (freshUserItems.size() > 0) {
                        int[] insertedIndices = new int[freshUserItems.size()];
                        Object[] insertedChildren = new Object[freshUserItems.size()];
                        for (i = 0; i < freshUserItems.size(); ++i) {
                            insertedIndices[i] = i;
                            insertedChildren[i] = freshUserItems.get(i);
                            if (freshUserItems.get(i) == null) {
                                SidebarTreeModel.this.favoritesNode.add(new DefaultMutableTreeNode("null?"));
                                continue;
                            }
                            SidebarTreeModel.this.favoritesNode.add((DefaultMutableTreeNode)freshUserItems.get(i));
                        }
                        SidebarTreeModel.this.fireTreeNodesInserted(SidebarTreeModel.this, SidebarTreeModel.this.favoritesNode.getPath(), insertedIndices, insertedChildren);
                    }
                }

                @Override
                protected void finished() {
                    SidebarTreeModel.this.validationHasCompleted();
                }
            });
        }
    }

    private void validationHasCompleted() {
        this.bestBefore = System.currentTimeMillis() + 60000L;
        this.infoState = 2;
    }

    private void updateDevicesNode() {
        int i;
        FileSystemTreeModel.Node modelDevicesNode = (FileSystemTreeModel.Node)this.volumesPath.getLastPathComponent();
        FileSystemTreeModel.Node computerNode = this.computerNode;
        SystemItemInfo info = (SystemItemInfo)this.systemItemsMap.get("Computer");
        if (info != null && !info.isVisible) {
            computerNode = null;
        }
        for (i = this.devicesNode.getChildCount() - 1; i >= 0; --i) {
            SidebarViewToModelNode viewNode = (SidebarViewToModelNode)this.devicesNode.getChildAt(i);
            FileSystemTreeModel.Node target = viewNode.getTarget();
            if (target.getParent() == modelDevicesNode || target == computerNode) continue;
            this.removeNodeFromParent(viewNode);
        }
        if (computerNode != null && !this.isInDeviceModel(computerNode) && !this.isInDeviceModel(computerNode)) {
            this.addToDeviceModel(computerNode);
        }
        int n = modelDevicesNode.getChildCount();
        for (i = 0; i < n; ++i) {
            FileSystemTreeModel.Node modelNode = (FileSystemTreeModel.Node)modelDevicesNode.getChildAt(i);
            if (!this.isDevice(modelNode) || this.isInDeviceModel(modelNode)) continue;
            this.addToDeviceModel(modelNode);
        }
        int count = this.devicesNode.getChildCount();
        if (count > 0) {
            int i2;
            SidebarViewToModelNode[] children = new SidebarViewToModelNode[count];
            for (i2 = 0; i2 < count; ++i2) {
                children[i2] = (SidebarViewToModelNode)this.devicesNode.getChildAt(i2);
            }
            Arrays.sort(children, new SideBarViewToModelNodeComparator());
            this.devicesNode.removeAllChildren();
            for (i2 = 0; i2 < count; ++i2) {
                this.devicesNode.add(children[i2]);
            }
        }
        if (this.devicesNode.getChildCount() > 0) {
            int[] childIndices = new int[this.devicesNode.getChildCount()];
            Object[] childNodes = new Object[this.devicesNode.getChildCount()];
            for (int i3 = 0; i3 < childIndices.length; ++i3) {
                childIndices[i3] = i3;
                childNodes[i3] = this.devicesNode.getChildAt(i3);
            }
            this.fireTreeNodesChanged(this, this.devicesNode.getPath(), childIndices, childNodes);
        }
    }

    private boolean isDevice(FileSystemTreeModel.Node modelNode) {
        return !modelNode.isLeaf() && !modelNode.getUserName().equals("Network");
    }

    private boolean isInDeviceModel(FileSystemTreeModel.Node modelNode) {
        int m = this.devicesNode.getChildCount();
        for (int j = 0; j < m; ++j) {
            SidebarViewToModelNode viewNode = (SidebarViewToModelNode)this.devicesNode.getChildAt(j);
            if (viewNode.getTarget() != modelNode) continue;
            return true;
        }
        return false;
    }

    private void addToDeviceModel(FileSystemTreeModel.Node modelNode) {
        SidebarViewToModelNode newNode = new SidebarViewToModelNode(modelNode);
        int insertionIndex = 0;
        this.insertNodeInto(newNode, this.devicesNode, insertionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] read() throws IOException {
        if (!OSXFile.canWorkWithAliases()) {
            throw new IOException("Unable to work with aliases");
        }
        HashMap<String, SystemItemInfo> sysItemsMap = new HashMap<String, SystemItemInfo>();
        ArrayList<Node> userItems = new ArrayList<Node>();
        FileReader reader = null;
        try {
            reader = new FileReader(sidebarFile);
            XMLElement xml = new XMLElement(new HashMap(), false, false);
            try {
                xml.parseFromReader(reader);
            }
            catch (XMLParseException e) {
                xml = new BinaryPListParser().parse(sidebarFile);
            }
            String key2 = "";
            String key3 = "";
            String key5 = "";
            Iterator i0 = xml.iterateChildren();
            while (i0.hasNext()) {
                XMLElement xml1 = (XMLElement)i0.next();
                Iterator i1 = xml1.iterateChildren();
                while (i1.hasNext()) {
                    XMLElement xml4;
                    Iterator i3;
                    XMLElement xml3;
                    Iterator i2;
                    XMLElement xml2 = (XMLElement)i1.next();
                    if (xml2.getName().equals("key")) {
                        key2 = xml2.getContent();
                    }
                    if (xml2.getName().equals("dict") && key2.equals("systemitems")) {
                        i2 = xml2.iterateChildren();
                        while (i2.hasNext()) {
                            xml3 = (XMLElement)i2.next();
                            if (xml3.getName().equals("key")) {
                                key3 = xml3.getContent();
                            }
                            if (!xml3.getName().equals("array") || !key3.equals("VolumesList")) continue;
                            i3 = xml3.iterateChildren();
                            while (i3.hasNext()) {
                                xml4 = (XMLElement)i3.next();
                                if (!xml4.getName().equals("dict")) continue;
                                SystemItemInfo info = new SystemItemInfo();
                                int flags = 0;
                                Iterator i4 = xml4.iterateChildren();
                                while (i4.hasNext()) {
                                    XMLElement xml5 = (XMLElement)i4.next();
                                    if (xml5.getName().equals("key")) {
                                        key5 = xml5.getContent();
                                    }
                                    info.sequenceNumber = sysItemsMap.size();
                                    if (xml5.getName().equals("string") && key5.equals("Name")) {
                                        info.name = xml5.getContent();
                                    }
                                    if (xml5.getName().equals("string") && key5.equals("Visibility")) {
                                        info.isVisible = xml5.getContent().equals("AlwaysVisible");
                                    }
                                    if (!xml5.getName().equals("integer") || !key5.equals("Flags")) continue;
                                    try {
                                        flags = Integer.parseInt(xml5.getContent());
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                                if (info.name == null) continue;
                                if (flags & true) {
                                    info.isVisible = false;
                                }
                                sysItemsMap.put(info.name, info);
                            }
                        }
                    }
                    if (!xml2.getName().equals("dict") || !key2.equals(favoriteItemsDictionaryName)) continue;
                    i2 = xml2.iterateChildren();
                    while (i2.hasNext()) {
                        xml3 = (XMLElement)i2.next();
                        i3 = xml3.iterateChildren();
                        while (i3.hasNext()) {
                            xml4 = (XMLElement)i3.next();
                            String aliasName = null;
                            int entryType = 0;
                            byte[] serializedAlias = null;
                            boolean isVisible = true;
                            Iterator i4 = xml4.iterateChildren();
                            while (i4.hasNext()) {
                                XMLElement xml5 = (XMLElement)i4.next();
                                if (xml5.getName().equals("key")) {
                                    key5 = xml5.getContent();
                                }
                                if (xml5.getName().equals("string") && key5.equals("Name")) {
                                    aliasName = xml5.getContent();
                                }
                                if (!xml5.getName().equals("key") && key5.equals("Alias")) {
                                    serializedAlias = Base64.decode(xml5.getContent());
                                }
                                if (key5.equals("EntryType")) {
                                    try {
                                        entryType = Integer.parseInt(xml5.getContent());
                                    }
                                    catch (NumberFormatException e) {
                                        entryType = 1;
                                    }
                                }
                                if (!key5.equals("Visibility") || xml5.getContent() == null || !xml5.getContent().equals("NeverVisible")) continue;
                                isVisible = false;
                            }
                            if (serializedAlias == null || aliasName == null || entryType != 0 || !isVisible || aliasName.equals("All My Files")) continue;
                            File f = OSXFile.resolveAlias(serializedAlias, true);
                            if (f != null) {
                                userItems.add(new FileNode(f));
                                continue;
                            }
                            userItems.add(new AliasNode(serializedAlias, aliasName));
                        }
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return new Object[]{sysItemsMap, userItems};
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    static {
        favoriteItemsDictionaryName = "favorites";
        if (QuaquaManager.isOSX() || QuaquaManager.getOS() == -3) {
            defaultUserItems = new File[]{new File(QuaquaManager.getProperty("user.home"), "Desktop"), new File(QuaquaManager.getProperty("user.home"), "Documents"), new File(QuaquaManager.getProperty("user.home"))};
            int osVersion = QuaquaManager.getOS();
            if (osVersion >= 9) {
                favoriteItemsDictionaryName = "favoriteitems";
            }
        } else {
            defaultUserItems = QuaquaManager.getOS() == -2 ? new File[]{new File(QuaquaManager.getProperty("user.home"), "Desktop"), new File(QuaquaManager.getProperty("user.home"), "\u684c\u9762"), new File(QuaquaManager.getProperty("user.home"), "My Documents"), new File(QuaquaManager.getProperty("user.home"))} : (QuaquaManager.getOS() == -4 ? new File[]{new File(QuaquaManager.getProperty("user.home"), "Desktop"), new File("/media"), new File(QuaquaManager.getProperty("user.home"), "Documents"), new File(QuaquaManager.getProperty("user.home"))} : new File[]{new File(QuaquaManager.getProperty("user.home"))});
        }
    }

    private class SideBarViewToModelNodeComparator
    implements Comparator<SidebarViewToModelNode> {
        private SideBarViewToModelNodeComparator() {
        }

        @Override
        public int compare(SidebarViewToModelNode n1, SidebarViewToModelNode n2) {
            FileSystemTreeModel.Node o1 = n1.getTarget();
            FileSystemTreeModel.Node o2 = n2.getTarget();
            return this.getSequenceNumber(o1) - this.getSequenceNumber(o2);
        }

        private int getSequenceNumber(FileSystemTreeModel.Node n) {
            if (n == SidebarTreeModel.this.computerNode) {
                return -1;
            }
            SystemItemInfo si = (SystemItemInfo)SidebarTreeModel.this.systemItemsMap.get(n.getUserName());
            return si != null ? si.sequenceNumber : -1;
        }
    }

    private class SidebarViewToModelNode
    extends Node {
        private FileSystemTreeModel.Node target;

        public SidebarViewToModelNode(FileSystemTreeModel.Node target) {
            this.target = target;
        }

        @Override
        public File getResolvedFile() {
            return this.target.getResolvedFile();
        }

        @Override
        public String getUserName() {
            return this.target.getUserName();
        }

        @Override
        public Icon getIcon() {
            return this.target.getIcon();
        }

        public FileSystemTreeModel.Node getTarget() {
            return this.target;
        }

        @Override
        public String toString() {
            return this.target.toString();
        }
    }

    private static class SystemItemInfo {
        String name = "";
        int sequenceNumber = 0;
        boolean isVisible = true;

        private SystemItemInfo() {
        }
    }

    private class AliasNode
    extends Node {
        private byte[] serializedAlias;
        private File file;
        private Icon icon;
        private String userName;
        private String aliasName;
        private boolean isTraversable;
        protected int fileLabel;

        public AliasNode(byte[] serializedAlias, String aliasName) {
            this.fileLabel = -1;
            this.file = null;
            this.aliasName = aliasName;
            this.serializedAlias = serializedAlias;
            this.isTraversable = true;
        }

        @Override
        public File getResolvedFile() {
            if (this.file == null) {
                this.icon = null;
                this.file = OSXFile.resolveAlias(this.serializedAlias, false);
            }
            return this.file;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (this.file != null && !UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(AliasNode.this.file);
                        }

                        @Override
                        public void done(Icon value) {
                            AliasNode.this.icon = value;
                            int[] changedIndices = new int[]{AliasNode.this.getParent().getIndex(AliasNode.this)};
                            Object[] changedChildren = new Object[]{AliasNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, ((DefaultMutableTreeNode)AliasNode.this.getParent()).getPath(), changedIndices, changedChildren);
                        }
                    });
                }
            }
            return this.icon;
        }

        @Override
        public String getUserName() {
            if (this.userName == null && this.file != null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName == null ? this.aliasName : this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        @Override
        public String toString() {
            return this.getUserName();
        }
    }

    private abstract class Node
    extends DefaultMutableTreeNode
    implements SidebarTreeFileNode {
        private Node() {
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }
    }

    private class FileNode
    extends Node {
        private File file;
        private Icon icon;
        private String userName;
        private boolean isTraversable;
        protected int fileLabel = -1;

        public FileNode(File file) {
            this.file = file;
            this.isTraversable = file.isDirectory();
        }

        public File lazyGetResolvedFile() {
            return this.file;
        }

        @Override
        public File getResolvedFile() {
            return this.file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean allowsChildren() {
            return false;
        }

        public String getFileKind() {
            return null;
        }

        public int getFileLabel() {
            return -1;
        }

        public long getFileLength() {
            return -1L;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (!UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(FileNode.this.file);
                        }

                        @Override
                        public void done(Icon value) {
                            FileNode.this.icon = value;
                            int[] changedIndices = new int[]{FileNode.this.getParent().getIndex(FileNode.this)};
                            Object[] changedChildren = new Object[]{FileNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, SidebarTreeModel.this.favoritesNode.getPath(), changedIndices, changedChildren);
                        }
                    });
                }
            }
            return this.icon;
        }

        @Override
        public String getUserName() {
            if (this.userName == null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        public boolean isAcceptable() {
            return true;
        }

        public boolean isValidating() {
            return false;
        }

        @Override
        public String toString() {
            return this.getUserName();
        }
    }
}

