/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.lion.filechooser;

import ch.randelshofer.quaqua.QuaquaNativeButtonBorder;
import ch.randelshofer.quaqua.QuaquaToggleButtonUI;
import ch.randelshofer.quaqua.osx.OSXConfiguration;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class ViewModeControl
extends ch.randelshofer.quaqua.filechooser.ViewModeControl {
    private static Image listViewImage;
    private static Image columnViewImage;
    private ButtonGroup group;
    private JToggleButton listViewButton;
    private JToggleButton columnViewButton;
    private int selectedViewMode = -1;

    public ViewModeControl() {
        this.initComponents();
        this.setFocusable(false);
        this.setSelectedViewMode(2);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.listViewButton.addKeyListener(l);
        this.columnViewButton.addKeyListener(l);
    }

    @Override
    public void setSelectedViewMode(int mode) {
        if (mode != this.selectedViewMode && (mode == 1 || mode == 2)) {
            this.selectedViewMode = mode;
            int count = this.getComponentCount();
            String action = "" + mode;
            for (int i = 0; i < count; ++i) {
                JToggleButton b;
                Component c = this.getComponent(i);
                if (!(c instanceof JToggleButton) || !action.equals((b = (JToggleButton)c).getActionCommand())) continue;
                b.setSelected(true);
            }
            this.selectedViewModeChanged();
        }
    }

    @Override
    public int getSelectedViewMode() {
        return this.selectedViewMode;
    }

    private void initComponents() {
        if (listViewImage == null) {
            listViewImage = Toolkit.getDefaultToolkit().getImage("NSImage://NSListViewTemplate");
        }
        if (columnViewImage == null) {
            columnViewImage = Toolkit.getDefaultToolkit().getImage("NSImage://NSColumnViewTemplate");
        }
        this.group = new ButtonGroup();
        ImageIcon listViewIcon = new ImageIcon(listViewImage);
        ImageIcon columnViewIcon = new ImageIcon(columnViewImage);
        this.listViewButton = this.createButton(listViewIcon, "first", 1);
        this.columnViewButton = this.createButton(columnViewIcon, "last", 2);
        this.add(this.listViewButton);
        this.add(this.columnViewButton);
        this.setLayout(new FlowLayout(1, 0, 0));
    }

    protected JToggleButton createButton(ImageIcon ic, String position, final int viewMode) {
        JToggleButton b = new JToggleButton(ic);
        b.putClientProperty("JButton.buttonType", "segmented");
        b.putClientProperty("JButton.segmentPosition", position);
        b.setUI(new QuaquaToggleButtonUI());
        b.setOpaque(true);
        b.setBorder(new QuaquaNativeButtonBorder());
        b.setFocusable(OSXConfiguration.isFullKeyboardAccess());
        Insets s = position.equals("first") ? new Insets(7, 12, 7, 8) : new Insets(7, 7, 7, 12);
        b.putClientProperty("Quaqua.Border.insets", s);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewModeControl.this.setSelectedViewMode(viewMode);
            }
        });
        b.setActionCommand("" + viewMode);
        this.group.add(b);
        return b;
    }
}

