/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.mavericks.filechooser;

import ch.randelshofer.quaqua.QuaquaTableHeaderUI;
import ch.randelshofer.quaqua.lion.filechooser.ListView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class ListView
extends ch.randelshofer.quaqua.lion.filechooser.ListView {
    protected Border tableHeaderBorder;
    protected Color tableHeaderLineColor = UIManager.getColor("FileChooser.listView.headerBorderColor");

    public ListView(JFileChooser fc) {
        super(fc);
        int columnMargin = this.tableColumnModel.getColumnMargin();
        this.tableHeaderBorder = new EmptyBorder(5, columnMargin / 2, 7, columnMargin / 2);
        this.tree.getTableHeader().setUI(new MyTableHeaderUI());
    }

    @Override
    protected MyTableColumnModel createColumnModel() {
        return new MyTableColumnModel();
    }

    protected class MyTableHeaderUI
    extends QuaquaTableHeaderUI {
        protected MyTableHeaderUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            g.setColor(ListView.this.tableHeaderLineColor);
            g.fillRect(0, c.getHeight() - 2, c.getWidth(), 1);
        }
    }

    protected class MyHeaderRenderer
    extends ListView.MyHeaderRenderer {
        public MyHeaderRenderer(int alignment) {
            super(alignment);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setBorder(ListView.this.tableHeaderBorder);
            return c;
        }
    }

    protected class MyTableColumnModel
    extends ListView.MyTableColumnModel {
        protected MyTableColumnModel() {
        }

        @Override
        protected DefaultTableCellRenderer createHeaderCellRenderer(int align) {
            return new MyHeaderRenderer(align);
        }
    }
}

