/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.mavericks.filechooser;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.filechooser.CellRenderer;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.FileSystemTreeModel;
import ch.randelshofer.quaqua.icon.EmptyIcon;
import ch.randelshofer.quaqua.osx.OSXFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MavericksFileRenderer
extends JLabel
implements ListCellRenderer,
CellRenderer {
    private Color labelForeground;
    private Color labelDisabledForeground;
    private Icon selectedExpandingIcon;
    private Icon selectedExpandedIcon;
    private Icon focusedSelectedExpandingIcon;
    private Icon focusedSelectedExpandedIcon;
    private Icon expandingIcon;
    private Icon expandedIcon;
    private Icon emptyIcon;
    private Icon aliasBadgeIcon;
    private JFileChooser fileChooser;
    private int textIconGap;
    private int textArrowIconGap;
    private Icon icon;
    private String text;
    private Icon arrowIcon;
    private Color labelColor;
    private Color labelBrightColor;
    private boolean isSelected;
    private boolean isActive;
    private boolean isGrayed;
    private boolean isAlias;
    private boolean isListView;
    private double labelRadius = 4.8;
    private static final Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle arrowIconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle labelRect = new Rectangle();
    private static Rectangle r = new Rectangle();

    public MavericksFileRenderer(JFileChooser fileChooser, Icon expandingIcon, Icon expandedIcon, Icon selectedExpandingIcon, Icon selectedExpandedIcon, Icon focusedSelectedExpandingIcon, Icon focusedSelectedExpandedIcon) {
        this.fileChooser = fileChooser;
        this.expandingIcon = expandingIcon;
        this.expandedIcon = expandedIcon;
        this.selectedExpandingIcon = selectedExpandingIcon;
        this.selectedExpandedIcon = selectedExpandedIcon;
        this.focusedSelectedExpandingIcon = focusedSelectedExpandingIcon;
        this.focusedSelectedExpandedIcon = focusedSelectedExpandedIcon;
        this.textIconGap = UIManager.getInt("FileChooser.browserCellTextIconGap");
        this.textArrowIconGap = UIManager.getInt("FileChooser.browserCellTextArrowIconGap");
        this.emptyIcon = new EmptyIcon(expandedIcon.getIconWidth(), expandedIcon.getIconHeight());
        this.aliasBadgeIcon = UIManager.getIcon("FileView.aliasBadgeIcon");
        this.labelForeground = UIManager.getColor("Label.foreground");
        this.labelDisabledForeground = UIManager.getColor("Label.disabledForeground");
        this.setOpaque(true);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return this.getCellRendererComponent(list, value, isSelected, cellHasFocus, false);
    }

    @Override
    public Component getCellRendererComponent(JComponent container, Object value, boolean isSelected, boolean cellHasFocus) {
        return this.getCellRendererComponent(container, value, isSelected, cellHasFocus, true);
    }

    protected Component getCellRendererComponent(JComponent container, Object value, boolean isSelected, boolean cellHasFocus, boolean isListView) {
        this.isListView = isListView;
        if (!(value instanceof FileInfo)) {
            return this;
        }
        FileInfo info = (FileInfo)value;
        this.isGrayed = !info.isAcceptable() && !info.isTraversable();
        this.labelColor = OSXFile.getLabelColor(info.getFileLabel(), this.isGrayed ? 2 : 0);
        this.labelBrightColor = OSXFile.getLabelColor(info.getFileLabel(), this.isGrayed ? 3 : 1);
        this.isSelected = isSelected;
        boolean bl = this.isActive = container.isEnabled() && QuaquaUtilities.isFocused(container);
        if (this.isSelected) {
            if (this.isActive) {
                this.setBackground(UIManager.getColor("Browser.selectionBackground"));
                this.setForeground(UIManager.getColor("Browser.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("Browser.inactiveSelectionBackground"));
                this.setForeground(UIManager.getColor("Browser.inactiveSelectionForeground"));
            }
        } else {
            this.setBackground(container.getBackground());
            this.setForeground(this.isGrayed ? this.labelDisabledForeground : this.labelForeground);
        }
        if (!isListView) {
            boolean useUnselectedArrow = UIManager.getBoolean("FileChooser.browserUseUnselectedExpandIconForLabeledFile");
            if (this.isSelected && (!useUnselectedArrow || this.labelColor == null)) {
                this.arrowIcon = QuaquaUtilities.isFocused(container) ? (info.isValidating() ? this.focusedSelectedExpandingIcon : this.focusedSelectedExpandedIcon) : (info.isValidating() ? this.selectedExpandingIcon : this.selectedExpandedIcon);
            } else {
                Icon icon = this.arrowIcon = info.isValidating() ? this.expandingIcon : this.expandedIcon;
            }
            if (!info.isTraversable() || OSXFile.isVirtualFile(info.lazyGetResolvedFile())) {
                this.arrowIcon = this.labelColor == null ? null : this.emptyIcon;
            }
        } else {
            this.arrowIcon = null;
        }
        this.text = info.getUserName();
        this.icon = info.getIcon();
        this.isAlias = false;
        if (info instanceof FileSystemTreeModel.Node) {
            FileSystemTreeModel.Node n = (FileSystemTreeModel.Node)info;
            this.isAlias = n.isAlias();
        }
        this.setOpaque(!isListView);
        this.setEnabled(container.isEnabled());
        this.setFont(container.getFont());
        this.setBorder(isListView ? null : (cellHasFocus ? UIManager.getBorder(this.isGrayed ? "FileChooser.browserCellFocusBorderGrayed" : "FileChooser.browserCellFocusBorder") : UIManager.getBorder("FileChooser.browserCellBorder")));
        return this;
    }

    @Override
    protected void paintComponent(Graphics gr) {
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)gr);
        Graphics2D g = (Graphics2D)gr;
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, width, height);
        MavericksFileRenderer.viewRect.x += insets.left;
        MavericksFileRenderer.viewRect.y += insets.top;
        MavericksFileRenderer.viewRect.width -= insets.left + insets.right;
        MavericksFileRenderer.viewRect.height -= insets.top + insets.bottom;
        Font textFont = this.getFont();
        g.setFont(textFont);
        FontMetrics textFM = g.getFontMetrics(textFont);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        String clippedText = this.layoutRenderer(textFM, this.text, this.icon, this.arrowIcon, viewRect, iconRect, textRect, arrowIconRect, labelRect, this.text == null ? 0 : this.textIconGap, this.textArrowIconGap);
        if (this.labelColor != null) {
            double r = this.labelRadius;
            Ellipse2D.Double s = new Ellipse2D.Double(MavericksFileRenderer.labelRect.x, MavericksFileRenderer.labelRect.y, r * 2.0, r * 2.0);
            g.setPaint(this.labelColor);
            g.fill(s);
            g.setPaint(this.isSelected && this.isActive ? Color.WHITE : Color.LIGHT_GRAY);
            g.draw(s);
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, g, MavericksFileRenderer.iconRect.x, MavericksFileRenderer.iconRect.y);
        }
        if (this.isAlias && this.aliasBadgeIcon != null) {
            this.aliasBadgeIcon.paintIcon(this, g, MavericksFileRenderer.iconRect.x, MavericksFileRenderer.iconRect.y);
        }
        if (clippedText != null && !clippedText.equals("")) {
            g.setColor(this.getForeground());
            g.drawString(clippedText, MavericksFileRenderer.textRect.x, MavericksFileRenderer.textRect.y + textFM.getAscent());
        }
        if (this.arrowIcon != null) {
            this.arrowIcon.paintIcon(this, g, MavericksFileRenderer.arrowIconRect.x, MavericksFileRenderer.arrowIconRect.y);
        }
        QuaquaUtilities.endGraphics(g, oldHints);
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        labelRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets;
        boolean isUseArrow;
        Font textFont = this.getFont();
        FontMetrics textFM = this.getFontMetrics(textFont);
        this.resetRects();
        this.layoutRenderer(textFM, this.text, this.icon, this.arrowIcon, viewRect, iconRect, textRect, arrowIconRect, labelRect, this.text == null ? 0 : this.textIconGap, this.textArrowIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(MavericksFileRenderer.iconRect.x, MavericksFileRenderer.iconRect.y, MavericksFileRenderer.iconRect.width, MavericksFileRenderer.iconRect.height, r);
        boolean bl = isUseArrow = this.arrowIcon != null;
        if (isUseArrow) {
            MavericksFileRenderer.r.width += MavericksFileRenderer.arrowIconRect.width + this.textArrowIconGap;
        }
        if (this.labelColor != null) {
            MavericksFileRenderer.r.width += MavericksFileRenderer.labelRect.width + this.textArrowIconGap;
        }
        if ((insets = this.getInsets()) != null) {
            MavericksFileRenderer.r.width += insets.left + insets.right;
            MavericksFileRenderer.r.height += insets.top + insets.bottom;
        }
        return r.getSize();
    }

    private String layoutRenderer(FontMetrics textFM, String text, Icon icon, Icon arrowIcon, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle arrowIconRect, Rectangle labelRect, int textIconGap, int textArrowIconGap) {
        boolean isUseArrow;
        boolean bl = isUseArrow = arrowIcon != null;
        if (isUseArrow) {
            arrowIconRect.width = arrowIcon.getIconWidth();
            arrowIconRect.height = arrowIcon.getIconHeight();
            arrowIconRect.x = viewRect.x + viewRect.width - arrowIconRect.width;
            viewRect.width -= arrowIconRect.width + textArrowIconGap;
        }
        if (this.labelColor != null) {
            int d;
            labelRect.width = d = (int)Math.ceil(2.0 * this.labelRadius);
            labelRect.height = d;
            labelRect.x = viewRect.x + viewRect.width - labelRect.width;
            viewRect.width -= labelRect.width + textArrowIconGap;
        }
        text = QuaquaUtilities.layoutCompoundLabel(this, textFM, text, icon, 0, 2, 0, 4, viewRect, iconRect, textRect, textIconGap);
        if (isUseArrow) {
            viewRect.width += arrowIconRect.width + textArrowIconGap;
        }
        if (this.labelColor != null) {
            viewRect.width += labelRect.width + textArrowIconGap;
        }
        Rectangle jLabelRect = iconRect.union(textRect);
        if (isUseArrow) {
            arrowIconRect.y = viewRect.y + jLabelRect.height / 2 - arrowIconRect.height / 2;
        }
        if (this.labelColor != null) {
            labelRect.y = viewRect.y + jLabelRect.height / 2 - labelRect.height / 2;
        }
        if (!QuaquaUtilities.isLeftToRight(this)) {
            int width = viewRect.width;
            iconRect.x = width - (iconRect.x + iconRect.width);
            textRect.x = width - (textRect.x + textRect.width);
            arrowIconRect.x = width - (arrowIconRect.x + arrowIconRect.width);
            labelRect.x = width - (labelRect.x + labelRect.width);
        }
        return text;
    }
}

