/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.mavericks.filechooser;

import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ScaledImageView
extends JComponent {
    private BufferedImage im;

    public void setImage(BufferedImage im) {
        this.im = im;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.im != null) {
            Insets s = this.getInsets();
            int left = s.left;
            int top = s.top;
            int cwidth = this.getWidth() - s.left - s.right;
            int cheight = this.getHeight() - s.top - s.bottom;
            float imwidth = this.im.getWidth();
            float imheight = this.im.getHeight();
            if (imwidth > 0.0f && imheight > 0.0f) {
                int size = Math.min(cwidth, cheight);
                float scale = Math.min((float)cwidth / imwidth, (float)cheight / imheight);
                int extraLeft = (int)Math.max(0.0f, ((float)cwidth - imwidth * scale) / 2.0f);
                int extraTop = (int)Math.max(0.0f, ((float)cheight - imheight * scale) / 2.0f);
                g.drawImage(this.im, left + extraLeft, top + extraTop, size, size, null);
            }
        }
        QuaquaUtilities.endGraphics(g, oldHints);
    }
}

