/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.osx.OSXPreferences;

public class OSXConfiguration {
    private static boolean isRequestFocusEnabled;
    private static boolean isFullKeyboardAccess;
    private static boolean isFileHidingEnabled;
    private static boolean isQuickLookEnabled;
    private static boolean isInitialized;

    public static boolean isRequestFocusEnabled() {
        OSXConfiguration.ensureInitialized();
        return isRequestFocusEnabled;
    }

    public static boolean isFullKeyboardAccess() {
        OSXConfiguration.ensureInitialized();
        return isFullKeyboardAccess;
    }

    public static boolean isFileHidingEnabled() {
        OSXConfiguration.ensureInitialized();
        return isFileHidingEnabled;
    }

    public static boolean isIsQuickLookEnabled() {
        OSXConfiguration.ensureInitialized();
        return isQuickLookEnabled;
    }

    private static void ensureInitialized() {
        int intValue;
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        String prefValue = QuaquaManager.getProperty("Quaqua.requestFocusEnabled", "false");
        isRequestFocusEnabled = Boolean.valueOf(prefValue);
        prefValue = OSXPreferences.getString(OSXPreferences.GLOBAL_PREFERENCES, "AppleKeyboardUIMode", "0");
        try {
            intValue = Integer.valueOf(prefValue);
        }
        catch (NumberFormatException e) {
            intValue = 0;
        }
        isFullKeyboardAccess = isRequestFocusEnabled || (intValue & 2) == 2;
        prefValue = OSXPreferences.getString(OSXPreferences.FINDER_PREFERENCES, "AppleShowAllFiles", "false").toLowerCase();
        isFileHidingEnabled = prefValue.equals("false") || prefValue.equals("no");
        isQuickLookEnabled = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.FileChooser.quickLookEnabled", "true"));
    }
}

