/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFImageDecoder;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.ImageDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.MemoryCacheSeekableStream;
import ch.randelshofer.quaqua.osx.JNILoader;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class OSXFile {
    public static final int FILE_TYPE_ALIAS = 2;
    public static final int FILE_TYPE_DIRECTORY = 1;
    public static final int FILE_TYPE_FILE = 0;
    public static final int FILE_TYPE_UNKNOWN = -1;
    private static final int EXPECTED_NATIVE_CODE_VERSION = 6;
    private static volatile Color[][] labelColors;
    private static volatile Boolean isNativeCodeAvailable;
    private static Icon computerIcon;
    private static String computerModel;
    private static boolean computerModelInitialized;
    private static Icon computerSidebarIcon;
    private static final int kLSItemInfoIsPlainFile = 1;
    private static final int kLSItemInfoIsPackage = 2;
    private static final int kLSItemInfoIsApplication = 4;
    private static final int kLSItemInfoIsContainer = 8;
    private static final int kLSItemInfoIsAliasFile = 16;
    private static final int kLSItemInfoIsSymlink = 32;
    private static final int kLSItemInfoIsInvisible = 64;
    private static final int kLSItemInfoIsNativeApp = 128;
    private static final int kLSItemInfoIsClassicApp = 256;
    private static final int kLSItemInfoAppPrefersNative = 512;
    private static final int kLSItemInfoAppPrefersClassic = 1024;
    private static final int kLSItemInfoAppIsScriptable = 2048;
    private static final int kLSItemInfoIsVolume = 4096;
    private static final int kLSItemInfoExtensionIsHidden = 0x100000;
    private static String[] nonTraversableDirectories;
    private static String computerName;
    private static boolean haveFetchedComputerName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final boolean isNativeCodeAvailable() {
        if (isNativeCodeAvailable == null) {
            block18: {
                Class<OSXFile> clazz = OSXFile.class;
                // MONITORENTER : ch.randelshofer.quaqua.osx.OSXFile.class
                if (isNativeCodeAvailable == null) {
                    boolean success = false;
                    try {
                        String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
                        if (value == null) {
                            value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
                        }
                        String libraryName = null;
                        if (value != null && value.equals("true")) {
                            success = true;
                        } else {
                            String osArch = System.getProperty("os.arch");
                            String[] libraryNames = osArch.equals("x86_64") ? new String[]{"quaqua64"} : new String[]{"quaqua64", "quaqua"};
                            for (int i = 0; i < libraryNames.length; ++i) {
                                libraryName = libraryNames[i];
                                try {
                                    JNILoader.loadLibrary(libraryName);
                                    success = true;
                                    break;
                                }
                                catch (UnsatisfiedLinkError e) {
                                    System.err.println("Warning: " + OSXFile.class + " couldn't load library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                    success = false;
                                    continue;
                                }
                                catch (AccessControlException e) {
                                    System.err.println("Warning: " + OSXFile.class + " access controller denied loading library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                    success = false;
                                    continue;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    System.err.println("Warning: " + OSXFile.class + " couldn't load library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                    success = false;
                                }
                            }
                        }
                        if (!success) break block18;
                        try {
                            int nativeCodeVersion = OSXFile.nativeGetNativeCodeVersion();
                            if (nativeCodeVersion != 6) {
                                System.err.println("Warning: " + OSXFile.class + " can't use library " + libraryName + ". It has version " + nativeCodeVersion + " instead of " + 6);
                                success = false;
                            }
                        }
                        catch (UnsatisfiedLinkError e) {
                            System.err.println("Warning: " + OSXFile.class + " could load library " + libraryName + " but can't use it. " + e);
                            success = false;
                        }
                    }
                    finally {
                        isNativeCodeAvailable = success;
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (isNativeCodeAvailable != Boolean.TRUE) return false;
        return true;
    }

    private OSXFile() {
    }

    public static File getAbsoluteFile(File f) {
        if (!f.isAbsolute()) {
            f = new File(QuaquaManager.getProperty("user.home") + File.separatorChar + f.getPath());
        }
        if (File.separatorChar == '\\') {
            return f;
        }
        StringBuffer buf = new StringBuffer(f.getPath().length());
        int skip = 0;
        for (File i = f; i != null; i = i.getParentFile()) {
            String name = i.getName();
            if (name.equals(".")) {
                if (skip <= 0) continue;
                --skip;
                continue;
            }
            if (name.equals("..")) {
                ++skip;
                continue;
            }
            if (skip > 0) {
                --skip;
                continue;
            }
            buf.insert(0, name);
            buf.insert(0, File.separatorChar);
        }
        return f.getPath().equals(buf.toString()) ? f : new File(buf.toString());
    }

    public static boolean canWorkWithAliases() {
        return OSXFile.isNativeCodeAvailable();
    }

    public static int getFileType(File f) {
        if (OSXFile.isNativeCodeAvailable()) {
            int flags = OSXFile.nativeGetBasicItemInfoFlags(f.getAbsolutePath());
            if ((flags & 0x10) != 0) {
                if (f.getParent().equals("/Volumes")) {
                    return 1;
                }
                return 2;
            }
            if ((flags & 8) != 0) {
                return 1;
            }
            if ((flags & 1) != 0) {
                return 0;
            }
            return -1;
        }
        return f.isDirectory() ? 1 : (f.isFile() ? 0 : -1);
    }

    public static File resolvePath(String path, File currentDirectory) {
        if (path.startsWith("/")) {
            return new File(path);
        }
        if (path.startsWith("~")) {
            if ((path = path.substring(1)).startsWith("/")) {
                String home = System.getProperty("user.home");
                return new File(home + path);
            }
            if (path.isEmpty()) {
                String home = System.getProperty("user.home");
                return new File(home);
            }
            return new File("/Users/" + path);
        }
        if (currentDirectory == null) {
            String home = System.getProperty("user.home");
            currentDirectory = new File(home);
        }
        return new File(currentDirectory, path);
    }

    public static File resolve(File f) {
        return OSXFile.resolveAlias(f, true);
    }

    public static File resolveAlias(File f, boolean noUI) {
        if (OSXFile.isNativeCodeAvailable()) {
            String path = OSXFile.nativeResolveAlias(f.getAbsolutePath(), noUI);
            if (path == null) {
                return null;
            }
            f = new File(path);
            if (OSXFile.getFileType(f) != 2) {
                return f;
            }
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ex) {
            return f;
        }
    }

    public static File resolveAlias(byte[] serializedAlias, boolean noUI) {
        if (OSXFile.isNativeCodeAvailable()) {
            String path = OSXFile.nativeResolveAlias(serializedAlias, noUI);
            return path == null ? null : new File(path);
        }
        return null;
    }

    public static boolean canWorkWithLabels() {
        return OSXFile.isNativeCodeAvailable();
    }

    public static int getLabel(File f) {
        if (OSXFile.isNativeCodeAvailable() && f != null) {
            return OSXFile.nativeGetLabel(f.getAbsolutePath());
        }
        return -1;
    }

    public static String[] getTagNames(File f) {
        String[] result = null;
        if (OSXFile.isNativeCodeAvailable() && f != null) {
            result = OSXFile.nativeGetTagNames(f.getAbsolutePath());
        }
        return result == null ? new String[]{} : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Color getLabelColor(int label, int type) {
        if (labelColors == null) {
            Class<OSXFile> clazz = OSXFile.class;
            // MONITORENTER : ch.randelshofer.quaqua.osx.OSXFile.class
            if (labelColors == null) {
                labelColors = QuaquaManager.getDesign() <= 5 ? new Color[][]{{null, null, null, null}, {new Color(0xB5B5B5), new Color(0xD7D7D7), new Color(0xE9E9E9), new Color(0xF3F3F3)}, {new Color(12442714), new Color(14478762), new Color(15529422), new Color(16120550)}, {new Color(13344222), new Color(14928878), new Color(15786742), new Color(16249082)}, {new Color(6730239), new Color(11983615), new Color(13756671), new Color(15332607)}, {new Color(15916890), new Color(16512170), new Color(16578254), new Color(16710886)}, {new Color(16741740), new Color(16757420), new Color(16766675), new Color(16771302)}, {new Color(16430421), new Color(16570018), new Color(16705996), new Color(0xFFF3E3)}} : new Color[][]{{null, null, null, null}, {new Color(0xB7B7B7), new Color(0xD8D8D8), new Color(0xE9E9E9), new Color(0xF3F3F3)}, {new Color(12704094), new Color(14609324), new Color(15529422), new Color(16120550)}, {new Color(13345759), new Color(15191534), new Color(15786742), new Color(16249082)}, {new Color(7190013), new Color(12114942), new Color(13756671), new Color(15332607)}, {new Color(15916384), new Color(16511660), new Color(16578254), new Color(16710886)}, {new Color(16480880), new Color(16561325), new Color(16766675), new Color(16771302)}, {new Color(16234075), new Color(16504484), new Color(16705996), new Color(0xFFF3E3)}};
            }
            // MONITOREXIT : clazz
        }
        if (label == -1) {
            return null;
        }
        Color color = labelColors[label][type];
        return color;
    }

    public static Color getTagColor(String tagName, int type) {
        int label = 0;
        if ("Gray".equals(tagName)) {
            label = 1;
        } else if ("Green".equals(tagName)) {
            label = 2;
        } else if ("Purple".equals(tagName)) {
            label = 3;
        } else if ("Blue".equals(tagName)) {
            label = 4;
        } else if ("Yellow".equals(tagName)) {
            label = 5;
        } else if ("Red".equals(tagName)) {
            label = 6;
        } else if ("Orange".equals(tagName)) {
            label = 7;
        }
        return OSXFile.getLabelColor(label, type);
    }

    public static BufferedImage getIconImage(File file, int size) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            try {
                BufferedImage image;
                byte[] tiffData = OSXFile.nativeGetIconImage(file.getAbsolutePath(), size);
                if (tiffData == null) {
                    return null;
                }
                TIFFImageDecoder decoder = new TIFFImageDecoder(new MemoryCacheSeekableStream(new ByteArrayInputStream(tiffData)), (ImageDecodeParam)new TIFFDecodeParam());
                RenderedImage rImg = decoder.decodeAsRenderedImage(0);
                if (rImg instanceof BufferedImage) {
                    image = (BufferedImage)rImg;
                } else {
                    Raster r = rImg.getData();
                    WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
                    rImg.copyData(wr);
                    image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
                }
                if (image.getWidth() != size) {
                    image = Images.toBufferedImage(image.getScaledInstance(size, size, 4));
                }
                return image;
            }
            catch (IOException ex) {
                System.err.println("Image decoder failed: " + ex.getMessage());
                return null;
            }
        }
        return null;
    }

    public static BufferedImage getQuickLookThumbnailImage(File file, int size) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            try {
                BufferedImage image;
                byte[] tiffData = OSXFile.nativeGetQuickLookThumbnailImage(file.getAbsolutePath(), size);
                if (tiffData == null) {
                    return null;
                }
                TIFFImageDecoder decoder = new TIFFImageDecoder(new MemoryCacheSeekableStream(new ByteArrayInputStream(tiffData)), (ImageDecodeParam)new TIFFDecodeParam());
                RenderedImage rImg = decoder.decodeAsRenderedImage(0);
                if (rImg instanceof BufferedImage) {
                    image = (BufferedImage)rImg;
                } else {
                    Raster r = rImg.getData();
                    WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
                    rImg.copyData(wr);
                    image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
                }
                return image;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public static Icon getIcon(File file, int size) {
        BufferedImage img = OSXFile.getIconImage(file, size);
        if (img == null) {
            System.err.println("Unable to get system icon for " + file);
        }
        return img == null ? UIManager.getIcon("FileView.fileIcon") : new ImageIcon(img);
    }

    public static Icon getQuickLookThumbnail(File file, int size) {
        return new ImageIcon(OSXFile.getQuickLookThumbnailImage(file, size));
    }

    public static String getKindString(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            return OSXFile.nativeGetKindString(file.getAbsolutePath());
        }
        return null;
    }

    public static boolean isVirtualFile(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            int flags = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            return (flags & 2) != 0;
        }
        return false;
    }

    public static boolean isInvisible(File file) {
        if (file != null) {
            if (OSXFile.isNativeCodeAvailable()) {
                int flags = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
                return (flags & 0x40) != 0;
            }
            return file.isHidden();
        }
        return false;
    }

    public static boolean isTraversable(File file) {
        return OSXFile.isTraversable(file, false, false);
    }

    public static boolean isTraversable(File file, boolean isPackageTraversable, boolean isApplicationTraversable) {
        if (file == null) {
            return false;
        }
        if (OSXFile.isNativeCodeAvailable()) {
            int flags = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            if ((flags & 0x10) != 0) {
                file = OSXFile.resolve(file);
                flags = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            }
            if ((flags & 9) == 8) {
                boolean isApplication;
                boolean isPackage = (flags & 2) != 0;
                boolean bl = isApplication = (flags & 4) != 0;
                if (isApplication) {
                    return isApplicationTraversable;
                }
                if (isPackage) {
                    return isPackageTraversable;
                }
                return OSXFile.basicIsTraversable(file);
            }
            if ((flags & 1) != 0) {
                return OSXFile.basicIsTraversable(file);
            }
            return OSXFile.isVolumes(file.getParent());
        }
        return OSXFile.basicIsTraversable(file);
    }

    private static boolean isVolumes(String s) {
        return s != null && s.equals("/Volumes");
    }

    private static boolean basicIsTraversable(File f) {
        String name = f.getName();
        if (f.isDirectory()) {
            for (String s : nonTraversableDirectories) {
                if (!s.equals(name)) continue;
                return false;
            }
            return true;
        }
        return OSXFile.isSavedSearch(f);
    }

    public static boolean isSavedSearch(File f) {
        return f.getName().endsWith(".savedSearch");
    }

    public static Icon getComputerIcon() {
        if (computerIcon == null) {
            String model = OSXFile.getComputerModel();
            if (model != null) {
                if (model.startsWith("MacBookAir")) {
                    computerIcon = UIManager.getIcon("FileView.macbookAirIcon");
                } else if (model.startsWith("MacBookPro")) {
                    computerIcon = UIManager.getIcon("FileView.macbookProIcon");
                } else if (model.startsWith("MacBook")) {
                    computerIcon = UIManager.getIcon("FileView.macbookIcon");
                } else if (model.startsWith("MacPro")) {
                    computerIcon = UIManager.getIcon("FileView.macproIcon");
                } else if (model.startsWith("Macmini")) {
                    computerIcon = UIManager.getIcon("FileView.macminiIcon");
                } else if (model.startsWith("iMac")) {
                    computerIcon = UIManager.getIcon("FileView.imacIcon");
                }
            }
            if (computerIcon == null) {
                computerIcon = UIManager.getIcon("FileView.imacIcon");
            }
            if (computerIcon == null) {
                computerIcon = UIManager.getIcon("FileView.computerIcon");
            }
        }
        return computerIcon;
    }

    public static Icon getSidebarComputerIcon() {
        if (computerSidebarIcon == null) {
            String model = OSXFile.getComputerModel();
            if (model != null) {
                if (model.startsWith("MacBook")) {
                    computerSidebarIcon = UIManager.getIcon("FileChooser.sideBarIcon.Laptop");
                } else if (model.startsWith("MacPro")) {
                    computerSidebarIcon = UIManager.getIcon("FileChooser.sideBarIcon.MacPro");
                } else if (model.startsWith("Macmini")) {
                    computerSidebarIcon = UIManager.getIcon("FileChooser.sideBarIcon.MacMini");
                }
            }
            if (computerSidebarIcon == null) {
                computerSidebarIcon = UIManager.getIcon("FileChooser.sideBarIcon.Imac");
            }
        }
        return computerSidebarIcon;
    }

    private static String getComputerModel() {
        if (!computerModelInitialized) {
            computerModelInitialized = true;
            String[] cmd = new String[]{"/usr/sbin/sysctl", "hw.model"};
            Charset cs = Charset.forName("UTF-8");
            String result = QuaquaUtilities.exec(cmd, cs);
            if (result != null) {
                int pos = result.indexOf(":");
                computerModel = result.substring(pos + 1).trim();
            }
        }
        return computerModel;
    }

    private static native int nativeGetFileType(String var0);

    private static native String nativeResolveAlias(String var0, boolean var1);

    private static native String nativeResolveAlias(byte[] var0, boolean var1);

    private static native int nativeGetLabel(String var0);

    private static native String[] nativeGetTagNames(String var0);

    private static native String nativeGetKindString(String var0);

    private static native byte[] nativeGetIconImage(String var0, int var1);

    private static native byte[] nativeGetQuickLookThumbnailImage(String var0, int var1);

    private static native int nativeGetBasicItemInfoFlags(String var0);

    public static String getComputerName() {
        if (!haveFetchedComputerName) {
            haveFetchedComputerName = true;
            String[] cmd = new String[]{"/usr/sbin/scutil", "--get", "ComputerName"};
            Charset cs = Charset.forName("UTF-8");
            computerName = QuaquaUtilities.exec(cmd, cs).trim();
        }
        return computerName;
    }

    public static String getDisplayName(File f) {
        if (OSXFile.isNativeCodeAvailable()) {
            return OSXFile.nativeGetDisplayName(f.getAbsolutePath());
        }
        return f.getName();
    }

    public static Date getLastUsedDate(File f) {
        long t = OSXFile.nativeGetLastUsedDate(f.getAbsolutePath());
        return t > 0L ? new Date(t) : null;
    }

    public static File[] executedSavedSearch(File savedSearchFile) {
        String savedSearchPath = savedSearchFile.getAbsolutePath();
        String[] paths = OSXFile.nativeExecuteSavedSearch(savedSearchPath);
        if (paths != null) {
            int count = paths.length;
            File[] files = new File[count];
            for (int i = 0; i < count; ++i) {
                files[i] = new File(paths[i]);
            }
            return files;
        }
        return null;
    }

    private static native String nativeGetDisplayName(String var0);

    private static native long nativeGetLastUsedDate(String var0);

    private static native String[] nativeExecuteSavedSearch(String var0);

    private static native int nativeGetNativeCodeVersion();

    static {
        nonTraversableDirectories = new String[]{".Spotlight-V100", ".DocumentRevisions", ".Trashes"};
    }
}

