/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.subset;

import ch.randelshofer.quaqua.LookAndFeelProxy;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.color.AlphaColorUIResource;
import ch.randelshofer.quaqua.color.GradientColor;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.osx.OSXConfiguration;
import ch.randelshofer.quaqua.osx.OSXPreferences;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;

public class Quaqua16LionFileChooserLAF
extends LookAndFeelProxy {
    protected static final String commonDir = "/ch/randelshofer/quaqua/images/";
    protected static final String leopardDir = "/ch/randelshofer/quaqua/leopard/images/";
    protected static final String snowLeopardDir = "/ch/randelshofer/quaqua/snowleopard/images/";
    protected static final String lionDir = "/ch/randelshofer/quaqua/lion/images/";
    private UIDefaults myDefaults;

    public Quaqua16LionFileChooserLAF() {
        String targetClassName = "apple.laf.AquaLookAndFeel";
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instantiate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    @Override
    public String getDescription() {
        return "The Quaqua Lion FileChooser Look and Feel for Java 1.6";
    }

    @Override
    public String getName() {
        return "Quaqua Lion FileChooser-only LAF";
    }

    @Override
    public void initialize() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Quaqua16LionFileChooserLAF.this.target.initialize();
                Quaqua16LionFileChooserLAF.this.myDefaults = Quaqua16LionFileChooserLAF.this.target.getDefaults();
                Quaqua16LionFileChooserLAF.this.initResourceBundle(Quaqua16LionFileChooserLAF.this.myDefaults);
                Quaqua16LionFileChooserLAF.this.initClassDefaults(Quaqua16LionFileChooserLAF.this.myDefaults);
                Quaqua16LionFileChooserLAF.this.initFontDefaults(Quaqua16LionFileChooserLAF.this.myDefaults);
                Quaqua16LionFileChooserLAF.this.initGeneralDefaults(Quaqua16LionFileChooserLAF.this.myDefaults);
                Quaqua16LionFileChooserLAF.this.initComponentDefaults(Quaqua16LionFileChooserLAF.this.myDefaults);
                return null;
            }
        });
    }

    @Override
    public UIDefaults getDefaults() {
        return this.myDefaults;
    }

    protected void initResourceBundle(UIDefaults table) {
        ResourceBundle bundle = ResourceBundle.getBundle("ch.randelshofer.quaqua.Labels", Locale.getDefault(), this.getClass().getClassLoader());
        Enumeration<String> i = bundle.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            table.put(key, bundle.getObject(key));
        }
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaLionPrefix = "ch.randelshofer.quaqua.lion.QuaquaLion";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "FileChooserUI", quaquaLionPrefix + "FileChooserUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initGeneralDefaults(UIDefaults table) {
        Object[] uiDefaults = new Object[]{"ClassLoader", this.getClass().getClassLoader()};
        table.putDefaults(uiDefaults);
    }

    protected Font getBaseSystemFont() {
        return new Font("Lucida Grande", 0, 13);
    }

    protected void initFontDefaults(UIDefaults table) {
        Font baseSystemFont = this.getBaseSystemFont();
        float fourteen = 14.0f;
        float thirteen = 13.0f;
        float twelve = 12.0f;
        float eleven = 11.0f;
        float ten = 11.0f;
        float nine = 9.0f;
        int fontPlain = 0;
        int fontBold = 1;
        UIDefaults.ProxyLazyValue systemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, thirteen)});
        UIDefaults.ProxyLazyValue emphasizedSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, thirteen)});
        UIDefaults.ProxyLazyValue smallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, eleven)});
        UIDefaults.ProxyLazyValue emphasizedSmallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, eleven)});
        UIDefaults.ProxyLazyValue miniSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, nine)});
        Object applicationFont = baseSystemFont;
        UIDefaults.ProxyLazyValue labelFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, ten)});
        UIDefaults.ProxyLazyValue viewFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, twelve)});
        UIDefaults.ProxyLazyValue menuFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, fourteen)});
        if (QuaquaManager.getProperty("Quaqua.sizeStyle", "regular").equals("small")) {
            viewFont = smallSystemFont;
            systemFont = smallSystemFont;
            emphasizedSystemFont = emphasizedSmallSystemFont;
            menuFont = smallSystemFont;
            applicationFont = smallSystemFont;
        }
        Object[] uiDefaults = new Object[]{"SystemFont", systemFont, "EmphasizedSystemFont", emphasizedSystemFont, "SmallSystemFont", smallSystemFont, "EmphasizedSmallSystemFont", emphasizedSmallSystemFont, "MiniSystemFont", miniSystemFont, "EmphasizedMiniSystemFont", miniSystemFont, "ApplicationFont", applicationFont, "LabelFont", labelFont, "ViewFont", viewFont, "MenuFont", menuFont, "Browser.font", viewFont, "Button.font", systemFont, "Button.smallFont", smallSystemFont, "FileChooser.previewLabelFont", smallSystemFont, "FileChooser.previewValueFont", smallSystemFont};
        this.putDefaults(table, uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        boolean isOrderFilesByType = false;
        String prefValue = OSXPreferences.getString(OSXPreferences.FINDER_PREFERENCES, "AppleShowAllFiles", "false").toLowerCase();
        boolean isFileHidingEnabled = prefValue.equals("false") || prefValue.equals("no");
        boolean isQuickLookEnabled = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.FileChooser.quickLookEnabled", "true"));
        Color grayedFocusCellBorderColor = new Color(-12552236);
        ColorUIResource menuSelectionForeground = new ColorUIResource(0xFFFFFF);
        ColorUIResource listAlternateBackground = new ColorUIResource(15988474);
        InactivatableColorUIResource listSelectionBackground = new InactivatableColorUIResource(4224980, 0xD0D0D0);
        String sideBarIconsPrefix = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/Sidebar";
        ColorUIResource sideBarIconColor = new ColorUIResource(125, 134, 147);
        ColorUIResource sideBarIconSelectionColor = new ColorUIResource(0xFFFFFF);
        BorderUIResource.CompoundBorderUIResource browserCellBorder = new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, new ColorUIResource(0xFFFFFF)), new BorderUIResource.EmptyBorderUIResource(0, 4, 1, 0));
        String iconPrefix = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/";
        Boolean isRequestFocusEnabled = OSXConfiguration.isRequestFocusEnabled();
        Boolean allControlsFocusable = OSXConfiguration.isFullKeyboardAccess();
        UIDefaults.ProxyLazyValue textFieldFocusHandler = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaTextFieldFocusHandler");
        Object[] uiDefaults = new Object[]{"Component.visualMargin", new InsetsUIResource(3, 3, 3, 3), "Browser.expandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/lion/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 0}), "Browser.expandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/lion/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 1}), "Browser.focusedSelectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/lion/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 2}), "Browser.focusedSelectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/lion/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 3}), "Browser.selectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/lion/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 4}), "Browser.selectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/lion/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 5}), "Browser.selectionBackground", new ColorUIResource(56, 117, 215), "Browser.selectionForeground", new ColorUIResource(255, 255, 255), "Browser.inactiveSelectionBackground", new ColorUIResource(208, 208, 208), "Browser.inactiveSelectionForeground", new ColorUIResource(0, 0, 0), "Browser.sizeHandleIcon", Quaqua16LionFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/lion/images/Browser.sizeHandleIcon.png"), "Button.focusable", allControlsFocusable, "ComboBox.buttonBorder", this.makeNativeButtonStateBorder(OSXAquaPainter.Widget.buttonComboBox, new Insets(0, -10, 0, -2), new Insets(0, 0, 0, 0), true), "ComboBox.cellAndButtonBorder", this.makeNativeButtonStateBorder(OSXAquaPainter.Widget.buttonPopUp, new Insets(1, 1, 0, 0), new Insets(3, 3, 3, 3), true), "ComboBox.buttonInsets", new Insets(-3, -3, -3, -3), "ComboBox.dropDownIcon", null, "ComboBox.dropDownWidth", 18, "ComboBox.selectionBackground", new GradientColor(new ColorUIResource(3700183), new ColorUIResource(5337334), new ColorUIResource(1721331)), "ComboBox.selectionForeground", menuSelectionForeground, "ComboBox.popupBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.leopard.QuaquaLeopardComboBoxPopupBorder"), "ComboBox.maximumRowCount", 10, "ComboBox.arrowButtonInsets", new InsetsUIResource(4, 8, 3, 5), "ComboBox.smallArrowButtonInsets", new InsetsUIResource(4, 6, 3, 5), "ComboBox.miniArrowButtonInsets", new InsetsUIResource(4, 3, 3, 5), "ComboBox.focusable", allControlsFocusable, "FileChooser.autovalidate", Boolean.TRUE, "FileChooser.enforceQuaquaTreeUI", Boolean.TRUE, "FileChooser.fileHidingEnabled", isFileHidingEnabled, "FileChooser.quickLookEnabled", isQuickLookEnabled, "FileChooser.orderByType", isOrderFilesByType, "FileChooser.previewLabelForeground", new ColorUIResource(0x6D6D6D), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 4), "FileChooser.previewLabelDelimiter", "", "FileChooser.cellTipOrigin", new Point(18, 1), "FileChooser.splitPaneDividerSize", 1, "FileChooser.splitPaneBackground", new ColorUIResource(0xA5A5A5), "FileChooser.browserCellFocusBorder", browserCellBorder, "FileChooser.browserCellFocusBorderGrayed", browserCellBorder, "FileChooser.browserCellBorder", browserCellBorder, "FileChooser.browserUseUnselectedExpandIconForLabeledFile", Boolean.FALSE, "FileChooser.browserCellColorLabelInsets", new InsetsUIResource(0, 1, -1, 1), "FileChooser.browserCellSelectedColorLabelInsets", new InsetsUIResource(1, 0, 0, 0), "FileChooser.browserCellTextIconGap", 6, "FileChooser.browserCellTextArrowIconGap", 5, "FileChooser.browserUseUnselectedExpandIconForLabeledFile", Boolean.TRUE, "FileChooser.sheetErrorFont", new FontUIResource("Lucida Grande", 0, 10), "FileChooser.sideBarIcon.Applications", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "ApplicationsFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Desktop", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "DesktopFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Documents", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "DocumentsFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Downloads", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "DownloadsFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Dropbox", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "DropBoxFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Home", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "HomeFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Library", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "GenericFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Movies", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "MoviesFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Music", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "MusicFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Network", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "Network.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Pictures", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "PicturesFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Public", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "DropBoxFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Shared", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "GenericFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Sites", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "GenericFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Utilities", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "UtilitiesFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.GenericFolder", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "GenericFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.GenericFile", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "GenericFile.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.GenericVolume", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "InternalDisk.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.SmartFolder", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "SmartFolder.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.TimeMachineVolume", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "TimeMachine.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Imac", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "iMac.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.MacPro", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "MacPro.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.MacMini", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "MacMini.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarIcon.Laptop", Quaqua16LionFileChooserLAF.makeNativeSidebarIcon(sideBarIconsPrefix + "Laptop.icns", 18, sideBarIconColor, sideBarIconSelectionColor), "FileChooser.sideBarRowHeight", 24, "FileView.computerIcon", Quaqua16LionFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/snowleopard/images/FileView.computerIcon.png"), "FileView.fileIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "GenericDocumentIcon.icns", 16), "FileView.directoryIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "GenericFolderIcon.icns", 16), "FileView.hardDriveIcon", Quaqua16LionFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/snowleopard/images/FileView.hardDriveIcon.png"), "FileView.floppyDriveIcon", Quaqua16LionFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/snowleopard/images/FileView.floppyDriveIcon.png"), "FileView.aliasBadgeIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "AliasBadgeIcon.icns", 16), "FileView.networkIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "GenericNetworkIcon.icns", 16), "FileView.macbookIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "com.apple.macbook-white.icns", 16), "FileView.macbookAirIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "com.apple.macbookair-13-unibody.icns", 16), "FileView.macbookProIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "com.apple.macbookpro-13-unibody.icns", 16), "FileView.macproIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "com.apple.macpro.icns", 16), "FileView.macminiIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "com.apple.macmini-unibody-no-optical.icns", 16), "FileView.imacIcon", Quaqua16LionFileChooserLAF.makeNativeIcon(iconPrefix + "com.apple.imac-unibody-21.icns", 16), "FileChooser.browserFocusCellHighlightBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{new Insets(1, 1, 1, 1)}), "FileChooser.browserFocusCellHighlightBorderGrayed", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new Object[]{1, 1, 1, 1, grayedFocusCellBorderColor}), "Label.embossForeground", new AlphaColorUIResource(0x7EFFFFFF), "Label.shadowForeground", new AlphaColorUIResource(0x7E000000), "List.alternateBackground.0", listAlternateBackground, "Sheet.showAsSheet", Boolean.TRUE, "Table.alternateBackground.0", listAlternateBackground, "Table.selectionBackground", listSelectionBackground, "TextField.borderInsets", new InsetsUIResource(3, 6, 3, 6), "TextField.focusHandler", textFieldFocusHandler, "ToggleButton.focusable", allControlsFocusable, "Tree.alternateBackground.0", listAlternateBackground, "Tree.openIcon", Quaqua16LionFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.openIcon.png"), "Tree.closedIcon", Quaqua16LionFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.closedIcon.png"), "Tree.sideBar.background", new InactivatableColorUIResource(new GradientColor(15265009, 15265009, 14344166), new GradientColor(0xF7F7F7, 0xF7F7F7, 0xEEEEEE)), "Tree.sideBar.selectionBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.lion.QuaquaLionSideBarSelectionBorder"), "Tree.leftChildIndent", 8, "Tree.rightChildIndent", 12, "Tree.icons", this.makeIcons("/ch/randelshofer/quaqua/lion/images/Tree.icons.png", 15, true), "Tree.sideBar.icons", this.makeIcons("/ch/randelshofer/quaqua/lion/images/Tree.sideBar.icons.png", 15, true), "Tree.sideBarCategory.foreground", new InactivatableColorUIResource(7372427, 8817554), "Tree.sideBarCategory.selectionForeground", new InactivatableColorUIResource(0xFFFFFF, 0xFFFFFF), "Tree.sideBarCategory.font", new FontUIResource("Lucida Grande", 1, 11), "Tree.sideBarCategory.selectionFont", new FontUIResource("Lucida Grande", 1, 11), "Tree.sideBar.foreground", new InactivatableColorUIResource(0, 0), "Tree.sideBar.selectionForeground", new InactivatableColorUIResource(0xFFFFFF, 0xFFFFFF), "Tree.sideBar.font", new FontUIResource("Lucida Grande", 0, 13), "Tree.sideBar.selectionFont", new FontUIResource("Lucida Grande", 1, 13), "Tree.sideBarCategory.selectionForeground", new InactivatableColorUIResource(0xFFFFFF, 0xFFFFFF), "Tree.rendererMargins", new InsetsUIResource(0, 0, 0, 0), "Tree.sideBarCategory.style", "emboss", "Tree.sideBarCategory.selectionStyle", "shadow", "Tree.sideBar.style", "plain", "Tree.sideBar.selectionStyle", "shadow"};
        table.putDefaults(uiDefaults);
    }

    protected URL getResource(String location) {
        URL url = this.getClass().getResource(location);
        if (url == null) {
            throw new InternalError("image resource missing: " + location);
        }
        return url;
    }

    protected Image createImage(String location) {
        return Toolkit.getDefaultToolkit().createImage(this.getResource(location));
    }

    protected Icon[] makeIcons(String location, int count, boolean horizontal) {
        Icon[] icons = new Icon[count];
        BufferedImage[] images = Images.split(this.createImage(location), count, horizontal);
        for (int i = 0; i < count; ++i) {
            icons[i] = new IconUIResource(new ImageIcon(images[i]));
        }
        return icons;
    }

    public static Object makeNativeSidebarIcon(String path, int size, Color color, Color selectionColor) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createNativeSidebarIcon", new Object[]{path, size, size, color, selectionColor});
    }

    protected Object makeNativeButtonStateBorder(OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets, boolean withFocusRing) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "createNativeButtonStateBorder", new Object[]{widget, imageInsets, borderInsets, withFocusRing});
    }

    protected void putDefaults(UIDefaults table, Object[] keyValueList) {
        Set included = QuaquaManager.getIncludedUIs();
        Set excluded = QuaquaManager.getExcludedUIs();
        if (excluded == null) {
            return;
        }
        if (included == null && excluded.isEmpty()) {
            table.putDefaults(keyValueList);
        } else if (included != null && excluded.isEmpty()) {
            for (int i = 0; i < keyValueList.length; i += 2) {
                if (keyValueList[i] instanceof String) {
                    String name = (String)keyValueList[i];
                    int p = name.indexOf(46);
                    if (p == -1 && name.endsWith("UI")) {
                        name = name.substring(0, name.length() - 2);
                        p = 1;
                    } else if (p != -1) {
                        name = name.substring(0, p);
                    }
                    if (p != -1 && !included.contains(name)) continue;
                    table.put(keyValueList[i], keyValueList[i + 1]);
                    continue;
                }
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        } else if (included == null) {
            for (int i = 0; i < keyValueList.length; i += 2) {
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        } else {
            for (int i = 0; i < keyValueList.length; i += 2) {
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        }
    }

    public static Object makeNativeIcon(String path, int size) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createNativeIcon", new Object[]{path, size});
    }

    @Override
    public String getID() {
        return "Aqua";
    }
}

