/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.tiger.filechooser;

import ch.randelshofer.quaqua.filechooser.BasicOSXFileSystemView;
import ch.randelshofer.quaqua.osx.OSXFile;
import java.io.File;
import java.util.Arrays;

public class OSXTigerFileSystemView
extends BasicOSXFileSystemView {
    public OSXTigerFileSystemView() {
        String[] names = new String[]{"AppleShare PDS", "automount", "bin", "Cleanup At Startup", "cores", "Desktop DB", "Desktop DF", "dev", "etc", "home", "mach", "mach_kernel", "mach_kernel.ctfsys", "mach.sym", "net", "opt", "private", "sbin", "Temporary Items", "TheVolumeSettingsFolder", "TheFindByContentFolder", "tmp", "Trash", "usr", "var", "Volumes", "\u0003\u0002\u0001Move&Rename"};
        hiddenTopLevelNames.addAll(Arrays.asList(names));
        names = new String[]{"$RECYCLE.BIN", "Thumbs.db", "desktop.ini"};
        hiddenDirectoryNames.addAll(Arrays.asList(names));
    }

    @Override
    public boolean isHiddenFile(File f) {
        if (OSXFile.isInvisible(f)) {
            return true;
        }
        String name = f.getName();
        if (name.length() == 0) {
            return false;
        }
        if (name.charAt(name.length() - 1) == '\r') {
            return true;
        }
        if (hiddenTopLevelNames.contains(name) && (f.getParent() == null || this.isRoot(f.getParentFile()))) {
            return true;
        }
        return hiddenDirectoryNames.contains(name);
    }
}

