/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class GroupBox
implements BackgroundBorder {
    private static Border etchedBorder = new EtchedBorder();
    private static final int IMAGE_STRIP = 7;
    private static final int EXTRA_TOP = 3;
    private static final int EXTRA_LEFT = 3;
    private static final int EXTRA_BOTTOM = 3;
    private static final int EXTRA_RIGHT = 3;
    private Insets minInsets;
    private Insets s;
    private Border boxBorder;

    public GroupBox() {
        this.s = this.minInsets = new Insets(3, 3, 3, 3);
    }

    @Override
    public Border getBackgroundBorder() {
        if (this.boxBorder == null) {
            this.boxBorder = this.createBorder();
        }
        return this.boxBorder;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.s;
    }

    public void setInsets(Insets s) {
        this.s = s != null ? this.ensureMinimum(s) : this.minInsets;
        this.boxBorder = null;
    }

    private Insets ensureMinimum(Insets s) {
        return new Insets(Math.max(3, s.top), Math.max(3, s.left), Math.max(3, s.bottom), Math.max(3, s.right));
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (c instanceof Box || !(c instanceof JComponent)) {
            etchedBorder.paintBorder(c, g, x, y, width, height);
        }
    }

    private Border createBorder() {
        int design = QuaquaManager.getDesign();
        String rs = design >= 9 ? "/ch/randelshofer/quaqua/images/GroupBoxMavericks.png" : "/ch/randelshofer/quaqua/images/GroupBox.png";
        Color fill = design >= 9 ? new Color(0xA000000, true) : new Color(0x8000000, true);
        return new CompoundBorder(new EmptyBorder(this.s.top - 3, this.s.left - 3, this.s.bottom - 3, this.s.right - 3), QuaquaBorderFactory.create(Toolkit.getDefaultToolkit().createImage(GroupBox.class.getResource(rs)), new Insets(7, 7, 7, 7), new Insets(7, 7, 7, 7), true, fill, false));
    }
}

