/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import ch.randelshofer.quaqua.osx.OSXPreferences;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;

public class Images {
    private static GraphiteFilter graphiteFilter;
    private static volatile Properties canGraphite;

    private Images() {
    }

    private static GraphiteFilter getGraphiteFilter() {
        if (graphiteFilter == null) {
            graphiteFilter = new GraphiteFilter();
        }
        return graphiteFilter;
    }

    public static Image createImage(Class baseClass, String location) {
        URL resource = baseClass.getResource(location);
        if (resource == null) {
            throw new IllegalArgumentException("no resource found for location:" + location);
        }
        return Images.createImage(resource);
    }

    public static Image createImage(URL resource) {
        Image image = Toolkit.getDefaultToolkit().createImage(resource);
        if (OSXPreferences.getString(OSXPreferences.GLOBAL_PREFERENCES, "AppleAquaColorVariant", "1").equals("6") && Images.canGraphite(resource)) {
            image = Images.toGraphite(image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean canGraphite(URL resource) {
        String file;
        int i;
        if (canGraphite == null) {
            Class<Images> clazz = Images.class;
            // MONITORENTER : ch.randelshofer.quaqua.util.Images.class
            if (canGraphite == null) {
                Properties p = new Properties();
                InputStream in = Images.class.getResourceAsStream("graphiteable.properties");
                try {
                    p.load(in);
                }
                catch (IOException e) {
                    System.err.println("Failed to load graphiteable.properties: " + e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        System.err.println("Failed to load graphiteable.properties: " + ex);
                    }
                }
                canGraphite = p;
            }
            // MONITOREXIT : clazz
        }
        if ((i = (file = resource.getFile()).lastIndexOf(File.separatorChar)) == -1) return canGraphite.containsKey(file);
        file = file.substring(i + 1);
        return canGraphite.containsKey(file);
    }

    private static Image toGraphite(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), Images.getGraphiteFilter()));
    }

    public static BufferedImage toBufferedImage(RenderedImage rImg) {
        BufferedImage image;
        if (rImg instanceof BufferedImage) {
            image = (BufferedImage)rImg;
        } else {
            Raster r = rImg.getData();
            WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
            rImg.copyData(wr);
            image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
        }
        return image;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        if (System.getProperty("java.version").startsWith("1.4.1_")) {
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            boolean hasAlpha;
            try {
                hasAlpha = Images.hasAlpha(image);
            }
            catch (IllegalAccessError e) {
                hasAlpha = true;
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                int transparency = 1;
                if (hasAlpha) {
                    transparency = 3;
                }
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                GraphicsConfiguration gc = gs.getDefaultConfiguration();
                bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
            }
            catch (Exception transparency) {
                // empty catch block
            }
            if (bimage == null) {
                int type = 1;
                if (hasAlpha) {
                    type = 2;
                }
                bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            }
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm != null ? cm.hasAlpha() : false;
    }

    public static BufferedImage[] split(Image image, int count, boolean isHorizontal) {
        BufferedImage src = Images.toBufferedImage(image);
        if (count == 1) {
            return new BufferedImage[]{src};
        }
        BufferedImage[] parts = new BufferedImage[count];
        for (int i = 0; i < count; ++i) {
            parts[i] = isHorizontal ? src.getSubimage(src.getWidth() / count * i, 0, src.getWidth() / count, src.getHeight()) : src.getSubimage(0, src.getHeight() / count * i, src.getWidth(), src.getHeight() / count);
        }
        return parts;
    }

    public static class GraphiteFilter
    extends RGBImageFilter {
        private static final float saturationAdjust = 0.179f;

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int alpha = rgb & 0xFF000000;
            int red = rgb >>> 16 & 0xFF;
            int green = rgb >>> 8 & 0xFF;
            int blue = rgb & 0xFF;
            float weight = 0.27366665f;
            float a = weight + 0.179f;
            float b = weight;
            float c = weight;
            int outputRed = (int)(a * (float)red + c * (float)green + b * (float)blue);
            int outputGreen = (int)(b * (float)red + a * (float)green + c * (float)blue);
            int outputBlue = (int)(c * (float)red + b * (float)green + a * (float)blue);
            return alpha | outputRed << 16 | outputGreen << 8 | outputBlue;
        }
    }
}

