/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.treetable.j;

import de.sciss.treetable.j.AbstractTreeModel;
import de.sciss.treetable.j.DefaultTreeColumnModel;
import de.sciss.treetable.j.DefaultTreeTableNode;
import de.sciss.treetable.j.DefaultTreeTableSorter;
import de.sciss.treetable.j.IconMap;
import de.sciss.treetable.j.ToolTipMap;
import de.sciss.treetable.j.TreeColumnModel;
import de.sciss.treetable.j.TreeTableCellEditor;
import de.sciss.treetable.j.TreeTableCellRenderer;
import de.sciss.treetable.j.TreeTableModel;
import de.sciss.treetable.j.TreeTableNode;
import de.sciss.treetable.j.TreeTableSorter;
import de.sciss.treetable.j.event.TreeColumnModelEvent;
import de.sciss.treetable.j.event.TreeColumnModelListener;
import de.sciss.treetable.j.event.TreeTableMouseEvent;
import de.sciss.treetable.j.event.TreeTableMouseListener;
import de.sciss.treetable.j.event.TreeTableMouseMotionListener;
import de.sciss.treetable.j.event.TreeTableSorterEvent;
import de.sciss.treetable.j.event.TreeTableSorterListener;
import de.sciss.treetable.j.ui.BasicTreeTableUI;
import de.sciss.treetable.j.ui.TableInterface;
import de.sciss.treetable.j.ui.TreeInterface;
import de.sciss.treetable.j.ui.TreeTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.AbstractButton;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeTable
extends JComponent
implements Scrollable {
    protected Adapter adapter;
    private TreeInterface tree;
    private TableInterface table;
    private TableColumnModel columnModel;
    private JTable rowHeader;
    private TreeTableCellRenderer focusRenderer;
    private Color alternateRowColor;
    private IconMap iconMap;
    private ToolTipMap<TreeTable> toolTipMap;
    private Icon openIcon;
    private Icon closedIcon;
    private Icon leafIcon;
    private Icon ascendingSortIcon;
    private Icon descendingSortIcon;
    private HashMap<Class<?>, TreeTableCellRenderer> defaultRenderers;
    private HashMap<Class<?>, TreeTableCellEditor> defaultEditors;
    private HashMap<TreePath, RowSorter.SortKey> sortedPaths = new HashMap();
    private int rowMargin = 0;
    private boolean expandsSortedNodes = true;
    private boolean nodeSortingEnabled = true;
    private boolean columnFocusEnabled = true;
    private boolean autoCreateColumnHeader = true;
    private boolean autoCreateRowHeader = false;
    private boolean autoCreateRowSorter = false;
    private static final String uiClassID = "TreeTableUI";
    private boolean hasTreeTableMouseListener = false;
    private boolean hasTreeTableMouseMotionListener = false;
    private boolean dragEnabled;
    private boolean dropModeSet = false;
    private transient DropLocation dropLocation;
    private transient DTDE dtde;

    public TreeTable() {
        this(new DefaultTreeTableNode());
    }

    public TreeTable(TreeTableNode root) {
        this(new DefaultTreeModel(root), new DefaultTreeColumnModel(root));
    }

    public TreeTable(TreeModel tm, TreeColumnModel rm) {
        this(tm, rm, null);
    }

    public TreeTable(TreeModel tm, TreeColumnModel tcm, TableColumnModel cm) {
        if (tm == null || tcm == null) {
            throw new NullPointerException();
        }
        this.adapter = this.createAdapter(tm, tcm);
        this.columnModel = cm;
        this.toolTipMap = this.getDefaultToolTipMap();
        this.setFocusable(true);
        this.setOpaque(true);
        this.updateUI();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setUI(TreeTableUI ui) {
        boolean addExpandLis = false;
        boolean addWillExpandLis = false;
        if (this.table != null) {
            this.table.removePropertyChangeListener(this.adapter);
            this.tree.removePropertyChangeListener(this.adapter);
            int lisCount = this.listenerList.getListenerCount(TreeExpansionListener.class);
            if (lisCount > 0) {
                this.tree.removeTreeExpansionListener(this.adapter);
                addExpandLis = true;
            }
            if ((lisCount = this.listenerList.getListenerCount(TreeWillExpandListener.class)) > 0) {
                this.tree.removeTreeWillExpandListener(this.adapter);
                addWillExpandLis = true;
            }
            this.getSelectionModel().removeTreeSelectionListener(this.adapter);
            if (this.getAutoCreateColumnsFromModel()) {
                this.columnModel = null;
            }
            this.updateUIProperties();
        }
        super.setUI(ui);
        this.tree = this.getUI().getTreeInterface(this);
        this.table = this.getUI().getTableInterface(this);
        this.getSelectionModel().addTreeSelectionListener(this.adapter);
        this.table.addPropertyChangeListener(this.adapter);
        this.tree.addPropertyChangeListener(this.adapter);
        if (addExpandLis) {
            this.tree.addTreeExpansionListener(this.adapter);
        }
        if (addWillExpandLis) {
            this.tree.addTreeWillExpandListener(this.adapter);
        }
        if (this.getAutoCreateColumnHeader() && this.isDisplayable()) {
            this.configureEnclosingScrollPane();
        }
    }

    @Override
    public TreeTableUI getUI() {
        return (TreeTableUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else if (this.ui != null && this.ui.getClass() == BasicTreeTableUI.class) {
            this.updateUIProperties();
            ((BasicTreeTableUI)this.ui).updateUI();
        } else {
            this.setUI(new BasicTreeTableUI());
        }
    }

    protected void updateUIProperties() {
        if (this.leafIcon instanceof UIResource) {
            this.leafIcon = null;
        }
        if (this.openIcon instanceof UIResource) {
            this.openIcon = null;
        }
        if (this.closedIcon instanceof UIResource) {
            this.closedIcon = null;
        }
        if (this.ascendingSortIcon instanceof UIResource) {
            this.ascendingSortIcon = null;
        }
        if (this.descendingSortIcon instanceof UIResource) {
            this.descendingSortIcon = null;
        }
        this.updateUIRenderers();
        this.updateUIEditors();
    }

    private void updateUIRenderers() {
        if (this.defaultRenderers == null && this.columnModel == null) {
            return;
        }
        IdentityHashMap components = new IdentityHashMap();
        if (this.defaultRenderers != null) {
            for (Map.Entry<Class<Object>, TreeTableCellRenderer> entry : this.defaultRenderers.entrySet()) {
                if (entry.getValue() instanceof JComponent) {
                    components.put(entry.getValue(), null);
                    continue;
                }
                if (entry.getValue() instanceof Component) continue;
                Class<Object> cls = entry.getKey();
                TreeColumnModel cm = this.adapter.treeColumnModel;
                int col = cm.getColumnCount();
                while (--col >= 0) {
                    if (!cls.isAssignableFrom(cm.getColumnClass(col))) continue;
                    this.addComponents(components, entry.getValue(), this.convertColumnIndexToView(col));
                }
            }
        }
        if (this.columnModel != null) {
            int col = this.columnModel.getColumnCount();
            while (--col >= 0) {
                TableCellRenderer tableCellRenderer = this.columnModel.getColumn(col).getCellRenderer();
                if (tableCellRenderer instanceof JComponent) {
                    components.put(tableCellRenderer, null);
                    continue;
                }
                if (tableCellRenderer instanceof Component || !(tableCellRenderer instanceof TreeTableCellRenderer)) continue;
                this.addComponents(components, (TreeTableCellRenderer)((Object)tableCellRenderer), col);
            }
        }
        for (JComponent jComponent : components.keySet()) {
            jComponent.updateUI();
        }
    }

    private void addComponents(IdentityHashMap components, TreeTableCellRenderer r, int col) {
        try {
            Object value;
            int row;
            if (this.getRowCount() == 0) {
                row = -1;
                value = null;
            } else {
                row = 0;
                value = this.adapter.getValueAt(0, col);
            }
            if (col == this.adapter.treeColumnModel.getHierarchicalColumn()) {
                Component c;
                if (row < 0) {
                    c = r.getTreeTableCellRendererComponent(this, value, false, false, row, col, false, true);
                } else {
                    TreePath path = this.getPathForRow(0);
                    c = r.getTreeTableCellRendererComponent(this, value, false, false, row, col, this.isExpanded(path), this.isLeaf(path));
                }
                if (c instanceof JComponent) {
                    components.put(c, c);
                }
            } else {
                Component c = r.getTreeTableCellRendererComponent(this, value, false, false, row, col);
                if (c instanceof JComponent) {
                    components.put(c, c);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateUIEditors() {
    }

    public void processTreeExpansion(TreePath path, int rowsAdded) {
        int row = this.getRowForPath(path);
        this.adapter.fireTableRowsInserted(row + 1, row + rowsAdded);
        this.adapter.updateSorter(path, true);
        if (this.getRowHeight() <= 0) {
            this.updateTableRowHeights(row + 1, row + rowsAdded + 1);
        }
    }

    public void processTreeCollapse(TreePath path, int rowsRemoved) {
        int row = this.getRowForPath(path);
        this.adapter.fireTableRowsDeleted(row + 1, row + rowsRemoved);
        this.adapter.updateSorter(path, false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unconfigureEnclosingScrollPane();
    }

    private JScrollPane getScrollPaneAncestor() {
        JScrollPane scrollPane;
        JViewport viewport;
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane && (viewport = (scrollPane = (JScrollPane)gp).getViewport()) != null && viewport.getView() == this) {
            return scrollPane;
        }
        return null;
    }

    protected void configureEnclosingScrollPane() {
        if (!this.getAutoCreateColumnHeader() && !this.getAutoCreateRowHeader()) {
            return;
        }
        JScrollPane scrollPane = this.getScrollPaneAncestor();
        if (scrollPane == null) {
            return;
        }
        if (this.getAutoCreateColumnHeader()) {
            Border scrollPaneBorder;
            scrollPane.setColumnHeaderView(this.getTableHeader());
            Border border = scrollPane.getBorder();
            if ((border == null || border instanceof UIResource) && (scrollPaneBorder = UIManager.getBorder("Table.scrollPaneBorder")) != null) {
                scrollPane.setBorder(scrollPaneBorder);
            }
        }
        if (this.getAutoCreateRowHeader()) {
            this.createRowHeader();
            scrollPane.setRowHeaderView(this.rowHeader);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        if (!this.getAutoCreateColumnHeader() && !this.getAutoCreateRowHeader()) {
            return;
        }
        JScrollPane scrollPane = this.getScrollPaneAncestor();
        if (scrollPane == null) {
            return;
        }
        if (this.getAutoCreateColumnHeader()) {
            scrollPane.setColumnHeaderView(null);
        }
        if (this.getAutoCreateRowHeader()) {
            scrollPane.setRowHeaderView(null);
            this.rowHeader = null;
        }
    }

    private void createRowHeader() {
        RowHeaderAdapter adapter = new RowHeaderAdapter(this.getTableModel());
        this.rowHeader = new JTable(adapter, null, this.getRowSelectionModel());
        this.rowHeader.addPropertyChangeListener("UI", adapter);
        this.rowHeader.setAutoCreateColumnsFromModel(false);
        this.rowHeader.setRowMargin(0);
        this.rowHeader.getColumnModel().setColumnMargin(0);
        this.rowHeader.setFocusable(false);
        TreeTable.updateRowHeaderRenderer(this.rowHeader);
        int ht = this.getRowHeight();
        if (ht > 0) {
            this.rowHeader.setRowHeight(ht);
        } else {
            this.updateRowHeaderHeights(0, this.getRowCount());
        }
    }

    private static void updateRowHeaderRenderer(JTable rowHeader) {
        TableCellRenderer r = rowHeader.getTableHeader().getDefaultRenderer();
        if (r instanceof JLabel) {
            JLabel l = (JLabel)((Object)r);
            l.setHorizontalAlignment(0);
        }
        rowHeader.getColumnModel().getColumn(0).setCellRenderer(r);
        Dimension size = r.getTableCellRendererComponent(rowHeader, "9999", false, false, -1, -1).getPreferredSize();
        rowHeader.setPreferredScrollableViewportSize(size);
    }

    private void updateRowHeaderHeights(int fromRow, int toRow) {
        for (int row = fromRow; row < toRow; ++row) {
            this.rowHeader.setRowHeight(row, this.getRowHeight(row));
        }
    }

    private <T extends EventListener> void addListener(Class<T> cls, T l) {
        if (l == null) {
            return;
        }
        int count = this.listenerList.getListenerCount(cls);
        this.listenerList.add(cls, l);
        if (count == 0) {
            if (cls == TreeExpansionListener.class) {
                this.tree.addTreeExpansionListener(this.adapter);
            } else if (cls == TreeWillExpandListener.class) {
                this.tree.addTreeWillExpandListener(this.adapter);
            } else if (cls == TreeTableMouseListener.class) {
                this.hasTreeTableMouseListener = true;
            } else if (cls == TreeTableMouseMotionListener.class) {
                this.hasTreeTableMouseMotionListener = true;
            }
        }
    }

    private <T extends EventListener> void removeListener(Class<T> cls, T l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(cls, l);
        int count = this.listenerList.getListenerCount(cls);
        if (count == 0) {
            if (cls == TreeExpansionListener.class) {
                this.tree.removeTreeExpansionListener(this.adapter);
            } else if (cls == TreeWillExpandListener.class) {
                this.tree.removeTreeWillExpandListener(this.adapter);
            } else if (cls == TreeTableMouseListener.class) {
                this.hasTreeTableMouseListener = false;
            } else if (cls == TreeTableMouseMotionListener.class) {
                this.hasTreeTableMouseMotionListener = false;
            }
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener l) {
        this.addListener(TreeExpansionListener.class, l);
    }

    public void removeTreeExpansionListener(TreeExpansionListener l) {
        this.removeListener(TreeExpansionListener.class, l);
    }

    private void fireTreeExpansionEvent(TreePath path, boolean exp) {
        TreeExpansionEvent e = new TreeExpansionEvent(this, path);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeExpansionListener.class) continue;
            TreeExpansionListener lis = (TreeExpansionListener)listeners[i + 1];
            if (exp) {
                lis.treeExpanded(e);
                continue;
            }
            lis.treeCollapsed(e);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener l) {
        this.addListener(TreeWillExpandListener.class, l);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener l) {
        this.removeListener(TreeWillExpandListener.class, l);
    }

    private void fireTreeWillExpandEvent(TreePath path, boolean exp) throws ExpandVetoException {
        TreeExpansionEvent e = new TreeExpansionEvent(this, path);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeWillExpandListener.class) continue;
            TreeWillExpandListener lis = (TreeWillExpandListener)listeners[i + 1];
            if (exp) {
                lis.treeWillExpand(e);
                continue;
            }
            lis.treeWillCollapse(e);
        }
    }

    public void addTreeTableMouseListener(TreeTableMouseListener l) {
        this.addListener(TreeTableMouseListener.class, l);
    }

    public void removeTreeTableMouseListener(TreeTableMouseListener l) {
        this.removeListener(TreeTableMouseListener.class, l);
    }

    public void addTreeTableMouseMotionListener(TreeTableMouseMotionListener l) {
        this.addListener(TreeTableMouseMotionListener.class, l);
    }

    public void removeTreeTableMouseMotionListener(TreeTableMouseMotionListener l) {
        this.removeListener(TreeTableMouseMotionListener.class, l);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.hasTreeTableMouseListener) {
            this.fireTreeTableMouseEvent(e);
        }
        super.processMouseEvent(e);
    }

    private void fireTreeTableMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 504: 
            case 505: {
                return;
            }
        }
        TreeTableMouseEvent evt = new TreeTableMouseEvent(this, e);
        Object[] listeners = this.listenerList.getListenerList();
        block8: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeTableMouseListener.class) continue;
            TreeTableMouseListener lis = (TreeTableMouseListener)listeners[i + 1];
            switch (e.getID()) {
                case 501: {
                    lis.mousePressed(evt);
                    continue block8;
                }
                case 502: {
                    lis.mouseReleased(evt);
                    continue block8;
                }
                case 500: {
                    lis.mouseClicked(evt);
                }
            }
        }
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.hasTreeTableMouseMotionListener) {
            this.fireTreeTableMouseMotionEvent(e);
        }
        super.processMouseMotionEvent(e);
    }

    private void fireTreeTableMouseMotionEvent(MouseEvent e) {
        TreeTableMouseEvent evt = new TreeTableMouseEvent(this, e);
        Object[] listeners = this.listenerList.getListenerList();
        block4: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeTableMouseMotionListener.class) continue;
            TreeTableMouseMotionListener lis = (TreeTableMouseMotionListener)listeners[i + 1];
            switch (e.getID()) {
                case 503: {
                    lis.mouseMoved(evt);
                    continue block4;
                }
                case 506: {
                    lis.mouseDragged(evt);
                }
            }
        }
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void doLayout() {
        this.table.doLayout();
        this.tree.doLayout();
        super.doLayout();
    }

    public void invalidateAllRows() {
        Enumeration<TreePath> paths;
        Adapter model = this.adapter;
        TreePath root = new TreePath(model.getRoot());
        if (this.tree.isRootVisible()) {
            this.adapter.invalidatePaths(root, null, null);
        }
        if ((paths = this.tree.getExpandedDescendants(root)) == null) {
            return;
        }
        while (paths.hasMoreElements()) {
            TreePath path = paths.nextElement();
            Object parent = path.getLastPathComponent();
            int count = model.getChildCount(parent);
            if (count <= 0) continue;
            int[] childIndices = new int[count];
            Object[] childNodes = new Object[count];
            int i = count;
            while (--i >= 0) {
                childIndices[i] = i;
                childNodes[i] = model.getChild(parent, i);
            }
            this.adapter.invalidatePaths(path, childIndices, childNodes);
        }
    }

    public void invalidatePath(TreePath path) {
        this.adapter.invalidatePath(path);
        if (this.getRowHeight() <= 0) {
            int row = this.getRowForPath(path);
            this.updateTableRowHeights(row, row + 1);
        }
    }

    protected void updateTableRowHeights() {
        this.updateTableRowHeights(0, this.tree.getRowCount());
    }

    protected void updateTableRowHeights(int fromRow, int toRow) {
        assert (this.tree.getRowHeight() <= 0);
        int row = toRow;
        while (--row >= fromRow) {
            this.table.setRowHeight(row, this.getRowBounds((int)row).height);
        }
        if (this.rowHeader != null) {
            this.updateRowHeaderHeights(fromRow, toRow);
        }
    }

    public boolean getAutoCreateColumnHeader() {
        return this.autoCreateColumnHeader;
    }

    public void setAutoCreateColumnHeader(boolean autoCreateColumnHeader) {
        boolean oldValue = this.getAutoCreateColumnHeader();
        this.autoCreateColumnHeader = autoCreateColumnHeader;
        this.firePropertyChange("autoCreateColumnHeader", oldValue, this.getAutoCreateColumnHeader());
    }

    public boolean getAutoCreateRowHeader() {
        return this.autoCreateRowHeader;
    }

    public void setAutoCreateRowHeader(boolean autoCreateRowHeader) {
        boolean oldValue = this.getAutoCreateRowHeader();
        this.autoCreateRowHeader = autoCreateRowHeader;
        this.firePropertyChange("autoCreateRowHeader", oldValue, this.getAutoCreateRowHeader());
    }

    public TreeTableCellRenderer getFocusRenderer() {
        return this.focusRenderer;
    }

    public void setFocusRenderer(TreeTableCellRenderer renderer) {
        TreeTableCellRenderer oldValue = this.getFocusRenderer();
        this.focusRenderer = renderer;
        this.firePropertyChange("focusRenderer", oldValue, this.getFocusRenderer());
        if (this.isValid()) {
            this.repaint(this.getLeadSelectionPath());
        }
    }

    public ToolTipMap<TreeTable> getDefaultToolTipMap() {
        return this.adapter;
    }

    public ToolTipMap<TreeTable> getToolTipMap() {
        return this.toolTipMap;
    }

    public void setToolTipMap(ToolTipMap<TreeTable> toolTipMap) {
        ToolTipMap<TreeTable> oldValue = this.getToolTipMap();
        this.toolTipMap = toolTipMap;
        this.firePropertyChange("toolTipMap", oldValue, this.getToolTipMap());
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return this.getToolTipMap() == null ? this.getToolTipText() : this.getToolTipMap().getToolTipText(this, e);
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setColumnModel(TableColumnModel columnModel) {
        TableColumnModel oldValue = this.getColumnModel();
        this.columnModel = columnModel;
        this.firePropertyChange("columnModel", oldValue, this.getColumnModel());
    }

    public TreeModel getTreeModel() {
        return this.adapter.treeModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        TreeModel oldValue = this.getTreeModel();
        this.adapter.setTreeModel(treeModel);
        this.firePropertyChange("treeModel", oldValue, this.getTreeModel());
        if (this.getAutoCreateRowSorter()) {
            this.autoCreateRowSorter();
        }
    }

    public TreeColumnModel getTreeColumnModel() {
        return this.adapter.treeColumnModel;
    }

    public void setTreeColumnModel(TreeColumnModel treeColumnModel) {
        TreeColumnModel oldValue = this.getTreeColumnModel();
        this.adapter.treeColumnModel = treeColumnModel;
        this.adapter.fireTableStructureChanged();
        this.firePropertyChange("treeColumnModel", oldValue, this.getTreeColumnModel());
        if (this.getAutoCreateRowSorter()) {
            this.autoCreateRowSorter();
        }
    }

    public TableModel getTableModel() {
        return this.adapter;
    }

    public TreeTableModel getTreeTableModel() {
        return this.adapter;
    }

    public TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> getRowSorter() {
        return this.adapter.rowSorter;
    }

    public void setRowSorter(TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> rowSorter) {
        TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> oldValue = this.getRowSorter();
        this.adapter.setRowSorter(rowSorter);
        this.firePropertyChange("rowSorter", oldValue, this.getRowSorter());
    }

    public boolean isNodeSortingEnabled() {
        return this.nodeSortingEnabled;
    }

    public void setNodeSortingEnabled(boolean nodeSortingEnabled) {
        boolean oldValue = this.isNodeSortingEnabled();
        this.nodeSortingEnabled = nodeSortingEnabled;
        this.firePropertyChange("nodeSortingEnabled", oldValue, this.isNodeSortingEnabled());
        if (!this.sortedPaths.isEmpty()) {
            this.repaint();
        }
    }

    public boolean getAutoCreateRowSorter() {
        return this.autoCreateRowSorter;
    }

    public void setAutoCreateRowSorter(boolean autoCreateRowSorter) {
        boolean oldValue = this.getAutoCreateRowSorter();
        this.autoCreateRowSorter = autoCreateRowSorter;
        if (this.getAutoCreateRowSorter()) {
            this.autoCreateRowSorter();
        }
        this.firePropertyChange("autoCreateRowSorter", oldValue, this.getAutoCreateRowSorter());
    }

    private void autoCreateRowSorter() {
        this.setRowSorter(new DefaultTreeTableSorter(this.getTreeModel(), this.getTreeColumnModel()));
    }

    public RowSorter<?> getSorterForPath(TreePath path) {
        return this.adapter.getSorter(path);
    }

    public boolean isColumnFocusEnabled() {
        return this.columnFocusEnabled;
    }

    public void setColumnFocusEnabled(boolean columnFocusEnabled) {
        boolean oldValue = this.isColumnFocusEnabled();
        this.columnFocusEnabled = columnFocusEnabled;
        this.firePropertyChange("columnFocusEnabled", oldValue, this.isColumnFocusEnabled());
        this.repaint(this.getLeadSelectionPath());
    }

    public TableColumn getColumn(Object identifier) {
        return this.columnModel.getColumn(this.columnModel.getColumnIndex(identifier));
    }

    public Color getAlternateRowColor() {
        return this.alternateRowColor;
    }

    public void setAlternateRowColor(Color alternateRowColor) {
        Color oldValue = this.getAlternateRowColor();
        this.alternateRowColor = alternateRowColor;
        this.firePropertyChange("alternateRowColor", oldValue, this.getAlternateRowColor());
    }

    public void setDefaultRenderer(Class<?> columnClass, TreeTableCellRenderer renderer) {
        this.defaultRenderers = TreeTable.putDefault(columnClass, renderer, this.defaultRenderers);
    }

    public TreeTableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        TreeTableCellRenderer r;
        TreeTableCellRenderer treeTableCellRenderer = r = this.defaultRenderers == null ? null : TreeTable.getDefault(columnClass, this.defaultRenderers);
        return r != null ? r : (this.ui == null ? null : this.getUI().getDefaultRenderer(this, columnClass));
    }

    public void setDefaultEditor(Class<?> columnClass, TreeTableCellEditor editor) {
        this.defaultEditors = TreeTable.putDefault(columnClass, editor, this.defaultEditors);
    }

    public TreeTableCellEditor getDefaultEditor(Class<?> columnClass, int column) {
        TreeTableCellEditor e;
        TreeTableCellEditor treeTableCellEditor = e = this.defaultEditors == null ? null : TreeTable.getDefault(columnClass, this.defaultEditors);
        return e != null ? e : (this.ui == null ? null : this.getUI().getDefaultEditor(this, columnClass, column));
    }

    private static <T> HashMap<Class<?>, T> putDefault(Class<?> key, T value, HashMap<Class<?>, T> defaults) {
        if (defaults == null) {
            if (value == null) {
                return null;
            }
            defaults = new HashMap(8);
        }
        if (value != null) {
            defaults.put(key, value);
        } else {
            defaults.remove(key);
        }
        return defaults;
    }

    private static <T> T getDefault(Class<?> cls, HashMap<Class<?>, T> defaults) {
        if (cls == null) {
            return null;
        }
        T def = defaults.get(cls);
        return def != null ? def : TreeTable.getDefault(cls.getSuperclass(), defaults);
    }

    public TreeTableCellRenderer getCellRenderer(int row, int column) {
        if (column >= 0 && column < this.getColumnModel().getColumnCount()) {
            TableCellRenderer renderer = this.getColumnModel().getColumn(column).getCellRenderer();
            if (renderer instanceof TreeTableCellRenderer) {
                return (TreeTableCellRenderer)((Object)renderer);
            }
            return this.getDefaultRenderer(this.getTreeColumnModel().getColumnClass(this.convertColumnIndexToModel(column)));
        }
        return this.getDefaultRenderer(Object.class);
    }

    public TreeTableCellEditor getCellEditor(int row, int column) {
        if (column >= 0 && column < this.getColumnModel().getColumnCount()) {
            TableCellEditor editor = this.getColumnModel().getColumn(column).getCellEditor();
            if (editor instanceof TreeTableCellEditor) {
                return (TreeTableCellEditor)((Object)editor);
            }
            return this.getDefaultEditor(this.getTreeColumnModel().getColumnClass(this.convertColumnIndexToModel(column)), column);
        }
        return this.getDefaultEditor(Object.class, column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.adapter.isCellEditable(row, this.convertColumnIndexToModel(column));
    }

    public boolean startEditingAtPath(TreePath path) {
        return this.editCellAt(this.getRowForPath(path), this.getHierarchicalColumn());
    }

    public boolean startEditingAtRow(int row) {
        return this.editCellAt(row, this.getHierarchicalColumn());
    }

    public boolean editCellAt(int row, int column) {
        return this.table.editCellAt(row, column);
    }

    public boolean isEditing() {
        return this.table.isEditing();
    }

    public Component getEditorComponent() {
        return this.table.getEditorComponent();
    }

    public int getEditingColumn() {
        return this.table.getEditingColumn();
    }

    public int getEditingRow() {
        return this.table.getEditingRow();
    }

    public TreeTableCellEditor getCellEditor() {
        return (TreeTableCellEditor)((Object)this.table.getCellEditor());
    }

    public int getHierarchicalColumn() {
        return this.convertColumnIndexToView(this.getTreeColumnModel().getHierarchicalColumn());
    }

    public int convertColumnIndexToView(int modelColumnIndex) {
        return this.table.convertColumnIndexToView(modelColumnIndex);
    }

    public int convertColumnIndexToModel(int viewColumnIndex) {
        return this.table.convertColumnIndexToModel(viewColumnIndex);
    }

    public int convertNodeIndexToView(Object parent, int modelIndex) {
        return this.adapter.convertIndexToView(parent, modelIndex);
    }

    public int convertNodeIndexToModel(Object parent, int viewIndex) {
        return this.adapter.convertIndexToModel(parent, viewIndex);
    }

    public Object getValueAt(int row, int column) {
        return this.adapter.getValueAt(row, this.convertColumnIndexToModel(column));
    }

    public Object getNode(int row) {
        return this.adapter.getNode(row);
    }

    public Icon getLeafIcon() {
        if (this.leafIcon == null) {
            this.leafIcon = UIManager.getIcon("Tree.leafIcon");
        }
        return this.leafIcon;
    }

    public void setLeafIcon(Icon leafIcon) {
        Icon oldValue = this.leafIcon;
        this.leafIcon = leafIcon;
        this.firePropertyChange("leafIcon", oldValue, this.getLeafIcon());
        this.repaintColumn(this.getHierarchicalColumn());
    }

    public Icon getOpenIcon() {
        if (this.openIcon == null) {
            this.openIcon = UIManager.getIcon("Tree.openIcon");
        }
        return this.openIcon;
    }

    public void setOpenIcon(Icon openIcon) {
        Icon oldValue = this.openIcon;
        this.openIcon = openIcon;
        this.firePropertyChange("openIcon", oldValue, this.getOpenIcon());
        this.repaintColumn(this.getHierarchicalColumn());
    }

    public Icon getClosedIcon() {
        if (this.closedIcon == null) {
            this.closedIcon = UIManager.getIcon("Tree.closedIcon");
        }
        return this.closedIcon;
    }

    public void setClosedIcon(Icon closedIcon) {
        Icon oldValue = this.closedIcon;
        this.closedIcon = closedIcon;
        this.firePropertyChange("closedIcon", oldValue, this.getClosedIcon());
        this.repaintColumn(this.getHierarchicalColumn());
    }

    private void repaintColumn(int col) {
        if (col < 0 || this.getRowCount() == 0) {
            return;
        }
        Rectangle r = this.getCellRect(0, col, true);
        r.height = this.getHeight();
        this.repaint(r);
    }

    public IconMap getIconMap() {
        return this.iconMap;
    }

    public void setIconMap(IconMap iconMap) {
        IconMap oldValue = this.getIconMap();
        this.iconMap = iconMap;
        this.firePropertyChange("iconMap", oldValue, this.getIconMap());
        if (this.isValid()) {
            this.repaintColumn(this.getHierarchicalColumn());
        }
    }

    public Icon getAscendingSortIcon() {
        if (this.ascendingSortIcon == null) {
            this.ascendingSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
        }
        return this.ascendingSortIcon;
    }

    public void setAscendingSortIcon(Icon ascendingSortIcon) {
        Icon oldValue = this.getAscendingSortIcon();
        this.ascendingSortIcon = ascendingSortIcon;
        this.firePropertyChange("ascendingSortIcon", oldValue, this.getAscendingSortIcon());
    }

    public Icon getDescendingSortIcon() {
        if (this.descendingSortIcon == null) {
            this.descendingSortIcon = UIManager.getIcon("Table.descendingSortIcon");
        }
        return this.descendingSortIcon;
    }

    public void setDescendingSortIcon(Icon descendingSortIcon) {
        Icon oldValue = this.getDescendingSortIcon();
        this.descendingSortIcon = descendingSortIcon;
        this.firePropertyChange("descendingSortIcon", oldValue, this.getDescendingSortIcon());
    }

    public Icon getIconForPath(TreePath path) {
        return this.getIcon(path.getLastPathComponent(), this.isExpanded(path), this.isLeaf(path));
    }

    public Icon getIconForRow(int row) {
        return this.getIconForPath(this.getPathForRow(row));
    }

    public Icon getIcon(Object node, boolean expanded, boolean leaf) {
        Icon icon;
        Icon icon2 = icon = this.iconMap == null ? null : this.iconMap.getIcon(this, node, expanded, leaf);
        if (icon == null) {
            icon = leaf ? this.getLeafIcon() : (expanded ? this.getOpenIcon() : this.getClosedIcon());
        }
        return icon;
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.table.getAutoCreateColumnsFromModel();
    }

    public void setAutoCreateColumnsFromModel(boolean autoCreateColumnsFromModel) {
        this.table.setAutoCreateColumnsFromModel(autoCreateColumnsFromModel);
    }

    public int getAutoResizeMode() {
        return this.table.getAutoResizeMode();
    }

    public void setAutoResizeMode(int mode) {
        this.table.setAutoResizeMode(mode);
    }

    public boolean getCellSelectionEnabled() {
        return this.table.getCellSelectionEnabled();
    }

    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        this.table.setCellSelectionEnabled(cellSelectionEnabled);
        if (this.getDragEnabled()) {
            this.updateDropMode();
        }
    }

    public boolean getColumnSelectionAllowed() {
        return this.table.getColumnSelectionAllowed();
    }

    public void setColumnSelectionAllowed(boolean columnSelectionAllowed) {
        this.table.setColumnSelectionAllowed(columnSelectionAllowed);
        if (this.getDragEnabled()) {
            this.updateDropMode();
        }
    }

    public Color getGridColor() {
        return this.table.getGridColor();
    }

    public void setGridColor(Color gridColor) {
        this.table.setGridColor(gridColor);
    }

    public Dimension getIntercellSpacing() {
        return this.table.getIntercellSpacing();
    }

    public void setIntercellSpacing(Dimension intercellSpacing) {
        this.table.setIntercellSpacing(intercellSpacing);
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public void setRowMargin(int rowMargin) {
        int oldValue = this.getRowMargin();
        this.rowMargin = rowMargin;
        this.firePropertyChange("rowMargin", oldValue, this.getRowMargin());
        if (this.isValid()) {
            this.repaint();
        }
    }

    public boolean getRowSelectionAllowed() {
        return this.table.getRowSelectionAllowed();
    }

    public void setRowSelectionAllowed(boolean rowSelectionAllowed) {
        this.table.setRowSelectionAllowed(rowSelectionAllowed);
        if (this.getDragEnabled()) {
            this.updateDropMode();
        }
    }

    public boolean getShowHorizontalLines() {
        return this.table.getShowHorizontalLines();
    }

    public void setShowHorizontalLines(boolean showHorizontalLines) {
        this.table.setShowHorizontalLines(showHorizontalLines);
    }

    public boolean getShowVerticalLines() {
        return this.table.getShowVerticalLines();
    }

    public void setShowVerticalLines(boolean showVerticalLines) {
        this.table.setShowVerticalLines(showVerticalLines);
    }

    public void setShowGrid(boolean showGrid) {
        this.table.setShowGrid(showGrid);
    }

    public JTableHeader getTableHeader() {
        return this.table.getTableHeader();
    }

    public void setTableHeader(JTableHeader tableHeader) {
        this.table.setTableHeader(tableHeader);
    }

    public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
        return this.tree.getExpandedDescendants(parent);
    }

    public void collapsePath(TreePath path) {
        this.tree.collapsePath(path);
    }

    public void collapseRow(int row) {
        this.collapsePath(this.getPathForRow(row));
    }

    public void expandPath(TreePath path) {
        this.tree.expandPath(path);
    }

    public void expandRow(int row) {
        this.expandPath(this.getPathForRow(row));
    }

    public void makeVisible(TreePath path) {
        this.tree.makeVisible(path);
    }

    public void scrollPathToVisible(TreePath path) {
        this.tree.scrollPathToVisible(path);
    }

    public void scrollRowToVisible(int row) {
        this.scrollPathToVisible(this.getPathForRow(row));
    }

    public Rectangle getPathBounds(TreePath path) {
        return this.ui == null ? null : this.getUI().getPathBounds(this, path);
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.ui == null ? null : this.getUI().getPathForLocation(this, x, y);
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        return this.ui == null ? null : this.getUI().getClosestPathForLocation(this, x, y);
    }

    public TreePath getPathForRow(int row) {
        return this.tree.getPathForRow(row);
    }

    public Rectangle getRowBounds(int row) {
        return this.getPathBounds(this.getPathForRow(row));
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public int getRowForLocation(int x, int y) {
        TreePath path = this.getPathForLocation(x, y);
        return path == null ? -1 : this.getRowForPath(path);
    }

    public int getClosestRowForLocation(int x, int y) {
        return this.tree.getClosestRowForLocation(x, y);
    }

    public int getRowForPath(TreePath path) {
        return this.tree.getRowForPath(path);
    }

    public boolean isCollapsed(int row) {
        return this.isCollapsed(this.getPathForRow(row));
    }

    public boolean isCollapsed(TreePath path) {
        return this.tree.isCollapsed(path);
    }

    public boolean isExpanded(int row) {
        return this.isExpanded(this.getPathForRow(row));
    }

    public boolean isExpanded(TreePath path) {
        return this.tree.isExpanded(path);
    }

    public boolean hasBeenExpanded(TreePath path) {
        return this.tree.hasBeenExpanded(path);
    }

    public boolean isFixedRowHeight() {
        return this.tree.isFixedRowHeight();
    }

    public boolean isLargeModel() {
        return this.tree.isLargeModel();
    }

    public void setLargeModel(boolean largeModel) {
        this.tree.setLargeModel(largeModel);
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean rootVisible) {
        this.tree.setRootVisible(rootVisible);
    }

    public boolean getScrollsOnExpand() {
        return this.tree.getScrollsOnExpand();
    }

    public void setScrollsOnExpand(boolean scrollsOnExpand) {
        this.tree.setScrollsOnExpand(scrollsOnExpand);
    }

    public boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    public void setShowsRootHandles(boolean newValue) {
        this.tree.setShowsRootHandles(newValue);
    }

    public void setToggleClickCount(int clickCount) {
        this.tree.setToggleClickCount(clickCount);
    }

    public int getToggleClickCount() {
        return this.tree.getToggleClickCount();
    }

    public int getVisibleRowCount() {
        return this.tree.getVisibleRowCount();
    }

    public void setVisibleRowCount(int newCount) {
        this.tree.setVisibleRowCount(newCount);
    }

    public int getRowHeight() {
        return this.tree.getRowHeight();
    }

    public void setRowHeight(int rowHeight) {
        int oldRowHeight = this.getRowHeight();
        if (rowHeight > 0) {
            this.table.setRowHeight(rowHeight);
            if (this.rowHeader != null) {
                this.rowHeader.setRowHeight(rowHeight);
            }
        }
        this.tree.setRowHeight(rowHeight);
        if (rowHeight <= 0 && oldRowHeight > 0) {
            this.updateTableRowHeights();
        }
    }

    public int getRowHeight(int row) {
        return this.table.getRowHeight(row);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.tree == null ? null : this.tree.getSelectionModel();
    }

    public void setSelectionModel(TreeSelectionModel selectionModel) {
        if (this.tree != null) {
            this.tree.setSelectionModel(selectionModel);
        }
    }

    public ListSelectionModel getRowSelectionModel() {
        return this.adapter;
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.tree.isSelectionEmpty();
    }

    public int getSelectionCount() {
        return this.tree.getSelectionCount();
    }

    public int getMaxSelectionRow() {
        return this.tree.getMaxSelectionRow();
    }

    public int getMinSelectionRow() {
        return this.tree.getMinSelectionRow();
    }

    public boolean isPathSelected(TreePath path) {
        return this.tree.isPathSelected(path);
    }

    public boolean isRowSelected(int row) {
        return this.isPathSelected(this.getPathForRow(row));
    }

    public boolean isColumnSelected(int column) {
        return this.columnModel.getSelectionModel().isSelectedIndex(column);
    }

    public boolean isCellSelected(int row, int column) {
        if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
            return false;
        }
        return !(this.getRowSelectionAllowed() && !this.isRowSelected(row) || this.getColumnSelectionAllowed() && !this.isColumnSelected(column));
    }

    public TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    public void setAnchorSelectionPath(TreePath newPath) {
        this.tree.setAnchorSelectionPath(newPath);
    }

    public TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    public void setLeadSelectionPath(TreePath newPath) {
        this.tree.setLeadSelectionPath(newPath);
    }

    public int getLeadSelectionRow() {
        return this.tree.getLeadSelectionRow();
    }

    public int getLeadSelectionColumn() {
        return this.columnModel.getSelectionModel().getLeadSelectionIndex();
    }

    public boolean getExpandsSelectedPaths() {
        return this.tree.getExpandsSelectedPaths();
    }

    public void setExpandsSelectedPaths(boolean newValue) {
        this.tree.setExpandsSelectedPaths(newValue);
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public int getSelectedRow() {
        return this.getRowForPath(this.getSelectionPath());
    }

    public TreePath[] getSelectionPaths() {
        return this.tree.getSelectionPaths();
    }

    public void setSelectionPaths(TreePath[] paths) {
        this.tree.setSelectionPaths(paths);
    }

    public int[] getSelectionRows() {
        return this.tree.getSelectionRows();
    }

    public int[] getSelectedRows() {
        return this.getSelectionRows();
    }

    public void addSelectionInterval(int index0, int index1) {
        this.tree.addSelectionInterval(index0, index1);
    }

    public void addSelectionPath(TreePath path) {
        this.tree.addSelectionPath(path);
    }

    public void addSelectionPaths(TreePath[] paths) {
        this.tree.addSelectionPaths(paths);
    }

    public void addSelectionRow(int row) {
        this.addSelectionPath(this.getPathForRow(row));
    }

    public void addSelectionRows(int[] rows) {
        this.tree.addSelectionRows(rows);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.tree.removeSelectionInterval(index0, index1);
    }

    public void removeSelectionPath(TreePath path) {
        this.tree.removeSelectionPath(path);
    }

    public void removeSelectionPaths(TreePath[] paths) {
        this.tree.removeSelectionPaths(paths);
    }

    public void removeSelectionRow(int row) {
        this.removeSelectionPath(this.getPathForRow(row));
    }

    public void removeSelectionRows(int[] rows) {
        this.tree.removeSelectionRows(rows);
    }

    public void setSelectionRows(int[] rows) {
        this.tree.setSelectionRows(rows);
    }

    public void setSelectionRow(int row) {
        this.setSelectionPath(this.getPathForRow(row));
    }

    public void setSelectionInterval(int index0, int index1) {
        this.tree.setSelectionInterval(index0, index1);
    }

    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        this.table.changeSelection(row, column, toggle, extend);
    }

    public Color getSelectionForeground() {
        return this.table.getSelectionForeground();
    }

    public void setSelectionForeground(Color selectionForeground) {
        this.table.setSelectionForeground(selectionForeground);
    }

    public Color getSelectionBackground() {
        return this.table.getSelectionBackground();
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.table.setSelectionBackground(selectionBackground);
    }

    public int getSelectedRowCount() {
        return this.getSelectionCount();
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    public int getSelectedColumnCount() {
        return this.columnModel.getSelectedColumnCount();
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        return this.table.getCellBounds(row, column, includeSpacing);
    }

    public int columnAtPoint(Point pt) {
        return this.table.columnAtPoint(pt);
    }

    public int rowAtPoint(Point pt) {
        return this.table.rowAtPoint(pt);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size;
        if (this.adapter.treeColumnModel.getHierarchicalColumn() < 0) {
            int ht = this.getRowHeight();
            if (ht <= 0) {
                ht = 20;
            }
            size = new Dimension(this.tree.getVisibleRowCount() * ht, 0);
        } else {
            size = this.tree.getPreferredScrollableViewportSize();
        }
        TableColumnModel cm = this.getColumnModel();
        int width = 0;
        int col = cm.getColumnCount();
        while (--col >= 0) {
            width += cm.getColumn(col).getPreferredWidth();
        }
        size.width = width + cm.getColumnMargin() * cm.getColumnCount();
        return size;
    }

    private Scrollable getScrollable(int orientation) {
        return orientation == 1 ? this.tree : this.table;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollable(orientation).getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.table.getScrollableTracksViewportHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.table.getScrollableTracksViewportWidth();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollable(orientation).getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    void repaint(TreePath path, int col) {
        if (col < 0) {
            this.repaint(path);
        } else if (path != null) {
            this.repaint(this.getCellRect(this.getRowForPath(path), col, true));
        }
    }

    void repaint(TreePath path) {
        if (path == null) {
            return;
        }
        Rectangle r = this.tree.getPathBounds(path);
        if (r == null) {
            return;
        }
        r.x = 0;
        r.width = this.getWidth();
        this.repaint(r);
    }

    protected Adapter createAdapter(TreeModel tm, TreeColumnModel tcm) {
        return new Adapter(tm, tcm);
    }

    public Map<TreePath, RowSorter.SortKey> getSortedPaths() {
        return Collections.unmodifiableMap(this.sortedPaths);
    }

    public boolean getExpandsSortedNodes() {
        return this.expandsSortedNodes;
    }

    public void setExpandesSortedNodes(boolean expandsSortedNodes) {
        boolean oldValue = this.getExpandsSortedNodes();
        this.expandsSortedNodes = expandsSortedNodes;
        this.firePropertyChange("expandsSortedNodes", oldValue, this.getExpandsSortedNodes());
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        boolean oldValue = this.getDragEnabled();
        this.dragEnabled = dragEnabled;
        this.firePropertyChange("dragEnabled", oldValue, this.getDragEnabled());
        if (this.getDragEnabled()) {
            this.updateDropMode();
        }
    }

    public DropMode getDropMode() {
        return this.table.getDropMode();
    }

    public void setDropMode(DropMode dropMode) {
        if (dropMode == null) {
            this.dropModeSet = false;
            this.updateDropMode();
        } else {
            switch (dropMode) {
                default: {
                    throw new IllegalArgumentException("Unsupported DropMode: " + (Object)((Object)dropMode));
                }
                case ON: 
                case INSERT: 
                case INSERT_ROWS: 
                case INSERT_COLS: 
                case ON_OR_INSERT: 
                case ON_OR_INSERT_ROWS: 
                case ON_OR_INSERT_COLS: 
            }
            this.dropModeSet = true;
            this.table.setDropMode(dropMode);
        }
    }

    private void updateDropMode() {
        if (this.dropModeSet) {
            return;
        }
        if (this.getRowSelectionAllowed()) {
            if (this.getColumnSelectionAllowed()) {
                this.table.setDropMode(DropMode.ON);
            } else {
                this.table.setDropMode(DropMode.INSERT_ROWS);
            }
        } else if (this.getColumnSelectionAllowed()) {
            this.table.setDropMode(DropMode.INSERT_COLS);
        } else {
            this.table.setDropMode(DropMode.ON);
        }
    }

    public DropLocation getDropLocation() {
        if (this.dtde != null) {
            return this.createDropLocation(this.dtde.getLocation());
        }
        return this.dropLocation;
    }

    @Override
    public void setTransferHandler(TransferHandler th) {
        super.setTransferHandler(th);
        if (th != null) {
            this.setDropTarget(new DT(this.getDropTarget()));
        }
    }

    private void setDropLocation(Point pt) {
        DropLocation oldLocation = this.dropLocation;
        DropLocation dropLocation = this.dropLocation = pt == null ? null : this.createDropLocation(pt);
        if (oldLocation == null || this.dropLocation == null) {
            if (oldLocation != this.dropLocation) {
                this.repaint(oldLocation, this.dropLocation);
            }
        } else if (oldLocation.equals(this.dropLocation)) {
            this.maybeTogglePath(oldLocation, pt);
        } else {
            if (pt.equals(oldLocation.getDropPoint())) {
                this.dropLocation.when = oldLocation.when;
            }
            this.repaint(oldLocation, this.dropLocation);
        }
    }

    private void repaint(DropLocation a, DropLocation b) {
        int minRow = Integer.MAX_VALUE;
        int maxRow = -1;
        if (a != null) {
            minRow = Math.min(minRow, a.getRow() - 1);
            maxRow = Math.max(maxRow, a.getRow());
        }
        if (b != null) {
            minRow = Math.min(minRow, b.getRow() - 1);
            maxRow = Math.max(maxRow, b.getRow());
        }
        Rectangle r = this.getCellRect(Math.max(0, minRow), 0, true);
        if (maxRow >= this.getRowCount()) {
            r.height = this.getHeight() - r.y;
        } else {
            r.add(this.getCellRect(maxRow, 0, true));
        }
        r.x = 0;
        r.width = this.getWidth();
        this.repaint(r);
    }

    private void maybeTogglePath(DropLocation oldLocation, Point pt) {
        if (!pt.equals(oldLocation.getDropPoint())) {
            this.dropLocation.when = 0L;
            return;
        }
        long when = oldLocation.when;
        if (when == 0L) {
            TreePath path = this.getPathForLocation(pt.x, pt.y);
            this.dropLocation.when = path == null ? (this.isOverTreeHandle(pt) ? System.currentTimeMillis() : -1L) : (this.isLeaf(path) || this.isExpanded(path) ? -1L : System.currentTimeMillis());
        } else if (when > 0L && System.currentTimeMillis() - when > 900L) {
            TreePath path = this.getClosestPathForLocation(pt.x, pt.y);
            if (this.isExpanded(path)) {
                this.collapsePath(path);
            } else {
                this.expandPath(path);
            }
            this.dropLocation.when = -1L;
        } else {
            this.dropLocation.when = when;
        }
    }

    private boolean isOverTreeHandle(Point pt) {
        int row;
        int col = this.columnAtPoint(pt);
        if (col >= 0 && col == this.getHierarchicalColumn() && (row = this.rowAtPoint(pt)) >= 0) {
            return this.getDistanceToTreeHandle(this.getPathForRow(row), pt.x) == 0;
        }
        return false;
    }

    private DropLocation createDropLocation(Point pt) {
        Rectangle cell;
        TreePath path = null;
        int index = -1;
        int row = this.rowAtPoint(pt);
        int col = this.columnAtPoint(pt);
        boolean insertRow = false;
        boolean insertColumn = false;
        DropMode mode = this.getDropMode();
        switch (mode) {
            case INSERT: {
                if (row < 0) {
                    mode = DropMode.INSERT_ROWS;
                    break;
                }
                if (col < 0) {
                    mode = DropMode.INSERT_COLS;
                    break;
                }
                cell = this.getCellRect(row, col, true);
                int dx = Math.min(pt.x - cell.x, cell.x + cell.width - pt.x);
                int dy = Math.min(pt.y - cell.y, cell.y + cell.height - pt.y);
                mode = dy < dx ? DropMode.INSERT_ROWS : DropMode.INSERT_COLS;
                break;
            }
            case ON_OR_INSERT: {
                if (row < 0) {
                    mode = DropMode.INSERT_ROWS;
                    break;
                }
                if (col < 0) {
                    mode = DropMode.INSERT_COLS;
                    break;
                }
                cell = this.getCellRect(row, col, true);
                int dx = Math.min(pt.x - cell.x, cell.x + cell.width - pt.x);
                int dy = Math.min(pt.y - cell.y, cell.y + cell.height - pt.y);
                if (dy < dx) {
                    mode = dy < cell.height / 4 ? DropMode.INSERT_ROWS : DropMode.ON;
                    break;
                }
                mode = dx < cell.width / 4 ? DropMode.INSERT_COLS : DropMode.ON;
                break;
            }
            case ON_OR_INSERT_ROWS: {
                if (row < 0) {
                    mode = DropMode.INSERT_ROWS;
                    break;
                }
                cell = this.getCellRect(row, col, true);
                int dy = Math.min(pt.y - cell.y, cell.y + cell.height - pt.y);
                mode = dy < cell.height / 4 ? DropMode.INSERT_ROWS : DropMode.ON;
                break;
            }
            case ON_OR_INSERT_COLS: {
                if (col < 0) {
                    mode = DropMode.INSERT_COLS;
                    break;
                }
                cell = this.getCellRect(row, col, true);
                int dx = Math.min(pt.x - cell.x, cell.x + cell.width - pt.x);
                mode = dx < cell.width / 4 ? DropMode.INSERT_COLS : DropMode.ON;
            }
        }
        switch (mode) {
            case ON: {
                if (row < 0) {
                    col = -1;
                    break;
                }
                if (col < 0) {
                    row = -1;
                    break;
                }
                path = this.getPathForRow(row);
                break;
            }
            case INSERT_ROWS: {
                insertRow = true;
                if (row < 0) {
                    row = this.getRowCount();
                    path = row == 0 ? new TreePath(this.adapter.treeRoot) : ((path = this.getPathForRow(row - 1)).getPathCount() < 3 ? new TreePath(this.adapter.treeRoot) : path.getParentPath().getParentPath());
                    index = this.getChildCount(path);
                    break;
                }
                TreePath rowPath = this.getPathForRow(row);
                path = rowPath.getParentPath();
                int n = index = path == null ? 0 : this.adapter.getIndexOfChild(path.getLastPathComponent(), rowPath.getLastPathComponent());
                if (path == null) {
                    path = rowPath;
                    if (!this.isRootVisible()) break;
                    row = 1;
                    break;
                }
                Rectangle cell2 = this.getCellRect(row, col, true);
                if (pt.y <= cell2.y + cell2.height / 2) break;
                if (this.isExpanded(rowPath)) {
                    path = rowPath;
                    index = 0;
                } else {
                    ++index;
                }
                ++row;
                break;
            }
            case INSERT_COLS: {
                insertColumn = true;
                if (row < 0) {
                    col = -1;
                    break;
                }
                path = this.getPathForRow(row);
                if (col < 0) {
                    col = this.columnModel.getColumnCount();
                    break;
                }
                cell = this.getCellRect(row, col, true);
                if (pt.x <= cell.x + cell.width / 2) break;
                ++col;
            }
        }
        return new DropLocation(pt, path, index, row, col, insertRow, insertColumn);
    }

    public int getNextMatch(String prefix, int startingRow, int column, Position.Bias bias) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        TableModel mdl = this.getTableModel();
        int max = this.getRowCount();
        if (startingRow < 0 || startingRow >= max) {
            throw new IllegalArgumentException();
        }
        int col = this.convertColumnIndexToModel(column);
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        prefix = prefix.toUpperCase();
        int index = startingRow;
        do {
            String str;
            if ((str = this.convertValueToText(mdl.getValueAt(index, col), column)).isEmpty() || !(str = str.toUpperCase()).startsWith(prefix)) continue;
            return index;
        } while ((index = (index + increment + max) % max) != startingRow);
        return -1;
    }

    public String convertValueToText(Object value, int column) {
        if (value == null) {
            return "";
        }
        String str = value.toString();
        return str == null ? "" : str;
    }

    public boolean isLeaf(TreePath path) {
        return this.getTreeModel().isLeaf(path.getLastPathComponent());
    }

    public int getChildCount(TreePath path) {
        return this.adapter.getChildCount(path.getLastPathComponent());
    }

    public int getDistanceToTreeHandle(TreePath path, int x) {
        return this.getUI().getDistanceToTreeHandle(this, path, x);
    }

    public int getAlignment(Component rendererComponent, int row, int column) {
        if (rendererComponent instanceof JLabel) {
            return this.getAlignment(((JLabel)rendererComponent).getHorizontalAlignment());
        }
        if (rendererComponent instanceof AbstractButton) {
            return this.getAlignment(((AbstractButton)rendererComponent).getHorizontalAlignment());
        }
        return 0;
    }

    private int getAlignment(int align) {
        switch (align) {
            case 10: {
                return this.getComponentOrientation().isLeftToRight() ? 2 : 4;
            }
            case 11: {
                return this.getComponentOrientation().isLeftToRight() ? 4 : 2;
            }
        }
        return align;
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final TreePath path;
        private final int index;
        private final int row;
        private final int column;
        private final boolean isInsertRow;
        private final boolean isInsertColumn;
        long when = 0L;

        DropLocation(Point pt, TreePath pth, int idx, int row, int col, boolean insertRow, boolean insertColumn) {
            super(pt);
            this.path = pth;
            this.index = idx;
            this.row = row;
            this.column = col;
            this.isInsertRow = insertRow;
            this.isInsertColumn = insertColumn;
        }

        public TreePath getPath() {
            return this.path;
        }

        public int getIndex() {
            return this.index;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean isInsertRow() {
            return this.isInsertRow;
        }

        public boolean isInsertColumn() {
            return this.isInsertColumn;
        }

        public boolean equals(DropLocation o) {
            return o != null && this.row == o.row && this.column == o.column && this.isInsertRow == o.isInsertRow && this.isInsertColumn == o.isInsertColumn && this.index == o.index && (this.path == null ? o.path == null : this.path.equals(o.path));
        }
    }

    private class DT
    extends DropTarget {
        private DropTarget delegate;

        DT(DropTarget dt) {
            super(dt.getComponent(), dt.getDefaultActions(), null);
            this.delegate = dt;
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            TreeTable.this.dtde = new DTDE(e);
            try {
                this.delegate.dragEnter(TreeTable.this.dtde);
            }
            finally {
                TreeTable.this.dtde = null;
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.delegate.dragExit(dte);
            TreeTable.this.setDropLocation(null);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            TreeTable.this.dtde = new DTDE(e);
            try {
                this.delegate.dragOver(TreeTable.this.dtde);
            }
            finally {
                TreeTable.this.dtde = null;
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            this.delegate.drop(dtde);
            TreeTable.this.setDropLocation(null);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.delegate.dropActionChanged(dtde);
        }

        @Override
        public void addDropTargetListener(DropTargetListener dtl) throws TooManyListenersException {
            this.delegate.addDropTargetListener(dtl);
        }

        @Override
        public void removeDropTargetListener(DropTargetListener dtl) {
            this.delegate.removeDropTargetListener(dtl);
        }
    }

    private class DTDE
    extends DropTargetDragEvent {
        private DropTargetDragEvent dtde;

        DTDE(DropTargetDragEvent e) {
            super(e.getDropTargetContext(), e.getLocation(), e.getDropAction(), e.getSourceActions());
            this.dtde = e;
        }

        @Override
        public void acceptDrag(int dragOperation) {
            TreeTable.this.setDropLocation(this.dtde.getLocation());
            this.dtde.acceptDrag(dragOperation);
        }

        @Override
        public void rejectDrag() {
            TreeTable.this.setDropLocation(null);
            this.dtde.rejectDrag();
        }
    }

    private static class RowHeaderAdapter
    extends AbstractTableModel
    implements TableModelListener,
    PropertyChangeListener {
        private TableModel model;

        RowHeaderAdapter(TableModel m) {
            this.model = m;
            m.addTableModelListener(this);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return rowIndex;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(new TableModelEvent(this, e.getFirstRow(), e.getLastRow(), 0, e.getType()));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TreeTable.updateRowHeaderRenderer((JTable)evt.getSource());
        }
    }

    private static class SorterHelper
    implements Comparator<AbstractMap.SimpleEntry<Integer, Object>> {
        private final RowSorter<?> sorter;
        private final int[] childIndices;
        private final Object[] childNodes;
        int[] viewIndices;
        Object[] viewNodes;
        int firstRow;
        int lastRow;

        SorterHelper(RowSorter<?> s, int[] i, Object[] n) {
            this.sorter = s;
            this.childIndices = i;
            this.childNodes = n;
        }

        @Override
        public int compare(AbstractMap.SimpleEntry<Integer, Object> a, AbstractMap.SimpleEntry<Integer, Object> b) {
            return a.getKey() - b.getKey();
        }

        boolean useAllChanged() {
            int[] childIndices = this.childIndices;
            int firstRow = -1;
            int lastRow = -1;
            int i = childIndices.length;
            while (--i >= 0) {
                int idx = childIndices[i];
                if (firstRow < 0) {
                    firstRow = lastRow = idx;
                    continue;
                }
                if (idx == firstRow - 1) {
                    firstRow = idx;
                    continue;
                }
                return true;
            }
            this.firstRow = firstRow;
            this.lastRow = lastRow;
            return false;
        }

        boolean computeView() {
            int[] viewIndices = new int[this.childIndices.length];
            Object[] viewNodes = new Object[this.childIndices.length];
            int viewLen = 0;
            for (int i = 0; i < this.childIndices.length; ++i) {
                int idx = this.childIndices[i];
                int view = this.sorter.convertRowIndexToView(idx);
                if (view < 0) continue;
                viewIndices[viewLen] = view;
                viewNodes[viewLen++] = this.childNodes[i];
            }
            if (viewLen == 0) {
                return false;
            }
            if (viewLen != viewIndices.length) {
                viewIndices = Arrays.copyOf(viewIndices, viewLen);
                viewNodes = Arrays.copyOf(viewNodes, viewLen);
            }
            AbstractMap.SimpleEntry[] entries = new AbstractMap.SimpleEntry[viewLen];
            int i = viewLen;
            while (--i >= 0) {
                entries[i] = new AbstractMap.SimpleEntry<Integer, Object>(viewIndices[i], viewNodes[i]);
            }
            Arrays.sort(entries, this);
            i = viewLen;
            while (--i >= 0) {
                viewIndices[i] = (Integer)entries[i].getKey();
                viewNodes[i] = entries[i].getValue();
            }
            this.viewIndices = viewIndices;
            this.viewNodes = viewNodes;
            return true;
        }
    }

    protected class Adapter
    extends AbstractTableModel
    implements TreeTableModel,
    TreeModelListener,
    TreeColumnModelListener,
    ListSelectionModel,
    PropertyChangeListener,
    TreeTableSorterListener,
    TreeExpansionListener,
    TreeSelectionListener,
    TreeWillExpandListener,
    ToolTipMap<TreeTable> {
        protected TreeModel treeModel;
        protected TreeColumnModel treeColumnModel;
        protected Object treeRoot;
        private TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> rowSorter;
        private boolean ignoreSortedChange = false;

        Adapter() {
        }

        public Adapter(TreeModel tm, TreeColumnModel tcm) {
            this.treeModel = tm;
            this.treeColumnModel = tcm;
            this.treeRoot = tm.getRoot();
            tm.addTreeModelListener(this);
            tcm.addTreeColumnModelListener(this);
        }

        public void setTreeModel(TreeModel m) {
            if (this.treeModel != null) {
                this.treeModel.removeTreeModelListener(this);
            }
            this.treeModel = m;
            if (this.treeModel != null) {
                this.treeModel.addTreeModelListener(this);
                TreeModelEvent e = new TreeModelEvent((Object)this.treeModel, new TreePath(this.treeModel.getRoot()));
                this.treeStructureChanged(e);
            }
        }

        public void setRowSorter(TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> sorter) {
            if (this.rowSorter != null) {
                this.rowSorter.removeTreeTableSorterListener(this);
            }
            this.rowSorter = sorter;
            if (sorter != null) {
                sorter.addTreeTableSorterListener(this);
            }
        }

        @Override
        public int getColumnCount() {
            return this.treeColumnModel.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return this.treeColumnModel.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.treeColumnModel.getColumnClass(column);
        }

        @Override
        public int getRowCount() {
            return TreeTable.this.tree.getRowCount();
        }

        public Object getNode(int row) {
            return TreeTable.this.getPathForRow(row).getLastPathComponent();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.treeColumnModel.getValueAt(this.getNode(row), column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.treeColumnModel.setValueAt(value, this.getNode(row), column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.treeColumnModel.isCellEditable(this.getNode(row), column);
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            if (TreeTable.this.getRowHeight() <= 0) {
                TreeTable.this.updateTableRowHeights();
            }
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
            if (TreeTable.this.getRowHeight() <= 0) {
                TreeTable.this.updateTableRowHeights();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeColumnChanged(TreeColumnModelEvent e) {
            int row;
            TreePath path = e.getTreePath();
            if (this.rowSorter != null) {
                RowSorter<? extends TreeModel> sorter;
                RowSorter<? extends TreeModel> rowSorter = sorter = path.getParentPath() != null ? this.rowSorter.getRowSorter(path.getParentPath().getLastPathComponent()) : null;
                if (sorter != null && path.getParentPath() != null) {
                    boolean isc = this.ignoreSortedChange;
                    this.ignoreSortedChange = true;
                    try {
                        Object parent = path.getParentPath().getLastPathComponent();
                        Object node = path.getLastPathComponent();
                        int modelRow = this.treeModel.getIndexOfChild(parent, node);
                        int viewRow = sorter.convertRowIndexToView(modelRow);
                        sorter.rowsUpdated(modelRow, modelRow);
                        if (sorter.convertRowIndexToView(modelRow) != viewRow) {
                            if (TreeTable.this.isExpanded(path)) {
                                this.updatePath(path, this.expandedDescendants(path));
                            } else {
                                this.fireTreeStructureChanged(path);
                            }
                            return;
                        }
                    }
                    finally {
                        this.ignoreSortedChange = isc;
                    }
                }
            }
            if ((row = TreeTable.this.getRowForPath(path)) < 0) {
                return;
            }
            if (e.getColumn() == -1) {
                this.fireTableRowsUpdated(row, row);
            } else {
                this.fireTableCellUpdated(row, e.getColumn());
            }
            if (TreeTable.this.getRowHeight() <= 0) {
                this.invalidatePath(e.getTreePath());
                TreeTable.this.updateTableRowHeights(row, row + 1);
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            int[] childIndices = e.getChildIndices();
            Object[] childNodes = e.getChildren();
            if (childNodes == null) {
                this.fireTreeNodesChanged(path, childIndices, childNodes);
                if (TreeTable.this.isRootVisible()) {
                    this.updateTable(0, 0, 0);
                }
            } else {
                this.processTreeNodesChanged(path, childIndices, childNodes);
                this.updateTable(path, this.getRows(path, childNodes), 0);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            int[] childIndices = e.getChildIndices();
            Object[] childNodes = e.getChildren();
            if (childIndices == null || childNodes == null) {
                return;
            }
            this.processTreeNodesInserted(path, childIndices, childNodes);
            this.updateTable(path, this.getRows(path, childNodes), 1);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            int[] childIndices = e.getChildIndices();
            Object[] childNodes = e.getChildren();
            if (childIndices == null || childNodes == null) {
                return;
            }
            int[] rows = this.getRows(path, childNodes);
            this.processTreeNodesRemoved(path, childIndices, childNodes);
            this.updateTable(path, rows, -1);
        }

        private int[] getRows(TreePath parent, Object[] childNodes) {
            if (!TreeTable.this.isExpanded(parent)) {
                return null;
            }
            if (parent.getPathCount() > 1 && TreeTable.this.getRowForPath(parent) < 0) {
                return null;
            }
            int[] rows = new int[childNodes.length];
            int len = 0;
            for (Object childNode : childNodes) {
                TreePath path = parent.pathByAddingChild(childNode);
                int r = TreeTable.this.getRowForPath(path);
                if (r < 0) continue;
                rows[len++] = r;
            }
            if (len == 0) {
                return null;
            }
            if (len != rows.length) {
                rows = Arrays.copyOf(rows, len);
            }
            return rows;
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            boolean rootChanged = false;
            if (path.getPathCount() == 1 && path.getLastPathComponent() != this.treeRoot) {
                rootChanged = true;
                this.treeRoot = path.getLastPathComponent();
            }
            if (this.rowSorter != null) {
                this.rowSorter.structureChanged(path, rootChanged);
            }
            this.fireTreeStructureChanged(path);
            if (rootChanged) {
                this.fireTableStructureChanged();
            } else if (TreeTable.this.isExpanded(path)) {
                this.fireTableDataChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTreeNodesChanged(TreePath path, int[] childIndices, Object[] childNodes) {
            RowSorter<? extends TreeModel> sorter;
            if (this.rowSorter != null && (sorter = this.rowSorter.getRowSorter(path.getLastPathComponent())) != null) {
                boolean isc = this.ignoreSortedChange;
                this.ignoreSortedChange = true;
                try {
                    if (childIndices.length == 1) {
                        int row = childIndices[0];
                        int viewRow = sorter.convertRowIndexToView(row);
                        sorter.rowsUpdated(row, row);
                        childIndices[0] = sorter.convertRowIndexToView(row);
                        if (childIndices[0] == viewRow) {
                            if (viewRow >= 0) {
                                this.fireTreeNodesChanged(path, childIndices, childNodes);
                            }
                            return;
                        }
                    } else {
                        SorterHelper help = new SorterHelper(sorter, childIndices, childNodes);
                        int[] viewIndices = null;
                        Object[] viewNodes = null;
                        if (help.computeView()) {
                            viewIndices = help.viewIndices;
                            viewNodes = help.viewNodes;
                        }
                        sorter.rowsUpdated(childIndices[0], childIndices[childIndices.length - 1]);
                        if (help.computeView()) {
                            if (Arrays.equals(viewIndices, help.viewIndices) && Arrays.equals(viewNodes, help.viewNodes)) {
                                this.fireTreeNodesChanged(path, viewIndices, viewNodes);
                                return;
                            }
                        } else if (viewIndices == null) {
                            return;
                        }
                    }
                }
                finally {
                    this.ignoreSortedChange = isc;
                }
                this.updatePath(path, this.expandedDescendants(path));
                return;
            }
            this.fireTreeNodesChanged(path, childIndices, childNodes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTreeNodesInserted(TreePath path, int[] childIndices, Object[] childNodes) {
            RowSorter<? extends TreeModel> sorter;
            if (this.rowSorter != null && (sorter = this.rowSorter.getRowSorter(path.getLastPathComponent())) != null) {
                boolean isc = this.ignoreSortedChange;
                this.ignoreSortedChange = true;
                try {
                    if (childIndices.length == 1) {
                        int row = childIndices[0];
                        sorter.rowsInserted(row, row);
                        childIndices[0] = sorter.convertRowIndexToView(row);
                        if (childIndices[0] >= 0) {
                            this.fireTreeNodesInserted(path, childIndices, childNodes);
                        }
                    } else {
                        SorterHelper help = new SorterHelper(sorter, childIndices, childNodes);
                        if (help.useAllChanged()) {
                            sorter.allRowsChanged();
                        } else {
                            sorter.rowsInserted(help.firstRow, help.lastRow);
                        }
                        if (help.computeView()) {
                            this.fireTreeNodesInserted(path, help.viewIndices, help.viewNodes);
                        }
                    }
                }
                finally {
                    this.ignoreSortedChange = isc;
                }
                return;
            }
            this.fireTreeNodesInserted(path, childIndices, childNodes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTreeNodesRemoved(TreePath path, int[] childIndices, Object[] childNodes) {
            RowSorter<? extends TreeModel> sorter;
            if (this.rowSorter != null && (sorter = this.rowSorter.getRowSorter(path.getLastPathComponent())) != null) {
                boolean isc = this.ignoreSortedChange;
                this.ignoreSortedChange = true;
                try {
                    if (childIndices.length == 1) {
                        int row = childIndices[0];
                        childIndices[0] = sorter.convertRowIndexToView(row);
                        if (childIndices[0] >= 0) {
                            this.fireTreeNodesRemoved(path, childIndices, childNodes);
                        }
                        sorter.rowsDeleted(row, row);
                    } else {
                        SorterHelper help = new SorterHelper(sorter, childIndices, childNodes);
                        if (help.computeView()) {
                            this.fireTreeNodesRemoved(path, help.viewIndices, help.viewNodes);
                        }
                        if (help.useAllChanged()) {
                            sorter.allRowsChanged();
                        } else {
                            sorter.rowsDeleted(help.firstRow, help.lastRow);
                        }
                    }
                }
                finally {
                    this.ignoreSortedChange = isc;
                }
                this.rowSorter.nodesRemoved(path, childNodes);
                return;
            }
            this.fireTreeNodesRemoved(path, childIndices, childNodes);
        }

        private void updateTable(TreePath parent, int[] rows, int eventType) {
            if (rows == null) {
                return;
            }
            int len = rows.length;
            if (len == 1) {
                this.updateTable(rows[0], rows[0], eventType);
            } else {
                int lastRow;
                int firstRow;
                Arrays.sort(rows, 0, len);
                if (eventType == -1) {
                    firstRow = rows[len - 1];
                    lastRow = rows[len - 1];
                    int i = len - 1;
                    while (--i >= 0) {
                        int idx = rows[i];
                        if (idx == firstRow - 1) {
                            firstRow = idx;
                            continue;
                        }
                        this.updateTable(firstRow, lastRow, eventType);
                        firstRow = lastRow = idx;
                    }
                } else {
                    firstRow = rows[0];
                    lastRow = rows[0];
                    for (int i = 1; i < len; ++i) {
                        int idx = rows[i];
                        if (idx == lastRow + 1) {
                            lastRow = idx;
                            continue;
                        }
                        this.updateTable(firstRow, lastRow, eventType);
                        lastRow = firstRow = idx;
                    }
                }
                this.updateTable(firstRow, lastRow, eventType);
            }
        }

        private void updateTable(int firstRow, int lastRow, int eventType) {
            this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, eventType));
            if (eventType != -1 && TreeTable.this.getRowHeight() <= 0) {
                TreeTable.this.updateTableRowHeights(firstRow, lastRow + 1);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            TreeTable.this.fireTreeExpansionEvent(e.getPath(), true);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            TreeTable.this.fireTreeExpansionEvent(e.getPath(), false);
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            TreeTable.this.fireTreeWillExpandEvent(e.getPath(), true);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
            TreeTable.this.fireTreeWillExpandEvent(e.getPath(), false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("leadSelectionPath") || name.equals("anchorSelectionPath")) {
                int col = !TreeTable.this.isColumnFocusEnabled() ? -1 : TreeTable.this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                TreeTable.this.repaint((TreePath)evt.getOldValue(), col);
                TreeTable.this.repaint((TreePath)evt.getNewValue(), col);
            } else if (name.equals("rowHeight") ? evt.getSource() != TreeTable.this.tree : name.equals("componentOrientation") || name.equals("enabled") || name.equals("rowSorter") || name.equals("model")) {
                return;
            }
            TreeTable.this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
        }

        @Override
        public void addListSelectionListener(ListSelectionListener l) {
            this.listenerList.add(ListSelectionListener.class, l);
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener l) {
            this.listenerList.remove(ListSelectionListener.class, l);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            TreeTable.this.tree.addSelectionInterval(index0, index1);
        }

        @Override
        public void clearSelection() {
            TreeTable.this.getSelectionModel().clearSelection();
        }

        @Override
        public int getAnchorSelectionIndex() {
            return TreeTable.this.getRowForPath(TreeTable.this.getAnchorSelectionPath());
        }

        @Override
        public int getLeadSelectionIndex() {
            return TreeTable.this.getRowForPath(TreeTable.this.getLeadSelectionPath());
        }

        @Override
        public int getMaxSelectionIndex() {
            return TreeTable.this.getSelectionModel().getMaxSelectionRow();
        }

        @Override
        public int getMinSelectionIndex() {
            return TreeTable.this.getSelectionModel().getMinSelectionRow();
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return TreeTable.this.getSelectionModel().isRowSelected(index);
        }

        @Override
        public boolean isSelectionEmpty() {
            return TreeTable.this.getSelectionModel().isSelectionEmpty();
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            TreePath anchor = TreeTable.this.getAnchorSelectionPath();
            TreeTable.this.tree.removeSelectionInterval(index0, index1);
            TreeTable.this.setAnchorSelectionPath(anchor);
            TreeTable.this.setLeadSelectionPath(TreeTable.this.getPathForRow(index1));
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
            TreeTable.this.setAnchorSelectionPath(TreeTable.this.getPathForRow(index));
        }

        @Override
        public void setLeadSelectionIndex(int index) {
            TreeTable.this.setLeadSelectionPath(TreeTable.this.getPathForRow(index));
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            TreeTable.this.setSelectionInterval(index0, index1);
            TreeTable.this.setAnchorSelectionPath(TreeTable.this.getPathForRow(index0));
            TreeTable.this.setLeadSelectionPath(TreeTable.this.getPathForRow(index1));
        }

        @Override
        public int getSelectionMode() {
            switch (TreeTable.this.getSelectionModel().getSelectionMode()) {
                case 2: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 1: {
                    return 0;
                }
            }
            return 2;
        }

        @Override
        public void setSelectionMode(int mode) {
            switch (mode) {
                default: {
                    return;
                }
                case 0: {
                    mode = 1;
                    break;
                }
                case 1: {
                    mode = 2;
                    break;
                }
                case 2: {
                    mode = 4;
                }
            }
            TreeTable.this.getSelectionModel().setSelectionMode(mode);
        }

        @Override
        public void setValueIsAdjusting(boolean valueIsAdjusting) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            int leadRow = TreeTable.this.getRowForPath(e.getNewLeadSelectionPath());
            int oldLeadRow = TreeTable.this.getRowForPath(e.getOldLeadSelectionPath());
            int minRow = Math.min(leadRow, oldLeadRow);
            int maxRow = Math.max(leadRow, oldLeadRow);
            TreePath[] paths = e.getPaths();
            if (paths != null) {
                for (TreePath path : paths) {
                    int row = TreeTable.this.getRowForPath(path);
                    minRow = Math.min(minRow, row);
                    maxRow = Math.max(maxRow, row);
                }
            }
            this.fireSelectionChanged(minRow, maxRow);
        }

        private void fireSelectionChanged(int firstRow, int lastRow) {
            ListSelectionEvent e = new ListSelectionEvent(this, firstRow, lastRow, false);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListSelectionListener.class) continue;
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        @Override
        public int getChildCount(Object parent) {
            RowSorter<? extends TreeModel> sorter;
            if (this.rowSorter != null && (sorter = this.rowSorter.getRowSorter(parent)) != null) {
                return sorter.getViewRowCount();
            }
            return this.treeModel.getChildCount(parent);
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.treeModel.getChild(parent, this.convertIndexToModel(parent, index));
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int index = this.treeModel.getIndexOfChild(parent, child);
            if (index < 0) {
                return index;
            }
            return this.convertIndexToView(parent, index);
        }

        @Override
        public Object getRoot() {
            return this.treeRoot;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.treeModel.isLeaf(node);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            this.treeModel.valueForPathChanged(path, newValue);
        }

        public int convertIndexToModel(Object parent, int index) {
            RowSorter<? extends TreeModel> sorter;
            if (this.rowSorter != null && (sorter = this.rowSorter.getRowSorter(parent)) != null) {
                return sorter.convertRowIndexToModel(index);
            }
            return index;
        }

        public int convertIndexToView(Object parent, int index) {
            RowSorter<? extends TreeModel> sorter;
            if (this.rowSorter != null && (sorter = this.rowSorter.getRowSorter(parent)) != null) {
                return sorter.convertRowIndexToView(index);
            }
            return index;
        }

        public void invalidateRows(int firstRow, int lastRow) {
            if (firstRow == lastRow) {
                this.invalidatePath(TreeTable.this.getPathForRow(firstRow));
            } else {
                HashMap<TreePath, ArrayList<Object>> map = new HashMap<TreePath, ArrayList<Object>>();
                int row = firstRow;
                TreePath path = TreeTable.this.getPathForRow(row);
                TreePath parentPath = path.getParentPath();
                if (parentPath == null) {
                    this.invalidatePaths(path, null, null);
                    path = TreeTable.this.getPathForRow(++row);
                    parentPath = path.getParentPath();
                }
                while (true) {
                    ArrayList<Object> list;
                    if ((list = (ArrayList<Object>)map.get(parentPath)) == null) {
                        list = new ArrayList<Object>();
                        map.put(parentPath, list);
                    }
                    list.add(path.getLastPathComponent());
                    if (++row > lastRow) break;
                    path = TreeTable.this.getPathForRow(row);
                    parentPath = path.getParentPath();
                }
                for (Map.Entry entry : map.entrySet()) {
                    Object parentNode = ((TreePath)entry.getKey()).getLastPathComponent();
                    Object[] childNodes = ((ArrayList)entry.getValue()).toArray();
                    int[] childIndices = new int[childNodes.length];
                    int i = childNodes.length;
                    while (--i >= 0) {
                        childIndices[i] = this.getIndexOfChild(parentNode, childNodes[i]);
                    }
                    this.invalidatePaths((TreePath)entry.getKey(), childIndices, childNodes);
                }
            }
        }

        void _invalidateRows(int firstRow, int lastRow) {
            for (int row = lastRow; row >= firstRow; --row) {
                this.invalidatePath(TreeTable.this.getPathForRow(row));
            }
        }

        public void invalidatePath(TreePath path) {
            Object[] childNodes;
            int[] children;
            if (path.getParentPath() == null) {
                children = null;
                childNodes = null;
            } else {
                Object node = path.getLastPathComponent();
                Object parentNode = (path = path.getParentPath()).getLastPathComponent();
                int index = this.getIndexOfChild(parentNode, node);
                if (index < 0) {
                    return;
                }
                children = new int[]{index};
                childNodes = new Object[]{node};
            }
            this.invalidatePaths(path, children, childNodes);
        }

        public void invalidatePaths(TreePath path, int[] childIndices, Object[] children) {
            this.fireTreeNodesChanged(path, childIndices, children);
        }

        protected void fireTreeNodesChanged(TreePath path, int[] childIndices, Object[] childNodes) {
            AbstractTreeModel.fireNodesChanged(this.listenerList, this, path, childIndices, childNodes);
        }

        protected void fireTreeNodesInserted(TreePath path, int[] childIndices, Object[] childNodes) {
            AbstractTreeModel.fireNodesInserted(this.listenerList, this, path, childIndices, childNodes);
        }

        protected void fireTreeNodesRemoved(TreePath path, int[] childIndices, Object[] childNodes) {
            AbstractTreeModel.fireNodesRemoved(this.listenerList, this, path, childIndices, childNodes);
        }

        protected void fireTreeStructureChanged(TreePath path) {
            AbstractTreeModel.fireTreeStructureChanged(this.listenerList, this, path);
        }

        @Override
        public void sorterChanged(TreeTableSorterEvent e) {
            switch (e.getType()) {
                case SORT_ORDER_CHANGED: {
                    JTableHeader header = TreeTable.this.getTableHeader();
                    if (header == null) break;
                    header.repaint();
                    break;
                }
                case SORTED: {
                    TreePath root = new TreePath(this.treeRoot);
                    this.updatePath(root, this.expandedDescendants(root));
                    if (TreeTable.this.getRowHeight() > 0) break;
                    TreeTable.this.updateTableRowHeights();
                    break;
                }
                case NODE_SORTED: {
                    this.nodeSorted(e.getTreePath());
                }
            }
        }

        private void nodeSorted(TreePath path) {
            if (!this.ignoreSortedChange) {
                RowSorter<? extends TreeModel> sorter = this.rowSorter.getRowSorter(path.getLastPathComponent());
                RowSorter.SortKey key = sorter.getSortKeys().get(0);
                if (key.getSortOrder() == SortOrder.UNSORTED) {
                    TreeTable.this.sortedPaths.remove(path);
                } else {
                    TreeTable.this.sortedPaths.put(path, key);
                }
                this.updatePath(path, this.expandedDescendants(path));
                if (TreeTable.this.getExpandsSortedNodes() && !TreeTable.this.isExpanded(path)) {
                    TreeTable.this.expandPath(path);
                }
            }
        }

        private List<TreePath> expandedDescendants(TreePath path) {
            Enumeration<TreePath> e = TreeTable.this.getExpandedDescendants(path);
            return e == null ? Collections.emptyList() : Collections.list(e);
        }

        void updatePath(TreePath path, List<TreePath> exp) {
            TreePath[] sel;
            block3: {
                block2: {
                    sel = TreeTable.this.getSelectionPaths();
                    int row = TreeTable.this.getRowForPath(path);
                    int rowCount = this.getRowCount();
                    this.fireTreeStructureChanged(path);
                    int newRowCount = this.getRowCount();
                    if (newRowCount != rowCount) break block2;
                    int count = this.getChildCount(path.getLastPathComponent());
                    if (count <= 0) break block3;
                    this.fireTableRowsUpdated(row + 1, row + count);
                    if (TreeTable.this.getRowHeight() > 0) break block3;
                    TreeTable.this.updateTableRowHeights(row + 1, row + count + 1);
                    break block3;
                }
                this.fireTableDataChanged();
                if (TreeTable.this.getRowHeight() <= 0) {
                    TreeTable.this.updateTableRowHeights();
                }
                for (TreePath p : exp) {
                    TreeTable.this.expandPath(p);
                }
            }
            TreeTable.this.setSelectionPaths(sel);
        }

        void updateSorter(TreePath path, boolean visible) {
            if (this.rowSorter != null) {
                List<TreePath> subPaths = visible ? this.expandedDescendants(path) : Collections.emptyList();
                this.rowSorter.setVisible(path, subPaths, visible);
                if (visible) {
                    this.updatePath(path, subPaths);
                }
            }
        }

        RowSorter<?> getSorter(TreePath path) {
            return this.rowSorter == null ? null : this.rowSorter.getRowSorter(path);
        }

        @Override
        public String getToolTipText(TreeTable treeTable, MouseEvent event) {
            Point pt = event.getPoint();
            int row = treeTable.rowAtPoint(pt);
            int col = treeTable.columnAtPoint(pt);
            String tip = null;
            if (row >= 0 && col >= 0) {
                TreeTableCellRenderer r = treeTable.getCellRenderer(row, col);
                boolean sel = treeTable.isCellSelected(row, col);
                boolean foc = treeTable.isColumnFocusEnabled() && col == treeTable.getLeadSelectionColumn() && row == treeTable.getLeadSelectionRow() && treeTable.isFocusOwner();
                Component c = r.getTreeTableCellRendererComponent(treeTable, treeTable.getValueAt(row, col), sel, foc, row, col);
                if (c instanceof JComponent) {
                    Rectangle cell = treeTable.getCellRect(row, col, false);
                    pt.translate(-cell.x, -cell.y);
                    MouseEvent e = new MouseEvent(c, event.getID(), event.getWhen(), event.getModifiers(), pt.x, pt.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), 0);
                    tip = ((JComponent)c).getToolTipText(e);
                }
            }
            if (tip == null) {
                tip = treeTable.getToolTipText();
            }
            return tip;
        }
    }
}

