/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.treetable.j.ui;

import com.sun.java.swing.Painter;
import de.sciss.treetable.j.CellEditorContainer;
import de.sciss.treetable.j.DefaultTreeTableCellEditor;
import de.sciss.treetable.j.DefaultTreeTableCellRenderer;
import de.sciss.treetable.j.TreeColumnModel;
import de.sciss.treetable.j.TreeTable;
import de.sciss.treetable.j.TreeTableCellEditor;
import de.sciss.treetable.j.TreeTableCellRenderer;
import de.sciss.treetable.j.TreeTableSorter;
import de.sciss.treetable.j.ui.TableInterface;
import de.sciss.treetable.j.ui.TreeInterface;
import de.sciss.treetable.j.ui.TreeTableUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.dnd.DragSource;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.CellEditor;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.synth.Region;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class BasicTreeTableUI
extends TreeTableUI {
    protected TreeTable treeTable;
    private JTree tree;
    private JTable table;
    protected Renderer treeTableCellRenderer;
    protected Editor treeTableCellEditor;
    protected DefaultTreeTableCellRenderer defaultTreeCellRenderer;
    protected Handler handler;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private List<String> properties;
    private PropertyChangeListener propertyChangeListener;
    private TreePath mouseOverSortPath;
    private int mouseOverSortColumn;
    private boolean paintMouseOverSortPath;
    private int sortWidth = -1;
    private Border ltrBorder;
    private Border rtlBorder;
    private Border noFocusBorder;
    private int treeHandleWidth = -1;

    @Override
    public void installUI(JComponent c) {
        this.treeTable = (TreeTable)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.tree = null;
        this.table = null;
        this.treeTable = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.treeTable, "Table.background", "Table.foreground", "Table.font");
        if (this.treeTable.getAlternateRowColor() == null || this.treeTable.getAlternateRowColor() instanceof UIResource) {
            Color c = UIManager.getColor("Table.alternateRowColor");
            this.treeTable.setAlternateRowColor(c);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.handler = this.createHandler();
        TreeTableCellRenderer focusRenderer = this.treeTable.getFocusRenderer();
        if (focusRenderer == null || focusRenderer instanceof UIResource) {
            this.treeTable.setFocusRenderer(this.createFocusRenderer());
        }
        this.tree = this.createAndConfigureTree();
        this.table = this.createAndConfigureTable();
        this.treeTableCellRenderer = this.createCellRenderer();
        this.treeTableCellEditor = this.createCellEditor();
        this.defaultTreeCellRenderer = new DefaultTreeTableCellRenderer();
        this.tree.setCellRenderer(this.treeTableCellRenderer);
        if (this.treeTable.getRowSorter() != null) {
            this.table.setRowSorter(new RowSorterAdapter());
        }
    }

    protected void uninstallComponents() {
        this.unconfigureTree();
        this.unconfigureTable();
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        if (this.focusListener != null) {
            this.treeTable.addFocusListener(this.focusListener);
        }
        this.keyListener = this.createKeyListener();
        if (this.keyListener != null) {
            this.treeTable.addKeyListener(this.keyListener);
        }
        this.mouseListener = this.createMouseListener();
        if (this.mouseListener != null) {
            this.treeTable.addMouseListener(this.mouseListener);
        }
        this.mouseMotionListener = this.createMouseMotionListener();
        if (this.mouseMotionListener != null) {
            this.treeTable.addMouseMotionListener(this.mouseMotionListener);
        }
        this.properties = this.getProperties();
        if (this.properties == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
            if (this.propertyChangeListener != null) {
                this.treeTable.addPropertyChangeListener(this.propertyChangeListener);
            }
        } else if (!this.properties.isEmpty()) {
            this.propertyChangeListener = this.createPropertyChangeListener();
            if (this.propertyChangeListener != null) {
                for (String name : this.properties) {
                    this.treeTable.addPropertyChangeListener(name, this.propertyChangeListener);
                }
            }
        }
        if (this.propertyChangeListener == null) {
            this.properties = Collections.emptyList();
        }
    }

    protected void uninstallListeners() {
        if (this.focusListener != null) {
            this.treeTable.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.keyListener != null) {
            this.treeTable.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
        if (this.mouseListener != null) {
            this.treeTable.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.mouseMotionListener != null) {
            this.treeTable.removeMouseMotionListener(this.mouseMotionListener);
            this.mouseMotionListener = null;
        }
        if (this.propertyChangeListener != null) {
            if (this.properties == null) {
                this.treeTable.removePropertyChangeListener(this.propertyChangeListener);
            } else {
                for (String name : this.properties) {
                    this.treeTable.removePropertyChangeListener(name, this.propertyChangeListener);
                }
            }
            this.properties = null;
            this.propertyChangeListener = null;
        }
    }

    public void updateUI() {
        this.sortWidth = -1;
        this.noFocusBorder = null;
        this.ltrBorder = null;
        this.rtlBorder = null;
        this.installDefaults();
        this.tree.updateUI();
        this.table.updateUI();
        this.defaultTreeCellRenderer.updateUI();
        this.updateTreeClientProperties(this.tree);
        this.treeTableCellRenderer = this.createCellRenderer();
        this.tree.setCellRenderer(this.treeTableCellRenderer);
    }

    protected Renderer createCellRenderer() {
        return this.isNimbus() ? new NimbusRenderer() : new Renderer();
    }

    protected Editor createCellEditor() {
        return new Editor();
    }

    protected TreeTableCellRenderer createFocusRenderer() {
        return new FocusRenderer();
    }

    protected JTree createAndConfigureTree() {
        JTree tree = this.createTree(this.treeTable.getTreeTableModel());
        if (this.treeTable.getSelectionModel() == null) {
            this.treeTable.setSelectionModel(tree.getSelectionModel());
        } else {
            tree.setSelectionModel(this.treeTable.getSelectionModel());
        }
        tree.setOpaque(false);
        tree.setRowHeight(20);
        tree.putClientProperty("JTree.lineStyle", "None");
        InputMap inputs = tree.getInputMap();
        this.remap(inputs, 37);
        this.remap(inputs, 39);
        this.updateTreeClientProperties(tree);
        return tree;
    }

    private void updateTreeClientProperties(JTree tree) {
        if (this.isNimbus()) {
            UIDefaults map = new UIDefaults();
            Painter painter = new Painter(){

                public void paint(Graphics2D g, Object c, int w, int h) {
                }
            };
            map.put("Tree:TreeCell[Enabled+Selected].backgroundPainter", painter);
            map.put("Tree:TreeCell[Focused+Selected].backgroundPainter", painter);
            tree.putClientProperty("Nimbus.Overrides", map);
        } else {
            tree.putClientProperty("Nimus.Overrides", null);
        }
    }

    private boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getName());
    }

    private void remap(InputMap inputs, int code) {
        Object key = inputs.get(KeyStroke.getKeyStroke(code, 0));
        if (key != null) {
            inputs.put(KeyStroke.getKeyStroke(code, 512), key);
        }
    }

    protected JTree createTree(TreeModel tm) {
        return new Tree(tm);
    }

    protected void unconfigureTree() {
        this.tree.setCellRenderer(null);
        this.tree.setModel(new DefaultTreeModel(null));
        this.tree.setSelectionModel(new DefaultTreeSelectionModel());
        this.tree.setUI(null);
    }

    protected JTable createAndConfigureTable() {
        TableColumnModel cm = this.treeTable.getColumnModel();
        JTable table = this.createTable(this.treeTable.getTreeTableModel(), cm, this.treeTable.getRowSelectionModel());
        table.setOpaque(false);
        table.setFillsViewportHeight(true);
        table.setShowHorizontalLines(false);
        table.setRowMargin(0);
        if (cm == null) {
            cm = table.getColumnModel();
            cm.setColumnMargin(this.isNimbus() ? 0 : 3);
            int hc = this.treeTable.getTreeColumnModel().getHierarchicalColumn();
            if (hc >= 0) {
                cm.getColumn(hc).setPreferredWidth(150);
            }
            this.treeTable.setColumnModel(cm);
        }
        table.setShowVerticalLines(false);
        table.setRowHeight(20);
        table.setColumnModel(new ColumnModelAdapter(cm));
        return table;
    }

    protected JTable createTable(TableModel tm, TableColumnModel cm, ListSelectionModel sm) {
        return new Table(tm, cm, sm);
    }

    protected void unconfigureTable() {
        this.table.setTableHeader(null);
        this.table.setModel(new DefaultTableModel());
        this.table.setColumnModel(new DefaultTableColumnModel());
        this.table.setSelectionModel(new DefaultListSelectionModel());
        this.table.setUI(null);
    }

    protected FocusListener createFocusListener() {
        return this.handler;
    }

    protected KeyListener createKeyListener() {
        return this.handler;
    }

    protected MouseListener createMouseListener() {
        return this.handler;
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.handler;
    }

    protected List<String> getProperties() {
        return Arrays.asList("componentOrientation", "enabled", "rowSorter", "JTree.lineStyle", "columnModel");
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.handler;
    }

    protected Handler createHandler() {
        return new Handler();
    }

    protected JTable getTable() {
        return this.table;
    }

    protected JTree getTree() {
        return this.tree;
    }

    @Override
    public TreeInterface getTreeInterface(TreeTable treeTable) {
        return (TreeInterface)((Object)this.tree);
    }

    @Override
    public TableInterface getTableInterface(TreeTable treeTable) {
        return (TableInterface)((Object)this.table);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = this.tree.getPreferredSize();
        size.width = this.table.getPreferredSize().width;
        return size;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        try {
            this.paintTable(g);
            if (this.treeTable.getRowCount() > 0) {
                this.paintTree(g);
                if (this.treeTable.isNodeSortingEnabled()) {
                    this.paintSortIndicators(g);
                }
            }
            if (!this.treeTable.isPaintingForPrint()) {
                if (this.treeTable.isFocusOwner()) {
                    this.paintFocus(g);
                }
                this.paintDropLines(g);
            }
        }
        finally {
            this.treeTableCellRenderer.clearState();
        }
    }

    protected void paintTable(Graphics g) {
        this.treeTableCellRenderer.prepareForTable(g);
        Graphics cg = g.create(0, 0, this.treeTable.getWidth(), this.treeTable.getHeight());
        try {
            this.table.paint(cg);
        }
        finally {
            cg.dispose();
        }
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            int row = this.table.getEditingRow();
            boolean sel = this.treeTableCellRenderer.isSelected(this.tree.isRowSelected(row) && this.table.isColumnSelected(col));
            TreeTableCellRenderer r = this.treeTable.getCellRenderer(row, col);
            Component c = r.getTreeTableCellRendererComponent(this.treeTable, null, sel, false, row, col);
            CellRendererPane rp = (CellRendererPane)this.table.getComponent(0);
            Rectangle cell = this.table.getCellRect(row, col, true);
            rp.paintComponent(g, c, this.table, cell.x, cell.y, cell.width, cell.height, true);
            rp.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTree(Graphics g) {
        TableColumn dc;
        Shape clip = g.getClip();
        if (this.tree.getWidth() <= 0 || !clip.intersects(this.tree.getBounds())) {
            return;
        }
        JTableHeader header = this.table.getTableHeader();
        int x = this.tree.getX();
        int clipX = 0;
        int clipW = this.tree.getWidth();
        if (header != null && (dc = header.getDraggedColumn()) != null) {
            if (dc.getModelIndex() == this.treeTable.getTreeColumnModel().getHierarchicalColumn()) {
                x += header.getDraggedDistance();
            } else {
                int col = this.table.convertColumnIndexToView(dc.getModelIndex());
                Rectangle r = this.table.getCellRect(0, col, true);
                int dragX0 = r.x + header.getDraggedDistance();
                int dragX1 = dragX0 + r.width;
                if (x >= dragX0 && x < dragX1) {
                    clipX = dragX1 - x;
                    clipW -= clipX;
                } else if (x < dragX0 && dragX0 < x + this.tree.getWidth()) {
                    clipW -= x + this.tree.getWidth() - dragX0;
                }
            }
        }
        this.treeTableCellRenderer.prepareForTree();
        Graphics cg = g.create(x, 0, this.tree.getWidth(), this.tree.getHeight());
        try {
            cg.clipRect(clipX, 0, clipW, this.tree.getHeight());
            this.tree.paint(cg);
        }
        finally {
            cg.dispose();
        }
    }

    protected void paintSortIndicators(Graphics g) {
        TreePath mouseOverPath = this.paintMouseOverSortPath ? this.mouseOverSortPath : null;
        int mouseOverColumn = this.mouseOverSortColumn;
        SortOrder order = null;
        for (Map.Entry<TreePath, RowSorter.SortKey> entry : this.treeTable.getSortedPaths().entrySet()) {
            RowSorter.SortKey key;
            int col;
            TreePath path = entry.getKey();
            if (!this.tree.isExpanded(path) || (col = this.table.convertColumnIndexToView((key = entry.getValue()).getColumn())) < 0) continue;
            if (mouseOverPath != null && col == mouseOverColumn && mouseOverPath.equals(path)) {
                order = entry.getValue().getSortOrder();
                continue;
            }
            this.paintSortIndicator(g, path, col, key.getSortOrder());
        }
        if (mouseOverPath != null) {
            RowSorter<? extends TreeModel> sorter = this.treeTable.getRowSorter().getRowSorter(mouseOverPath);
            if (sorter instanceof TreeTableSorter.SortCycle) {
                List<SortOrder> cycle = ((TreeTableSorter.SortCycle)((Object)sorter)).getSortCycle();
                if (order == null) {
                    order = cycle.get(0);
                } else {
                    int idx = cycle.indexOf((Object)order);
                    if (idx < 0 || ++idx >= cycle.size()) {
                        idx = 0;
                    }
                    order = cycle.get(idx);
                }
            } else {
                SortOrder sortOrder = order = order == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
            }
            if (order == SortOrder.UNSORTED) {
                int row = this.tree.getRowForPath(mouseOverPath);
                Rectangle r = this.table.getCellRect(row, mouseOverColumn, true);
                int h = 2;
                int w = this.getSortWidth() - this.getSortMargin() * 2;
                int y = r.y + (r.height - h) / 2;
                int align = this.treeTable.getAlignment(this.getRendererComponent(false, false, row, mouseOverColumn), row, mouseOverColumn);
                g.setColor(Color.GRAY);
                switch (align) {
                    case 0: 
                    case 2: {
                        g.fillRect(r.x + r.width - w - this.getSortMargin(), y, w, h);
                        break;
                    }
                    case 4: {
                        g.fillRect(r.x + this.getSortMargin(), y, w, h);
                    }
                }
            } else {
                Graphics2D g2 = null;
                Composite comp = null;
                if (g instanceof Graphics2D) {
                    g2 = (Graphics2D)g;
                    comp = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                this.paintSortIndicator(g, mouseOverPath, this.mouseOverSortColumn, order);
                if (g2 != null) {
                    g2.setComposite(comp);
                }
            }
        }
    }

    private void paintSortIndicator(Graphics g, TreePath path, int col, SortOrder sortOrder) {
        Icon icon;
        switch (sortOrder) {
            default: {
                return;
            }
            case ASCENDING: {
                icon = this.treeTable.getAscendingSortIcon();
                break;
            }
            case DESCENDING: {
                icon = this.treeTable.getDescendingSortIcon();
            }
        }
        int row = this.tree.getRowForPath(path);
        Rectangle r = this.table.getCellRect(row, col, true);
        int y = r.y + (r.height - icon.getIconHeight()) / 2;
        int align = this.treeTable.getAlignment(this.getRendererComponent(false, false, row, col), row, col);
        switch (align) {
            case 0: 
            case 2: {
                icon.paintIcon(this.treeTable, g, r.x + r.width - icon.getIconWidth() - this.getSortMargin(), y);
                break;
            }
            case 4: {
                icon.paintIcon(this.treeTable, g, r.x + this.getSortMargin(), y);
            }
        }
    }

    void setMouseOverSortIndicator(TreePath path, int col) {
        TreePath oldPath = this.mouseOverSortPath;
        int oldColumn = this.mouseOverSortColumn;
        if (col != oldColumn || (path == null ? oldPath != null : !path.equals(oldPath))) {
            this.mouseOverSortColumn = col;
            this.mouseOverSortPath = path;
            this.paintMouseOverSortPath = true;
            if (oldPath != null) {
                this.repaint(oldPath, oldColumn);
            }
            if (path != null) {
                this.repaint(path, col);
            }
        }
    }

    private void repaint(TreePath path, int col) {
        Rectangle r = this.table.getCellRect(this.tree.getRowForPath(path), col, true);
        this.treeTable.repaint(r);
    }

    private Component getRendererComponent(boolean sel, boolean foc, int row, int col) {
        TreeTableCellRenderer r = this.treeTable.getCellRenderer(row, col);
        Object value = this.treeTable.getValueAt(row, col);
        if (col == this.treeTable.getHierarchicalColumn()) {
            TreePath path = this.tree.getPathForRow(row);
            return r.getTreeTableCellRendererComponent(this.treeTable, value, sel, foc, row, col, this.treeTable.isExpanded(path), this.treeTable.isLeaf(path));
        }
        return r.getTreeTableCellRendererComponent(this.treeTable, value, sel, foc, row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintFocus(Graphics g) {
        TreeTableCellRenderer focusRenderer = this.treeTable.getFocusRenderer();
        if (focusRenderer == null) {
            return;
        }
        if (this.treeTable.isColumnFocusEnabled()) {
            TableColumn dc;
            int leadColumn = this.treeTable.getLeadSelectionColumn();
            if (leadColumn < 0) {
                return;
            }
            int leadRow = this.treeTable.getLeadSelectionRow();
            Rectangle r = this.table.getCellRect(leadRow, leadColumn, true);
            Rectangle clipR = null;
            JTableHeader header = this.table.getTableHeader();
            if (header != null && (dc = header.getDraggedColumn()) != null && header.getDraggedDistance() != 0) {
                if (dc.getModelIndex() == this.treeTable.getTreeColumnModel().getHierarchicalColumn()) {
                    r.x += header.getDraggedDistance();
                } else {
                    int col = this.table.convertColumnIndexToView(dc.getModelIndex());
                    Rectangle dr = this.table.getCellRect(leadRow, col, true);
                    dr.x += header.getDraggedDistance();
                    clipR = r.intersection(dr);
                    clipR.x -= r.x;
                }
            }
            if (!g.getClip().intersects(r)) {
                return;
            }
            Component c = focusRenderer.getTreeTableCellRendererComponent(this.treeTable, "", false, true, leadRow, leadColumn);
            c.setBounds(0, 0, r.width, r.height);
            Graphics cg = g.create(r.x, r.y, r.width, r.height);
            try {
                if (clipR != null) {
                    if (clipR.x == 0) {
                        cg.setClip(clipR.width, 0, r.width, r.height);
                    } else {
                        cg.setClip(0, 0, clipR.x, r.height);
                    }
                }
                c.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }
        int row = this.tree.getRowForPath(this.tree.getLeadSelectionPath());
        int columns = this.table.getColumnModel().getColumnCount();
        if (row >= 0 && columns > 0) {
            Rectangle r = this.table.getCellRect(row, 0, true);
            if (columns > 1) {
                r.add(this.table.getCellRect(row, columns - 1, true));
            }
            if (g.getClip().intersects(r)) {
                Component c = focusRenderer.getTreeTableCellRendererComponent(this.treeTable, "", false, true, row, -1);
                c.setBounds(0, 0, r.width, r.height);
                Graphics cg = g.create(r.x, r.y, r.width, r.height);
                try {
                    TableColumn dc;
                    boolean paintFullRow = true;
                    JTableHeader header = this.table.getTableHeader();
                    if (header != null && (dc = header.getDraggedColumn()) != null && header.getDraggedDistance() != 0) {
                        paintFullRow = false;
                        int col = this.table.convertColumnIndexToView(dc.getModelIndex());
                        Rectangle dr = this.table.getCellRect(row, col, true);
                        if (header.getDraggedDistance() < 0) {
                            int w = dr.x + dr.width + header.getDraggedDistance();
                            cg.setClip(0, 0, w, r.height);
                            c.paint(cg);
                            int x = dr.x + dr.width;
                            cg.setClip(x, 0, r.width - x, r.height);
                            c.paint(cg);
                        } else {
                            cg.setClip(0, 0, dr.x, r.height);
                            c.paint(cg);
                            int x = dr.x + header.getDraggedDistance();
                            cg.setClip(x, 0, r.width - x, r.height);
                            c.paint(cg);
                        }
                    }
                    if (paintFullRow) {
                        c.paint(cg);
                    }
                }
                finally {
                    cg.dispose();
                }
            }
        }
    }

    protected void layoutTable() {
        this.table.setBounds(0, 0, this.treeTable.getWidth(), this.treeTable.getHeight());
    }

    protected void layoutTree() {
        int hier = this.treeTable.getHierarchicalColumn();
        if (hier < 0) {
            this.tree.setBounds(0, 0, 0, 0);
        } else {
            Rectangle r = this.table.getCellRect(-1, hier, true);
            int cm = this.treeTable.getColumnModel().getColumnMargin();
            r.x += cm / 2;
            r.width -= cm;
            r.height = this.treeTable.getHeight();
            this.tree.setBounds(r);
        }
    }

    @Override
    public void configureCellRenderer(DefaultTreeTableCellRenderer renderer, TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column) {
        this.treeTableCellRenderer.configureCellRenderer(renderer, treeTable, value, selected, hasFocus, row, column);
    }

    @Override
    public void configureCellRenderer(DefaultTreeTableCellRenderer renderer, TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column, boolean expanded, boolean leaf) {
        this.treeTableCellRenderer.configureCellRenderer(renderer, treeTable, value, selected, hasFocus, row, column, expanded, leaf);
    }

    @Override
    public void configureCellEditor(DefaultTreeTableCellEditor editor, TreeTable treeTable, Object value, boolean selected, int row, int column) {
        editor.getTableCellEditorComponent(this.table, value, selected, row, column);
    }

    @Override
    public void configureCellEditor(DefaultTreeTableCellEditor editor, TreeTable treeTable, Object value, boolean selected, int row, int column, boolean expanded, boolean leaf) {
        editor.getTreeCellEditorComponent(this.tree, value, selected, expanded, leaf, row);
    }

    @Override
    public TreeTableCellRenderer getDefaultRenderer(TreeTable treeTable, Class<?> columnClass) {
        this.treeTableCellRenderer.loadRenderer(columnClass);
        return this.treeTableCellRenderer;
    }

    @Override
    public TreeTableCellEditor getDefaultEditor(TreeTable treeTable, Class<?> columnClass, int column) {
        this.treeTableCellEditor.loadEditor(columnClass, column);
        return this.treeTableCellEditor;
    }

    @Override
    public Rectangle getPathBounds(TreeTable treeTable, TreePath path) {
        Rectangle r = this.tree.getPathBounds(path);
        if (r != null) {
            r.x += this.tree.getX();
            r.y += this.tree.getY();
        }
        return r;
    }

    @Override
    public TreePath getPathForLocation(TreeTable treeTable, int x, int y) {
        TreePath path = this.tree.getPathForLocation(x - this.tree.getX(), y - this.tree.getY());
        if (path != null) {
            return path;
        }
        int row = this.table.rowAtPoint(new Point(x, y));
        return row >= 0 ? this.tree.getPathForRow(row) : null;
    }

    @Override
    public TreePath getClosestPathForLocation(TreeTable treeTable, int x, int y) {
        return this.tree.getClosestPathForLocation(x - this.tree.getX(), y - this.tree.getY());
    }

    protected boolean hasTreeHandle(TreeTable treeTable, TreePath path) {
        return !treeTable.isLeaf(path) && (treeTable.getChildCount(path) > 0 || treeTable.hasBeenExpanded(path));
    }

    static boolean isOverTreeHandle(boolean ltr, Rectangle nb, int thw, int x) {
        return ltr ? x < nb.x && (thw < 0 || x > nb.x - thw) : x > nb.x + nb.width && (thw < 0 || x < nb.x + nb.width + thw);
    }

    @Override
    public int getDistanceToTreeHandle(TreeTable treeTable, TreePath path, int x) {
        int treePosition;
        Rectangle nb = this.tree.getPathBounds(path);
        if (nb == null) {
            return 0;
        }
        boolean ltr = treeTable.getComponentOrientation().isLeftToRight();
        if (ltr ? x < nb.x : x > nb.x + nb.width) {
            boolean hasTreeHandle = this.hasTreeHandle(treeTable, path);
            if (hasTreeHandle && BasicTreeTableUI.isOverTreeHandle(ltr, nb, this.getTreeHandleWidth(), x)) {
                treePosition = 0;
            } else {
                int n = treePosition = ltr ? x - nb.x : nb.x + nb.width - x;
                if (hasTreeHandle) {
                    treePosition += this.getTreeHandleWidth();
                }
            }
        } else {
            treePosition = ltr ? x - nb.x : nb.x + nb.width - x;
        }
        return treePosition;
    }

    protected void updateTableAfterExpansion(TreePath path, int interval) {
        if (interval < 0) {
            this.treeTable.processTreeCollapse(path, -interval);
        } else if (interval > 0) {
            this.treeTable.processTreeExpansion(path, interval);
        }
    }

    protected void scrollToVisible(Rectangle r, int x, int y) {
        r.x += x;
        r.y += y;
        this.treeTable.scrollRectToVisible(r);
        r.x -= x;
        r.y -= y;
    }

    private static Color createColor(Color c) {
        if (c instanceof UIResource) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        return c;
    }

    protected int getSortWidth() {
        if (this.sortWidth < 0) {
            this.sortWidth = this.getSortMargin() * 2 + Math.max(this.treeTable.getAscendingSortIcon().getIconWidth(), this.treeTable.getDescendingSortIcon().getIconWidth());
        }
        return this.sortWidth;
    }

    protected int getSortMargin() {
        return 2;
    }

    private Border getDefaultLTRBorder() {
        if (this.ltrBorder == null) {
            this.ltrBorder = new EmptyBorder(1, 0, 1, 1);
        }
        return this.ltrBorder;
    }

    private Border getDefaultRTLBorder() {
        if (this.rtlBorder == null) {
            this.rtlBorder = new EmptyBorder(1, 1, 1, 0);
        }
        return this.rtlBorder;
    }

    private Border getDefaultNoFocusBorder() {
        if (this.noFocusBorder == null) {
            this.noFocusBorder = UIManager.getBorder("Table.cellNoFocusBorder");
            if (this.noFocusBorder == null) {
                this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            }
        }
        return this.noFocusBorder;
    }

    protected int getTreeHandleWidth() {
        return this.treeHandleWidth;
    }

    protected boolean processKeyBinding(JComponent c, KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (c instanceof ProcessKeyBinding) {
            return ((ProcessKeyBinding)((Object)c)).processKeyBinding(ks, e, condition, pressed);
        }
        return false;
    }

    private void paintDropLines(Graphics g) {
        TreeTable.DropLocation loc = this.treeTable.getDropLocation();
        if (loc == null || !loc.isInsertRow() && !loc.isInsertColumn()) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color shortColor = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private Rectangle getHDropLineRect(TreeTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    private Rectangle getVDropLineRect(TreeTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (ltr) {
                rect.x += rect.width;
            }
        } else if (!ltr) {
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    private Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect == null) {
            return rect;
        }
        if (horizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    protected class Handler
    extends MouseAdapter
    implements FocusListener,
    KeyListener,
    PropertyChangeListener {
        private boolean sendDragToTable = true;
        private boolean sortPressed = false;
        private MouseEvent dndArmedEvent;
        private int motionThreshold;
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private long timeFactor = 1000L;

        @Override
        public void keyPressed(KeyEvent e) {
            this.processKeyEvent(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processKeyEvent(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.processKeyEvent(e);
            if (!e.isConsumed()) {
                this.changeSelection(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.processMouseEvent(e);
            if (e.isConsumed()) {
                this.sendDragToTable = false;
            } else if (BasicTreeTableUI.this.treeTable.getDragEnabled()) {
                this.motionThreshold = Math.max(10, DragSource.getDragThreshold());
                this.dndArmedEvent = e;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BasicTreeTableUI.this.setMouseOverSortIndicator(null, -1);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.processMouseEvent(e);
            this.dndArmedEvent = null;
            this.sendDragToTable = true;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.processMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!BasicTreeTableUI.this.treeTable.isNodeSortingEnabled() || BasicTreeTableUI.this.treeTable.getRowSorter() == null) {
                BasicTreeTableUI.this.setMouseOverSortIndicator(null, -1);
            } else if (!BasicTreeTableUI.this.treeTable.isEditing()) {
                Point pt = e.getPoint();
                int col = BasicTreeTableUI.this.table.columnAtPoint(pt);
                if (col < 0) {
                    BasicTreeTableUI.this.setMouseOverSortIndicator(null, -1);
                } else {
                    TreePath path;
                    BasicTreeTableUI.this.setMouseOverSortIndicator(path, (path = this.getSortPath(pt, col)) == null ? -1 : col);
                }
            }
        }

        private TreePath getSortPath(Point pt, int col) {
            int row = BasicTreeTableUI.this.table.rowAtPoint(pt);
            if (row < 0) {
                return null;
            }
            TreePath path = BasicTreeTableUI.this.tree.getPathForRow(row);
            if (BasicTreeTableUI.this.treeTable.isLeaf(path) || BasicTreeTableUI.this.treeTable.getChildCount(path) == 0) {
                return null;
            }
            Rectangle r = BasicTreeTableUI.this.table.getCellRect(row, col, true);
            switch (BasicTreeTableUI.this.treeTable.getAlignment(BasicTreeTableUI.this.getRendererComponent(false, false, row, col), row, col)) {
                default: {
                    return null;
                }
                case 0: 
                case 2: {
                    if (pt.x >= r.x + r.width - BasicTreeTableUI.this.getSortWidth()) break;
                    return null;
                }
                case 4: {
                    if (pt.x <= r.x + BasicTreeTableUI.this.getSortWidth()) break;
                    return null;
                }
            }
            return path;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (BasicTreeTableUI.this.treeTable.getDragEnabled()) {
                if (this.dndArmedEvent != null) {
                    int dx = Math.abs(e.getX() - this.dndArmedEvent.getX());
                    int dy = Math.abs(e.getY() - this.dndArmedEvent.getY());
                    if (dx > this.motionThreshold || dy > this.motionThreshold) {
                        int actions;
                        TransferHandler th = BasicTreeTableUI.this.treeTable.getTransferHandler();
                        int n = actions = th == null ? 0 : th.getSourceActions(BasicTreeTableUI.this.treeTable);
                        if (actions != 0) {
                            int action = 2;
                            th.exportAsDrag(BasicTreeTableUI.this.treeTable, this.dndArmedEvent, action);
                        }
                    }
                }
            } else if (this.sendDragToTable) {
                this.dispatchMouseEvent(e, BasicTreeTableUI.this.table);
            }
        }

        protected void processKeyEvent(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
            int condition = BasicTreeTableUI.this.treeTable.getConditionForKeyStroke(ks);
            if (condition == 0 || condition == 1) {
                return;
            }
            if (!this.dispatchToTable(e) || !this.dispatchKeyEvent(e, ks, BasicTreeTableUI.this.table)) {
                this.dispatchKeyEvent(e, ks, BasicTreeTableUI.this.tree);
            }
        }

        private boolean dispatchToTable(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    return false;
                }
                case 35: 
                case 36: 
                case 37: 
                case 39: {
                    return (BasicTreeTableUI.this.treeTable.isColumnFocusEnabled() || BasicTreeTableUI.this.treeTable.getColumnSelectionAllowed()) && BasicTreeTableUI.this.table.getColumnModel().getColumnCount() > 1;
                }
            }
            return true;
        }

        private boolean dispatchKeyEvent(KeyEvent e, KeyStroke ks, JComponent c) {
            int condition = c.getConditionForKeyStroke(ks);
            if ((condition == 0 || condition == 1) && BasicTreeTableUI.this.processKeyBinding(c, ks, e, condition, !ks.isOnKeyRelease())) {
                e.consume();
                return true;
            }
            return false;
        }

        protected void processMouseEvent(MouseEvent e) {
            if (e.isConsumed() || e.isPopupTrigger()) {
                return;
            }
            if (this.sortNode(e)) {
                return;
            }
            if (!this.dispatchToTree(e)) {
                this.dispatchMouseEvent(e, BasicTreeTableUI.this.table);
            }
        }

        private boolean sortNode(MouseEvent e) {
            switch (e.getID()) {
                default: {
                    return false;
                }
                case 502: {
                    try {
                        boolean bl = this.sortPressed;
                        return bl;
                    }
                    finally {
                        this.sortPressed = false;
                    }
                }
                case 501: 
            }
            if (BasicTreeTableUI.this.mouseOverSortPath == null) {
                return false;
            }
            TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> sorter = BasicTreeTableUI.this.treeTable.getRowSorter();
            if (sorter == null) {
                return false;
            }
            RowSorter<? extends TreeModel> nodeSorter = sorter.getRowSorter(BasicTreeTableUI.this.mouseOverSortPath);
            if (nodeSorter == null) {
                return false;
            }
            nodeSorter.toggleSortOrder(BasicTreeTableUI.this.table.convertColumnIndexToModel(BasicTreeTableUI.this.mouseOverSortColumn));
            BasicTreeTableUI.this.paintMouseOverSortPath = false;
            this.sortPressed = true;
            e.consume();
            return true;
        }

        private boolean dispatchToTree(MouseEvent e) {
            switch (e.getID()) {
                case 504: 
                case 505: {
                    return false;
                }
            }
            int hier = BasicTreeTableUI.this.treeTable.getHierarchicalColumn();
            if (hier < 0) {
                return false;
            }
            Point pt = e.getPoint();
            int col = BasicTreeTableUI.this.table.columnAtPoint(pt);
            if (col != hier) {
                return false;
            }
            int row = BasicTreeTableUI.this.table.rowAtPoint(pt);
            if (row < 0) {
                return false;
            }
            TreePath path = BasicTreeTableUI.this.tree.getPathForRow(row);
            if (!BasicTreeTableUI.this.hasTreeHandle(BasicTreeTableUI.this.treeTable, path)) {
                return false;
            }
            if (BasicTreeTableUI.isOverTreeHandle(BasicTreeTableUI.this.tree.getComponentOrientation().isLeftToRight(), BasicTreeTableUI.this.tree.getPathBounds(path), BasicTreeTableUI.this.getTreeHandleWidth(), e.getX() - BasicTreeTableUI.this.tree.getX())) {
                this.dispatchMouseEvent(e, BasicTreeTableUI.this.tree);
                e.consume();
                return true;
            }
            return false;
        }

        protected void dispatchMouseEvent(MouseEvent e, JComponent c) {
            MouseEvent me = new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), e.getX() - c.getX(), e.getY() - c.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), false, e.getButton());
            c.dispatchEvent(me);
            if (me.isConsumed()) {
                e.consume();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("rowSorter")) {
                BasicTreeTableUI.this.table.setRowSorter(evt.getNewValue() == null ? null : new RowSorterAdapter());
            } else if (name.equals("enabled")) {
                boolean enabled = (Boolean)evt.getNewValue();
                BasicTreeTableUI.this.table.setEnabled(enabled);
                BasicTreeTableUI.this.tree.setEnabled(enabled);
            } else if (name.equals("componentOrientation")) {
                ComponentOrientation o = (ComponentOrientation)evt.getNewValue();
                BasicTreeTableUI.this.table.setComponentOrientation(o);
                BasicTreeTableUI.this.tree.setComponentOrientation(o);
                BasicTreeTableUI.this.treeTable.revalidate();
                BasicTreeTableUI.this.treeTable.repaint();
            } else if ("JTree.lineStyle".equals(name)) {
                BasicTreeTableUI.this.tree.putClientProperty("JTree.lineStyle", evt.getNewValue());
            } else if ("columnModel".equals(name)) {
                BasicTreeTableUI.this.table.setColumnModel(new ColumnModelAdapter((TableColumnModel)evt.getNewValue()));
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusChanged();
        }

        protected void focusChanged() {
            this.repaintLead();
        }

        private void repaintLead() {
            Rectangle rect;
            TreePath lead = BasicTreeTableUI.this.tree.getLeadSelectionPath();
            if (lead == null) {
                return;
            }
            int row = BasicTreeTableUI.this.tree.getRowForPath(lead);
            if (BasicTreeTableUI.this.treeTable.isColumnFocusEnabled()) {
                int col = BasicTreeTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (col < 0) {
                    return;
                }
                rect = BasicTreeTableUI.this.table.getCellRect(row, col, true);
            } else {
                rect = BasicTreeTableUI.this.table.getCellRect(row, 0, true);
                rect.width = BasicTreeTableUI.this.treeTable.getWidth();
            }
            BasicTreeTableUI.this.treeTable.repaint(rect);
        }

        protected void changeSelection(KeyEvent e) {
            int index;
            int col = -1;
            if (BasicTreeTableUI.this.treeTable.isColumnFocusEnabled() && (col = BasicTreeTableUI.this.treeTable.getLeadSelectionColumn()) >= BasicTreeTableUI.this.treeTable.getColumnCount()) {
                col = -1;
            }
            if (col < 0 && (col = Math.max(0, BasicTreeTableUI.this.treeTable.getHierarchicalColumn())) >= BasicTreeTableUI.this.treeTable.getColumnCount()) {
                return;
            }
            if (BasicTreeTableUI.this.treeTable.getRowCount() == 0 || e.isAltDown() || e.isControlDown() || e.isMetaDown() || this.isNavigationKey(BasicTreeTableUI.this.table, e)) {
                return;
            }
            boolean startingFromSelection = true;
            char c = e.getKeyChar();
            long time = e.getWhen();
            int startIndex = BasicTreeTableUI.this.table.getSelectionModel().getLeadSelectionIndex();
            if (time - this.lastTime < this.timeFactor) {
                this.typedString = this.typedString + c;
                if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                    ++startIndex;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++startIndex;
                this.prefix = this.typedString = Character.toString(c);
            }
            this.lastTime = time;
            if (startIndex < 0 || startIndex >= BasicTreeTableUI.this.table.getRowCount()) {
                startingFromSelection = false;
                startIndex = 0;
            }
            if ((index = BasicTreeTableUI.this.treeTable.getNextMatch(this.prefix, startIndex, col, Position.Bias.Forward)) >= 0) {
                BasicTreeTableUI.this.table.changeSelection(index, col, false, false);
            } else if (startingFromSelection && (index = BasicTreeTableUI.this.treeTable.getNextMatch(this.prefix, startIndex, col, Position.Bias.Forward)) >= 0) {
                BasicTreeTableUI.this.table.changeSelection(index, col, false, false);
            }
        }

        private boolean isNavigationKey(JTable table, KeyEvent event) {
            InputMap inputMap = table.getInputMap(1);
            return inputMap != null && inputMap.get(KeyStroke.getKeyStroke(event.getKeyCode(), 0)) != null;
        }
    }

    private class FocusRenderer
    extends DefaultTableCellRenderer.UIResource
    implements TreeTableCellRenderer {
        private FocusRenderer() {
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(BasicTreeTableUI.this.table, value, selected, hasFocus, row, column);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column, boolean expanded, boolean leaf) {
            return super.getTableCellRendererComponent(BasicTreeTableUI.this.table, value, selected, hasFocus, row, column);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }

    protected class Editor
    extends AbstractCellEditor
    implements TableCellEditor,
    CellEditorListener,
    TreeTableCellEditor {
        private TreeEditor defaultTreeEditor;
        private TreeEditorContainer treeEditorContainer;
        private transient TreeTableCellEditor treeTableEditor;
        private transient CellEditor defaultEditor;

        protected Editor() {
        }

        public void loadEditor(int row, int col) {
            this.clearState();
            this.treeTableEditor = BasicTreeTableUI.this.treeTable.getCellEditor(row, col);
        }

        public void loadEditor(Class<?> cls, int col) {
            this.treeTableEditor = this;
            if (col == BasicTreeTableUI.this.treeTable.getHierarchicalColumn()) {
                if (this.defaultTreeEditor == null) {
                    this.defaultTreeEditor = new TreeEditor(BasicTreeTableUI.this.table.getDefaultEditor(Object.class));
                }
                this.defaultEditor = this.defaultTreeEditor;
            } else {
                this.defaultEditor = BasicTreeTableUI.this.table.getDefaultEditor(BasicTreeTableUI.this.table.getColumnClass(col));
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
            Component c;
            boolean treeColumn;
            boolean bl = treeColumn = column == BasicTreeTableUI.this.treeTable.getHierarchicalColumn();
            if (treeColumn) {
                TreePath path = BasicTreeTableUI.this.tree.getPathForRow(row);
                boolean expanded = BasicTreeTableUI.this.tree.isExpanded(path);
                boolean leaf = BasicTreeTableUI.this.treeTable.isLeaf(path);
                c = this.treeTableEditor.getTreeTableCellEditorComponent(BasicTreeTableUI.this.treeTable, value, selected, row, column, expanded, leaf);
            } else {
                c = this.treeTableEditor.getTreeTableCellEditorComponent(BasicTreeTableUI.this.treeTable, value, selected, row, column);
            }
            if (treeColumn) {
                if (this.treeEditorContainer == null) {
                    this.treeEditorContainer = new TreeEditorContainer();
                }
                this.treeEditorContainer.setState(c, row);
                c = this.treeEditorContainer;
            }
            this.getEditor().addCellEditorListener(this);
            return c;
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable treeTable, Object value, boolean sel, int row, int col) {
            return ((TableCellEditor)this.defaultEditor).getTableCellEditorComponent(BasicTreeTableUI.this.table, value, sel, row, col);
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable treeTable, Object value, boolean sel, int row, int col, boolean exp, boolean leaf) {
            return this.defaultTreeEditor.getTreeTableCellEditorComponent(treeTable, value, sel, row, col, exp, leaf);
        }

        private CellEditor getEditor() {
            return this.defaultEditor != null ? this.defaultEditor : this.treeTableEditor;
        }

        @Override
        public void cancelCellEditing() {
            this.getEditor().cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.getEditor().getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.getEditor().isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.getEditor().shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.getEditor().stopCellEditing();
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this.fireEditingCanceled();
            this.clearState();
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this.fireEditingStopped();
            this.clearState();
        }

        public void clearState() {
            if (this.treeTableEditor != null) {
                this.getEditor().removeCellEditorListener(this);
                this.treeTableEditor = null;
                this.defaultEditor = null;
                if (this.treeEditorContainer != null) {
                    this.treeEditorContainer.clearState();
                }
                if (this.defaultTreeEditor != null) {
                    this.defaultTreeEditor.clearState();
                }
            }
        }
    }

    private class TreeEditor
    extends CellEditorContainer<TableCellEditor> {
        TreeEditor(TableCellEditor editor) {
            super(editor);
        }

        @Override
        public Component getCellEditorComponent(TreeTable treeTable, Object value, boolean sel, int row, int col, boolean exp, boolean leaf) {
            return ((TableCellEditor)this.editor).getTableCellEditorComponent(BasicTreeTableUI.this.table, value, sel, row, col);
        }
    }

    private class TreeEditorContainer
    extends Container {
        private Component component;
        private int row;

        TreeEditorContainer() {
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            Rectangle node = BasicTreeTableUI.this.tree.getRowBounds(this.row);
            if (BasicTreeTableUI.this.tree.getComponentOrientation().isLeftToRight()) {
                x = node.x;
                w -= node.x;
            } else {
                w = node.x + node.width;
            }
            this.component.setBounds(0, 0, w, h);
            super.setBounds(x, y, w, h);
        }

        void setState(Component c, int row) {
            this.add(c);
            this.component = c;
            this.row = row;
        }

        void clearState() {
            this.removeAll();
            this.component = null;
        }
    }

    protected class Renderer
    extends CellRendererPane
    implements TreeCellRenderer,
    TableCellRenderer,
    TreeTableCellRenderer {
        protected Component component;
        protected boolean tableColumn = true;
        protected boolean treeColumnSelected;
        protected boolean rowSelectionAllowed;
        protected boolean columnSelectionAllowed;
        protected Object node;
        protected int row;
        protected int column;
        protected Color backgroundColor;
        protected Color alternateRowColor;
        private TableCellRenderer renderer;
        private int left;
        private int right;
        private int top;
        private int bottom;
        private int focusRow;
        private int focusColumn;

        public void loadRenderer(Class<?> cls) {
            this.renderer = BasicTreeTableUI.this.table.getDefaultRenderer(cls);
        }

        public void prepareForTable(Graphics g) {
            this.prepareBackgroundColors();
            int cm = BasicTreeTableUI.this.treeTable.getColumnModel().getColumnMargin();
            int rm = BasicTreeTableUI.this.treeTable.getRowMargin();
            if (cm != 0 || rm != 0) {
                this.left = cm / 2;
                this.right = this.left + cm % 2;
                this.top = rm / 2;
                this.bottom = this.top + rm % 2;
            } else {
                this.bottom = 0;
                this.top = 0;
                this.right = 0;
                this.left = 0;
            }
            if (BasicTreeTableUI.this.treeTable.getFocusRenderer() != null) {
                this.focusColumn = -1;
                this.focusRow = -1;
            } else {
                this.focusRow = BasicTreeTableUI.this.tree.getLeadSelectionRow();
                this.focusColumn = BasicTreeTableUI.this.treeTable.isColumnFocusEnabled() ? Integer.MIN_VALUE : BasicTreeTableUI.this.treeTable.getLeadSelectionColumn();
            }
        }

        protected void prepareBackgroundColors() {
            this.backgroundColor = BasicTreeTableUI.this.treeTable.getBackground();
            this.alternateRowColor = BasicTreeTableUI.this.treeTable.getAlternateRowColor();
            if (this.alternateRowColor == null) {
                this.alternateRowColor = this.backgroundColor;
            }
        }

        public void prepareForTree() {
            this.tableColumn = false;
            this.column = BasicTreeTableUI.this.treeTable.getHierarchicalColumn();
            this.rowSelectionAllowed = BasicTreeTableUI.this.table.getRowSelectionAllowed();
            this.columnSelectionAllowed = BasicTreeTableUI.this.table.getColumnSelectionAllowed();
            this.treeColumnSelected = BasicTreeTableUI.this.table.isColumnSelected(this.column);
        }

        public void clearState() {
            this.renderer = null;
            this.component = null;
            this.node = null;
            this.backgroundColor = null;
            this.alternateRowColor = null;
            this.removeAll();
            this.tableColumn = true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean sel, boolean foc, int row, int col) {
            this.tableColumn = true;
            this.row = row;
            this.column = col;
            foc = this.isFocused(row, col);
            this.component = this.getTableComponent(value, sel, foc, row, col);
            return this;
        }

        private Component getTableComponent(Object value, boolean sel, boolean foc, int row, int col) {
            return BasicTreeTableUI.this.treeTable.getCellRenderer(row, col).getTreeTableCellRendererComponent(BasicTreeTableUI.this.treeTable, value, sel, foc, row, col);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean foc) {
            if (this.tableColumn) {
                this.tableColumn = false;
                this.column = BasicTreeTableUI.this.treeTable.getHierarchicalColumn();
            }
            this.node = value;
            this.row = row;
            sel = this.isSelected(sel);
            foc = this.isFocused(row, this.column);
            TreeColumnModel model = BasicTreeTableUI.this.treeTable.getTreeColumnModel();
            value = model.getValueAt(value, model.getHierarchicalColumn());
            this.component = this.getTreeComponent(value, sel, foc, row, this.column, exp, leaf);
            return this;
        }

        private Component getTreeComponent(Object value, boolean sel, boolean foc, int row, int col, boolean exp, boolean leaf) {
            return BasicTreeTableUI.this.treeTable.getCellRenderer(row, col).getTreeTableCellRendererComponent(BasicTreeTableUI.this.treeTable, value, sel, foc, row, col, exp, leaf);
        }

        boolean isSelected(boolean sel) {
            if (!this.columnSelectionAllowed) {
                return this.rowSelectionAllowed ? sel : false;
            }
            return this.rowSelectionAllowed ? sel && this.treeColumnSelected : this.treeColumnSelected;
        }

        boolean isFocused(int row, int col) {
            return row == this.focusRow && this.focusColumn < -1 ? true : col == this.focusColumn;
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean sel, boolean foc, int row, int col) {
            Component c = this.renderer.getTableCellRendererComponent(BasicTreeTableUI.this.table, value, sel, foc, row, col);
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
            this.configureCellRenderer(c, sel, row, col);
            return c;
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean sel, boolean foc, int row, int col, boolean exp, boolean leaf) {
            return BasicTreeTableUI.this.defaultTreeCellRenderer.getTreeTableCellRendererComponent(treeTable, value, sel, foc, row, col, exp, leaf);
        }

        private Dimension getComponentPreferredSize() {
            Dimension size = this.component.getPreferredSize();
            if (BasicTreeTableUI.this.treeTable.isNodeSortingEnabled()) {
                switch (BasicTreeTableUI.this.treeTable.getAlignment(this.component, this.row, this.column)) {
                    case 0: {
                        size.width += BasicTreeTableUI.this.getSortWidth() * 2;
                        break;
                    }
                    case 2: 
                    case 4: {
                        size.width += BasicTreeTableUI.this.getSortWidth();
                    }
                }
            }
            return size;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size;
            if (this.tableColumn || BasicTreeTableUI.this.tree.getRowHeight() > 0) {
                return this.getComponentPreferredSize();
            }
            if (!BasicTreeTableUI.this.tree.isRootVisible() && this.row <= 0 && this.node == BasicTreeTableUI.this.treeTable.getTreeModel().getRoot()) {
                return new Dimension(0, 0);
            }
            int margin = BasicTreeTableUI.this.treeTable.getRowMargin();
            int tc = this.column;
            if (tc >= 0) {
                size = this.getComponentPreferredSize();
                size.height += margin;
            } else {
                size = new Dimension(1, margin);
            }
            TableColumnModel cm = BasicTreeTableUI.this.treeTable.getColumnModel();
            TreeColumnModel rm = BasicTreeTableUI.this.treeTable.getTreeColumnModel();
            Object nod = this.node;
            int col = cm.getColumnCount();
            while (--col >= 0) {
                if (col == tc) continue;
                Object value = rm.getValueAt(nod, cm.getColumn(col).getModelIndex());
                Component c = this.getTableComponent(value, false, false, this.row, col);
                size.height = Math.max(size.height, c.getPreferredSize().height + margin);
            }
            return size;
        }

        @Override
        public void paint(Graphics g) {
            if (this.tableColumn) {
                this.paintTableComponent(g, this.component);
            } else {
                this.paintTreeComponent(g, this.component);
            }
        }

        void paintComponent(Graphics g, Component c, int x, int y, int w, int h) {
            this.paintComponent(g, c, null, x += this.left, y += this.top, w -= this.left + this.right, h -= this.top + this.bottom, true);
        }

        void paintComponent(Graphics g, Component c, int align) {
            int w = BasicTreeTableUI.this.getSortWidth();
            switch (align) {
                case 0: {
                    this.paintComponent(g, c, w, 0, this.getWidth() - w - w, this.getHeight());
                    break;
                }
                case 2: {
                    this.paintComponent(g, c, 0, 0, this.getWidth() - w, this.getHeight());
                    break;
                }
                case 4: {
                    this.paintComponent(g, c, w, 0, this.getWidth() - w, this.getHeight());
                }
            }
        }

        protected void paintTableComponent(Graphics g, Component c) {
            if (c.isBackgroundSet()) {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (BasicTreeTableUI.this.treeTable.isNodeSortingEnabled()) {
                this.paintComponent(g, c, BasicTreeTableUI.this.treeTable.getAlignment(c, this.row, this.column));
            } else {
                this.paintComponent(g, c, 0, 0, this.getWidth(), this.getHeight());
            }
        }

        protected void paintTreeComponent(Graphics g, Component c) {
            int x = 0;
            int y = 0;
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.getX() + w > BasicTreeTableUI.this.tree.getWidth()) {
                w = BasicTreeTableUI.this.tree.getWidth() - this.getX();
            }
            this.paintComponent(g, c, null, x, y += this.top, w, h -= this.top + this.bottom, true);
        }

        @Override
        public boolean isOpaque() {
            Container p = this.getParent();
            return p != null ? p.isOpaque() : super.isOpaque();
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(long tm, int x, int y, int w, int h) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        private void configureCellRenderer(Component c, boolean sel, int row, int col) {
            Color fg = null;
            Color bg = null;
            TreeTable.DropLocation dropLocation = BasicTreeTableUI.this.treeTable.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == col) {
                fg = this.getDropCellForeground();
                bg = this.getDropCellBackground();
                sel = true;
            }
            if (sel) {
                c.setForeground(fg != null ? fg : BasicTreeTableUI.this.treeTable.getSelectionForeground());
                c.setBackground(bg != null ? bg : BasicTreeTableUI.this.treeTable.getSelectionBackground());
            } else {
                c.setForeground(BasicTreeTableUI.this.treeTable.getForeground());
                if (this.backgroundColor == null) {
                    this.prepareBackgroundColors();
                }
                c.setBackground(row % 2 == 0 ? this.backgroundColor : this.alternateRowColor);
            }
        }

        public boolean configureCellRenderer(DefaultTreeTableCellRenderer renderer, TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column) {
            renderer.setOpaque(false);
            renderer.setIcon(null);
            renderer.setDisabledIcon(null);
            this.configureCellRenderer(renderer, selected, row, column);
            renderer.setFont(treeTable.getFont());
            if (hasFocus) {
                Border border = null;
                if (selected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                renderer.setBorder(border);
                if (!selected && BasicTreeTableUI.this.table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        super.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(col);
                    }
                }
            } else {
                renderer.setBorder(this.getNoFocusBorder());
            }
            return selected;
        }

        protected Border getNoFocusBorder() {
            return BasicTreeTableUI.this.getDefaultNoFocusBorder();
        }

        protected Color getDropCellForeground() {
            return UIManager.getColor("Table.dropCellForeground");
        }

        protected Color getDropCellBackground() {
            return UIManager.getColor("Table.dropCellBackground");
        }

        public void configureCellRenderer(DefaultTreeTableCellRenderer renderer, TreeTable treeTable, Object value, boolean sel, boolean foc, int row, int col, boolean exp, boolean leaf) {
            renderer.setOpaque(false);
            Color fg = sel ? treeTable.getSelectionForeground() : treeTable.getForeground();
            renderer.setForeground(fg);
            Icon icon = treeTable.getIcon(value, exp, leaf);
            if (!treeTable.isEnabled()) {
                renderer.setEnabled(false);
                renderer.setDisabledIcon(icon);
            } else {
                renderer.setEnabled(true);
                renderer.setIcon(icon);
            }
            ComponentOrientation o = treeTable.getComponentOrientation();
            renderer.setComponentOrientation(o);
            renderer.setBorder(o.isLeftToRight() ? this.getLTRBorder() : this.getRTLBorder());
            renderer.setFont(treeTable.getFont());
        }

        protected Border getLTRBorder() {
            return BasicTreeTableUI.this.getDefaultLTRBorder();
        }

        protected Border getRTLBorder() {
            return BasicTreeTableUI.this.getDefaultRTLBorder();
        }
    }

    private class NimbusRenderer
    extends Renderer {
        private static final String collapsedSelected = "Tree[Enabled+Selected].collapsedIconPainter";
        private static final String expandedSelected = "Tree[Enabled+Selected].expandedIconPainter";
        private static final String collapsed = "Tree[Enabled].collapsedIconPainter";
        private static final String expanded = "Tree[Enabled].expandedIconPainter";
        private UIDefaults current;
        private UIDefaults rowSelection;
        private UIDefaults columnSelected;
        private UIDefaults noneSelected;
        private boolean focus;
        private int row;
        private int column;
        private TreeTableCellRenderer focusRenderer;

        NimbusRenderer() {
            this.rowSelection = this.current = (UIDefaults)BasicTreeTableUI.this.tree.getClientProperty("Nimbus.Overrides");
            this.rowSelection.put(collapsed, UIManager.get(collapsed));
            this.rowSelection.put(expanded, UIManager.get(expanded));
            this.rowSelection.put(collapsedSelected, UIManager.get(collapsedSelected));
            this.rowSelection.put(expandedSelected, UIManager.get(expandedSelected));
        }

        private UIDefaults getDefaults() {
            if (this.rowSelectionAllowed) {
                if (!this.columnSelectionAllowed || this.treeColumnSelected) {
                    return this.rowSelection;
                }
            } else if (this.columnSelectionAllowed && this.treeColumnSelected) {
                if (this.columnSelected == null) {
                    this.columnSelected = new UIDefaults();
                    this.columnSelected.putAll(this.rowSelection);
                    this.columnSelected.put(collapsed, UIManager.get(collapsedSelected));
                    this.columnSelected.put(expanded, UIManager.get(expandedSelected));
                }
                return this.columnSelected;
            }
            if (this.noneSelected == null) {
                this.noneSelected = new UIDefaults();
                this.noneSelected.putAll(this.rowSelection);
                this.noneSelected.put(collapsedSelected, UIManager.get(collapsed));
                this.noneSelected.put(expandedSelected, UIManager.get(expanded));
            }
            return this.noneSelected;
        }

        @Override
        public void prepareForTable(Graphics g) {
            super.prepareForTable(g);
            this.focus = false;
        }

        @Override
        protected void prepareBackgroundColors() {
            super.prepareBackgroundColors();
            this.backgroundColor = BasicTreeTableUI.createColor(this.backgroundColor);
            this.alternateRowColor = BasicTreeTableUI.createColor(this.alternateRowColor);
        }

        @Override
        public void prepareForTree() {
            super.prepareForTree();
            if (System.getSecurityManager() != null) {
                return;
            }
            UIDefaults map = this.getDefaults();
            if (map == this.current) {
                return;
            }
            this.current = map;
            this.clearCachedOverrides(BasicTreeTableUI.this.tree, Region.TREE);
            BasicTreeTableUI.this.tree.putClientProperty("Nimbus.Overrides", map);
            this.focus = false;
        }

        @Override
        protected Color getDropCellForeground() {
            return BasicTreeTableUI.createColor(super.getDropCellForeground());
        }

        @Override
        protected Color getDropCellBackground() {
            return BasicTreeTableUI.createColor(super.getDropCellBackground());
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean sel, boolean foc, int row, int col) {
            Component c = super.getTreeTableCellRendererComponent(treeTable, value, sel, foc, row, col);
            this.focus = foc;
            this.row = row;
            this.column = col;
            return c;
        }

        @Override
        protected void paintTableComponent(Graphics g, Component c) {
            super.paintTableComponent(g, c);
            if (this.focus && c instanceof JCheckBox) {
                Component fc = this.getFocusRenderer().getTreeTableCellRendererComponent(BasicTreeTableUI.this.treeTable, "", false, true, this.row, this.column);
                if (BasicTreeTableUI.this.treeTable.isNodeSortingEnabled()) {
                    this.paintComponent(g, fc, BasicTreeTableUI.this.treeTable.getAlignment(c, this.row, this.column));
                } else {
                    this.paintComponent(g, fc, BasicTreeTableUI.this.table, 0, 0, this.getWidth(), this.getHeight(), true);
                }
            }
        }

        private TreeTableCellRenderer getFocusRenderer() {
            TreeTableCellRenderer r = BasicTreeTableUI.this.treeTable.getFocusRenderer();
            if (r == null) {
                if (this.focusRenderer == null) {
                    this.focusRenderer = new FocusRenderer();
                }
                r = this.focusRenderer;
            }
            return r;
        }

        private void clearCachedOverrides(JComponent c, Object region) {
            try {
                LookAndFeel nimbusLaf = UIManager.getLookAndFeel();
                Class<?> nimbusLafClass = nimbusLaf.getClass();
                Field defaultsField = nimbusLafClass.getDeclaredField("defaults");
                defaultsField.setAccessible(true);
                Object defaults = defaultsField.get(nimbusLaf);
                Class<?> defaultsClass = defaults.getClass();
                Field mField = defaultsClass.getDeclaredField("m");
                mField.setAccessible(true);
                Map m = (Map)mField.get(defaults);
                List values = (List)m.get(region);
                if (values != null) {
                    for (Object lazyStyleObj : values) {
                        Class<?> lazyStyleClass = lazyStyleObj.getClass();
                        Field overridesCacheField = lazyStyleClass.getDeclaredField("overridesCache");
                        overridesCacheField.setAccessible(true);
                        Map overridesCache = (Map)overridesCacheField.get(lazyStyleObj);
                        if (overridesCache == null) continue;
                        overridesCache.remove(c);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class ColumnModelAdapter
    implements TableColumnModel {
        private TableColumnModel delegate;

        ColumnModelAdapter(TableColumnModel cm) {
            this.delegate = cm;
        }

        @Override
        public int getColumnMargin() {
            return 0;
        }

        @Override
        public void addColumn(TableColumn aColumn) {
            this.delegate.addColumn(aColumn);
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener x) {
            this.delegate.addColumnModelListener(x);
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            return this.delegate.getColumn(columnIndex);
        }

        @Override
        public int getColumnCount() {
            return this.delegate.getColumnCount();
        }

        @Override
        public int getColumnIndex(Object columnIdentifier) {
            return this.delegate.getColumnIndex(columnIdentifier);
        }

        @Override
        public int getColumnIndexAtX(int xPosition) {
            return this.delegate.getColumnIndexAtX(xPosition);
        }

        @Override
        public Enumeration<TableColumn> getColumns() {
            return this.delegate.getColumns();
        }

        @Override
        public boolean getColumnSelectionAllowed() {
            return this.delegate.getColumnSelectionAllowed();
        }

        @Override
        public int getSelectedColumnCount() {
            return this.delegate.getSelectedColumnCount();
        }

        @Override
        public int[] getSelectedColumns() {
            return this.delegate.getSelectedColumns();
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.delegate.getSelectionModel();
        }

        @Override
        public int getTotalColumnWidth() {
            return this.delegate.getTotalColumnWidth();
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            this.delegate.moveColumn(columnIndex, newIndex);
        }

        @Override
        public void removeColumn(TableColumn column) {
            this.delegate.removeColumn(column);
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener x) {
            this.delegate.removeColumnModelListener(x);
        }

        @Override
        public void setColumnMargin(int newMargin) {
            this.delegate.setColumnMargin(newMargin);
        }

        @Override
        public void setColumnSelectionAllowed(boolean flag) {
            this.delegate.setColumnSelectionAllowed(flag);
        }

        @Override
        public void setSelectionModel(ListSelectionModel newModel) {
            this.delegate.setSelectionModel(newModel);
        }
    }

    private class RowSorterAdapter
    extends RowSorter<TableModel> {
        private RowSorterAdapter() {
        }

        @Override
        public int convertRowIndexToModel(int index) {
            return index;
        }

        @Override
        public int convertRowIndexToView(int index) {
            return index;
        }

        @Override
        public TableModel getModel() {
            return BasicTreeTableUI.this.getTable().getModel();
        }

        @Override
        public int getModelRowCount() {
            return this.getModel().getRowCount();
        }

        @Override
        public int getViewRowCount() {
            return this.getModelRowCount();
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            return BasicTreeTableUI.this.treeTable.getRowSorter().getSortKeys();
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
            BasicTreeTableUI.this.treeTable.getRowSorter().setSortKeys(keys);
        }

        @Override
        public void toggleSortOrder(int column) {
            BasicTreeTableUI.this.treeTable.getRowSorter().toggleSortOrder(column);
        }

        @Override
        public void allRowsChanged() {
        }

        @Override
        public void modelStructureChanged() {
        }

        @Override
        public void rowsDeleted(int firstRow, int endRow) {
        }

        @Override
        public void rowsInserted(int firstRow, int endRow) {
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow) {
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow, int column) {
        }

        @Override
        public void addRowSorterListener(RowSorterListener l) {
        }

        @Override
        public void removeRowSorterListener(RowSorterListener l) {
        }
    }

    protected static class TreeTableColumn
    extends TableColumn {
        public TreeTableColumn(int modelIndex) {
            super(modelIndex);
        }

        @Override
        public void setCellRenderer(TableCellRenderer renderer) {
            if (renderer != null && !(renderer instanceof TreeTableCellRenderer)) {
                throw new IllegalArgumentException("renderer must implement TreeTableCellRenderer");
            }
            super.setCellRenderer(renderer);
        }

        @Override
        public void setCellEditor(TableCellEditor editor) {
            if (editor != null && !(editor instanceof TreeTableCellEditor)) {
                throw new IllegalArgumentException("editor must implement TreeTableCellEditor");
            }
            super.setCellEditor(editor);
        }
    }

    private class Table
    extends JTable
    implements TableInterface,
    ProcessKeyBinding {
        private RowSorter<? extends TableModel> rowSorter;

        Table(TableModel tm, TableColumnModel cm, ListSelectionModel sm) {
            super(tm, cm, sm);
        }

        @Override
        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        @Override
        public boolean getDragEnabled() {
            return BasicTreeTableUI.this.treeTable.getDragEnabled();
        }

        @Override
        public Container getParent() {
            return BasicTreeTableUI.this.treeTable.getParent();
        }

        @Override
        public void computeVisibleRect(Rectangle visibleRect) {
            BasicTreeTableUI.this.treeTable.computeVisibleRect(visibleRect);
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            BasicTreeTableUI.this.treeTable.repaint(tm, x + this.getX(), y + this.getY(), width, height);
        }

        @Override
        public void paintImmediately(int x, int y, int w, int h) {
            BasicTreeTableUI.this.treeTable.paintImmediately(x + this.getX(), y + this.getY(), w, h);
        }

        @Override
        public void revalidate() {
            BasicTreeTableUI.this.treeTable.revalidate();
        }

        @Override
        public boolean requestFocusInWindow() {
            return BasicTreeTableUI.this.treeTable.requestFocusInWindow();
        }

        @Override
        public void requestFocus() {
            BasicTreeTableUI.this.treeTable.requestFocus();
        }

        @Override
        public boolean requestFocus(boolean temporary) {
            return BasicTreeTableUI.this.treeTable.requestFocus(temporary);
        }

        @Override
        public void doLayout() {
            BasicTreeTableUI.this.layoutTable();
            super.doLayout();
        }

        @Override
        public void scrollRectToVisible(Rectangle r) {
            BasicTreeTableUI.this.scrollToVisible(r, this.getX(), this.getY());
        }

        @Override
        public boolean hasFocus() {
            return BasicTreeTableUI.this.treeTable.hasFocus();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            BasicTreeTableUI.this.treeTableCellEditor.loadEditor(row, column);
            return BasicTreeTableUI.this.treeTableCellEditor;
        }

        @Override
        public boolean editCellAt(int row, int col, EventObject e) {
            if (super.editCellAt(row, col, e)) {
                if (col == BasicTreeTableUI.this.treeTable.getHierarchicalColumn()) {
                    Rectangle b = BasicTreeTableUI.this.tree.getRowBounds(row);
                    b.x = 0;
                    b.width = BasicTreeTableUI.this.tree.getWidth();
                    BasicTreeTableUI.this.tree.repaint(b);
                }
                return true;
            }
            return false;
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int col) {
            return super.prepareEditor(editor, row, col);
        }

        @Override
        protected void addImpl(Component comp, Object constraints, int index) {
            if (comp instanceof CellRendererPane) {
                super.addImpl(comp, constraints, index);
            } else {
                BasicTreeTableUI.this.treeTable.add(comp, constraints, index);
            }
        }

        @Override
        public void remove(Component comp) {
            if (comp instanceof CellRendererPane) {
                super.remove(comp);
            } else {
                BasicTreeTableUI.this.treeTable.remove(comp);
            }
        }

        @Override
        public Color getBackground() {
            return BasicTreeTableUI.this.treeTable.getBackground();
        }

        @Override
        public Color getForeground() {
            return BasicTreeTableUI.this.treeTable.getForeground();
        }

        @Override
        public Font getFont() {
            return BasicTreeTableUI.this.treeTable.getFont();
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return BasicTreeTableUI.this.treeTableCellRenderer;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            TreeTable t = BasicTreeTableUI.this.treeTable;
            boolean hier = column == t.getHierarchicalColumn();
            String value = hier ? "" : this.getValueAt(row, column);
            boolean sel = !this.isPaintingForPrint() && this.isCellSelected(row, column);
            boolean foc = false;
            return renderer.getTableCellRendererComponent(this, value, sel, foc, row, column);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (BasicTreeTableUI.this.table == null) {
                if (this.getAutoCreateColumnsFromModel()) {
                    this.createDefaultColumnsFromModel();
                }
            } else {
                super.tableChanged(e);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            super.columnAdded(e);
            if (BasicTreeTableUI.this.tree.getRowHeight() <= 0) {
                BasicTreeTableUI.this.treeTable.invalidateAllRows();
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            super.columnMoved(e);
            if (e.getFromIndex() != e.getToIndex()) {
                BasicTreeTableUI.this.tree.doLayout();
            }
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            super.columnRemoved(e);
            if (BasicTreeTableUI.this.tree.getRowHeight() <= 0) {
                BasicTreeTableUI.this.treeTable.invalidateAllRows();
            }
        }

        @Override
        public void createDefaultColumnsFromModel() {
            TableModel m = this.getModel();
            if (m != null) {
                TableColumnModel cm = this.getColumnModel();
                while (cm.getColumnCount() > 0) {
                    cm.removeColumn(cm.getColumn(0));
                }
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    this.addColumn(new TreeTableColumn(i));
                }
            }
        }

        @Override
        public RowSorter<? extends TableModel> getRowSorter() {
            return this.rowSorter;
        }

        @Override
        public void setRowSorter(RowSorter<? extends TableModel> rowSorter) {
            RowSorter<? extends TableModel> oldValue = this.getRowSorter();
            this.rowSorter = rowSorter;
            this.firePropertyChange("rowSorter", oldValue, rowSorter);
        }

        @Override
        public TransferHandler getTransferHandler() {
            TransferHandler th = BasicTreeTableUI.this.treeTable.getTransferHandler();
            if (th != null) {
                return th;
            }
            return super.getTransferHandler();
        }

        @Override
        public Rectangle getCellBounds(int row, int column, boolean includeSpacing) {
            return super.getCellRect(row, column, includeSpacing);
        }
    }

    private class Tree
    extends JTree
    implements TreeInterface,
    ProcessKeyBinding {
        Tree(TreeModel model) {
            super(model);
        }

        @Override
        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        @Override
        public Container getParent() {
            return BasicTreeTableUI.this.treeTable.getParent();
        }

        @Override
        public boolean getDragEnabled() {
            return BasicTreeTableUI.this.treeTable.getDragEnabled();
        }

        @Override
        public boolean hasFocus() {
            return false;
        }

        @Override
        public void computeVisibleRect(Rectangle visibleRect) {
            BasicTreeTableUI.this.treeTable.computeVisibleRect(visibleRect);
            Rectangle2D.intersect(visibleRect, this.getBounds(), visibleRect);
            visibleRect.x -= this.getX();
            visibleRect.y -= this.getY();
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            BasicTreeTableUI.this.treeTable.repaint(tm, x + this.getX(), y + this.getY(), width, height);
        }

        @Override
        public void paintImmediately(int x, int y, int w, int h) {
            BasicTreeTableUI.this.treeTable.paintImmediately(x + this.getX(), y + this.getY(), w, h);
        }

        @Override
        public void revalidate() {
            BasicTreeTableUI.this.treeTable.revalidate();
        }

        @Override
        public boolean requestFocusInWindow() {
            return BasicTreeTableUI.this.treeTable.requestFocusInWindow();
        }

        @Override
        public void requestFocus() {
            BasicTreeTableUI.this.treeTable.requestFocus();
        }

        @Override
        public boolean requestFocus(boolean temporary) {
            return BasicTreeTableUI.this.treeTable.requestFocus(temporary);
        }

        @Override
        public void doLayout() {
            BasicTreeTableUI.this.layoutTree();
            super.doLayout();
        }

        @Override
        public void scrollRectToVisible(Rectangle r) {
            BasicTreeTableUI.this.scrollToVisible(r, this.getX(), this.getY());
        }

        @Override
        protected void setExpandedState(TreePath path, boolean state) {
            TreePath updatePath = path;
            if (state) {
                TreePath par;
                while ((par = updatePath.getParentPath()) != null && !this.isExpanded(par)) {
                    updatePath = par;
                }
            }
            int rowCount = this.getRowCount();
            super.setExpandedState(path, state);
            BasicTreeTableUI.this.updateTableAfterExpansion(updatePath, this.getRowCount() - rowCount);
        }

        @Override
        public void setUI(TreeUI ui) {
            super.setUI(ui);
            if (ui instanceof BasicTreeUI) {
                BasicTreeUI bui = (BasicTreeUI)ui;
                BasicTreeTableUI.this.treeHandleWidth = bui.getLeftChildIndent() + bui.getRightChildIndent();
            } else {
                BasicTreeTableUI.this.treeHandleWidth = -1;
            }
        }

        @Override
        public Color getBackground() {
            return BasicTreeTableUI.this.treeTable.getBackground();
        }

        @Override
        public Color getForeground() {
            return BasicTreeTableUI.this.treeTable.getForeground();
        }

        @Override
        public Font getFont() {
            return BasicTreeTableUI.this.treeTable.getFont();
        }
    }

    protected static interface ProcessKeyBinding {
        public boolean processKeyBinding(KeyStroke var1, KeyEvent var2, int var3, boolean var4);
    }
}

