/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.UserInterfaceConfiguration;
import com.xk72.charles.gui.lib.H;
import com.xk72.charles.gui.settings.N;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.transaction.viewers.k;
import com.xk72.charles.win32.a;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.SystemTray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UISettingsPanel
extends SettingsPanel {
    private final JComboBox<Comparable<?>> cFont;
    private final JComboBox<Comparable<?>> cFontSize;
    private final JCheckBox bShowTrayIcon = new JCheckBox(k.c() ? "Show Charles icon in the menu bar" : "Show system tray icon");
    private final JCheckBox bMinimiseToTray = new JCheckBox("Minimise to system tray");
    private final JCheckBox bShowMemoryUsage = new JCheckBox("Show memory usage");
    private final JCheckBox bEnableHotkeys = new JCheckBox("Enable global hotkeys");
    private final JCheckBox bAlwaysOnTop = new JCheckBox("Charles window always on top");
    private final JCheckBox bHighlightTreeChanges = new JCheckBox("Highlight changes in the Structure view");

    public UISettingsPanel() {
        super(CharlesContext.getInstance().getBundle().getString("settings.ui.name"));
        this.setHelp(this.ctx.getBundle().getString("settings.ui.help"));
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        String[] stringArray = UISettingsPanel.a(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.cFont = new JComboBox<String>(stringArray);
        this.cFont.insertItemAt((Comparable<?>)((Object)"Default"), 0);
        this.cFont.setSelectedIndex(0);
        if (userInterfaceConfiguration.getDisplayFont() != null) {
            this.cFont.setSelectedItem(userInterfaceConfiguration.getDisplayFont());
        }
        this.cFontSize = new JComboBox();
        this.cFontSize.addItem((Comparable<?>)((Object)"Default"));
        for (int i2 = 9; i2 <= 24; ++i2) {
            this.cFontSize.addItem(new Integer(i2));
        }
        if (userInterfaceConfiguration.getDisplayFontSize() != null) {
            this.cFontSize.setSelectedItem(userInterfaceConfiguration.getDisplayFontSize());
        }
        this.bShowTrayIcon.setSelected(userInterfaceConfiguration.isShowTrayIcon());
        this.bMinimiseToTray.setSelected(userInterfaceConfiguration.isMinimiseToTray());
        this.bMinimiseToTray.setEnabled(this.bShowTrayIcon.isSelected());
        this.bShowTrayIcon.addChangeListener(new N(this));
        this.bShowMemoryUsage.setSelected(userInterfaceConfiguration.isShowMemoryUsage());
        this.bEnableHotkeys.setSelected(userInterfaceConfiguration.isEnableHotkeys());
        this.bAlwaysOnTop.setSelected(userInterfaceConfiguration.isAlwaysOnTop());
        this.bHighlightTreeChanges.setSelected(userInterfaceConfiguration.isHighlightTreeChanges());
        JPanel jPanel = new JPanel(H.g(null));
        jPanel.add(new JLabel("Display font:"));
        jPanel.add(this.cFont);
        jPanel.add(new JLabel("Display font size:"));
        jPanel.add(this.cFontSize);
        H.a(jPanel);
        if (SystemTray.isSupported()) {
            jPanel.add((Component)this.bShowTrayIcon, "skip");
        }
        if (a.a()) {
            jPanel.add((Component)this.bMinimiseToTray, "skip");
            jPanel.add((Component)this.bEnableHotkeys, "skip");
        }
        if (CharlesContext.getJavaVersion() >= 15) {
            jPanel.add((Component)this.bAlwaysOnTop, "skip");
        }
        jPanel.add((Component)this.bHighlightTreeChanges, "skip");
        jPanel.add((Component)this.bShowMemoryUsage, "skip");
        this.add(jPanel);
    }

    private static String[] a(String[] object) {
        object = new ArrayList<String>(Arrays.asList(object));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(".System")) continue;
            iterator.remove();
        }
        return object.toArray(new String[object.size()]);
    }

    public static void main(String[] stringArray) {
        new UISettingsPanel().test();
    }

    @Override
    public boolean save() {
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        String string = this.cFont.getSelectedItem().toString();
        Integer n2 = this.cFontSize.getSelectedItem() instanceof Integer ? (Integer)this.cFontSize.getSelectedItem() : null;
        boolean bl = !UISettingsPanel.a(userInterfaceConfiguration.getDisplayFont(), string) || !UISettingsPanel.a(userInterfaceConfiguration.getDisplayFontSize(), n2);
        userInterfaceConfiguration.setDisplayFont(string);
        userInterfaceConfiguration.setDisplayFontSize(n2);
        if (bl) {
            this.ctx.info("Display Font Changes", "Please restart Charles to complete the application of display font changes.");
        }
        userInterfaceConfiguration.setShowTrayIcon(this.bShowTrayIcon.isSelected());
        userInterfaceConfiguration.setMinimiseToTray(this.bMinimiseToTray.isSelected());
        userInterfaceConfiguration.setShowMemoryUsage(this.bShowMemoryUsage.isSelected());
        userInterfaceConfiguration.setEnableHotkeys(this.bEnableHotkeys.isSelected());
        userInterfaceConfiguration.setAlwaysOnTop(this.bAlwaysOnTop.isSelected());
        userInterfaceConfiguration.setHighlightTreeChanges(this.bHighlightTreeChanges.isSelected());
        return true;
    }

    private static boolean a(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    static /* synthetic */ JCheckBox a(UISettingsPanel uISettingsPanel) {
        return uISettingsPanel.bShowTrayIcon;
    }

    static /* synthetic */ JCheckBox b(UISettingsPanel uISettingsPanel) {
        return uISettingsPanel.bMinimiseToTray;
    }
}

